/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

class FlinkKeyUtils {
    FlinkKeyUtils() {
    }

    static <K> ByteBuffer encodeKey(K key, Coder<K> keyCoder) {
        byte[] keyBytes;
        Preconditions.checkNotNull(keyCoder, (Object)"Provided coder must not be null");
        try {
            keyBytes = CoderUtils.encodeToByteArray(keyCoder, key);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to encode key: %s", key), e);
        }
        return ByteBuffer.wrap(keyBytes);
    }

    static <K> K decodeKey(ByteBuffer byteBuffer, Coder<K> keyCoder) {
        Preconditions.checkNotNull((Object)byteBuffer, (Object)"Provided ByteBuffer must not be null");
        Preconditions.checkNotNull(keyCoder, (Object)"Provided coder must not be null");
        Preconditions.checkState((boolean)byteBuffer.hasArray(), (Object)"ByteBuffer key must contain an array.");
        byte[] keyBytes = byteBuffer.array();
        try {
            return (K)CoderUtils.decodeFromByteArray(keyCoder, (byte[])keyBytes);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to decode encoded key: %s", Arrays.toString(keyBytes)), e);
        }
    }
}

