/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.nio.ByteBuffer;
import org.apache.beam.runners.flink.translation.wrappers.streaming.FlinkKeyUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;

public class KvToByteBufferKeySelector<K, V>
implements KeySelector<WindowedValue<KV<K, V>>, ByteBuffer>,
ResultTypeQueryable<ByteBuffer> {
    private final Coder<K> keyCoder;

    public KvToByteBufferKeySelector(Coder<K> keyCoder) {
        this.keyCoder = keyCoder;
    }

    public ByteBuffer getKey(WindowedValue<KV<K, V>> value) throws Exception {
        Object key = ((KV)value.getValue()).getKey();
        return FlinkKeyUtils.encodeKey(key, this.keyCoder);
    }

    public TypeInformation<ByteBuffer> getProducedType() {
        return new GenericTypeInfo(ByteBuffer.class);
    }
}

