/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferedElement;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferingElementsHandler;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;

public class KeyedBufferingElementsHandler
implements BufferingElementsHandler {
    private final KeyedStateBackend backend;
    private final ListStateDescriptor<BufferedElement> stateDescriptor;

    static KeyedBufferingElementsHandler create(KeyedStateBackend backend, ListStateDescriptor<BufferedElement> stateDescriptor) {
        return new KeyedBufferingElementsHandler(backend, stateDescriptor);
    }

    private KeyedBufferingElementsHandler(KeyedStateBackend backend, ListStateDescriptor<BufferedElement> stateDescriptor) {
        this.backend = backend;
        this.stateDescriptor = stateDescriptor;
    }

    @Override
    public void buffer(BufferedElement element) {
        try {
            ListState state = (ListState)this.backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, this.stateDescriptor);
            state.add((Object)element);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to buffer element in state backend." + element, e);
        }
    }

    @Override
    public Stream<BufferedElement> getElements() {
        return this.backend.getKeys(this.stateDescriptor.getName(), (Object)VoidNamespace.INSTANCE).flatMap(key -> {
            try {
                this.backend.setCurrentKey(key);
                ListState state = (ListState)this.backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, this.stateDescriptor);
                return StreamSupport.stream(((Iterable)state.get()).spliterator(), false);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to retrieve buffered element from state backend.", e);
            }
        });
    }

    @Override
    public void clear() {
        List keys = this.backend.getKeys(this.stateDescriptor.getName(), (Object)VoidNamespace.INSTANCE).collect(Collectors.toList());
        try {
            for (Object key : keys) {
                this.backend.setCurrentKey(key);
                ListState state = (ListState)this.backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, this.stateDescriptor);
                state.clear();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to clear buffered element state", e);
        }
    }
}

