/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;

class AssignWindows<T>
extends PTransform<PCollection<T>, PCollection<T>> {
    private final Window<T> transform;

    public AssignWindows(Window<T> transform) {
        this.transform = transform;
    }

    public PCollection<T> expand(PCollection<T> input) {
        WindowingStrategy outputStrategy = this.transform.getOutputStrategyInternal(input.getWindowingStrategy());
        if (this.transform.getWindowFn() != null) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)outputStrategy, (PCollection.IsBounded)input.isBounded());
        }
        return ((PCollection)input.apply("Identity", (PTransform)ParDo.of((DoFn)new DoFn<T, T>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output(c.element());
            }
        }))).setWindowingStrategyInternal(outputStrategy);
    }

    public void validate(PipelineOptions options) {
        this.transform.validate(options);
    }

    protected Coder<?> getDefaultOutputCoder(PCollection<T> input) {
        return input.getCoder();
    }

    protected String getKindString() {
        return "Window.Into()";
    }
}

