/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.google.api.services.dataflow.model.JobMetrics;
import com.google.api.services.dataflow.model.MetricUpdate;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.beam.runners.dataflow.AutoValue_DataflowMetrics_DataflowMetricQueryResults;
import org.apache.beam.runners.dataflow.AutoValue_DataflowMetrics_DataflowMetricResult;
import org.apache.beam.runners.dataflow.DataflowClient;
import org.apache.beam.runners.dataflow.DataflowPipelineJob;
import org.apache.beam.runners.dataflow.repackaged.com.google.common.base.MoreObjects;
import org.apache.beam.runners.dataflow.repackaged.com.google.common.base.Objects;
import org.apache.beam.runners.dataflow.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.metrics.MetricFiltering;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.metrics.MetricKey;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataflowMetrics
extends MetricResults {
    private static final Logger LOG = LoggerFactory.getLogger(DataflowMetrics.class);
    private DataflowClient dataflowClient;
    private DataflowPipelineJob dataflowPipelineJob;
    private MetricQueryResults cachedMetricResults = null;

    public DataflowMetrics(DataflowPipelineJob dataflowPipelineJob, DataflowClient dataflowClient) {
        this.dataflowClient = dataflowClient;
        this.dataflowPipelineJob = dataflowPipelineJob;
    }

    private MetricKey metricHashKey(MetricUpdate metricUpdate) {
        String fullStepName = (String)metricUpdate.getName().getContext().get("step");
        fullStepName = this.dataflowPipelineJob.transformStepNames != null ? ((AppliedPTransform)this.dataflowPipelineJob.transformStepNames.inverse().get(fullStepName)).getFullName() : fullStepName;
        return MetricKey.create(fullStepName, MetricName.named((String)((String)metricUpdate.getName().getContext().get("namespace")), (String)metricUpdate.getName().getName()));
    }

    private boolean isMetricTentative(MetricUpdate metricUpdate) {
        return metricUpdate.getName().getContext().containsKey("tentative") && Objects.equal(metricUpdate.getName().getContext().get("tentative"), "true");
    }

    private MetricQueryResults populateMetricQueryResults(List<MetricUpdate> metricUpdates, MetricsFilter filter) {
        HashMap<MetricKey, MetricUpdate> tentativeByName = new HashMap<MetricKey, MetricUpdate>();
        HashMap<MetricKey, MetricUpdate> committedByName = new HashMap<MetricKey, MetricUpdate>();
        HashSet<MetricKey> metricHashKeys = new HashSet<MetricKey>();
        for (MetricUpdate update : metricUpdates) {
            if (Objects.equal(update.getName().getOrigin(), "user") && this.isMetricTentative(update) && update.getName().getContext().containsKey("namespace")) {
                tentativeByName.put(this.metricHashKey(update), update);
                metricHashKeys.add(this.metricHashKey(update));
                continue;
            }
            if (!Objects.equal(update.getName().getOrigin(), "user") || !update.getName().getContext().containsKey("namespace") || this.isMetricTentative(update)) continue;
            committedByName.put(this.metricHashKey(update), update);
            metricHashKeys.add(this.metricHashKey(update));
        }
        ImmutableList.Builder counterResults = ImmutableList.builder();
        ImmutableList.Builder distributionResults = ImmutableList.builder();
        ImmutableList.Builder gaugeResults = ImmutableList.builder();
        for (MetricKey metricKey : metricHashKeys) {
            if (!MetricFiltering.matches(filter, metricKey)) continue;
            try {
                String metricName = metricKey.metricName().name();
                if (metricName.endsWith("[MIN]") || metricName.endsWith("[MAX]") || metricName.endsWith("[MEAN]") || metricName.endsWith("[COUNT]")) {
                    LOG.warn("Distribution metrics are not yet supported. You can see them in the Dataflow User Interface");
                    continue;
                }
                String namespace = metricKey.metricName().namespace();
                String step = metricKey.stepName();
                Long committed = ((Number)((MetricUpdate)committedByName.get(metricKey)).getScalar()).longValue();
                Long attempted = ((Number)((MetricUpdate)tentativeByName.get(metricKey)).getScalar()).longValue();
                counterResults.add(DataflowMetricResult.create(MetricName.named((String)namespace, (String)metricName), step, committed, attempted));
            }
            catch (Exception e) {
                LOG.warn("Error handling metric {} for filter {}, skipping result.", (Object)metricKey, (Object)filter);
            }
        }
        return DataflowMetricQueryResults.create(counterResults.build(), distributionResults.build(), gaugeResults.build());
    }

    private MetricQueryResults queryServiceForMetrics(MetricsFilter filter) {
        JobMetrics jobMetrics;
        ImmutableList<MetricResult<Long>> counters = ImmutableList.of();
        ImmutableList<MetricResult<DistributionResult>> distributions = ImmutableList.of();
        ImmutableList<MetricResult<GaugeResult>> gauges = ImmutableList.of();
        try {
            jobMetrics = this.dataflowClient.getJobMetrics(this.dataflowPipelineJob.jobId);
        }
        catch (IOException e) {
            LOG.warn("Unable to query job metrics.\n");
            return DataflowMetricQueryResults.create(counters, distributions, gauges);
        }
        List<MetricUpdate> metricUpdates = MoreObjects.firstNonNull(jobMetrics.getMetrics(), Collections.emptyList());
        return this.populateMetricQueryResults(metricUpdates, filter);
    }

    public MetricQueryResults queryMetrics() {
        return this.queryMetrics(null);
    }

    public MetricQueryResults queryMetrics(MetricsFilter filter) {
        if (this.cachedMetricResults != null) {
            return this.cachedMetricResults;
        }
        MetricQueryResults result = this.queryServiceForMetrics(filter);
        if (this.dataflowPipelineJob.getState().isTerminal()) {
            this.cachedMetricResults = result;
        }
        return result;
    }

    static abstract class DataflowMetricResult<T>
    implements MetricResult<T> {
        DataflowMetricResult() {
        }

        public abstract MetricName name();

        public abstract String step();

        public abstract T committed();

        public abstract T attempted();

        public static <T> MetricResult<T> create(MetricName name, String scope, T committed, T attempted) {
            return new AutoValue_DataflowMetrics_DataflowMetricResult<T>(name, scope, committed, attempted);
        }
    }

    static abstract class DataflowMetricQueryResults
    implements MetricQueryResults {
        DataflowMetricQueryResults() {
        }

        public static MetricQueryResults create(Iterable<MetricResult<Long>> counters, Iterable<MetricResult<DistributionResult>> distributions, Iterable<MetricResult<GaugeResult>> gauges) {
            return new AutoValue_DataflowMetrics_DataflowMetricQueryResults(counters, distributions, gauges);
        }
    }
}

