/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.beam.runners.dataflow.repackaged.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataflowRunnerInfo {
    private static final Logger LOG = LoggerFactory.getLogger(DataflowRunnerInfo.class);
    private static final String PROPERTIES_PATH = "/org/apache/beam/runners/dataflow/dataflow.properties";
    private Properties properties = new Properties();
    private static final String FNAPI_ENVIRONMENT_MAJOR_VERSION_KEY = "fnapi.environment.major.version";
    private static final String LEGACY_ENVIRONMENT_MAJOR_VERSION_KEY = "legacy.environment.major.version";
    private static final String CONTAINER_VERSION_KEY = "container.version";

    public static DataflowRunnerInfo getDataflowRunnerInfo() {
        return LazyInit.INSTANCE;
    }

    public String getLegacyEnvironmentMajorVersion() {
        Preconditions.checkState(this.properties.containsKey(LEGACY_ENVIRONMENT_MAJOR_VERSION_KEY), "Unknown legacy environment major version");
        return this.properties.getProperty(LEGACY_ENVIRONMENT_MAJOR_VERSION_KEY);
    }

    public String getFnApiEnvironmentMajorVersion() {
        Preconditions.checkState(this.properties.containsKey(FNAPI_ENVIRONMENT_MAJOR_VERSION_KEY), "Unknown FnAPI environment major version");
        return this.properties.getProperty(FNAPI_ENVIRONMENT_MAJOR_VERSION_KEY);
    }

    public String getContainerVersion() {
        Preconditions.checkState(this.properties.containsKey(CONTAINER_VERSION_KEY), "Unknown container version");
        return this.properties.getProperty(CONTAINER_VERSION_KEY);
    }

    private DataflowRunnerInfo(String resourcePath) {
        try (InputStream in = DataflowRunnerInfo.class.getResourceAsStream(PROPERTIES_PATH);){
            if (in == null) {
                LOG.warn("Dataflow runner properties resource not found: {}", (Object)resourcePath);
                return;
            }
            this.properties.load(in);
        }
        catch (IOException e) {
            LOG.warn("Error loading Dataflow runner properties resource: ", (Throwable)e);
        }
    }

    private static class LazyInit {
        private static final DataflowRunnerInfo INSTANCE = new DataflowRunnerInfo("/org/apache/beam/runners/dataflow/dataflow.properties");

        private LazyInit() {
        }
    }
}

