/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.HashMap;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.CoderTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.util.AppliedCombineFn;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;

public class CombineTranslation {
    public static final String JAVA_SERIALIZED_COMBINE_FN_URN = "urn:beam:java:combinefn:v1";

    public static RunnerApi.CombinePayload toProto(AppliedPTransform<?, ?, Combine.PerKey<?, ?, ?>> combine, SdkComponents sdkComponents) throws IOException {
        CombineFnBase.GlobalCombineFn combineFn = ((Combine.PerKey)combine.getTransform()).getFn();
        try {
            Coder accumulatorCoder = CombineTranslation.extractAccumulatorCoder(combineFn, combine);
            HashMap sideInputs = new HashMap();
            return RunnerApi.CombinePayload.newBuilder().setAccumulatorCoderId(sdkComponents.registerCoder(accumulatorCoder)).putAllSideInputs(sideInputs).setCombineFn(CombineTranslation.toProto(combineFn)).build();
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalStateException(e);
        }
    }

    private static <K, InputT, AccumT> Coder<AccumT> extractAccumulatorCoder(CombineFnBase.GlobalCombineFn<InputT, AccumT, ?> combineFn, AppliedPTransform<PCollection<KV<K, InputT>>, ?, Combine.PerKey<K, InputT, ?>> transform) throws CannotProvideCoderException {
        KvCoder inputCoder = (KvCoder)((PCollection)Iterables.getOnlyElement(transform.getInputs().values())).getCoder();
        return AppliedCombineFn.withInputCoder(combineFn, (CoderRegistry)transform.getPipeline().getCoderRegistry(), (KvCoder)inputCoder, (Iterable)((Combine.PerKey)transform.getTransform()).getSideInputs(), (WindowingStrategy)((PCollection)Iterables.getOnlyElement(transform.getOutputs().values())).getWindowingStrategy()).getAccumulatorCoder();
    }

    public static RunnerApi.SdkFunctionSpec toProto(CombineFnBase.GlobalCombineFn<?, ?, ?> combineFn) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_COMBINE_FN_URN).setParameter(Any.pack((Message)BytesValue.newBuilder().setValue(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(combineFn))).build()))).build();
    }

    public static Coder<?> getAccumulatorCoder(RunnerApi.CombinePayload payload, RunnerApi.Components components) throws IOException {
        String id = payload.getAccumulatorCoderId();
        return CoderTranslation.fromProto(components.getCodersOrThrow(id), components);
    }

    public static CombineFnBase.GlobalCombineFn<?, ?, ?> getCombineFn(RunnerApi.CombinePayload payload) throws IOException {
        Preconditions.checkArgument(payload.getCombineFn().getSpec().getUrn().equals(JAVA_SERIALIZED_COMBINE_FN_URN));
        return (CombineFnBase.GlobalCombineFn)SerializableUtils.deserializeFromByteArray((byte[])((BytesValue)payload.getCombineFn().getSpec().getParameter().unpack(BytesValue.class)).getValue().toByteArray(), (String)"CombineFn");
    }
}

