/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.CoderTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;

public class PCollectionTranslation {
    private PCollectionTranslation() {
    }

    public static RunnerApi.PCollection toProto(PCollection<?> pCollection, SdkComponents components) throws IOException {
        String coderId = components.registerCoder(pCollection.getCoder());
        String windowingStrategyId = components.registerWindowingStrategy(pCollection.getWindowingStrategy());
        return RunnerApi.PCollection.newBuilder().setUniqueName(pCollection.getName()).setCoderId(coderId).setIsBounded(PCollectionTranslation.toProto(pCollection.isBounded())).setWindowingStrategyId(windowingStrategyId).build();
    }

    public static PCollection.IsBounded isBounded(RunnerApi.PCollection pCollection) {
        return PCollectionTranslation.fromProto(pCollection.getIsBounded());
    }

    public static Coder<?> getCoder(RunnerApi.PCollection pCollection, RunnerApi.Components components) throws IOException {
        return CoderTranslation.fromProto(components.getCodersOrThrow(pCollection.getCoderId()), components);
    }

    public static WindowingStrategy<?, ?> getWindowingStrategy(RunnerApi.PCollection pCollection, RunnerApi.Components components) throws InvalidProtocolBufferException {
        return WindowingStrategyTranslation.fromProto(components.getWindowingStrategiesOrThrow(pCollection.getWindowingStrategyId()), components);
    }

    static RunnerApi.IsBounded toProto(PCollection.IsBounded bounded) {
        switch (bounded) {
            case BOUNDED: {
                return RunnerApi.IsBounded.BOUNDED;
            }
            case UNBOUNDED: {
                return RunnerApi.IsBounded.UNBOUNDED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s %s", PCollection.IsBounded.class.getSimpleName(), bounded));
    }

    static PCollection.IsBounded fromProto(RunnerApi.IsBounded isBounded) {
        switch (isBounded) {
            case BOUNDED: {
                return PCollection.IsBounded.BOUNDED;
            }
            case UNBOUNDED: {
                return PCollection.IsBounded.UNBOUNDED;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.IsBounded.class.getCanonicalName(), PCollection.IsBounded.class.getCanonicalName(), isBounded));
    }
}

