/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction;

import com.google.protobuf.Any;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;

public class PTransformTranslation {
    public static final String PAR_DO_TRANSFORM_URN = "urn:beam:transform:pardo:v1";
    public static final String FLATTEN_TRANSFORM_URN = "urn:beam:transform:flatten:v1";
    public static final String GROUP_BY_KEY_TRANSFORM_URN = "urn:beam:transform:groupbykey:v1";
    public static final String READ_TRANSFORM_URN = "urn:beam:transform:read:v1";
    public static final String WINDOW_TRANSFORM_URN = "urn:beam:transform:window:v1";
    public static final String TEST_STREAM_TRANSFORM_URN = "urn:beam:transform:teststream:v1";
    public static final String WRITE_FILES_TRANSFORM_URN = "urn:beam:transform:write_files:0.1";
    @Deprecated
    public static final String CREATE_VIEW_TRANSFORM_URN = "urn:beam:transform:create_view:v1";
    private static final Map<Class<? extends PTransform>, TransformPayloadTranslator> KNOWN_PAYLOAD_TRANSLATORS = PTransformTranslation.loadTransformPayloadTranslators();

    private static Map<Class<? extends PTransform>, TransformPayloadTranslator> loadTransformPayloadTranslators() {
        ImmutableMap.Builder<? extends Class<? extends PTransform>, ? extends TransformPayloadTranslator> builder = ImmutableMap.builder();
        for (TransformPayloadTranslatorRegistrar registrar : ServiceLoader.load(TransformPayloadTranslatorRegistrar.class)) {
            builder.putAll(registrar.getTransformPayloadTranslators());
        }
        return builder.build();
    }

    private PTransformTranslation() {
    }

    static RunnerApi.PTransform toProto(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
        RunnerApi.PTransform.Builder transformBuilder = RunnerApi.PTransform.newBuilder();
        for (Map.Entry entry : appliedPTransform.getInputs().entrySet()) {
            Preconditions.checkArgument(entry.getValue() instanceof PCollection, "Unexpected input type %s", ((PValue)entry.getValue()).getClass());
            transformBuilder.putInputs(PTransformTranslation.toProto((TupleTag)entry.getKey()), components.registerPCollection((PCollection)entry.getValue()));
        }
        for (Map.Entry entry : appliedPTransform.getOutputs().entrySet()) {
            if (!(entry.getValue() instanceof PCollection)) continue;
            Preconditions.checkArgument(entry.getValue() instanceof PCollection, "Unexpected output type %s", ((PValue)entry.getValue()).getClass());
            transformBuilder.putOutputs(PTransformTranslation.toProto((TupleTag)entry.getKey()), components.registerPCollection((PCollection)entry.getValue()));
        }
        for (AppliedPTransform appliedPTransform2 : subtransforms) {
            transformBuilder.addSubtransforms(components.getExistingPTransformId(appliedPTransform2));
        }
        transformBuilder.setUniqueName(appliedPTransform.getFullName());
        PTransform transform = appliedPTransform.getTransform();
        if (transform instanceof RawPTransform) {
            RawPTransform rawPTransform = (RawPTransform)transform;
            if (rawPTransform.getUrn() != null) {
                RunnerApi.FunctionSpec.Builder payload = RunnerApi.FunctionSpec.newBuilder().setUrn(rawPTransform.getUrn());
                Any parameter = rawPTransform.getPayload();
                if (parameter != null) {
                    payload.setParameter(parameter);
                }
                transformBuilder.setSpec(payload);
            }
        } else if (KNOWN_PAYLOAD_TRANSLATORS.containsKey(transform.getClass())) {
            RunnerApi.FunctionSpec functionSpec = KNOWN_PAYLOAD_TRANSLATORS.get(transform.getClass()).translate(appliedPTransform, components);
            transformBuilder.setSpec(functionSpec);
        }
        return transformBuilder.build();
    }

    static RunnerApi.PTransform toProto(AppliedPTransform<?, ?, ?> appliedPTransform, SdkComponents components) throws IOException {
        return PTransformTranslation.toProto(appliedPTransform, Collections.emptyList(), components);
    }

    private static String toProto(TupleTag<?> tag) {
        return tag.getId();
    }

    @Nullable
    public static String urnForTransformOrNull(PTransform<?, ?> transform) {
        if (transform instanceof RawPTransform) {
            return ((RawPTransform)transform).getUrn();
        }
        TransformPayloadTranslator translator = KNOWN_PAYLOAD_TRANSLATORS.get(transform.getClass());
        if (translator == null) {
            return null;
        }
        return translator.getUrn(transform);
    }

    public static String urnForTransform(PTransform<?, ?> transform) {
        String urn = PTransformTranslation.urnForTransformOrNull(transform);
        if (urn == null) {
            throw new IllegalStateException(String.format("No translator known for %s", transform.getClass().getName()));
        }
        return urn;
    }

    public static class RawPTransformTranslator
    implements TransformPayloadTranslator<RawPTransform<?, ?>> {
        @Override
        public String getUrn(RawPTransform<?, ?> transform) {
            return transform.getUrn();
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, RawPTransform<?, ?>> transform, SdkComponents components) {
            if (((RawPTransform)transform.getTransform()).getUrn() == null) {
                return null;
            }
            RunnerApi.FunctionSpec.Builder transformSpec = RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((RawPTransform)transform.getTransform()));
            Any payload = ((RawPTransform)transform.getTransform()).getPayload();
            if (payload != null) {
                transformSpec.setParameter(payload);
            }
            return transformSpec.build();
        }
    }

    public static abstract class RawPTransform<InputT extends PInput, OutputT extends POutput>
    extends PTransform<InputT, OutputT> {
        @Nullable
        public abstract String getUrn();

        @Nullable
        public Any getPayload() {
            return null;
        }
    }

    public static interface TransformPayloadTranslator<T extends PTransform<?, ?>> {
        public String getUrn(T var1);

        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, T> var1, SdkComponents var2) throws IOException;
    }
}

