/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction;

import com.google.auto.service.AutoService;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.PCollectionTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;

public class ReadTranslation {
    private static final String JAVA_SERIALIZED_BOUNDED_SOURCE = "urn:beam:java:boundedsource:v1";
    private static final String JAVA_SERIALIZED_UNBOUNDED_SOURCE = "urn:beam:java:unboundedsource:v1";

    public static RunnerApi.ReadPayload toProto(Read.Bounded<?> read) {
        return RunnerApi.ReadPayload.newBuilder().setIsBounded(RunnerApi.IsBounded.BOUNDED).setSource(ReadTranslation.toProto(read.getSource())).build();
    }

    public static RunnerApi.ReadPayload toProto(Read.Unbounded<?> read) {
        return RunnerApi.ReadPayload.newBuilder().setIsBounded(RunnerApi.IsBounded.UNBOUNDED).setSource(ReadTranslation.toProto(read.getSource())).build();
    }

    public static RunnerApi.SdkFunctionSpec toProto(Source<?> source) {
        if (source instanceof BoundedSource) {
            return ReadTranslation.toProto((BoundedSource)source);
        }
        if (source instanceof UnboundedSource) {
            return ReadTranslation.toProto((UnboundedSource)source);
        }
        throw new IllegalArgumentException(String.format("Unknown %s type %s", Source.class.getSimpleName(), source.getClass()));
    }

    private static RunnerApi.SdkFunctionSpec toProto(BoundedSource<?> source) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_BOUNDED_SOURCE).setParameter(Any.pack((Message)BytesValue.newBuilder().setValue(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(source))).build()))).build();
    }

    public static BoundedSource<?> boundedSourceFromProto(RunnerApi.ReadPayload payload) throws InvalidProtocolBufferException {
        Preconditions.checkArgument(payload.getIsBounded().equals((Object)RunnerApi.IsBounded.BOUNDED));
        return (BoundedSource)SerializableUtils.deserializeFromByteArray((byte[])((BytesValue)payload.getSource().getSpec().getParameter().unpack(BytesValue.class)).getValue().toByteArray(), (String)"BoundedSource");
    }

    public static <T> BoundedSource<T> boundedSourceFromTransform(AppliedPTransform<PBegin, PCollection<T>, PTransform<PBegin, PCollection<T>>> transform) throws IOException {
        return ReadTranslation.boundedSourceFromProto(ReadTranslation.getReadPayload(transform));
    }

    public static <T, CheckpointT extends UnboundedSource.CheckpointMark> UnboundedSource<T, CheckpointT> unboundedSourceFromTransform(AppliedPTransform<PBegin, PCollection<T>, PTransform<PBegin, PCollection<T>>> transform) throws IOException {
        return ReadTranslation.unboundedSourceFromProto(ReadTranslation.getReadPayload(transform));
    }

    private static <T> RunnerApi.ReadPayload getReadPayload(AppliedPTransform<PBegin, PCollection<T>, PTransform<PBegin, PCollection<T>>> transform) throws IOException {
        return (RunnerApi.ReadPayload)PTransformTranslation.toProto(transform, Collections.emptyList(), SdkComponents.create()).getSpec().getParameter().unpack(RunnerApi.ReadPayload.class);
    }

    private static RunnerApi.SdkFunctionSpec toProto(UnboundedSource<?, ?> source) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_UNBOUNDED_SOURCE).setParameter(Any.pack((Message)BytesValue.newBuilder().setValue(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(source))).build()))).build();
    }

    public static UnboundedSource<?, ?> unboundedSourceFromProto(RunnerApi.ReadPayload payload) throws InvalidProtocolBufferException {
        Preconditions.checkArgument(payload.getIsBounded().equals((Object)RunnerApi.IsBounded.UNBOUNDED));
        return (UnboundedSource)SerializableUtils.deserializeFromByteArray((byte[])((BytesValue)payload.getSource().getSpec().getParameter().unpack(BytesValue.class)).getValue().toByteArray(), (String)"BoundedSource");
    }

    public static PCollection.IsBounded sourceIsBounded(AppliedPTransform<?, ?, ?> transform) {
        try {
            return PCollectionTranslation.fromProto(((RunnerApi.ReadPayload)PTransformTranslation.toProto(transform, Collections.emptyList(), SdkComponents.create()).getSpec().getParameter().unpack(RunnerApi.ReadPayload.class)).getIsBounded());
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error determining boundedness of Read", e);
        }
    }

    @AutoService(value=TransformPayloadTranslatorRegistrar.class)
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put(Read.Unbounded.class, new UnboundedReadPayloadTranslator()).put(Read.Bounded.class, (UnboundedReadPayloadTranslator)((Object)new BoundedReadPayloadTranslator())).build();
        }
    }

    public static class BoundedReadPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Read.Bounded<?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new BoundedReadPayloadTranslator();
        }

        private BoundedReadPayloadTranslator() {
        }

        @Override
        public String getUrn(Read.Bounded<?> transform) {
            return "urn:beam:transform:read:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Read.Bounded<?>> transform, SdkComponents components) {
            RunnerApi.ReadPayload payload = ReadTranslation.toProto((Read.Bounded)transform.getTransform());
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((Read.Bounded)transform.getTransform())).setParameter(Any.pack((Message)payload)).build();
        }
    }

    public static class UnboundedReadPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Read.Unbounded<?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new UnboundedReadPayloadTranslator();
        }

        private UnboundedReadPayloadTranslator() {
        }

        @Override
        public String getUrn(Read.Unbounded<?> transform) {
            return "urn:beam:transform:read:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Read.Unbounded<?>> transform, SdkComponents components) {
            RunnerApi.ReadPayload payload = ReadTranslation.toProto((Read.Unbounded)transform.getTransform());
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((Read.Unbounded)transform.getTransform())).setParameter(Any.pack((Message)payload)).build();
        }
    }
}

