/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PCollectionViews;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.WindowingStrategy;

@Experimental(value=Experimental.Kind.SPLITTABLE_DO_FN)
public class SplittableParDo<InputT, OutputT, RestrictionT>
extends PTransform<PCollection<InputT>, PCollectionTuple> {
    private final DoFn<InputT, OutputT> doFn;
    private final List<PCollectionView<?>> sideInputs;
    private final TupleTag<OutputT> mainOutputTag;
    private final TupleTagList additionalOutputTags;
    public static final String SPLITTABLE_PROCESS_URN = "urn:beam:runners_core:transforms:splittable_process:v1";
    public static final String SPLITTABLE_PROCESS_KEYED_ELEMENTS_URN = "urn:beam:runners_core:transforms:splittable_process_keyed_elements:v1";
    public static final String SPLITTABLE_GBKIKWI_URN = "urn:beam:runners_core:transforms:splittable_gbkikwi:v1";

    private SplittableParDo(DoFn<InputT, OutputT> doFn, TupleTag<OutputT> mainOutputTag, List<PCollectionView<?>> sideInputs, TupleTagList additionalOutputTags) {
        Preconditions.checkArgument(DoFnSignatures.getSignature(doFn.getClass()).processElement().isSplittable(), "fn must be a splittable DoFn");
        this.doFn = doFn;
        this.mainOutputTag = mainOutputTag;
        this.sideInputs = sideInputs;
        this.additionalOutputTags = additionalOutputTags;
    }

    public static <InputT, OutputT> SplittableParDo<InputT, OutputT, ?> forJavaParDo(ParDo.MultiOutput<InputT, OutputT> parDo) {
        Preconditions.checkArgument(parDo != null, "parDo must not be null");
        return new SplittableParDo(parDo.getFn(), parDo.getMainOutputTag(), parDo.getSideInputs(), parDo.getAdditionalOutputTags());
    }

    public PCollectionTuple expand(PCollection<InputT> input) {
        Coder restrictionCoder = DoFnInvokers.invokerFor(this.doFn).invokeGetRestrictionCoder(input.getPipeline().getCoderRegistry());
        KvCoder splitCoder = KvCoder.of((Coder)input.getCoder(), (Coder)restrictionCoder);
        PCollection keyedRestrictions = (PCollection)((PCollection)((PCollection)((PCollection)input.apply("Pair with initial restriction", (PTransform)ParDo.of(new PairWithRestrictionFn(this.doFn)))).setCoder((Coder)splitCoder).apply("Split restriction", (PTransform)ParDo.of(new SplitRestrictionFn(this.doFn)))).setCoder((Coder)splitCoder).apply("Explode windows", (PTransform)ParDo.of(new ExplodeWindowsFn()))).apply("Assign unique key", (PTransform)WithKeys.of(new RandomUniqueKeyFn()));
        return (PCollectionTuple)keyedRestrictions.apply("ProcessKeyedElements", new ProcessKeyedElements(this.doFn, input.getCoder(), restrictionCoder, input.getWindowingStrategy(), this.sideInputs, this.mainOutputTag, this.additionalOutputTags));
    }

    public Map<TupleTag<?>, PValue> getAdditionalInputs() {
        return PCollectionViews.toAdditionalInputs(this.sideInputs);
    }

    private static class SplitRestrictionFn<InputT, RestrictionT>
    extends DoFn<KV<InputT, RestrictionT>, KV<InputT, RestrictionT>> {
        private final DoFn<InputT, ?> splittableFn;
        private transient DoFnInvoker<InputT, ?> invoker;

        SplitRestrictionFn(DoFn<InputT, ?> splittableFn) {
            this.splittableFn = splittableFn;
        }

        @DoFn.Setup
        public void setup() {
            this.invoker = DoFnInvokers.invokerFor(this.splittableFn);
        }

        @DoFn.ProcessElement
        public void processElement(final DoFn.ProcessContext c) {
            final Object element = ((KV)c.element()).getKey();
            this.invoker.invokeSplitRestriction(element, ((KV)c.element()).getValue(), new DoFn.OutputReceiver<RestrictionT>(){

                public void output(RestrictionT part) {
                    c.output((Object)KV.of((Object)element, part));
                }
            });
        }
    }

    private static class PairWithRestrictionFn<InputT, OutputT, RestrictionT>
    extends DoFn<InputT, KV<InputT, RestrictionT>> {
        private DoFn<InputT, OutputT> fn;
        private transient DoFnInvoker<InputT, OutputT> invoker;

        PairWithRestrictionFn(DoFn<InputT, OutputT> fn) {
            this.fn = fn;
        }

        @DoFn.Setup
        public void setup() {
            this.invoker = DoFnInvokers.invokerFor(this.fn);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            context.output((Object)KV.of((Object)context.element(), (Object)this.invoker.invokeGetInitialRestriction(context.element())));
        }
    }

    private static class RandomUniqueKeyFn<T>
    implements SerializableFunction<T, String> {
        private RandomUniqueKeyFn() {
        }

        public String apply(T input) {
            return UUID.randomUUID().toString();
        }
    }

    public static class ProcessKeyedElements<InputT, OutputT, RestrictionT>
    extends PTransformTranslation.RawPTransform<PCollection<KV<String, KV<InputT, RestrictionT>>>, PCollectionTuple> {
        private final DoFn<InputT, OutputT> fn;
        private final Coder<InputT> elementCoder;
        private final Coder<RestrictionT> restrictionCoder;
        private final WindowingStrategy<InputT, ?> windowingStrategy;
        private final List<PCollectionView<?>> sideInputs;
        private final TupleTag<OutputT> mainOutputTag;
        private final TupleTagList additionalOutputTags;

        public ProcessKeyedElements(DoFn<InputT, OutputT> fn, Coder<InputT> elementCoder, Coder<RestrictionT> restrictionCoder, WindowingStrategy<InputT, ?> windowingStrategy, List<PCollectionView<?>> sideInputs, TupleTag<OutputT> mainOutputTag, TupleTagList additionalOutputTags) {
            this.fn = fn;
            this.elementCoder = elementCoder;
            this.restrictionCoder = restrictionCoder;
            this.windowingStrategy = windowingStrategy;
            this.sideInputs = sideInputs;
            this.mainOutputTag = mainOutputTag;
            this.additionalOutputTags = additionalOutputTags;
        }

        public DoFn<InputT, OutputT> getFn() {
            return this.fn;
        }

        public Coder<InputT> getElementCoder() {
            return this.elementCoder;
        }

        public Coder<RestrictionT> getRestrictionCoder() {
            return this.restrictionCoder;
        }

        public WindowingStrategy<InputT, ?> getInputWindowingStrategy() {
            return this.windowingStrategy;
        }

        public List<PCollectionView<?>> getSideInputs() {
            return this.sideInputs;
        }

        public TupleTag<OutputT> getMainOutputTag() {
            return this.mainOutputTag;
        }

        public TupleTagList getAdditionalOutputTags() {
            return this.additionalOutputTags;
        }

        public PCollectionTuple expand(PCollection<KV<String, KV<InputT, RestrictionT>>> input) {
            return ProcessKeyedElements.createPrimitiveOutputFor(input, this.fn, this.mainOutputTag, this.additionalOutputTags, this.windowingStrategy);
        }

        public static <OutputT> PCollectionTuple createPrimitiveOutputFor(PCollection<?> input, DoFn<?, OutputT> fn, TupleTag<OutputT> mainOutputTag, TupleTagList additionalOutputTags, WindowingStrategy<?, ?> windowingStrategy) {
            DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
            PCollectionTuple outputs = PCollectionTuple.ofPrimitiveOutputsInternal((Pipeline)input.getPipeline(), (TupleTagList)TupleTagList.of(mainOutputTag).and(additionalOutputTags.getAll()), windowingStrategy, (PCollection.IsBounded)input.isBounded().and(signature.isBoundedPerElement()));
            outputs.get(mainOutputTag).setTypeDescriptor(fn.getOutputTypeDescriptor());
            return outputs;
        }

        public Map<TupleTag<?>, PValue> getAdditionalInputs() {
            return PCollectionViews.toAdditionalInputs(this.sideInputs);
        }

        @Override
        public String getUrn() {
            return SplittableParDo.SPLITTABLE_PROCESS_KEYED_ELEMENTS_URN;
        }
    }

    private static class ExplodeWindowsFn<InputT>
    extends DoFn<InputT, InputT> {
        private ExplodeWindowsFn() {
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c, BoundedWindow window) {
            c.output(c.element());
        }
    }
}

