/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction;

import com.google.auto.service.AutoService;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;

public class WindowIntoTranslation {
    public static RunnerApi.WindowIntoPayload toProto(Window.Assign<?> transform, SdkComponents components) {
        return RunnerApi.WindowIntoPayload.newBuilder().setWindowFn(WindowingStrategyTranslation.toProto(transform.getWindowFn(), components)).build();
    }

    public static WindowFn<?, ?> getWindowFn(RunnerApi.WindowIntoPayload payload) throws InvalidProtocolBufferException {
        RunnerApi.SdkFunctionSpec spec = payload.getWindowFn();
        return WindowingStrategyTranslation.windowFnFromProto(spec);
    }

    @AutoService(value=TransformPayloadTranslatorRegistrar.class)
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return Collections.singletonMap(Window.Assign.class, new WindowIntoPayloadTranslator());
        }
    }

    public static class WindowIntoPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Window.Assign<?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new WindowIntoPayloadTranslator();
        }

        private WindowIntoPayloadTranslator() {
        }

        @Override
        public String getUrn(Window.Assign<?> transform) {
            return "urn:beam:transform:window:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Window.Assign<?>> transform, SdkComponents components) {
            RunnerApi.WindowIntoPayload payload = WindowIntoTranslation.toProto((Window.Assign)transform.getTransform(), components);
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((Window.Assign)transform.getTransform())).setParameter(Any.pack((Message)payload)).build();
        }
    }

    static class WindowAssignTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Window.Assign<?>> {
        WindowAssignTranslator() {
        }

        @Override
        public String getUrn(Window.Assign<?> transform) {
            return "urn:beam:transform:window:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Window.Assign<?>> transform, SdkComponents components) {
            return RunnerApi.FunctionSpec.newBuilder().setUrn("urn:beam:transform:window:v1").setParameter(Any.pack((Message)WindowIntoTranslation.toProto((Window.Assign)transform.getTransform(), components))).build();
        }
    }
}

