/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Duration;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.TriggerTranslation;
import org.apache.beam.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.common.runner.v1.StandardWindowFns;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.WindowingStrategy;

public class WindowingStrategyTranslation
implements Serializable {
    public static final String GLOBAL_WINDOWS_FN = "beam:windowfn:global_windows:v0.1";
    public static final String FIXED_WINDOWS_FN = "beam:windowfn:fixed_windows:v0.1";
    public static final String SLIDING_WINDOWS_FN = "beam:windowfn:sliding_windows:v0.1";
    public static final String SESSION_WINDOWS_FN = "beam:windowfn:session_windows:v0.1";
    public static final String SERIALIZED_JAVA_WINDOWFN_URN = "beam:windowfn:javasdk:v0.1";
    public static final String OLD_SERIALIZED_JAVA_WINDOWFN_URN = "urn:beam:windowfn:javasdk:0.1";
    private static final boolean USE_OLD_SERIALIZED_JAVA_WINDOWFN_URN = true;

    public static WindowingStrategy.AccumulationMode fromProto(RunnerApi.AccumulationMode proto) {
        switch (proto) {
            case DISCARDING: {
                return WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES;
            }
            case ACCUMULATING: {
                return WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.AccumulationMode.class.getCanonicalName(), WindowingStrategy.AccumulationMode.class.getCanonicalName(), proto));
    }

    public static RunnerApi.AccumulationMode toProto(WindowingStrategy.AccumulationMode accumulationMode) {
        switch (accumulationMode) {
            case DISCARDING_FIRED_PANES: {
                return RunnerApi.AccumulationMode.DISCARDING;
            }
            case ACCUMULATING_FIRED_PANES: {
                return RunnerApi.AccumulationMode.ACCUMULATING;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", WindowingStrategy.AccumulationMode.class.getCanonicalName(), RunnerApi.AccumulationMode.class.getCanonicalName(), accumulationMode));
    }

    public static RunnerApi.ClosingBehavior toProto(Window.ClosingBehavior closingBehavior) {
        switch (closingBehavior) {
            case FIRE_ALWAYS: {
                return RunnerApi.ClosingBehavior.EMIT_ALWAYS;
            }
            case FIRE_IF_NON_EMPTY: {
                return RunnerApi.ClosingBehavior.EMIT_IF_NONEMPTY;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", Window.ClosingBehavior.class.getCanonicalName(), RunnerApi.ClosingBehavior.class.getCanonicalName(), closingBehavior));
    }

    public static Window.ClosingBehavior fromProto(RunnerApi.ClosingBehavior proto) {
        switch (proto) {
            case EMIT_ALWAYS: {
                return Window.ClosingBehavior.FIRE_ALWAYS;
            }
            case EMIT_IF_NONEMPTY: {
                return Window.ClosingBehavior.FIRE_IF_NON_EMPTY;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.ClosingBehavior.class.getCanonicalName(), Window.ClosingBehavior.class.getCanonicalName(), proto));
    }

    public static Window.OnTimeBehavior fromProto(RunnerApi.OnTimeBehavior proto) {
        switch (proto) {
            case FIRE_ALWAYS: {
                return Window.OnTimeBehavior.FIRE_ALWAYS;
            }
            case FIRE_IF_NONEMPTY: {
                return Window.OnTimeBehavior.FIRE_IF_NON_EMPTY;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.OnTimeBehavior.class.getCanonicalName(), Window.OnTimeBehavior.class.getCanonicalName(), proto));
    }

    public static RunnerApi.OutputTime toProto(TimestampCombiner timestampCombiner) {
        switch (timestampCombiner) {
            case EARLIEST: {
                return RunnerApi.OutputTime.EARLIEST_IN_PANE;
            }
            case END_OF_WINDOW: {
                return RunnerApi.OutputTime.END_OF_WINDOW;
            }
            case LATEST: {
                return RunnerApi.OutputTime.LATEST_IN_PANE;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s: %s", TimestampCombiner.class.getSimpleName(), timestampCombiner));
    }

    public static TimestampCombiner timestampCombinerFromProto(RunnerApi.OutputTime proto) {
        switch (proto) {
            case EARLIEST_IN_PANE: {
                return TimestampCombiner.EARLIEST;
            }
            case END_OF_WINDOW: {
                return TimestampCombiner.END_OF_WINDOW;
            }
            case LATEST_IN_PANE: {
                return TimestampCombiner.LATEST;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.OutputTime.class.getCanonicalName(), RunnerApi.OutputTime.class.getCanonicalName(), proto));
    }

    public static RunnerApi.SdkFunctionSpec toProto(WindowFn<?, ?> windowFn, SdkComponents components) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(OLD_SERIALIZED_JAVA_WINDOWFN_URN).setParameter(Any.pack((Message)BytesValue.newBuilder().setValue(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(windowFn))).build()))).build();
    }

    public static RunnerApi.MessageWithComponents toProto(WindowingStrategy<?, ?> windowingStrategy) throws IOException {
        SdkComponents components = SdkComponents.create();
        RunnerApi.WindowingStrategy windowingStrategyProto = WindowingStrategyTranslation.toProto(windowingStrategy, components);
        return RunnerApi.MessageWithComponents.newBuilder().setWindowingStrategy(windowingStrategyProto).setComponents(components.toComponents()).build();
    }

    public static RunnerApi.WindowingStrategy toProto(WindowingStrategy<?, ?> windowingStrategy, SdkComponents components) throws IOException {
        RunnerApi.SdkFunctionSpec windowFnSpec = WindowingStrategyTranslation.toProto(windowingStrategy.getWindowFn(), components);
        RunnerApi.WindowingStrategy.Builder windowingStrategyProto = RunnerApi.WindowingStrategy.newBuilder().setOutputTime(WindowingStrategyTranslation.toProto(windowingStrategy.getTimestampCombiner())).setAccumulationMode(WindowingStrategyTranslation.toProto(windowingStrategy.getMode())).setClosingBehavior(WindowingStrategyTranslation.toProto(windowingStrategy.getClosingBehavior())).setAllowedLateness(windowingStrategy.getAllowedLateness().getMillis()).setTrigger(TriggerTranslation.toProto(windowingStrategy.getTrigger())).setWindowFn(windowFnSpec).setWindowCoderId(components.registerCoder(windowingStrategy.getWindowFn().windowCoder()));
        return windowingStrategyProto.build();
    }

    public static WindowingStrategy<?, ?> fromProto(RunnerApi.MessageWithComponents proto) throws InvalidProtocolBufferException {
        switch (proto.getRootCase()) {
            case WINDOWING_STRATEGY: {
                return WindowingStrategyTranslation.fromProto(proto.getWindowingStrategy(), proto.getComponents());
            }
        }
        throw new IllegalArgumentException(String.format("Expected a %s with components but received %s", RunnerApi.WindowingStrategy.class.getCanonicalName(), proto));
    }

    public static WindowingStrategy<?, ?> fromProto(RunnerApi.WindowingStrategy proto, RunnerApi.Components components) throws InvalidProtocolBufferException {
        RunnerApi.SdkFunctionSpec windowFnSpec = proto.getWindowFn();
        WindowFn<?, ?> windowFn = WindowingStrategyTranslation.windowFnFromProto(windowFnSpec);
        TimestampCombiner timestampCombiner = WindowingStrategyTranslation.timestampCombinerFromProto(proto.getOutputTime());
        WindowingStrategy.AccumulationMode accumulationMode = WindowingStrategyTranslation.fromProto(proto.getAccumulationMode());
        Trigger trigger = TriggerTranslation.fromProto(proto.getTrigger());
        Window.ClosingBehavior closingBehavior = WindowingStrategyTranslation.fromProto(proto.getClosingBehavior());
        org.joda.time.Duration allowedLateness = org.joda.time.Duration.millis((long)proto.getAllowedLateness());
        Window.OnTimeBehavior onTimeBehavior = WindowingStrategyTranslation.fromProto(proto.getOnTimeBehavior());
        return WindowingStrategy.of(windowFn).withAllowedLateness(allowedLateness).withMode(accumulationMode).withTrigger(trigger).withTimestampCombiner(timestampCombiner).withClosingBehavior(closingBehavior).withOnTimeBehavior(onTimeBehavior);
    }

    public static WindowFn<?, ?> windowFnFromProto(RunnerApi.SdkFunctionSpec windowFnSpec) throws InvalidProtocolBufferException {
        switch (windowFnSpec.getSpec().getUrn()) {
            case "beam:windowfn:global_windows:v0.1": {
                return new GlobalWindows();
            }
            case "beam:windowfn:fixed_windows:v0.1": {
                StandardWindowFns.FixedWindowsPayload fixedParams = (StandardWindowFns.FixedWindowsPayload)windowFnSpec.getSpec().getParameter().unpack(StandardWindowFns.FixedWindowsPayload.class);
                return FixedWindows.of((org.joda.time.Duration)org.joda.time.Duration.millis((long)Durations.toMillis((Duration)fixedParams.getSize()))).withOffset(org.joda.time.Duration.millis((long)Timestamps.toMillis((Timestamp)fixedParams.getOffset())));
            }
            case "beam:windowfn:sliding_windows:v0.1": {
                StandardWindowFns.SlidingWindowsPayload slidingParams = (StandardWindowFns.SlidingWindowsPayload)windowFnSpec.getSpec().getParameter().unpack(StandardWindowFns.SlidingWindowsPayload.class);
                return SlidingWindows.of((org.joda.time.Duration)org.joda.time.Duration.millis((long)Durations.toMillis((Duration)slidingParams.getSize()))).every(org.joda.time.Duration.millis((long)Durations.toMillis((Duration)slidingParams.getPeriod()))).withOffset(org.joda.time.Duration.millis((long)Timestamps.toMillis((Timestamp)slidingParams.getOffset())));
            }
            case "beam:windowfn:session_windows:v0.1": {
                StandardWindowFns.SessionsPayload sessionParams = (StandardWindowFns.SessionsPayload)windowFnSpec.getSpec().getParameter().unpack(StandardWindowFns.SessionsPayload.class);
                return Sessions.withGapDuration((org.joda.time.Duration)org.joda.time.Duration.millis((long)Durations.toMillis((Duration)sessionParams.getGapSize())));
            }
            case "beam:windowfn:javasdk:v0.1": 
            case "urn:beam:windowfn:javasdk:0.1": {
                return (WindowFn)SerializableUtils.deserializeFromByteArray((byte[])((BytesValue)windowFnSpec.getSpec().getParameter().unpack(BytesValue.class)).getValue().toByteArray(), (String)"WindowFn");
            }
        }
        throw new IllegalArgumentException("Unknown or unsupported WindowFn: " + windowFnSpec.getSpec().getUrn());
    }
}

