/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction;

import com.google.auto.service.AutoService;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;

public class WriteFilesTranslation {
    public static final String CUSTOM_JAVA_FILE_BASED_SINK_URN = "urn:beam:file_based_sink:javasdk:0.1";

    @VisibleForTesting
    static RunnerApi.WriteFilesPayload toProto(WriteFiles<?> transform) {
        return RunnerApi.WriteFilesPayload.newBuilder().setSink(WriteFilesTranslation.toProto(transform.getSink())).setWindowedWrites(transform.isWindowedWrites()).setRunnerDeterminedSharding(transform.getNumShards() == null && transform.getSharding() == null).build();
    }

    private static RunnerApi.SdkFunctionSpec toProto(FileBasedSink<?> sink) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_FILE_BASED_SINK_URN).setParameter(Any.pack((Message)BytesValue.newBuilder().setValue(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(sink))).build()))).build();
    }

    @VisibleForTesting
    static FileBasedSink<?> sinkFromProto(RunnerApi.SdkFunctionSpec sinkProto) throws IOException {
        Preconditions.checkArgument(sinkProto.getSpec().getUrn().equals(CUSTOM_JAVA_FILE_BASED_SINK_URN), "Cannot extract %s instance from %s with URN %s", (Object)FileBasedSink.class.getSimpleName(), (Object)RunnerApi.FunctionSpec.class.getSimpleName(), (Object)sinkProto.getSpec().getUrn());
        byte[] serializedSink = ((BytesValue)sinkProto.getSpec().getParameter().unpack(BytesValue.class)).getValue().toByteArray();
        return (FileBasedSink)SerializableUtils.deserializeFromByteArray((byte[])serializedSink, (String)FileBasedSink.class.getSimpleName());
    }

    public static <T> FileBasedSink<T> getSink(AppliedPTransform<PCollection<T>, PDone, ? extends PTransform<PCollection<T>, PDone>> transform) throws IOException {
        return WriteFilesTranslation.sinkFromProto(WriteFilesTranslation.getWriteFilesPayload(transform).getSink());
    }

    public static <T> boolean isWindowedWrites(AppliedPTransform<PCollection<T>, PDone, ? extends PTransform<PCollection<T>, PDone>> transform) throws IOException {
        return WriteFilesTranslation.getWriteFilesPayload(transform).getWindowedWrites();
    }

    public static <T> boolean isRunnerDeterminedSharding(AppliedPTransform<PCollection<T>, PDone, ? extends PTransform<PCollection<T>, PDone>> transform) throws IOException {
        return WriteFilesTranslation.getWriteFilesPayload(transform).getRunnerDeterminedSharding();
    }

    private static <T> RunnerApi.WriteFilesPayload getWriteFilesPayload(AppliedPTransform<PCollection<T>, PDone, ? extends PTransform<PCollection<T>, PDone>> transform) throws IOException {
        return (RunnerApi.WriteFilesPayload)PTransformTranslation.toProto(transform, Collections.emptyList(), SdkComponents.create()).getSpec().getParameter().unpack(RunnerApi.WriteFilesPayload.class);
    }

    @AutoService(value=TransformPayloadTranslatorRegistrar.class)
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return Collections.singletonMap(WriteFiles.class, new WriteFilesTranslator());
        }
    }

    static class WriteFilesTranslator
    implements PTransformTranslation.TransformPayloadTranslator<WriteFiles<?>> {
        WriteFilesTranslator() {
        }

        @Override
        public String getUrn(WriteFiles<?> transform) {
            return "urn:beam:transform:write_files:0.1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, WriteFiles<?>> transform, SdkComponents components) {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((WriteFiles)transform.getTransform())).setParameter(Any.pack((Message)WriteFilesTranslation.toProto((WriteFiles)transform.getTransform()))).build();
        }
    }
}

