/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;

public class DoFnInfo<InputT, OutputT>
implements Serializable {
    private final DoFn<InputT, OutputT> doFn;
    private final WindowingStrategy<?, ?> windowingStrategy;
    private final Iterable<PCollectionView<?>> sideInputViews;
    private final Coder<InputT> inputCoder;
    private final long mainOutput;
    private final Map<Long, TupleTag<?>> outputMap;

    public static <InputT, OutputT> DoFnInfo<InputT, OutputT> forFn(DoFn<InputT, OutputT> doFn, WindowingStrategy<?, ?> windowingStrategy, Iterable<PCollectionView<?>> sideInputViews, Coder<InputT> inputCoder, long mainOutput, Map<Long, TupleTag<?>> outputMap) {
        return new DoFnInfo<InputT, OutputT>(doFn, windowingStrategy, sideInputViews, inputCoder, mainOutput, outputMap);
    }

    public DoFnInfo<InputT, OutputT> withFn(DoFn<InputT, OutputT> newFn) {
        return DoFnInfo.forFn(newFn, this.windowingStrategy, this.sideInputViews, this.inputCoder, this.mainOutput, this.outputMap);
    }

    private DoFnInfo(DoFn<InputT, OutputT> doFn, WindowingStrategy<?, ?> windowingStrategy, Iterable<PCollectionView<?>> sideInputViews, Coder<InputT> inputCoder, long mainOutput, Map<Long, TupleTag<?>> outputMap) {
        this.doFn = doFn;
        this.windowingStrategy = windowingStrategy;
        this.sideInputViews = sideInputViews;
        this.inputCoder = inputCoder;
        this.mainOutput = mainOutput;
        this.outputMap = outputMap;
    }

    public DoFn<InputT, OutputT> getDoFn() {
        return this.doFn;
    }

    public WindowingStrategy<?, ?> getWindowingStrategy() {
        return this.windowingStrategy;
    }

    public Iterable<PCollectionView<?>> getSideInputViews() {
        return this.sideInputViews;
    }

    public Coder<InputT> getInputCoder() {
        return this.inputCoder;
    }

    public long getMainOutput() {
        return this.mainOutput;
    }

    public Map<Long, TupleTag<?>> getOutputMap() {
        return this.outputMap;
    }
}

