/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.services.dataflow.model.DataflowPackage;
import java.util.List;
import org.apache.beam.runners.dataflow.options.DataflowPipelineDebugOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.repackaged.com.google.common.base.MoreObjects;
import org.apache.beam.runners.dataflow.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.dataflow.util.PackageUtil;
import org.apache.beam.runners.dataflow.util.Stager;
import org.apache.beam.sdk.extensions.gcp.storage.GcsCreateOptions;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.options.PipelineOptions;

public class GcsStager
implements Stager {
    private DataflowPipelineOptions options;

    private GcsStager(DataflowPipelineOptions options) {
        this.options = options;
    }

    public static GcsStager fromOptions(PipelineOptions options) {
        return new GcsStager((DataflowPipelineOptions)options.as(DataflowPipelineOptions.class));
    }

    @Override
    public List<DataflowPackage> stageFiles() {
        int uploadSizeBytes;
        Preconditions.checkNotNull(this.options.getStagingLocation());
        String windmillBinary = ((DataflowPipelineDebugOptions)this.options.as(DataflowPipelineDebugOptions.class)).getOverrideWindmillBinary();
        if (windmillBinary != null) {
            this.options.getFilesToStage().add("windmill_main=" + windmillBinary);
        }
        Preconditions.checkArgument((uploadSizeBytes = MoreObjects.firstNonNull(this.options.getGcsUploadBufferSizeBytes(), 0x100000).intValue()) > 0, "gcsUploadBufferSizeBytes must be > 0");
        uploadSizeBytes = Math.min(uploadSizeBytes, 0x100000);
        GcsCreateOptions createOptions = ((GcsCreateOptions.Builder)GcsCreateOptions.builder().setGcsUploadBufferSizeBytes(Integer.valueOf(uploadSizeBytes)).setMimeType("application/octet-stream")).build();
        return PackageUtil.stageClasspathElements(this.options.getFilesToStage(), this.options.getStagingLocation(), (CreateOptions)createOptions);
    }
}

