/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.dataflow.model.AutoscalingSettings;
import com.google.api.services.dataflow.model.DataflowPackage;
import com.google.api.services.dataflow.model.Disk;
import com.google.api.services.dataflow.model.Environment;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.Step;
import com.google.api.services.dataflow.model.WorkerPool;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.Environments;
import org.apache.beam.runners.core.construction.PipelineTranslation;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.core.construction.TransformInputs;
import org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.runners.dataflow.BatchViewOverrides;
import org.apache.beam.runners.dataflow.CreateDataflowView;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.dataflow.PrimitiveParDoSingleFactory;
import org.apache.beam.runners.dataflow.ReadTranslator;
import org.apache.beam.runners.dataflow.TransformTranslator;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjects;
import org.apache.beam.runners.dataflow.util.OutputReference;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.util.AppliedCombineFn;
import org.apache.beam.sdk.util.DoFnInfo;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.StringUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.MessageOrBuilder;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.TextFormat;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class DataflowPipelineTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(DataflowPipelineTranslator.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static Map<Class, TransformTranslator> transformTranslators = new HashMap<Class, TransformTranslator>();
    private final DataflowPipelineOptions options;

    private static byte[] serializeWindowingStrategy(WindowingStrategy<?, ?> windowingStrategy) {
        try {
            SdkComponents sdkComponents = SdkComponents.create();
            sdkComponents.registerEnvironment(Environments.JAVA_SDK_HARNESS_ENVIRONMENT);
            return WindowingStrategyTranslation.toMessageProto(windowingStrategy, (SdkComponents)sdkComponents).toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to format windowing strategy %s as bytes", windowingStrategy), e);
        }
    }

    public static DataflowPipelineTranslator fromOptions(DataflowPipelineOptions options) {
        return new DataflowPipelineTranslator(options);
    }

    private DataflowPipelineTranslator(DataflowPipelineOptions options) {
        this.options = options;
    }

    public JobSpecification translate(Pipeline pipeline, DataflowRunner runner, List<DataflowPackage> packages) {
        SdkComponents sdkComponents = SdkComponents.create();
        sdkComponents.registerEnvironment(Environments.JAVA_SDK_HARNESS_ENVIRONMENT);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        LOG.debug("Portable pipeline proto:\n{}", (Object)TextFormat.printToString((MessageOrBuilder)pipelineProto));
        Translator translator = new Translator(pipeline, runner, sdkComponents);
        Job result = translator.translate(packages);
        return new JobSpecification(result, pipelineProto, Collections.unmodifiableMap(translator.stepNames));
    }

    public static String jobToString(Job job) {
        try {
            return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)job);
        }
        catch (JsonProcessingException exc) {
            throw new IllegalStateException("Failed to render Job as String.", exc);
        }
    }

    public static <TransformT extends PTransform> void registerTransformTranslator(Class<TransformT> transformClass, TransformTranslator<? extends TransformT> transformTranslator) {
        if (transformTranslators.put(transformClass, transformTranslator) != null) {
            throw new IllegalArgumentException("defining multiple translators for " + transformClass);
        }
    }

    public <TransformT extends PTransform> TransformTranslator<TransformT> getTransformTranslator(Class<TransformT> transformClass) {
        return transformTranslators.get(transformClass);
    }

    public String toString() {
        return "DataflowPipelineTranslator#" + this.hashCode();
    }

    private static Map<String, Object> getProperties(Step step) {
        HashMap properties = step.getProperties();
        if (properties == null) {
            properties = new HashMap();
            step.setProperties(properties);
        }
        return properties;
    }

    private static void translateInputs(TransformTranslator.StepTranslationContext stepContext, PCollection<?> input, List<PCollectionView<?>> sideInputs, TransformTranslator.TranslationContext context) {
        stepContext.addInput("parallel_input", (PInput)input);
        DataflowPipelineTranslator.translateSideInputs(stepContext, sideInputs, context);
    }

    private static void translateSideInputs(TransformTranslator.StepTranslationContext stepContext, List<PCollectionView<?>> sideInputs, TransformTranslator.TranslationContext context) {
        HashMap<String, Object> nonParInputs = new HashMap<String, Object>();
        for (PCollectionView<?> view : sideInputs) {
            nonParInputs.put(view.getTagInternal().getId(), (Object)context.asOutputReference((PValue)view, context.getProducer((PValue)view)));
        }
        stepContext.addInput("non_parallel_inputs", nonParInputs);
    }

    private static void translateFn(TransformTranslator.StepTranslationContext stepContext, String ptransformId, DoFn fn, WindowingStrategy windowingStrategy, Iterable<PCollectionView<?>> sideInputs, Coder inputCoder, TransformTranslator.TranslationContext context, TupleTag<?> mainOutput, Map<TupleTag<?>, Coder<?>> outputCoders) {
        DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
        if (signature.usesState() || signature.usesTimers()) {
            DataflowRunner.verifyStateSupported(fn);
            DataflowRunner.verifyStateSupportForWindowingStrategy(windowingStrategy);
        }
        stepContext.addInput("user_fn", fn.getClass().getName());
        if (context.isFnApi()) {
            stepContext.addInput("serialized_fn", ptransformId);
        } else {
            stepContext.addInput("serialized_fn", StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)DoFnInfo.forFn((DoFn)fn, (WindowingStrategy)windowingStrategy, sideInputs, (Coder)inputCoder, outputCoders, mainOutput))));
        }
        if (context.getPipelineOptions().isStreaming() && (signature.usesState() || signature.usesTimers())) {
            stepContext.addInput("uses_keyed_state", "true");
        }
    }

    private static void translateOutputs(Map<TupleTag<?>, PValue> outputs, TransformTranslator.StepTranslationContext stepContext) {
        for (Map.Entry<TupleTag<?>, PValue> taggedOutput : outputs.entrySet()) {
            TupleTag<?> tag = taggedOutput.getKey();
            Preconditions.checkArgument((boolean)(taggedOutput.getValue() instanceof PCollection), (String)"Non %s returned from Multi-output %s", (Object)PCollection.class.getSimpleName(), (Object)stepContext);
            stepContext.addOutput(tag.getId(), (PCollection)taggedOutput.getValue());
        }
    }

    private static CloudObject translateCoder(Coder<?> coder, TransformTranslator.TranslationContext context) {
        return CloudObjects.asCloudObject(coder, context.isFnApi() ? context.getSdkComponents() : null);
    }

    static {
        DataflowPipelineTranslator.registerTransformTranslator(View.CreatePCollectionView.class, new TransformTranslator<View.CreatePCollectionView>(){

            @Override
            public void translate(View.CreatePCollectionView transform, TransformTranslator.TranslationContext context) {
                this.translateTyped(transform, context);
            }

            private <ElemT, ViewT> void translateTyped(View.CreatePCollectionView<ElemT, ViewT> transform, TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "CollectionToSingleton");
                PCollection input = (PCollection)context.getInput(transform);
                stepContext.addInput("parallel_input", (PInput)input);
                WindowingStrategy windowingStrategy = input.getWindowingStrategy();
                stepContext.addInput("windowing_strategy", StringUtils.byteArrayToJsonString((byte[])DataflowPipelineTranslator.serializeWindowingStrategy(windowingStrategy)));
                stepContext.addInput("is_merging_window_fn", !windowingStrategy.getWindowFn().isNonMerging());
                stepContext.addCollectionToSingletonOutput(input, "output", transform.getView());
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(CreateDataflowView.class, new TransformTranslator<CreateDataflowView>(){

            @Override
            public void translate(CreateDataflowView transform, TransformTranslator.TranslationContext context) {
                this.translateTyped(transform, context);
            }

            private <ElemT, ViewT> void translateTyped(CreateDataflowView<ElemT, ViewT> transform, TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep(transform, "CollectionToSingleton");
                PCollection input = (PCollection)context.getInput(transform);
                stepContext.addInput("parallel_input", (PInput)input);
                stepContext.addCollectionToSingletonOutput(input, "output", transform.getView());
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(DataflowRunner.CombineGroupedValues.class, new TransformTranslator<DataflowRunner.CombineGroupedValues>(){

            @Override
            public void translate(DataflowRunner.CombineGroupedValues transform, TransformTranslator.TranslationContext context) {
                this.translateHelper(transform, context);
            }

            private <K, InputT, OutputT> void translateHelper(DataflowRunner.CombineGroupedValues<K, InputT, OutputT> primitiveTransform, TransformTranslator.TranslationContext context) {
                boolean isFnApi;
                Combine.GroupedValues<K, InputT, OutputT> originalTransform = primitiveTransform.getOriginalCombine();
                TransformTranslator.StepTranslationContext stepContext = context.addStep(primitiveTransform, "CombineValues");
                DataflowPipelineTranslator.translateInputs(stepContext, (PCollection)context.getInput(primitiveTransform), originalTransform.getSideInputs(), context);
                AppliedCombineFn fn = originalTransform.getAppliedFn(((PCollection)context.getInput(primitiveTransform)).getPipeline().getCoderRegistry(), ((PCollection)context.getInput(primitiveTransform)).getCoder(), ((PCollection)context.getInput(primitiveTransform)).getWindowingStrategy());
                stepContext.addEncodingInput(fn.getAccumulatorCoder());
                List experiments = context.getPipelineOptions().getExperiments();
                boolean bl = isFnApi = experiments != null && experiments.contains("beam_fn_api");
                if (isFnApi) {
                    String ptransformId = context.getSdkComponents().getPTransformIdOrThrow(context.getCurrentParent());
                    stepContext.addInput("serialized_fn", ptransformId);
                } else {
                    stepContext.addInput("serialized_fn", StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)fn)));
                }
                stepContext.addOutput("output", (PCollection)context.getOutput(primitiveTransform));
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(Flatten.PCollections.class, new TransformTranslator<Flatten.PCollections>(){

            @Override
            public void translate(Flatten.PCollections transform, TransformTranslator.TranslationContext context) {
                this.flattenHelper(transform, context);
            }

            private <T> void flattenHelper(Flatten.PCollections<T> transform, TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "Flatten");
                ArrayList<OutputReference> inputs = new ArrayList<OutputReference>();
                for (PValue input : context.getInputs(transform).values()) {
                    inputs.add(context.asOutputReference(input, context.getProducer(input)));
                }
                stepContext.addInput("inputs", inputs);
                stepContext.addOutput("output", (PCollection)context.getOutput(transform));
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(BatchViewOverrides.GroupByKeyAndSortValuesOnly.class, new TransformTranslator<BatchViewOverrides.GroupByKeyAndSortValuesOnly>(){

            @Override
            public void translate(BatchViewOverrides.GroupByKeyAndSortValuesOnly transform, TransformTranslator.TranslationContext context) {
                this.groupByKeyAndSortValuesHelper(transform, context);
            }

            private <K1, K2, V> void groupByKeyAndSortValuesHelper(BatchViewOverrides.GroupByKeyAndSortValuesOnly<K1, K2, V> transform, TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep(transform, "GroupByKey");
                PCollection input = (PCollection)context.getInput(transform);
                stepContext.addInput("parallel_input", (PInput)input);
                stepContext.addOutput("output", (PCollection)context.getOutput(transform));
                stepContext.addInput("sort_values", true);
                stepContext.addInput("disallow_combiner_lifting", true);
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(GroupByKey.class, new TransformTranslator<GroupByKey>(){

            @Override
            public void translate(GroupByKey transform, TransformTranslator.TranslationContext context) {
                this.groupByKeyHelper(transform, context);
            }

            private <K, V> void groupByKeyHelper(GroupByKey<K, V> transform, TransformTranslator.TranslationContext context) {
                boolean allowCombinerLifting;
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "GroupByKey");
                PCollection input = (PCollection)context.getInput(transform);
                stepContext.addInput("parallel_input", (PInput)input);
                stepContext.addOutput("output", (PCollection)context.getOutput(transform));
                WindowingStrategy windowingStrategy = input.getWindowingStrategy();
                boolean isStreaming = ((StreamingOptions)context.getPipelineOptions().as(StreamingOptions.class)).isStreaming();
                boolean bl = allowCombinerLifting = windowingStrategy.getWindowFn().isNonMerging() && windowingStrategy.getWindowFn().assignsToOneWindow();
                if (isStreaming) {
                    allowCombinerLifting &= transform.fewKeys();
                    allowCombinerLifting &= windowingStrategy.getTrigger() instanceof DefaultTrigger;
                }
                stepContext.addInput("disallow_combiner_lifting", !allowCombinerLifting);
                stepContext.addInput("serialized_fn", StringUtils.byteArrayToJsonString((byte[])DataflowPipelineTranslator.serializeWindowingStrategy(windowingStrategy)));
                stepContext.addInput("is_merging_window_fn", !windowingStrategy.getWindowFn().isNonMerging());
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(ParDo.MultiOutput.class, new TransformTranslator<ParDo.MultiOutput>(){

            @Override
            public void translate(ParDo.MultiOutput transform, TransformTranslator.TranslationContext context) {
                this.translateMultiHelper(transform, context);
            }

            private <InputT, OutputT> void translateMultiHelper(ParDo.MultiOutput<InputT, OutputT> transform, TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "ParallelDo");
                Map<TupleTag, Coder> outputCoders = context.getOutputs(transform).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PCollection)e.getValue()).getCoder()));
                DataflowPipelineTranslator.translateInputs(stepContext, (PCollection)context.getInput(transform), transform.getSideInputs(), context);
                DataflowPipelineTranslator.translateOutputs(context.getOutputs(transform), stepContext);
                String ptransformId = context.getSdkComponents().getPTransformIdOrThrow(context.getCurrentTransform());
                DataflowPipelineTranslator.translateFn(stepContext, ptransformId, transform.getFn(), ((PCollection)context.getInput(transform)).getWindowingStrategy(), transform.getSideInputs(), ((PCollection)context.getInput(transform)).getCoder(), context, transform.getMainOutputTag(), outputCoders);
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(PrimitiveParDoSingleFactory.ParDoSingle.class, new TransformTranslator<PrimitiveParDoSingleFactory.ParDoSingle>(){

            @Override
            public void translate(PrimitiveParDoSingleFactory.ParDoSingle transform, TransformTranslator.TranslationContext context) {
                this.translateSingleHelper(transform, context);
            }

            private <InputT, OutputT> void translateSingleHelper(PrimitiveParDoSingleFactory.ParDoSingle<InputT, OutputT> transform, TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "ParallelDo");
                Map<TupleTag, Coder> outputCoders = context.getOutputs(transform).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PCollection)e.getValue()).getCoder()));
                DataflowPipelineTranslator.translateInputs(stepContext, (PCollection)context.getInput(transform), transform.getSideInputs(), context);
                stepContext.addOutput(transform.getMainOutputTag().getId(), (PCollection)context.getOutput(transform));
                String ptransformId = context.getSdkComponents().getPTransformIdOrThrow(context.getCurrentTransform());
                DataflowPipelineTranslator.translateFn(stepContext, ptransformId, transform.getFn(), ((PCollection)context.getInput(transform)).getWindowingStrategy(), transform.getSideInputs(), ((PCollection)context.getInput(transform)).getCoder(), context, transform.getMainOutputTag(), outputCoders);
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(Window.Assign.class, new TransformTranslator<Window.Assign>(){

            @Override
            public void translate(Window.Assign transform, TransformTranslator.TranslationContext context) {
                this.translateHelper(transform, context);
            }

            private <T> void translateHelper(Window.Assign<T> transform, TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "Bucket");
                PCollection input = (PCollection)context.getInput(transform);
                stepContext.addInput("parallel_input", (PInput)input);
                stepContext.addOutput("output", (PCollection)context.getOutput(transform));
                WindowingStrategy strategy = ((PCollection)context.getOutput(transform)).getWindowingStrategy();
                byte[] serializedBytes = DataflowPipelineTranslator.serializeWindowingStrategy(strategy);
                String serializedJson = StringUtils.byteArrayToJsonString((byte[])serializedBytes);
                stepContext.addInput("serialized_fn", serializedJson);
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(Read.Bounded.class, new ReadTranslator());
        DataflowPipelineTranslator.registerTransformTranslator(SplittableParDo.ProcessKeyedElements.class, new TransformTranslator<SplittableParDo.ProcessKeyedElements>(){

            @Override
            public void translate(SplittableParDo.ProcessKeyedElements transform, TransformTranslator.TranslationContext context) {
                this.translateTyped(transform, context);
            }

            private <InputT, OutputT, RestrictionT> void translateTyped(SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT> transform, TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "SplittableProcessKeyed");
                Map<TupleTag, Coder> outputCoders = context.getOutputs(transform).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PCollection)e.getValue()).getCoder()));
                DataflowPipelineTranslator.translateInputs(stepContext, (PCollection)context.getInput(transform), transform.getSideInputs(), context);
                DataflowPipelineTranslator.translateOutputs(context.getOutputs(transform), stepContext);
                String ptransformId = context.getSdkComponents().getPTransformIdOrThrow(context.getCurrentTransform());
                DataflowPipelineTranslator.translateFn(stepContext, ptransformId, transform.getFn(), transform.getInputWindowingStrategy(), transform.getSideInputs(), transform.getElementCoder(), context, transform.getMainOutputTag(), outputCoders);
                stepContext.addInput("restriction_coder", (Map<String, Object>)((Object)DataflowPipelineTranslator.translateCoder(transform.getRestrictionCoder(), context)));
            }
        });
    }

    static class StepTranslator
    implements TransformTranslator.StepTranslationContext {
        private final Translator translator;
        private final Step step;

        private StepTranslator(Translator translator, Step step) {
            this.translator = translator;
            this.step = step;
        }

        private Map<String, Object> getProperties() {
            return DataflowPipelineTranslator.getProperties(this.step);
        }

        @Override
        public void addEncodingInput(Coder<?> coder) {
            CloudObject encoding = DataflowPipelineTranslator.translateCoder(coder, this.translator);
            Structs.addObject(this.getProperties(), "encoding", (Map<String, Object>)((Object)encoding));
        }

        @Override
        public void addInput(String name, Boolean value) {
            Structs.addBoolean(this.getProperties(), name, value);
        }

        @Override
        public void addInput(String name, String value) {
            Structs.addString(this.getProperties(), name, value);
        }

        @Override
        public void addInput(String name, Long value) {
            Structs.addLong(this.getProperties(), name, value);
        }

        @Override
        public void addInput(String name, Map<String, Object> elements) {
            Structs.addDictionary(this.getProperties(), name, elements);
        }

        @Override
        public void addInput(String name, List<? extends Map<String, Object>> elements) {
            Structs.addList(this.getProperties(), name, elements);
        }

        @Override
        public void addInput(String name, PInput value) {
            if (!(value instanceof PValue)) {
                throw new IllegalStateException("Input must be a PValue");
            }
            PValue pvalue = (PValue)value;
            this.addInput(name, (Map<String, Object>)((Object)this.translator.asOutputReference(pvalue, this.translator.getProducer(pvalue))));
        }

        @Override
        public void addOutput(String name, PCollection<?> value) {
            this.translator.producers.put(value, this.translator.currentTransform);
            WindowedValue.FullWindowedValueCoder coder = WindowedValue.getFullCoder((Coder)value.getCoder(), (Coder)value.getWindowingStrategy().getWindowFn().windowCoder());
            this.addOutput(name, (PValue)value, (Coder<?>)coder);
        }

        @Override
        public void addCollectionToSingletonOutput(PCollection<?> inputValue, String outputName, PCollectionView<?> outputValue) {
            this.translator.producers.put(outputValue, this.translator.currentTransform);
            Coder inputValueCoder = (Coder)Preconditions.checkNotNull((Object)((Coder)this.translator.outputCoders.get(inputValue)));
            Preconditions.checkState((boolean)(inputValueCoder instanceof WindowedValue.WindowedValueCoder));
            IterableCoder outputValueCoder = IterableCoder.of((Coder)inputValueCoder);
            this.addOutput(outputName, (PValue)outputValue, (Coder<?>)outputValueCoder);
        }

        private void addOutput(String name, PValue value, Coder<?> valueCoder) {
            this.translator.registerOutputName(value, name);
            Map<String, Object> properties = this.getProperties();
            ArrayList<HashMap<String, Object>> outputInfoList = null;
            try {
                outputInfoList = (ArrayList<HashMap<String, Object>>)properties.get("output_info");
            }
            catch (Exception e) {
                throw new RuntimeException("Inconsistent dataflow pipeline translation", e);
            }
            if (outputInfoList == null) {
                outputInfoList = new ArrayList<HashMap<String, Object>>();
                properties.put("output_info", outputInfoList);
            }
            HashMap<String, Object> outputInfo = new HashMap<String, Object>();
            Structs.addString(outputInfo, "output_name", name);
            String stepName = Structs.getString(properties, "user_name");
            String generatedName = String.format("%s.out%d", stepName, outputInfoList.size());
            Structs.addString(outputInfo, "user_name", generatedName);
            if (value instanceof PCollection && this.translator.runner.doesPCollectionRequireIndexedFormat((PCollection)value)) {
                Structs.addBoolean(outputInfo, "use_indexed_format", true);
            }
            if (valueCoder != null) {
                CloudObject encoding = DataflowPipelineTranslator.translateCoder(valueCoder, this.translator);
                Structs.addObject(outputInfo, "encoding", (Map<String, Object>)((Object)encoding));
                this.translator.outputCoders.put(value, valueCoder);
            }
            outputInfoList.add(outputInfo);
        }

        private void addDisplayData(Step step, String stepName, HasDisplayData hasDisplayData) {
            DisplayData displayData = DisplayData.from((HasDisplayData)hasDisplayData);
            List list = (List)MAPPER.convertValue((Object)displayData, List.class);
            Structs.addList(this.getProperties(), "display_data", list);
        }
    }

    class Translator
    extends Pipeline.PipelineVisitor.Defaults
    implements TransformTranslator.TranslationContext {
        private final Supplier<Long> idGenerator = new Supplier<Long>(){
            private final AtomicLong generator = new AtomicLong(1L);

            public Long get() {
                return this.generator.getAndIncrement();
            }
        };
        private final Pipeline pipeline;
        private final DataflowRunner runner;
        private final Job job = new Job();
        private final Map<AppliedPTransform<?, ?, ?>, String> stepNames = new HashMap();
        private final Map<PValue, AppliedPTransform<?, ?, ?>> producers = new HashMap();
        private final Map<PValue, String> outputNames = new HashMap<PValue, String>();
        private final Map<PValue, Coder<?>> outputCoders = new HashMap();
        private final SdkComponents sdkComponents;
        private AppliedPTransform<?, ?, ?> currentTransform;
        private ArrayDeque<TransformHierarchy.Node> parents = new ArrayDeque();

        public Translator(Pipeline pipeline, DataflowRunner runner, SdkComponents sdkComponents) {
            this.pipeline = pipeline;
            this.runner = runner;
            this.sdkComponents = sdkComponents;
        }

        public Job translate(List<DataflowPackage> packages) {
            List<String> experiments;
            this.job.setName(DataflowPipelineTranslator.this.options.getJobName().toLowerCase());
            Environment environment = new Environment();
            this.job.setEnvironment(environment);
            WorkerPool workerPool = new WorkerPool();
            if (DataflowPipelineTranslator.this.options.isEnableStreamingEngine()) {
                experiments = DataflowPipelineTranslator.this.options.getExperiments();
                if (experiments == null) {
                    experiments = new ArrayList<String>();
                }
                if (!experiments.contains("enable_streaming_engine")) {
                    experiments.add("enable_streaming_engine");
                }
                if (!experiments.contains("enable_windmill_service")) {
                    experiments.add("enable_windmill_service");
                }
                DataflowPipelineTranslator.this.options.setExperiments(experiments);
            } else {
                experiments = DataflowPipelineTranslator.this.options.getExperiments();
                if (experiments != null && (experiments.contains("enable_streaming_engine") || experiments.contains("enable_windmill_service"))) {
                    throw new IllegalArgumentException("Streaming engine both disabled and enabled: enableStreamingEngine is set to false, but enable_windmill_service and/or enable_streaming_engine are present. It is recommended you only set enableStreamingEngine.");
                }
            }
            if (DataflowPipelineTranslator.this.options.isStreaming()) {
                this.job.setType("JOB_TYPE_STREAMING");
            } else {
                this.job.setType("JOB_TYPE_BATCH");
                workerPool.setDiskType(DataflowPipelineTranslator.this.options.getWorkerDiskType());
            }
            if (DataflowPipelineTranslator.this.options.getWorkerMachineType() != null) {
                workerPool.setMachineType(DataflowPipelineTranslator.this.options.getWorkerMachineType());
            }
            if (DataflowPipelineTranslator.this.options.getUsePublicIps() != null) {
                if (DataflowPipelineTranslator.this.options.getUsePublicIps().booleanValue()) {
                    workerPool.setIpConfiguration("WORKER_IP_PUBLIC");
                } else {
                    workerPool.setIpConfiguration("WORKER_IP_PRIVATE");
                }
            }
            workerPool.setPackages(packages);
            workerPool.setNumWorkers(Integer.valueOf(DataflowPipelineTranslator.this.options.getNumWorkers()));
            if (DataflowPipelineTranslator.this.options.getLabels() != null) {
                this.job.setLabels(DataflowPipelineTranslator.this.options.getLabels());
            }
            if (DataflowPipelineTranslator.this.options.isStreaming() && !ExperimentalOptions.hasExperiment((PipelineOptions)DataflowPipelineTranslator.this.options, (String)"enable_windmill_service")) {
                Disk disk = new Disk();
                disk.setDiskType(DataflowPipelineTranslator.this.options.getWorkerDiskType());
                workerPool.setDataDisks(Collections.singletonList(disk));
            }
            if (!Strings.isNullOrEmpty((String)DataflowPipelineTranslator.this.options.getZone())) {
                workerPool.setZone(DataflowPipelineTranslator.this.options.getZone());
            }
            if (!Strings.isNullOrEmpty((String)DataflowPipelineTranslator.this.options.getNetwork())) {
                workerPool.setNetwork(DataflowPipelineTranslator.this.options.getNetwork());
            }
            if (!Strings.isNullOrEmpty((String)DataflowPipelineTranslator.this.options.getSubnetwork())) {
                workerPool.setSubnetwork(DataflowPipelineTranslator.this.options.getSubnetwork());
            }
            if (DataflowPipelineTranslator.this.options.getDiskSizeGb() > 0) {
                workerPool.setDiskSizeGb(Integer.valueOf(DataflowPipelineTranslator.this.options.getDiskSizeGb()));
            }
            AutoscalingSettings settings = new AutoscalingSettings();
            if (DataflowPipelineTranslator.this.options.getAutoscalingAlgorithm() != null) {
                settings.setAlgorithm(DataflowPipelineTranslator.this.options.getAutoscalingAlgorithm().getAlgorithm());
            }
            settings.setMaxNumWorkers(Integer.valueOf(DataflowPipelineTranslator.this.options.getMaxNumWorkers()));
            workerPool.setAutoscalingSettings(settings);
            ArrayList<WorkerPool> workerPools = new ArrayList<WorkerPool>();
            workerPools.add(workerPool);
            environment.setWorkerPools(workerPools);
            if (DataflowPipelineTranslator.this.options.getServiceAccount() != null) {
                environment.setServiceAccountEmail(DataflowPipelineTranslator.this.options.getServiceAccount());
            }
            if (DataflowPipelineTranslator.this.options.getDataflowKmsKey() != null) {
                ExperimentalOptions.addExperiment((ExperimentalOptions)DataflowPipelineTranslator.this.options, (String)String.format("service_default_cmek_config=%s", DataflowPipelineTranslator.this.options.getDataflowKmsKey()));
            }
            this.pipeline.traverseTopologically((Pipeline.PipelineVisitor)this);
            return this.job;
        }

        @Override
        public DataflowPipelineOptions getPipelineOptions() {
            return DataflowPipelineTranslator.this.options;
        }

        @Override
        public <InputT extends PInput> Map<TupleTag<?>, PValue> getInputs(PTransform<InputT, ?> transform) {
            return this.getCurrentTransform(transform).getInputs();
        }

        @Override
        public <InputT extends PValue> InputT getInput(PTransform<InputT, ?> transform) {
            return (InputT)((PValue)Iterables.getOnlyElement((Iterable)TransformInputs.nonAdditionalInputs(this.getCurrentTransform(transform))));
        }

        @Override
        public <OutputT extends POutput> Map<TupleTag<?>, PValue> getOutputs(PTransform<?, OutputT> transform) {
            return this.getCurrentTransform(transform).getOutputs();
        }

        @Override
        public <OutputT extends PValue> OutputT getOutput(PTransform<?, OutputT> transform) {
            return (OutputT)((PValue)Iterables.getOnlyElement(this.getOutputs(transform).values()));
        }

        @Override
        public String getFullName(PTransform<?, ?> transform) {
            return this.getCurrentTransform(transform).getFullName();
        }

        @Override
        public AppliedPTransform<?, ?, ?> getCurrentTransform() {
            return this.currentTransform;
        }

        private AppliedPTransform<?, ?, ?> getCurrentTransform(PTransform<?, ?> transform) {
            Preconditions.checkArgument((this.currentTransform != null && this.currentTransform.getTransform() == transform ? 1 : 0) != 0, (Object)"can only be called with current transform");
            return this.currentTransform;
        }

        public void visitPrimitiveTransform(TransformHierarchy.Node node) {
            PTransform transform = node.getTransform();
            TransformTranslator<?> translator = DataflowPipelineTranslator.this.getTransformTranslator(transform.getClass());
            Preconditions.checkState((translator != null ? 1 : 0) != 0, (String)"no translator registered for primitive transform %s at node %s", (Object)transform, (Object)node.getFullName());
            LOG.debug("Translating {}", (Object)transform);
            this.currentTransform = node.toAppliedPTransform(this.getPipeline());
            translator.translate(transform, this);
            this.currentTransform = null;
        }

        public void visitValue(PValue value, TransformHierarchy.Node producer) {
            LOG.debug("Checking translation of {}", (Object)value);
            if (producer.getTransform() instanceof CreateDataflowView && !ExperimentalOptions.hasExperiment((PipelineOptions)DataflowPipelineTranslator.this.options, (String)"beam_fn_api")) {
                this.asOutputReference((PValue)((CreateDataflowView)producer.getTransform()).getView(), (AppliedPTransform<?, ?, ?>)producer.toAppliedPTransform(this.getPipeline()));
                return;
            }
            if (producer.getTransform() instanceof View.CreatePCollectionView && ExperimentalOptions.hasExperiment((PipelineOptions)DataflowPipelineTranslator.this.options, (String)"beam_fn_api")) {
                this.asOutputReference((PValue)((View.CreatePCollectionView)producer.getTransform()).getView(), producer.toAppliedPTransform(this.getPipeline()));
                return;
            }
            this.asOutputReference(value, producer.toAppliedPTransform(this.getPipeline()));
        }

        @Override
        public StepTranslator addStep(PTransform<?, ?> transform, String type) {
            String stepName = this.genStepName();
            if (this.stepNames.put(this.getCurrentTransform(transform), stepName) != null) {
                throw new IllegalArgumentException(transform + " already has a name specified");
            }
            ArrayList<Step> steps = this.job.getSteps();
            if (steps == null) {
                steps = new ArrayList<Step>();
                this.job.setSteps(steps);
            }
            Step step = new Step();
            step.setName(stepName);
            step.setKind(type);
            steps.add(step);
            StepTranslator stepContext = new StepTranslator(this, step);
            stepContext.addInput("user_name", this.getFullName(transform));
            stepContext.addDisplayData(step, stepName, transform);
            LOG.info("Adding {} as step {}", (Object)this.getCurrentTransform(transform).getFullName(), (Object)stepName);
            return stepContext;
        }

        @Override
        public OutputReference asOutputReference(PValue value, AppliedPTransform<?, ?, ?> producer) {
            String stepName = this.stepNames.get(producer);
            Preconditions.checkArgument((stepName != null ? 1 : 0) != 0, (String)"%s doesn't have a name specified", producer);
            String outputName = this.outputNames.get(value);
            Preconditions.checkArgument((outputName != null ? 1 : 0) != 0, (String)"output %s doesn't have a name specified", (Object)value);
            return new OutputReference(stepName, outputName);
        }

        @Override
        public SdkComponents getSdkComponents() {
            return this.sdkComponents;
        }

        @Override
        public AppliedPTransform<?, ?, ?> getProducer(PValue value) {
            return (AppliedPTransform)Preconditions.checkNotNull(this.producers.get(value), (String)"Unknown producer for value %s while translating step %s", (Object)value, (Object)this.currentTransform.getFullName());
        }

        private String genStepName() {
            return "s" + (this.stepNames.size() + 1);
        }

        private void registerOutputName(PValue value, String name) {
            if (this.outputNames.put(value, name) != null) {
                throw new IllegalArgumentException("output " + value + " already has a name specified");
            }
        }

        public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
            if (!node.isRootNode()) {
                this.parents.addFirst(node);
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        public void leaveCompositeTransform(TransformHierarchy.Node node) {
            if (!node.isRootNode()) {
                this.parents.removeFirst();
            }
        }

        @Override
        public AppliedPTransform<?, ?, ?> getCurrentParent() {
            if (this.parents.isEmpty()) {
                return null;
            }
            return this.parents.peekFirst().toAppliedPTransform(this.getPipeline());
        }
    }

    public static class JobSpecification {
        private final Job job;
        private final Map<AppliedPTransform<?, ?, ?>, String> stepNames;
        private final RunnerApi.Pipeline pipelineProto;

        public JobSpecification(Job job, RunnerApi.Pipeline pipelineProto, Map<AppliedPTransform<?, ?, ?>, String> stepNames) {
            this.job = job;
            this.pipelineProto = pipelineProto;
            this.stepNames = stepNames;
        }

        public Job getJob() {
            return this.job;
        }

        public RunnerApi.Pipeline getPipelineProto() {
            return this.pipelineProto;
        }

        public Map<AppliedPTransform<?, ?, ?>, String> getStepNames() {
            return this.stepNames;
        }
    }
}

