/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataflowRunnerInfo
extends ReleaseInfo {
    private static final Logger LOG = LoggerFactory.getLogger(DataflowRunnerInfo.class);
    private static final String APACHE_BEAM_DISTRIBUTION_PROPERTIES_PATH = "/org/apache/beam/runners/dataflow/dataflow.properties";
    private static final String FNAPI_ENVIRONMENT_MAJOR_VERSION_KEY = "fnapi.environment.major.version";
    private static final String LEGACY_ENVIRONMENT_MAJOR_VERSION_KEY = "legacy.environment.major.version";
    private static final String CONTAINER_VERSION_KEY = "container.version";
    private final Map<String, String> properties;

    public static DataflowRunnerInfo getDataflowRunnerInfo() {
        return LazyInit.INSTANCE;
    }

    public String getLegacyEnvironmentMajorVersion() {
        Preconditions.checkState((boolean)this.properties.containsKey(LEGACY_ENVIRONMENT_MAJOR_VERSION_KEY), (Object)"Unknown legacy environment major version");
        return this.properties.get(LEGACY_ENVIRONMENT_MAJOR_VERSION_KEY);
    }

    public String getFnApiEnvironmentMajorVersion() {
        Preconditions.checkState((boolean)this.properties.containsKey(FNAPI_ENVIRONMENT_MAJOR_VERSION_KEY), (Object)"Unknown FnAPI environment major version");
        return this.properties.get(FNAPI_ENVIRONMENT_MAJOR_VERSION_KEY);
    }

    public String getContainerVersion() {
        Preconditions.checkState((boolean)this.properties.containsKey(CONTAINER_VERSION_KEY), (Object)"Unknown container version");
        return this.properties.get(CONTAINER_VERSION_KEY);
    }

    public Map<String, String> getProperties() {
        return ImmutableMap.copyOf(this.properties);
    }

    private DataflowRunnerInfo(Map<String, String> properties) {
        this.properties = properties;
    }

    private static Properties load(String path) throws IOException {
        Properties properties = new Properties();
        try (InputStream in = DataflowRunnerInfo.class.getResourceAsStream(path);){
            if (in == null) {
                Properties properties2 = null;
                return properties2;
            }
            properties.load(in);
        }
        return properties;
    }

    private static void copyFromSystemProperties(String property, Properties properties) {
        String value = System.getProperty(property);
        if (value != null) {
            properties.setProperty(property, value);
        }
    }

    private static class LazyInit {
        private static final DataflowRunnerInfo INSTANCE;

        private LazyInit() {
        }

        static {
            Properties properties;
            try {
                properties = DataflowRunnerInfo.load(DataflowRunnerInfo.APACHE_BEAM_DISTRIBUTION_PROPERTIES_PATH);
                if (properties == null) {
                    LOG.warn("Dataflow runner properties resource not found.");
                    properties = new Properties();
                }
            }
            catch (IOException e) {
                LOG.warn("Error loading Dataflow runner properties resource: ", (Throwable)e);
                properties = new Properties();
            }
            if (!properties.containsKey("name")) {
                properties.setProperty("name", ReleaseInfo.getReleaseInfo().getName());
            }
            if (!properties.containsKey("version")) {
                properties.setProperty("version", ReleaseInfo.getReleaseInfo().getVersion());
            }
            DataflowRunnerInfo.copyFromSystemProperties("java.vendor", properties);
            DataflowRunnerInfo.copyFromSystemProperties("java.version", properties);
            DataflowRunnerInfo.copyFromSystemProperties("os.arch", properties);
            DataflowRunnerInfo.copyFromSystemProperties("os.name", properties);
            DataflowRunnerInfo.copyFromSystemProperties("os.version", properties);
            INSTANCE = new DataflowRunnerInfo((Map)ImmutableMap.copyOf((Map)properties));
        }
    }
}

