/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.ForwardingPTransform;
import org.apache.beam.runners.core.construction.PTransformReplacements;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.SingleInputOutputOverrideFactory;
import org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PCollectionViews;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Sets;

public class PrimitiveParDoSingleFactory<InputT, OutputT>
extends SingleInputOutputOverrideFactory<PCollection<? extends InputT>, PCollection<OutputT>, ParDo.SingleOutput<InputT, OutputT>> {
    public PTransformOverrideFactory.PTransformReplacement<PCollection<? extends InputT>, PCollection<OutputT>> getReplacementTransform(AppliedPTransform<PCollection<? extends InputT>, PCollection<OutputT>, ParDo.SingleOutput<InputT, OutputT>> transform) {
        return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new ParDoSingle((ParDo.SingleOutput)transform.getTransform(), (TupleTag)Iterables.getOnlyElement(transform.getOutputs().keySet()), PTransformReplacements.getSingletonMainOutput(transform).getCoder()));
    }

    @AutoService(value=TransformPayloadTranslatorRegistrar.class)
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return Collections.singletonMap(ParDoSingle.class, new PayloadTranslator());
        }
    }

    public static class PayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<ParDoSingle<?, ?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new PayloadTranslator();
        }

        private PayloadTranslator() {
        }

        public String getUrn(ParDoSingle<?, ?> transform) {
            return PTransformTranslation.PAR_DO_TRANSFORM_URN;
        }

        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, ParDoSingle<?, ?>> transform, SdkComponents components) throws IOException {
            RunnerApi.ParDoPayload payload = PayloadTranslator.payloadForParDoSingle(transform, components);
            return RunnerApi.FunctionSpec.newBuilder().setUrn(PTransformTranslation.PAR_DO_TRANSFORM_URN).setPayload(payload.toByteString()).build();
        }

        private static RunnerApi.ParDoPayload payloadForParDoSingle(final AppliedPTransform<?, ?, ParDoSingle<?, ?>> transform, SdkComponents components) throws IOException {
            final ParDoSingle parDo = (ParDoSingle)transform.getTransform();
            final DoFn doFn = parDo.getFn();
            final DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
            if (!ExperimentalOptions.hasExperiment((PipelineOptions)transform.getPipeline().getOptions(), (String)"beam_fn_api")) {
                Preconditions.checkArgument((!signature.processElement().isSplittable() ? 1 : 0) != 0, (Object)String.format("Not expecting a splittable %s: should have been overridden", ParDoSingle.class.getSimpleName()));
            }
            Set allInputs = transform.getInputs().keySet().stream().map(TupleTag::getId).collect(Collectors.toSet());
            Set sideInputs = parDo.getSideInputs().stream().map(s -> s.getTagInternal().getId()).collect(Collectors.toSet());
            Set timerInputs = signature.timerDeclarations().keySet();
            String mainInputName = (String)Iterables.getOnlyElement((Iterable)Sets.difference(allInputs, (Set)Sets.union(sideInputs, timerInputs)));
            PCollection mainInput = (PCollection)transform.getInputs().get(new TupleTag(mainInputName));
            final DoFnSchemaInformation doFnSchemaInformation = ParDo.getDoFnSchemaInformation(doFn, (PCollection)mainInput);
            return ParDoTranslation.payloadForParDoLike((ParDoTranslation.ParDoLike)new ParDoTranslation.ParDoLike(){

                public RunnerApi.SdkFunctionSpec translateDoFn(SdkComponents newComponents) {
                    return ParDoTranslation.translateDoFn(parDo.getFn(), parDo.getMainOutputTag(), (DoFnSchemaInformation)doFnSchemaInformation, (SdkComponents)newComponents);
                }

                public List<RunnerApi.Parameter> translateParameters() {
                    return ParDoTranslation.translateParameters((List)signature.processElement().extraParameters());
                }

                public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents components) {
                    return ParDoTranslation.translateSideInputs(parDo.getSideInputs(), (SdkComponents)components);
                }

                public Map<String, RunnerApi.StateSpec> translateStateSpecs(SdkComponents components) throws IOException {
                    HashMap<String, RunnerApi.StateSpec> stateSpecs = new HashMap<String, RunnerApi.StateSpec>();
                    for (Map.Entry state : signature.stateDeclarations().entrySet()) {
                        RunnerApi.StateSpec spec = ParDoTranslation.translateStateSpec((StateSpec)DoFnSignatures.getStateSpecOrThrow((DoFnSignature.StateDeclaration)((DoFnSignature.StateDeclaration)state.getValue()), (DoFn)doFn), (SdkComponents)components);
                        stateSpecs.put((String)state.getKey(), spec);
                    }
                    return stateSpecs;
                }

                public Map<String, RunnerApi.TimerSpec> translateTimerSpecs(SdkComponents newComponents) {
                    HashMap<String, RunnerApi.TimerSpec> timerSpecs = new HashMap<String, RunnerApi.TimerSpec>();
                    for (Map.Entry timer : signature.timerDeclarations().entrySet()) {
                        RunnerApi.TimerSpec spec = ParDoTranslation.translateTimerSpec((TimerSpec)DoFnSignatures.getTimerSpecOrThrow((DoFnSignature.TimerDeclaration)((DoFnSignature.TimerDeclaration)timer.getValue()), (DoFn)doFn), (SdkComponents)newComponents);
                        timerSpecs.put((String)timer.getKey(), spec);
                    }
                    return timerSpecs;
                }

                public boolean isSplittable() {
                    return signature.processElement().isSplittable();
                }

                public String translateRestrictionCoderId(SdkComponents newComponents) {
                    if (signature.processElement().isSplittable()) {
                        Coder restrictionCoder = DoFnInvokers.invokerFor((DoFn)doFn).invokeGetRestrictionCoder(transform.getPipeline().getCoderRegistry());
                        try {
                            return newComponents.registerCoder(restrictionCoder);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(String.format("Unable to register restriction coder for %s.", transform.getFullName()), e);
                        }
                    }
                    return "";
                }
            }, (SdkComponents)components);
        }
    }

    public static class ParDoSingle<InputT, OutputT>
    extends ForwardingPTransform<PCollection<? extends InputT>, PCollection<OutputT>> {
        private final ParDo.SingleOutput<InputT, OutputT> original;
        private final TupleTag<?> onlyOutputTag;
        private final Coder<OutputT> outputCoder;

        private ParDoSingle(ParDo.SingleOutput<InputT, OutputT> original, TupleTag<?> onlyOutputTag, Coder<OutputT> outputCoder) {
            this.original = original;
            this.onlyOutputTag = onlyOutputTag;
            this.outputCoder = outputCoder;
        }

        public PCollection<OutputT> expand(PCollection<? extends InputT> input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)input.getWindowingStrategy(), (PCollection.IsBounded)input.isBounded(), this.outputCoder, this.onlyOutputTag);
        }

        public DoFn<InputT, OutputT> getFn() {
            return this.original.getFn();
        }

        public TupleTag<?> getMainOutputTag() {
            return this.onlyOutputTag;
        }

        public List<PCollectionView<?>> getSideInputs() {
            return this.original.getSideInputs();
        }

        public Map<TupleTag<?>, PValue> getAdditionalInputs() {
            return PCollectionViews.toAdditionalInputs(this.getSideInputs());
        }

        protected PTransform<PCollection<? extends InputT>, PCollection<OutputT>> delegate() {
            return this.original;
        }
    }
}

