/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

class SerializableCoderCloudObjectTranslator
implements CloudObjectTranslator<SerializableCoder> {
    private static final String TYPE_FIELD = "type";

    SerializableCoderCloudObjectTranslator() {
    }

    @Override
    public CloudObject toCloudObject(SerializableCoder target, SdkComponents sdkComponents) {
        CloudObject base = CloudObject.forClass(SerializableCoder.class);
        Structs.addString((Map<String, Object>)((Object)base), TYPE_FIELD, target.getRecordType().getName());
        return base;
    }

    @Override
    public SerializableCoder<?> fromCloudObject(CloudObject cloudObject) {
        String className = Structs.getString((Map<String, Object>)((Object)cloudObject), TYPE_FIELD);
        try {
            Class<?> targetClass = Class.forName(className);
            Preconditions.checkArgument((boolean)Serializable.class.isAssignableFrom(targetClass), (String)"Target class %s does not extend %s", (Object)targetClass.getName(), (Object)Serializable.class.getSimpleName());
            return SerializableCoder.of(targetClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Class<SerializableCoder> getSupportedClass() {
        return SerializableCoder.class;
    }

    @Override
    public String cloudObjectClassName() {
        return CloudObject.forClass(SerializableCoder.class).getClassName();
    }
}

