/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.internal;

import com.google.auto.value.AutoValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.runners.dataflow.internal.AutoValue_IsmFormat_Footer;
import org.apache.beam.runners.dataflow.internal.AutoValue_IsmFormat_IsmRecord;
import org.apache.beam.runners.dataflow.internal.AutoValue_IsmFormat_IsmShard;
import org.apache.beam.runners.dataflow.internal.AutoValue_IsmFormat_KeyPrefix;
import org.apache.beam.runners.dataflow.util.RandomAccessData;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.hash.HashFunction;
import org.apache.beam.vendor.guava.v20_0.com.google.common.hash.Hashing;

public class IsmFormat {
    private static final int HASH_SEED = 1225801234;
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32((int)1225801234);
    public static final int SHARD_BITS = 127;
    private static final Object METADATA_KEY = new Object(){

        public String toString() {
            return "META";
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return -1248902349;
        }
    };
    public static final Coder<List<IsmShard>> ISM_SHARD_INDEX_CODER = ListCoder.of((Coder)IsmShardCoder.of());

    public static void validateCoderIsCompatible(IsmRecordCoder<?> coder) {
        for (Coder<?> keyComponentCoder : coder.getKeyComponentCoders()) {
            try {
                keyComponentCoder.verifyDeterministic();
            }
            catch (Coder.NonDeterministicException e) {
                throw new IllegalArgumentException(String.format("Key component coder %s is expected to be deterministic.", keyComponentCoder), e);
            }
        }
    }

    public static boolean isMetadataKey(List<?> keyComponents) {
        for (Object keyComponent : keyComponents) {
            if (keyComponent != METADATA_KEY) continue;
            return true;
        }
        return false;
    }

    public static Object getMetadataKey() {
        return METADATA_KEY;
    }

    public static final class FooterCoder
    extends AtomicCoder<Footer> {
        private static final FooterCoder INSTANCE = new FooterCoder();

        public static FooterCoder of() {
            return INSTANCE;
        }

        public void encode(Footer value, OutputStream outStream) throws CoderException, IOException {
            DataOutputStream dataOut = new DataOutputStream(outStream);
            dataOut.writeLong(value.getIndexPosition());
            dataOut.writeLong(value.getBloomFilterPosition());
            dataOut.writeLong(value.getNumberOfKeys());
            dataOut.write(2);
        }

        public Footer decode(InputStream inStream) throws CoderException, IOException {
            DataInputStream dataIn = new DataInputStream(inStream);
            Footer footer = Footer.of(dataIn.readLong(), dataIn.readLong(), dataIn.readLong());
            int version = dataIn.read();
            if (version != 2) {
                throw new IOException("Unknown version " + version + ". Only version 2 is currently supported.");
            }
            return footer;
        }

        public void verifyDeterministic() {
        }

        public boolean consistentWithEquals() {
            return true;
        }

        public boolean isRegisterByteSizeObserverCheap(Footer value) {
            return true;
        }

        public long getEncodedElementByteSize(Footer value) throws Exception {
            return 25L;
        }
    }

    @AutoValue
    public static abstract class Footer {
        public static final int LONG_BYTES = 8;
        public static final int FIXED_LENGTH = 25;
        public static final byte VERSION = 2;

        public abstract byte getVersion();

        public abstract long getIndexPosition();

        public abstract long getBloomFilterPosition();

        public abstract long getNumberOfKeys();

        public static Footer of(long indexPosition, long bloomFilterPosition, long numberOfKeys) {
            return new AutoValue_IsmFormat_Footer(2, indexPosition, bloomFilterPosition, numberOfKeys);
        }
    }

    public static final class KeyPrefixCoder
    extends AtomicCoder<KeyPrefix> {
        private static final KeyPrefixCoder INSTANCE = new KeyPrefixCoder();

        public static KeyPrefixCoder of() {
            return INSTANCE;
        }

        public void encode(KeyPrefix value, OutputStream outStream) throws CoderException, IOException {
            VarInt.encode((int)value.getSharedKeySize(), (OutputStream)outStream);
            VarInt.encode((int)value.getUnsharedKeySize(), (OutputStream)outStream);
        }

        public KeyPrefix decode(InputStream inStream) throws CoderException, IOException {
            return KeyPrefix.of(VarInt.decodeInt((InputStream)inStream), VarInt.decodeInt((InputStream)inStream));
        }

        public void verifyDeterministic() {
        }

        public boolean consistentWithEquals() {
            return true;
        }

        public boolean isRegisterByteSizeObserverCheap(KeyPrefix value) {
            return true;
        }

        public long getEncodedElementByteSize(KeyPrefix value) throws Exception {
            Preconditions.checkNotNull((Object)value);
            return (long)VarInt.getLength((int)value.getSharedKeySize()) + (long)VarInt.getLength((int)value.getUnsharedKeySize());
        }
    }

    @AutoValue
    public static abstract class KeyPrefix {
        public abstract int getSharedKeySize();

        public abstract int getUnsharedKeySize();

        public static KeyPrefix of(int sharedKeySize, int unsharedKeySize) {
            return new AutoValue_IsmFormat_KeyPrefix(sharedKeySize, unsharedKeySize);
        }
    }

    public static class IsmShardCoder
    extends AtomicCoder<IsmShard> {
        private static final IsmShardCoder INSTANCE = new IsmShardCoder();

        public static IsmShardCoder of() {
            return INSTANCE;
        }

        private IsmShardCoder() {
        }

        public void encode(IsmShard value, OutputStream outStream) throws CoderException, IOException {
            Preconditions.checkState((value.getIndexOffset() >= 0L ? 1 : 0) != 0, (String)"%s attempting to be written without index offset.", (Object)value);
            VarIntCoder.of().encode(Integer.valueOf(value.getId()), outStream);
            VarLongCoder.of().encode(Long.valueOf(value.getBlockOffset()), outStream);
            VarLongCoder.of().encode(Long.valueOf(value.getIndexOffset()), outStream);
        }

        public IsmShard decode(InputStream inStream) throws CoderException, IOException {
            return IsmShard.of(VarIntCoder.of().decode(inStream), VarLongCoder.of().decode(inStream), VarLongCoder.of().decode(inStream));
        }

        public void verifyDeterministic() {
            VarIntCoder.of().verifyDeterministic();
            VarLongCoder.of().verifyDeterministic();
        }

        public boolean consistentWithEquals() {
            return true;
        }
    }

    @AutoValue
    public static abstract class IsmShard {
        abstract int id();

        abstract long blockOffset();

        abstract long indexOffset();

        IsmShard() {
        }

        public static IsmShard of(int id, long blockOffset) {
            AutoValue_IsmFormat_IsmShard ismShard = new AutoValue_IsmFormat_IsmShard(id, blockOffset, -1L);
            Preconditions.checkState((id >= 0 ? 1 : 0) != 0, (String)"%s attempting to be written with negative shard id.", (Object)ismShard);
            Preconditions.checkState((blockOffset >= 0L ? 1 : 0) != 0, (String)"%s attempting to be written with negative block offset.", (Object)ismShard);
            return ismShard;
        }

        public static IsmShard of(int id, long blockOffset, long indexOffset) {
            AutoValue_IsmFormat_IsmShard ismShard = new AutoValue_IsmFormat_IsmShard(id, blockOffset, indexOffset);
            Preconditions.checkState((id >= 0 ? 1 : 0) != 0, (String)"%s attempting to be written with negative shard id.", (Object)ismShard);
            Preconditions.checkState((blockOffset >= 0L ? 1 : 0) != 0, (String)"%s attempting to be written with negative block offset.", (Object)ismShard);
            Preconditions.checkState((indexOffset >= 0L ? 1 : 0) != 0, (String)"%s attempting to be written with negative index offset.", (Object)ismShard);
            return ismShard;
        }

        public int getId() {
            return this.id();
        }

        public long getBlockOffset() {
            return this.blockOffset();
        }

        public long getIndexOffset() {
            Preconditions.checkState((this.indexOffset() >= 0L ? 1 : 0) != 0, (Object)"Unable to fetch index offset because it was never specified.");
            return this.indexOffset();
        }

        public IsmShard withIndexOffset(long indexOffset) {
            return IsmShard.of(this.id(), this.blockOffset(), indexOffset);
        }
    }

    public static class MetadataKeyCoder<K>
    extends StructuredCoder<K> {
        private final Coder<K> keyCoder;

        public static <K> MetadataKeyCoder<K> of(Coder<K> keyCoder) {
            Preconditions.checkNotNull(keyCoder);
            return new MetadataKeyCoder<K>(keyCoder);
        }

        private MetadataKeyCoder(Coder<K> keyCoder) {
            this.keyCoder = keyCoder;
        }

        public Coder<K> getKeyCoder() {
            return this.keyCoder;
        }

        public void encode(K value, OutputStream outStream) throws CoderException, IOException {
            if (value == METADATA_KEY) {
                outStream.write(0);
            } else {
                outStream.write(1);
                this.keyCoder.encode(value, outStream);
            }
        }

        public K decode(InputStream inStream) throws CoderException, IOException {
            int marker = inStream.read();
            if (marker == 0) {
                return (K)IsmFormat.getMetadataKey();
            }
            if (marker == 1) {
                return (K)this.keyCoder.decode(inStream);
            }
            throw new CoderException(String.format("Expected marker but got %s.", marker));
        }

        public List<Coder<?>> getCoderArguments() {
            return ImmutableList.of(this.keyCoder);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            MetadataKeyCoder.verifyDeterministic((Coder)this, (String)"Expected key coder to be deterministic", (Coder[])new Coder[]{this.keyCoder});
        }
    }

    public static class IsmRecordCoder<V>
    extends CustomCoder<IsmRecord<V>> {
        private final int numberOfShardKeyCoders;
        private final int numberOfMetadataShardKeyCoders;
        private final List<Coder<?>> keyComponentCoders;
        private final Coder<V> valueCoder;

        public static <V> IsmRecordCoder<V> of(int numberOfShardKeyCoders, int numberOfMetadataShardKeyCoders, List<Coder<?>> keyComponentCoders, Coder<V> valueCoder) {
            Preconditions.checkNotNull(keyComponentCoders);
            Preconditions.checkArgument((keyComponentCoders.size() > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((numberOfShardKeyCoders > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((numberOfShardKeyCoders <= keyComponentCoders.size() ? 1 : 0) != 0);
            Preconditions.checkArgument((numberOfMetadataShardKeyCoders <= keyComponentCoders.size() ? 1 : 0) != 0);
            return new IsmRecordCoder<V>(numberOfShardKeyCoders, numberOfMetadataShardKeyCoders, keyComponentCoders, valueCoder);
        }

        private IsmRecordCoder(int numberOfShardKeyCoders, int numberOfMetadataShardKeyCoders, List<Coder<?>> keyComponentCoders, Coder<V> valueCoder) {
            this.numberOfShardKeyCoders = numberOfShardKeyCoders;
            this.numberOfMetadataShardKeyCoders = numberOfMetadataShardKeyCoders;
            this.keyComponentCoders = keyComponentCoders;
            this.valueCoder = valueCoder;
        }

        public List<Coder<?>> getKeyComponentCoders() {
            return this.keyComponentCoders;
        }

        public <T> Coder<T> getKeyComponentCoder(int index) {
            return this.keyComponentCoders.get(index);
        }

        public Coder<V> getValueCoder() {
            return this.valueCoder;
        }

        public void encode(IsmRecord<V> value, OutputStream outStream) throws CoderException, IOException {
            if (value.getKeyComponents().size() != this.keyComponentCoders.size()) {
                throw new CoderException(String.format("Expected %s key component(s) but received key component(s) %s.", this.keyComponentCoders.size(), value.getKeyComponents()));
            }
            for (int i = 0; i < this.keyComponentCoders.size(); ++i) {
                this.getKeyComponentCoder(i).encode(value.getKeyComponent(i), outStream);
            }
            if (IsmFormat.isMetadataKey(value.getKeyComponents())) {
                ByteArrayCoder.of().encode(value.getMetadata(), outStream);
            } else {
                this.valueCoder.encode(value.getValue(), outStream);
            }
        }

        public IsmRecord<V> decode(InputStream inStream) throws CoderException, IOException {
            ArrayList<Object> keyComponents = new ArrayList<Object>(this.keyComponentCoders.size());
            for (Coder<?> keyCoder : this.keyComponentCoders) {
                keyComponents.add(keyCoder.decode(inStream));
            }
            if (IsmFormat.isMetadataKey(keyComponents)) {
                return IsmRecord.meta(keyComponents, ByteArrayCoder.of().decode(inStream));
            }
            return IsmRecord.of(keyComponents, this.valueCoder.decode(inStream));
        }

        public int getNumberOfShardKeyCoders(List<?> keyComponents) {
            if (IsmFormat.isMetadataKey(keyComponents)) {
                return this.numberOfMetadataShardKeyCoders;
            }
            return this.numberOfShardKeyCoders;
        }

        public int hash(List<?> keyComponents) {
            return this.encodeAndHash(keyComponents, new RandomAccessData(), new ArrayList<Integer>());
        }

        public int encodeAndHash(List<?> keyComponents, RandomAccessData keyBytesToMutate) {
            return this.encodeAndHash(keyComponents, keyBytesToMutate, new ArrayList<Integer>());
        }

        public int encodeAndHash(List<?> keyComponents, RandomAccessData keyBytesToMutate, List<Integer> keyComponentByteOffsetsToMutate) {
            int shardOffset;
            int numberOfKeyCodersToUse;
            Preconditions.checkNotNull(keyComponents);
            Preconditions.checkArgument((keyComponents.size() <= this.keyComponentCoders.size() ? 1 : 0) != 0, (String)"Expected at most %s key component(s) but received %s.", (int)this.keyComponentCoders.size(), keyComponents);
            if (IsmFormat.isMetadataKey(keyComponents)) {
                numberOfKeyCodersToUse = this.numberOfMetadataShardKeyCoders;
                shardOffset = 128;
            } else {
                numberOfKeyCodersToUse = this.numberOfShardKeyCoders;
                shardOffset = 0;
            }
            Preconditions.checkArgument((numberOfKeyCodersToUse <= keyComponents.size() ? 1 : 0) != 0, (String)"Expected at least %s key component(s) but received %s.", (int)this.numberOfShardKeyCoders, keyComponents);
            try {
                for (int i = 0; i < numberOfKeyCodersToUse; ++i) {
                    this.getKeyComponentCoder(i).encode(keyComponents.get(i), keyBytesToMutate.asOutputStream(), Coder.Context.NESTED);
                    keyComponentByteOffsetsToMutate.add(keyBytesToMutate.size());
                }
                int rval = HASH_FUNCTION.hashBytes(keyBytesToMutate.array(), 0, keyBytesToMutate.size()).asInt() & 0x7F;
                rval += shardOffset;
                for (int i = numberOfKeyCodersToUse; i < keyComponents.size(); ++i) {
                    this.getKeyComponentCoder(i).encode(keyComponents.get(i), keyBytesToMutate.asOutputStream(), Coder.Context.NESTED);
                    keyComponentByteOffsetsToMutate.add(keyBytesToMutate.size());
                }
                return rval;
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Failed to hash %s with coder %s", new Object[]{keyComponents, this}), e);
            }
        }

        public List<Coder<?>> getCoderArguments() {
            return ImmutableList.builder().addAll(this.keyComponentCoders).add(this.valueCoder).build();
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            IsmRecordCoder.verifyDeterministic((Coder)this, (String)"Key component coders expected to be deterministic.", this.keyComponentCoders);
            IsmRecordCoder.verifyDeterministic((Coder)this, (String)"Value coder expected to be deterministic.", (Coder[])new Coder[]{this.valueCoder});
        }

        public boolean consistentWithEquals() {
            for (Coder<?> keyComponentCoder : this.keyComponentCoders) {
                if (keyComponentCoder.consistentWithEquals()) continue;
                return false;
            }
            return this.valueCoder.consistentWithEquals();
        }

        public Object structuralValue(IsmRecord<V> record) {
            Preconditions.checkNotNull(record);
            Preconditions.checkState((record.getKeyComponents().size() == this.keyComponentCoders.size() ? 1 : 0) != 0, (String)"Expected the number of key component coders %s to match the number of key components %s.", (int)this.keyComponentCoders.size(), record.getKeyComponents());
            if (this.consistentWithEquals()) {
                ArrayList<Object> keyComponentStructuralValues = new ArrayList<Object>();
                for (int i = 0; i < this.keyComponentCoders.size(); ++i) {
                    keyComponentStructuralValues.add(this.getKeyComponentCoder(i).structuralValue(record.getKeyComponent(i)));
                }
                if (IsmFormat.isMetadataKey(record.getKeyComponents())) {
                    return IsmRecord.meta(keyComponentStructuralValues, record.getMetadata());
                }
                return IsmRecord.of(keyComponentStructuralValues, this.valueCoder.structuralValue(record.getValue()));
            }
            return super.structuralValue(record);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof IsmRecordCoder)) {
                return false;
            }
            IsmRecordCoder that = (IsmRecordCoder)((Object)other);
            return Objects.equals(this.numberOfShardKeyCoders, that.numberOfShardKeyCoders) && Objects.equals(this.numberOfMetadataShardKeyCoders, that.numberOfMetadataShardKeyCoders) && Objects.equals(this.keyComponentCoders, that.keyComponentCoders) && Objects.equals(this.valueCoder, that.valueCoder);
        }

        public int hashCode() {
            return Objects.hash(this.numberOfShardKeyCoders, this.numberOfMetadataShardKeyCoders, this.keyComponentCoders, this.valueCoder);
        }
    }

    @AutoValue
    public static abstract class IsmRecord<V> {
        abstract List<?> keyComponents();

        @Nullable
        abstract V value();

        @Nullable
        abstract byte[] metadata();

        IsmRecord() {
        }

        public static <V> IsmRecord<V> of(List<?> keyComponents, V value) {
            Preconditions.checkArgument((!keyComponents.isEmpty() ? 1 : 0) != 0, (Object)"Expected non-empty list of key components.");
            Preconditions.checkArgument((!IsmFormat.isMetadataKey(keyComponents) ? 1 : 0) != 0, (Object)"Expected key components to not contain metadata key.");
            return new AutoValue_IsmFormat_IsmRecord<V>(keyComponents, value, null);
        }

        public static <V> IsmRecord<V> meta(List<?> keyComponents, byte[] metadata) {
            Preconditions.checkNotNull((Object)metadata);
            Preconditions.checkArgument((!keyComponents.isEmpty() ? 1 : 0) != 0, (Object)"Expected non-empty list of key components.");
            Preconditions.checkArgument((boolean)IsmFormat.isMetadataKey(keyComponents), (Object)"Expected key components to contain metadata key.");
            return new AutoValue_IsmFormat_IsmRecord<Object>(keyComponents, null, metadata);
        }

        public List<?> getKeyComponents() {
            return this.keyComponents();
        }

        public Object getKeyComponent(int index) {
            return this.keyComponents().get(index);
        }

        public V getValue() {
            Preconditions.checkState((!IsmFormat.isMetadataKey(this.keyComponents()) ? 1 : 0) != 0, (Object)"This is a metadata record and not a value record.");
            return this.value();
        }

        public byte[] getMetadata() {
            Preconditions.checkState((boolean)IsmFormat.isMetadataKey(this.keyComponents()), (Object)"This is a value record and not a metadata record.");
            return this.metadata();
        }
    }
}

