/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.auto.service.AutoService;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.dataflow.internal.IsmFormat;
import org.apache.beam.runners.dataflow.util.AvroCoderCloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslators;
import org.apache.beam.runners.dataflow.util.CoderCloudObjectTranslatorRegistrar;
import org.apache.beam.runners.dataflow.util.RandomAccessData;
import org.apache.beam.runners.dataflow.util.SchemaCoderCloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.SerializableCoderCloudObjectTranslator;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.BigIntegerCoder;
import org.apache.beam.sdk.coders.BitSetCoder;
import org.apache.beam.sdk.coders.ByteCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CollectionCoder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.DurationCoder;
import org.apache.beam.sdk.coders.FloatCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.SetCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.TextualIntegerCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV2;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableSet;

@AutoService(value=CoderCloudObjectTranslatorRegistrar.class)
public class DefaultCoderCloudObjectTranslatorRegistrar
implements CoderCloudObjectTranslatorRegistrar {
    private static final List<CloudObjectTranslator<? extends Coder>> DEFAULT_TRANSLATORS = ImmutableList.of(CloudObjectTranslators.globalWindow(), CloudObjectTranslators.intervalWindow(), CloudObjectTranslators.bytes(), CloudObjectTranslators.varInt(), CloudObjectTranslators.lengthPrefix(), CloudObjectTranslators.stream(), CloudObjectTranslators.pair(), CloudObjectTranslators.windowedValue(), (Object)new AvroCoderCloudObjectTranslator(), (Object)new SerializableCoderCloudObjectTranslator(), (Object)new SchemaCoderCloudObjectTranslator(), CloudObjectTranslators.iterableLike(CollectionCoder.class), (Object[])new CloudObjectTranslator[]{CloudObjectTranslators.iterableLike(ListCoder.class), CloudObjectTranslators.iterableLike(SetCoder.class), CloudObjectTranslators.map(), CloudObjectTranslators.nullable(), CloudObjectTranslators.union(), CloudObjectTranslators.coGroupByKeyResult(), CloudObjectTranslators.javaSerialized()});
    @VisibleForTesting
    static final ImmutableSet<Class<? extends Coder>> KNOWN_ATOMIC_CODERS = ImmutableSet.of(BigDecimalCoder.class, BigEndianIntegerCoder.class, BigEndianLongCoder.class, BigIntegerCoder.class, BitSetCoder.class, ByteCoder.class, (Object[])new Class[]{DoubleCoder.class, DurationCoder.class, FloatCoder.class, IsmFormat.FooterCoder.class, InstantCoder.class, IsmFormat.IsmShardCoder.class, IsmFormat.KeyPrefixCoder.class, RandomAccessData.RandomAccessDataCoder.class, StringUtf8Coder.class, TableDestinationCoderV2.class, TableRowJsonCoder.class, TextualIntegerCoder.class, VarIntCoder.class, VoidCoder.class});

    @Override
    public Map<String, CloudObjectTranslator<? extends Coder>> classNamesToTranslators() {
        ImmutableMap.Builder nameToTranslators = ImmutableMap.builder();
        for (CloudObjectTranslator<? extends Coder> translator : this.classesToTranslators().values()) {
            nameToTranslators.put((Object)translator.cloudObjectClassName(), translator);
        }
        return nameToTranslators.build();
    }

    @Override
    public Map<Class<? extends Coder>, CloudObjectTranslator<? extends Coder>> classesToTranslators() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (CloudObjectTranslator<? extends Coder> defaultTranslator : DEFAULT_TRANSLATORS) {
            builder.put(defaultTranslator.getSupportedClass(), defaultTranslator);
        }
        for (Class atomicCoder : KNOWN_ATOMIC_CODERS) {
            builder.put((Object)atomicCoder, CloudObjectTranslators.atomic(atomicCoder));
        }
        return builder.build();
    }
}

