/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.beam.runners.dataflow.CreateDataflowView;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.dataflow.internal.IsmFormat;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.SystemDoFnInternal;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ForwardingMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.joda.time.Instant;

class BatchViewOverrides {
    BatchViewOverrides() {
    }

    private static <T> WindowedValue<T> valueInEmptyWindows(T value) {
        return new ValueInEmptyWindows(value);
    }

    private static class ValueInEmptyWindows<T>
    extends WindowedValue<T> {
        private final T value;

        private ValueInEmptyWindows(T value) {
            this.value = value;
        }

        public <NewT> WindowedValue<NewT> withValue(NewT value) {
            return new ValueInEmptyWindows<NewT>(value);
        }

        public T getValue() {
            return this.value;
        }

        public Instant getTimestamp() {
            return BoundedWindow.TIMESTAMP_MIN_VALUE;
        }

        public Collection<? extends BoundedWindow> getWindows() {
            return Collections.emptyList();
        }

        public PaneInfo getPane() {
            return PaneInfo.NO_FIRING;
        }

        public String toString() {
            return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("value", this.getValue()).toString();
        }

        public int hashCode() {
            return Objects.hash(this.getValue());
        }

        public boolean equals(Object o) {
            if (o instanceof ValueInEmptyWindows) {
                ValueInEmptyWindows that = (ValueInEmptyWindows)((Object)o);
                return Objects.equals(that.getValue(), this.getValue());
            }
            return super.equals(o);
        }
    }

    static class TransformedMapCoder<K, V1, V2>
    extends StructuredCoder<TransformedMap<K, V1, V2>> {
        private final Coder<Function<V1, V2>> transformCoder;
        private final Coder<Map<K, V1>> originalMapCoder;

        private TransformedMapCoder(Coder<Function<V1, V2>> transformCoder, Coder<Map<K, V1>> originalMapCoder) {
            this.transformCoder = transformCoder;
            this.originalMapCoder = originalMapCoder;
        }

        public static <K, V1, V2> TransformedMapCoder<K, V1, V2> of(Coder<Function<V1, V2>> transformCoder, Coder<Map<K, V1>> originalMapCoder) {
            return new TransformedMapCoder<K, V1, V2>(transformCoder, originalMapCoder);
        }

        public void encode(TransformedMap<K, V1, V2> value, OutputStream outStream) throws CoderException, IOException {
            this.transformCoder.encode((Object)((TransformedMap)value).transform, outStream);
            this.originalMapCoder.encode((Object)((TransformedMap)value).originalMap, outStream);
        }

        public TransformedMap<K, V1, V2> decode(InputStream inStream) throws CoderException, IOException {
            return new TransformedMap((Function)this.transformCoder.decode(inStream), (Map)this.originalMapCoder.decode(inStream));
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.transformCoder, this.originalMapCoder);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            TransformedMapCoder.verifyDeterministic((Coder)this, (String)"Expected transform coder to be deterministic.", (Coder[])new Coder[]{this.transformCoder});
            TransformedMapCoder.verifyDeterministic((Coder)this, (String)"Expected map coder to be deterministic.", (Coder[])new Coder[]{this.originalMapCoder});
        }
    }

    static class TransformedMap<K, V1, V2>
    extends ForwardingMap<K, V2> {
        private final Function<V1, V2> transform;
        private final Map<K, V1> originalMap;
        private final Map<K, V2> transformedMap;

        TransformedMap(Function<V1, V2> transform, Map<K, V1> originalMap) {
            this.transform = transform;
            this.originalMap = Collections.unmodifiableMap(originalMap);
            this.transformedMap = Maps.transformValues(originalMap, transform);
        }

        protected Map<K, V2> delegate() {
            return this.transformedMap;
        }
    }

    static class GroupByKeyAndSortValuesOnly<K1, K2, V>
    extends PTransform<PCollection<KV<K1, KV<K2, V>>>, PCollection<KV<K1, Iterable<KV<K2, V>>>>> {
        GroupByKeyAndSortValuesOnly() {
        }

        public PCollection<KV<K1, Iterable<KV<K2, V>>>> expand(PCollection<KV<K1, KV<K2, V>>> input) {
            KvCoder inputCoder = (KvCoder)input.getCoder();
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.BOUNDED, (Coder)KvCoder.of((Coder)inputCoder.getKeyCoder(), (Coder)IterableCoder.of((Coder)inputCoder.getValueCoder())));
        }
    }

    private static class GroupByWindowHashAsKeyAndWindowAsSortKey<T, W extends BoundedWindow>
    extends PTransform<PCollection<T>, PCollection<KV<Integer, Iterable<KV<W, WindowedValue<T>>>>>> {
        private final IsmFormat.IsmRecordCoder<?> ismCoderForHash;

        private GroupByWindowHashAsKeyAndWindowAsSortKey(IsmFormat.IsmRecordCoder<?> ismCoderForHash) {
            this.ismCoderForHash = ismCoderForHash;
        }

        public PCollection<KV<Integer, Iterable<KV<W, WindowedValue<T>>>>> expand(PCollection<T> input) {
            Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
            PCollection rval = (PCollection)input.apply((PTransform)ParDo.of(new UseWindowHashAsKeyAndWindowAsSortKeyDoFn(this.ismCoderForHash)));
            rval.setCoder((Coder)KvCoder.of((Coder)VarIntCoder.of(), (Coder)KvCoder.of((Coder)windowCoder, (Coder)WindowedValue.FullWindowedValueCoder.of((Coder)input.getCoder(), (Coder)windowCoder))));
            return (PCollection)rval.apply(new GroupByKeyAndSortValuesOnly());
        }

        @SystemDoFnInternal
        private static class UseWindowHashAsKeyAndWindowAsSortKeyDoFn<T, W extends BoundedWindow>
        extends DoFn<T, KV<Integer, KV<W, WindowedValue<T>>>> {
            private final IsmFormat.IsmRecordCoder<?> ismCoderForHash;

            private UseWindowHashAsKeyAndWindowAsSortKeyDoFn(IsmFormat.IsmRecordCoder<?> ismCoderForHash) {
                this.ismCoderForHash = ismCoderForHash;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c, BoundedWindow untypedWindow) throws Exception {
                BoundedWindow window = untypedWindow;
                c.output((Object)KV.of((Object)this.ismCoderForHash.hash((List<?>)ImmutableList.of((Object)window)), (Object)KV.of((Object)window, (Object)WindowedValue.of((Object)c.element(), (Instant)c.timestamp(), (BoundedWindow)window, (PaneInfo)c.pane()))));
            }
        }
    }

    private static class IterableWithWindowedValuesToIterable<V>
    implements Function<Iterable<WindowedValue<V>>, Iterable<V>>,
    Serializable {
        private static final IterableWithWindowedValuesToIterable<?> INSTANCE = new IterableWithWindowedValuesToIterable();

        private IterableWithWindowedValuesToIterable() {
        }

        private static <V> IterableWithWindowedValuesToIterable<V> of() {
            return INSTANCE;
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public Iterable<V> apply(@Nonnull Iterable<WindowedValue<V>> input) {
            return Iterables.transform(input, (Function)WindowedValueToValue.of());
        }
    }

    private static class WindowedValueToValue<V>
    implements Function<WindowedValue<V>, V>,
    Serializable {
        private static final WindowedValueToValue<?> INSTANCE = new WindowedValueToValue();

        private WindowedValueToValue() {
        }

        private static <V> WindowedValueToValue<V> of() {
            return INSTANCE;
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public V apply(@Nonnull WindowedValue<V> input) {
            return (V)input.getValue();
        }
    }

    static class BatchViewAsIterable<T>
    extends PTransform<PCollection<T>, PCollection<?>> {
        private final transient DataflowRunner runner;
        private final PCollectionView<Iterable<T>> view;

        public BatchViewAsIterable(DataflowRunner runner, View.CreatePCollectionView<T, Iterable<T>> transform) {
            this.runner = runner;
            this.view = transform.getView();
        }

        public PCollection<?> expand(PCollection<T> input) {
            return BatchViewAsList.applyForIterableLike(this.runner, input, this.view);
        }
    }

    static class BatchViewAsList<T>
    extends PTransform<PCollection<T>, PCollection<?>> {
        private final transient DataflowRunner runner;
        private final PCollectionView<List<T>> view;

        public BatchViewAsList(DataflowRunner runner, View.CreatePCollectionView<T, List<T>> transform) {
            this.runner = runner;
            this.view = transform.getView();
        }

        public PCollection<?> expand(PCollection<T> input) {
            return BatchViewAsList.applyForIterableLike(this.runner, input, this.view);
        }

        static <T, W extends BoundedWindow, ViewT> PCollection<?> applyForIterableLike(DataflowRunner runner, PCollection<T> input, PCollectionView<ViewT> view) {
            Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
            IsmFormat.IsmRecordCoder<WindowedValue<T>> ismCoder = BatchViewAsList.coderForListLike((Coder<? extends BoundedWindow>)windowCoder, input.getCoder());
            if (input.getWindowingStrategy().getWindowFn() instanceof GlobalWindows) {
                PCollection reifiedPerWindowAndSorted = (PCollection)input.apply((PTransform)ParDo.of(new ToIsmRecordForGlobalWindowDoFn()));
                reifiedPerWindowAndSorted.setCoder(ismCoder);
                runner.addPCollectionRequiringIndexedFormat(reifiedPerWindowAndSorted);
                reifiedPerWindowAndSorted.apply(CreateDataflowView.forBatch(view));
                return reifiedPerWindowAndSorted;
            }
            PCollection reifiedPerWindowAndSorted = (PCollection)((PCollection)input.apply(new GroupByWindowHashAsKeyAndWindowAsSortKey(ismCoder))).apply((PTransform)ParDo.of(new ToIsmRecordForNonGlobalWindowDoFn(windowCoder)));
            reifiedPerWindowAndSorted.setCoder(ismCoder);
            runner.addPCollectionRequiringIndexedFormat(reifiedPerWindowAndSorted);
            reifiedPerWindowAndSorted.apply(CreateDataflowView.forBatch(view));
            return reifiedPerWindowAndSorted;
        }

        protected String getKindString() {
            return "BatchViewAsList";
        }

        static <T> IsmFormat.IsmRecordCoder<WindowedValue<T>> coderForListLike(Coder<? extends BoundedWindow> windowCoder, Coder<T> valueCoder) {
            return IsmFormat.IsmRecordCoder.of(1, 0, ImmutableList.of(windowCoder, (Object)BigEndianLongCoder.of()), WindowedValue.FullWindowedValueCoder.of(valueCoder, windowCoder));
        }

        @SystemDoFnInternal
        static class ToIsmRecordForNonGlobalWindowDoFn<T, W extends BoundedWindow>
        extends DoFn<KV<Integer, Iterable<KV<W, WindowedValue<T>>>>, IsmFormat.IsmRecord<WindowedValue<T>>> {
            private final Coder<W> windowCoder;

            ToIsmRecordForNonGlobalWindowDoFn(Coder<W> windowCoder) {
                this.windowCoder = windowCoder;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                long elementsInWindow = 0L;
                Optional previousWindowStructuralValue = Optional.absent();
                for (KV value : (Iterable)((KV)c.element()).getValue()) {
                    Object currentWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)value.getKey()));
                    if (previousWindowStructuralValue.isPresent() && !previousWindowStructuralValue.get().equals(currentWindowStructuralValue)) {
                        elementsInWindow = 0L;
                    }
                    c.output(IsmFormat.IsmRecord.of(ImmutableList.of((Object)value.getKey(), (Object)elementsInWindow), (WindowedValue)value.getValue()));
                    previousWindowStructuralValue = Optional.of((Object)currentWindowStructuralValue);
                    ++elementsInWindow;
                }
            }
        }

        @SystemDoFnInternal
        static class ToIsmRecordForGlobalWindowDoFn<T>
        extends DoFn<T, IsmFormat.IsmRecord<WindowedValue<T>>> {
            long indexInBundle;

            ToIsmRecordForGlobalWindowDoFn() {
            }

            @DoFn.StartBundle
            public void startBundle() throws Exception {
                this.indexInBundle = 0L;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output(IsmFormat.IsmRecord.of(ImmutableList.of((Object)GlobalWindow.INSTANCE, (Object)this.indexInBundle), WindowedValue.of((Object)c.element(), (Instant)c.timestamp(), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)c.pane())));
                ++this.indexInBundle;
            }
        }
    }

    static class BatchViewAsSingleton<T>
    extends PTransform<PCollection<T>, PCollection<?>> {
        private final transient DataflowRunner runner;
        private final PCollectionView<T> view;
        private final Combine.CombineFn<T, ?, T> combineFn;
        private final int fanout;

        public BatchViewAsSingleton(DataflowRunner runner, View.CreatePCollectionView<T, T> transform, Combine.CombineFn<T, ?, T> combineFn, int fanout) {
            this.runner = runner;
            this.view = transform.getView();
            this.combineFn = combineFn;
            this.fanout = fanout;
        }

        public PCollection<?> expand(PCollection<T> input) {
            input = (PCollection)input.apply((PTransform)Combine.globally(this.combineFn).withoutDefaults().withFanout(this.fanout));
            Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
            return BatchViewAsSingleton.applyForSingleton(this.runner, input, new IsmRecordForSingularValuePerWindowDoFn(windowCoder), input.getCoder(), this.view);
        }

        static <T, FinalT, ViewT, W extends BoundedWindow> PCollection<?> applyForSingleton(DataflowRunner runner, PCollection<T> input, DoFn<KV<Integer, Iterable<KV<W, WindowedValue<T>>>>, IsmFormat.IsmRecord<WindowedValue<FinalT>>> doFn, Coder<FinalT> defaultValueCoder, PCollectionView<ViewT> view) {
            Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
            IsmFormat.IsmRecordCoder<WindowedValue<FinalT>> ismCoder = BatchViewAsSingleton.coderForSingleton((Coder<? extends BoundedWindow>)windowCoder, defaultValueCoder);
            PCollection reifiedPerWindowAndSorted = (PCollection)((PCollection)input.apply(new GroupByWindowHashAsKeyAndWindowAsSortKey(ismCoder))).apply((PTransform)ParDo.of(doFn));
            reifiedPerWindowAndSorted.setCoder(ismCoder);
            runner.addPCollectionRequiringIndexedFormat(reifiedPerWindowAndSorted);
            reifiedPerWindowAndSorted.apply(CreateDataflowView.forBatch(view));
            return reifiedPerWindowAndSorted;
        }

        protected String getKindString() {
            return "BatchViewAsSingleton";
        }

        static <T> IsmFormat.IsmRecordCoder<WindowedValue<T>> coderForSingleton(Coder<? extends BoundedWindow> windowCoder, Coder<T> valueCoder) {
            return IsmFormat.IsmRecordCoder.of(1, 0, ImmutableList.of(windowCoder), WindowedValue.FullWindowedValueCoder.of(valueCoder, windowCoder));
        }

        static class IsmRecordForSingularValuePerWindowDoFn<T, W extends BoundedWindow>
        extends DoFn<KV<Integer, Iterable<KV<W, WindowedValue<T>>>>, IsmFormat.IsmRecord<WindowedValue<T>>> {
            private final Coder<W> windowCoder;

            IsmRecordForSingularValuePerWindowDoFn(Coder<W> windowCoder) {
                this.windowCoder = windowCoder;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                Optional previousWindowStructuralValue = Optional.absent();
                Object previousValue = null;
                for (KV next : (Iterable)((KV)c.element()).getValue()) {
                    Object currentWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)next.getKey()));
                    Preconditions.checkState((!previousWindowStructuralValue.isPresent() || !previousWindowStructuralValue.get().equals(currentWindowStructuralValue) ? 1 : 0) != 0, (String)"Multiple values [%s, %s] found for singleton within window [%s].", previousValue, (Object)((WindowedValue)next.getValue()).getValue(), (Object)next.getKey());
                    c.output(IsmFormat.IsmRecord.of(ImmutableList.of((Object)((BoundedWindow)next.getKey())), (WindowedValue)next.getValue()));
                    previousWindowStructuralValue = Optional.of((Object)currentWindowStructuralValue);
                    previousValue = ((WindowedValue)next.getValue()).getValue();
                }
            }
        }
    }

    static class BatchViewAsMultimap<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<?>> {
        private final transient DataflowRunner runner;
        private final PCollectionView<Map<K, Iterable<V>>> view;

        public BatchViewAsMultimap(DataflowRunner runner, View.CreatePCollectionView<KV<K, V>, Map<K, Iterable<V>>> transform) {
            this.runner = runner;
            this.view = transform.getView();
        }

        public PCollection<?> expand(PCollection<KV<K, V>> input) {
            return this.applyInternal(input);
        }

        private <W extends BoundedWindow> PCollection<?> applyInternal(PCollection<KV<K, V>> input) {
            try {
                return BatchViewAsMultimap.applyForMapLike(this.runner, input, this.view, false);
            }
            catch (Coder.NonDeterministicException e) {
                this.runner.recordViewUsesNonDeterministicKeyCoder(this);
                return this.applyForSingletonFallback(input);
            }
        }

        private <W extends BoundedWindow> PCollection<?> applyForSingletonFallback(PCollection<KV<K, V>> input) {
            Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
            KvCoder inputCoder = (KvCoder)input.getCoder();
            SerializableCoder transformCoder = SerializableCoder.of(IterableWithWindowedValuesToIterable.class);
            TransformedMapCoder finalValueCoder = TransformedMapCoder.of(transformCoder, MapCoder.of((Coder)inputCoder.getKeyCoder(), (Coder)IterableCoder.of((Coder)WindowedValue.FullWindowedValueCoder.of((Coder)inputCoder.getValueCoder(), (Coder)windowCoder))));
            return BatchViewAsSingleton.applyForSingleton(this.runner, input, new ToMultimapDoFn(windowCoder), finalValueCoder, this.view);
        }

        private static <K, V, W extends BoundedWindow, ViewT> PCollection<?> applyForMapLike(DataflowRunner runner, PCollection<KV<K, V>> input, PCollectionView<ViewT> view, boolean uniqueKeysExpected) throws Coder.NonDeterministicException {
            Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
            KvCoder inputCoder = (KvCoder)input.getCoder();
            inputCoder.getKeyCoder().verifyDeterministic();
            IsmFormat.IsmRecordCoder<WindowedValue<V>> ismCoder = BatchViewAsMultimap.coderForMapLike((Coder<? extends BoundedWindow>)windowCoder, inputCoder.getKeyCoder(), inputCoder.getValueCoder());
            TupleTag mainOutputTag = new TupleTag();
            TupleTag outputForSizeTag = new TupleTag();
            TupleTag outputForEntrySetTag = new TupleTag();
            PCollectionTuple outputTuple = (PCollectionTuple)((PCollection)input.apply("GBKaSVForData", new GroupByKeyHashAndSortByKeyAndWindow(ismCoder))).apply((PTransform)ParDo.of(new ToIsmRecordForMapLikeDoFn(outputForSizeTag, outputForEntrySetTag, windowCoder, inputCoder.getKeyCoder(), ismCoder, uniqueKeysExpected)).withOutputTags(mainOutputTag, TupleTagList.of((List)ImmutableList.of((Object)outputForSizeTag, (Object)outputForEntrySetTag))));
            PCollection perHashWithReifiedWindows = outputTuple.get(mainOutputTag);
            perHashWithReifiedWindows.setCoder(ismCoder);
            PCollection outputForSize = outputTuple.get(outputForSizeTag);
            outputForSize.setCoder((Coder)KvCoder.of((Coder)VarIntCoder.of(), (Coder)KvCoder.of((Coder)windowCoder, (Coder)VarLongCoder.of())));
            PCollection windowMapSizeMetadata = (PCollection)((PCollection)outputForSize.apply("GBKaSVForSize", new GroupByKeyAndSortValuesOnly())).apply((PTransform)ParDo.of(new ToIsmMetadataRecordForSizeDoFn(windowCoder)));
            windowMapSizeMetadata.setCoder(ismCoder);
            PCollection outputForEntrySet = outputTuple.get(outputForEntrySetTag);
            outputForEntrySet.setCoder((Coder)KvCoder.of((Coder)VarIntCoder.of(), (Coder)KvCoder.of((Coder)windowCoder, (Coder)inputCoder.getKeyCoder())));
            PCollection windowMapKeysMetadata = (PCollection)((PCollection)outputForEntrySet.apply("GBKaSVForKeys", new GroupByKeyAndSortValuesOnly())).apply((PTransform)ParDo.of(new ToIsmMetadataRecordForKeyDoFn(inputCoder.getKeyCoder(), windowCoder)));
            windowMapKeysMetadata.setCoder(ismCoder);
            runner.addPCollectionRequiringIndexedFormat(perHashWithReifiedWindows);
            runner.addPCollectionRequiringIndexedFormat(windowMapSizeMetadata);
            runner.addPCollectionRequiringIndexedFormat(windowMapKeysMetadata);
            PCollectionList outputs = PCollectionList.of((Iterable)ImmutableList.of((Object)perHashWithReifiedWindows, (Object)windowMapSizeMetadata, (Object)windowMapKeysMetadata));
            PCollection flattenedOutputs = (PCollection)Pipeline.applyTransform((PInput)outputs, (PTransform)Flatten.pCollections());
            flattenedOutputs.apply(CreateDataflowView.forBatch(view));
            return flattenedOutputs;
        }

        protected String getKindString() {
            return "BatchViewAsMultimap";
        }

        static <V> IsmFormat.IsmRecordCoder<WindowedValue<V>> coderForMapLike(Coder<? extends BoundedWindow> windowCoder, Coder<?> keyCoder, Coder<V> valueCoder) {
            return IsmFormat.IsmRecordCoder.of(1, 2, ImmutableList.of(IsmFormat.MetadataKeyCoder.of(keyCoder), windowCoder, (Object)BigEndianLongCoder.of()), WindowedValue.FullWindowedValueCoder.of(valueCoder, windowCoder));
        }

        static class ToMultimapDoFn<K, V, W extends BoundedWindow>
        extends DoFn<KV<Integer, Iterable<KV<W, WindowedValue<KV<K, V>>>>>, IsmFormat.IsmRecord<WindowedValue<TransformedMap<K, Iterable<WindowedValue<V>>, Iterable<V>>>>> {
            private final Coder<W> windowCoder;

            ToMultimapDoFn(Coder<W> windowCoder) {
                this.windowCoder = windowCoder;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                Optional previousWindowStructuralValue = Optional.absent();
                Optional previousWindow = Optional.absent();
                ArrayListMultimap multimap = ArrayListMultimap.create();
                for (KV kv : (Iterable)((KV)c.element()).getValue()) {
                    Object currentWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)kv.getKey()));
                    if (previousWindowStructuralValue.isPresent() && !previousWindowStructuralValue.get().equals(currentWindowStructuralValue)) {
                        Map resultMap = multimap.asMap();
                        c.output(IsmFormat.IsmRecord.of(ImmutableList.of((Object)((BoundedWindow)previousWindow.get())), BatchViewOverrides.valueInEmptyWindows(new TransformedMap(IterableWithWindowedValuesToIterable.of(), resultMap))));
                        multimap = ArrayListMultimap.create();
                    }
                    multimap.put(((KV)((WindowedValue)kv.getValue()).getValue()).getKey(), (Object)((WindowedValue)kv.getValue()).withValue(((KV)((WindowedValue)kv.getValue()).getValue()).getValue()));
                    previousWindowStructuralValue = Optional.of((Object)currentWindowStructuralValue);
                    previousWindow = Optional.of((Object)((BoundedWindow)kv.getKey()));
                }
                Map resultMap = multimap.asMap();
                c.output(IsmFormat.IsmRecord.of(ImmutableList.of((Object)((BoundedWindow)previousWindow.get())), BatchViewOverrides.valueInEmptyWindows(new TransformedMap(IterableWithWindowedValuesToIterable.of(), resultMap))));
            }
        }

        static class ToIsmMetadataRecordForKeyDoFn<K, V, W extends BoundedWindow>
        extends DoFn<KV<Integer, Iterable<KV<W, K>>>, IsmFormat.IsmRecord<WindowedValue<V>>> {
            private final Coder<K> keyCoder;
            private final Coder<W> windowCoder;

            ToIsmMetadataRecordForKeyDoFn(Coder<K> keyCoder, Coder<W> windowCoder) {
                this.keyCoder = keyCoder;
                this.windowCoder = windowCoder;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                Iterator iterator = ((Iterable)((KV)c.element()).getValue()).iterator();
                KV currentValue = (KV)iterator.next();
                Object currentWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)currentValue.getKey()));
                long elementsInWindow = 1L;
                while (iterator.hasNext()) {
                    KV nextValue = (KV)iterator.next();
                    Object nextWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)nextValue.getKey()));
                    c.output(IsmFormat.IsmRecord.meta(ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)currentValue.getKey(), (Object)elementsInWindow), CoderUtils.encodeToByteArray(this.keyCoder, (Object)currentValue.getValue())));
                    ++elementsInWindow;
                    if (!currentWindowStructuralValue.equals(nextWindowStructuralValue)) {
                        elementsInWindow = 1L;
                    }
                    currentValue = nextValue;
                    currentWindowStructuralValue = nextWindowStructuralValue;
                }
                c.output(IsmFormat.IsmRecord.meta(ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)currentValue.getKey(), (Object)elementsInWindow), CoderUtils.encodeToByteArray(this.keyCoder, (Object)currentValue.getValue())));
            }
        }

        static class ToIsmMetadataRecordForSizeDoFn<K, V, W extends BoundedWindow>
        extends DoFn<KV<Integer, Iterable<KV<W, Long>>>, IsmFormat.IsmRecord<WindowedValue<V>>> {
            private final Coder<W> windowCoder;

            ToIsmMetadataRecordForSizeDoFn(Coder<W> windowCoder) {
                this.windowCoder = windowCoder;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                Iterator iterator = ((Iterable)((KV)c.element()).getValue()).iterator();
                KV currentValue = (KV)iterator.next();
                Object currentWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)currentValue.getKey()));
                long size = 0L;
                while (iterator.hasNext()) {
                    KV nextValue = (KV)iterator.next();
                    Object nextWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)nextValue.getKey()));
                    size += ((Long)currentValue.getValue()).longValue();
                    if (!currentWindowStructuralValue.equals(nextWindowStructuralValue)) {
                        c.output(IsmFormat.IsmRecord.meta(ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)currentValue.getKey(), (Object)0L), CoderUtils.encodeToByteArray((Coder)VarLongCoder.of(), (Object)size)));
                        size = 0L;
                    }
                    currentValue = nextValue;
                    currentWindowStructuralValue = nextWindowStructuralValue;
                }
                c.output(IsmFormat.IsmRecord.meta(ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)currentValue.getKey(), (Object)0L), CoderUtils.encodeToByteArray((Coder)VarLongCoder.of(), (Object)(size += ((Long)currentValue.getValue()).longValue()))));
            }
        }

        static class ToIsmRecordForMapLikeDoFn<K, V, W extends BoundedWindow>
        extends DoFn<KV<Integer, Iterable<KV<KV<K, W>, WindowedValue<V>>>>, IsmFormat.IsmRecord<WindowedValue<V>>> {
            private final TupleTag<KV<Integer, KV<W, Long>>> outputForSize;
            private final TupleTag<KV<Integer, KV<W, K>>> outputForEntrySet;
            private final Coder<W> windowCoder;
            private final Coder<K> keyCoder;
            private final IsmFormat.IsmRecordCoder<WindowedValue<V>> ismCoder;
            private final boolean uniqueKeysExpected;

            ToIsmRecordForMapLikeDoFn(TupleTag<KV<Integer, KV<W, Long>>> outputForSize, TupleTag<KV<Integer, KV<W, K>>> outputForEntrySet, Coder<W> windowCoder, Coder<K> keyCoder, IsmFormat.IsmRecordCoder<WindowedValue<V>> ismCoder, boolean uniqueKeysExpected) {
                this.outputForSize = outputForSize;
                this.outputForEntrySet = outputForEntrySet;
                this.windowCoder = windowCoder;
                this.keyCoder = keyCoder;
                this.ismCoder = ismCoder;
                this.uniqueKeysExpected = uniqueKeysExpected;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                long currentKeyIndex = 0L;
                long currentUniqueKeyCounter = 1L;
                Iterator iterator = ((Iterable)((KV)c.element()).getValue()).iterator();
                KV currentValue = (KV)iterator.next();
                Object currentKeyStructuralValue = this.keyCoder.structuralValue(((KV)currentValue.getKey()).getKey());
                Object currentWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)((KV)currentValue.getKey()).getValue()));
                while (iterator.hasNext()) {
                    long nextUniqueKeyCounter;
                    long nextKeyIndex;
                    KV nextValue = (KV)iterator.next();
                    Object nextKeyStructuralValue = this.keyCoder.structuralValue(((KV)nextValue.getKey()).getKey());
                    Object nextWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)((KV)nextValue.getKey()).getValue()));
                    this.outputDataRecord(c, currentValue, currentKeyIndex);
                    if (!currentWindowStructuralValue.equals(nextWindowStructuralValue)) {
                        this.outputMetadataRecordForSize(c, currentValue, currentUniqueKeyCounter);
                        this.outputMetadataRecordForEntrySet(c, currentValue);
                        nextKeyIndex = 0L;
                        nextUniqueKeyCounter = 1L;
                    } else if (!currentKeyStructuralValue.equals(nextKeyStructuralValue)) {
                        this.outputMetadataRecordForEntrySet(c, currentValue);
                        nextKeyIndex = 0L;
                        nextUniqueKeyCounter = currentUniqueKeyCounter + 1L;
                    } else if (!this.uniqueKeysExpected) {
                        nextKeyIndex = currentKeyIndex + 1L;
                        nextUniqueKeyCounter = currentUniqueKeyCounter;
                    } else {
                        throw new IllegalStateException(String.format("Unique keys are expected but found key %s with values %s and %s in window %s.", ((KV)currentValue.getKey()).getKey(), ((WindowedValue)currentValue.getValue()).getValue(), ((WindowedValue)nextValue.getValue()).getValue(), ((KV)currentValue.getKey()).getValue()));
                    }
                    currentValue = nextValue;
                    currentWindowStructuralValue = nextWindowStructuralValue;
                    currentKeyStructuralValue = nextKeyStructuralValue;
                    currentKeyIndex = nextKeyIndex;
                    currentUniqueKeyCounter = nextUniqueKeyCounter;
                }
                this.outputDataRecord(c, currentValue, currentKeyIndex);
                this.outputMetadataRecordForSize(c, currentValue, currentUniqueKeyCounter);
                this.outputMetadataRecordForEntrySet(c, currentValue);
            }

            private void outputDataRecord(DoFn.ProcessContext c, KV<KV<K, W>, WindowedValue<V>> value, long keyIndex) {
                IsmFormat.IsmRecord<WindowedValue> ismRecord = IsmFormat.IsmRecord.of(ImmutableList.of((Object)((KV)value.getKey()).getKey(), (Object)((KV)value.getKey()).getValue(), (Object)keyIndex), (WindowedValue)value.getValue());
                c.output(ismRecord);
            }

            private void outputMetadataRecordForSize(DoFn.ProcessContext c, KV<KV<K, W>, WindowedValue<V>> value, long uniqueKeyCount) {
                c.output(this.outputForSize, (Object)KV.of((Object)this.ismCoder.hash((List<?>)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)((KV)value.getKey()).getValue())), (Object)KV.of((Object)((BoundedWindow)((KV)value.getKey()).getValue()), (Object)uniqueKeyCount)));
            }

            private void outputMetadataRecordForEntrySet(DoFn.ProcessContext c, KV<KV<K, W>, WindowedValue<V>> value) {
                c.output(this.outputForEntrySet, (Object)KV.of((Object)this.ismCoder.hash((List<?>)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)((KV)value.getKey()).getValue())), (Object)KV.of((Object)((BoundedWindow)((KV)value.getKey()).getValue()), (Object)((KV)value.getKey()).getKey())));
            }
        }

        private static class GroupByKeyHashAndSortByKeyAndWindow<K, V, W extends BoundedWindow>
        extends PTransform<PCollection<KV<K, V>>, PCollection<KV<Integer, Iterable<KV<KV<K, W>, WindowedValue<V>>>>>> {
            private final IsmFormat.IsmRecordCoder<?> coder;

            public GroupByKeyHashAndSortByKeyAndWindow(IsmFormat.IsmRecordCoder<?> coder) {
                this.coder = coder;
            }

            public PCollection<KV<Integer, Iterable<KV<KV<K, W>, WindowedValue<V>>>>> expand(PCollection<KV<K, V>> input) {
                Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
                KvCoder inputCoder = (KvCoder)input.getCoder();
                PCollection keyedByHash = (PCollection)input.apply((PTransform)ParDo.of(new GroupByKeyHashAndSortByKeyAndWindowDoFn(this.coder)));
                keyedByHash.setCoder((Coder)KvCoder.of((Coder)VarIntCoder.of(), (Coder)KvCoder.of((Coder)KvCoder.of((Coder)inputCoder.getKeyCoder(), (Coder)windowCoder), (Coder)WindowedValue.FullWindowedValueCoder.of((Coder)inputCoder.getValueCoder(), (Coder)windowCoder))));
                return (PCollection)keyedByHash.apply(new GroupByKeyAndSortValuesOnly());
            }

            @SystemDoFnInternal
            private static class GroupByKeyHashAndSortByKeyAndWindowDoFn<K, V, W>
            extends DoFn<KV<K, V>, KV<Integer, KV<KV<K, W>, WindowedValue<V>>>> {
                private final IsmFormat.IsmRecordCoder<?> coder;

                private GroupByKeyHashAndSortByKeyAndWindowDoFn(IsmFormat.IsmRecordCoder<?> coder) {
                    this.coder = coder;
                }

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c, BoundedWindow untypedWindow) throws Exception {
                    BoundedWindow window = untypedWindow;
                    c.output((Object)KV.of((Object)this.coder.hash((List<?>)ImmutableList.of((Object)((KV)c.element()).getKey())), (Object)KV.of((Object)KV.of((Object)((KV)c.element()).getKey(), (Object)window), (Object)WindowedValue.of((Object)((KV)c.element()).getValue(), (Instant)c.timestamp(), (BoundedWindow)untypedWindow, (PaneInfo)c.pane()))));
                }
            }
        }
    }

    static class BatchViewAsMap<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<?>> {
        private final transient DataflowRunner runner;
        private final PCollectionView<Map<K, V>> view;

        public BatchViewAsMap(DataflowRunner runner, View.CreatePCollectionView<KV<K, V>, Map<K, V>> transform) {
            this.runner = runner;
            this.view = transform.getView();
        }

        public PCollection<?> expand(PCollection<KV<K, V>> input) {
            return this.applyInternal(input);
        }

        private <W extends BoundedWindow> PCollection<?> applyInternal(PCollection<KV<K, V>> input) {
            try {
                return BatchViewAsMultimap.applyForMapLike(this.runner, input, this.view, true);
            }
            catch (Coder.NonDeterministicException e) {
                this.runner.recordViewUsesNonDeterministicKeyCoder(this);
                return this.applyForSingletonFallback(input);
            }
        }

        protected String getKindString() {
            return "BatchViewAsMap";
        }

        private <W extends BoundedWindow> PCollection<?> applyForSingletonFallback(PCollection<KV<K, V>> input) {
            Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
            KvCoder inputCoder = (KvCoder)input.getCoder();
            SerializableCoder transformCoder = SerializableCoder.of(WindowedValueToValue.class);
            TransformedMapCoder finalValueCoder = TransformedMapCoder.of(transformCoder, MapCoder.of((Coder)inputCoder.getKeyCoder(), (Coder)WindowedValue.FullWindowedValueCoder.of((Coder)inputCoder.getValueCoder(), (Coder)windowCoder)));
            return BatchViewAsSingleton.applyForSingleton(this.runner, input, new ToMapDoFn(windowCoder), finalValueCoder, this.view);
        }

        static class ToMapDoFn<K, V, W extends BoundedWindow>
        extends DoFn<KV<Integer, Iterable<KV<W, WindowedValue<KV<K, V>>>>>, IsmFormat.IsmRecord<WindowedValue<TransformedMap<K, WindowedValue<V>, V>>>> {
            private final Coder<W> windowCoder;

            ToMapDoFn(Coder<W> windowCoder) {
                this.windowCoder = windowCoder;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                Optional previousWindowStructuralValue = Optional.absent();
                Optional previousWindow = Optional.absent();
                HashMap<Object, WindowedValue> map = new HashMap<Object, WindowedValue>();
                for (KV kv : (Iterable)((KV)c.element()).getValue()) {
                    Object currentWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)kv.getKey()));
                    if (previousWindowStructuralValue.isPresent() && !previousWindowStructuralValue.get().equals(currentWindowStructuralValue)) {
                        c.output(IsmFormat.IsmRecord.of(ImmutableList.of((Object)((BoundedWindow)previousWindow.get())), BatchViewOverrides.valueInEmptyWindows(new TransformedMap(WindowedValueToValue.of(), map))));
                        map = new HashMap();
                    }
                    Preconditions.checkState((!map.containsKey(((KV)((WindowedValue)kv.getValue()).getValue()).getKey()) ? 1 : 0) != 0, (String)"Multiple values [%s, %s] found for single key [%s] within window [%s].", map.get(((KV)((WindowedValue)kv.getValue()).getValue()).getKey()), (Object)((KV)((WindowedValue)kv.getValue()).getValue()).getValue(), (Object)kv.getKey());
                    map.put(((KV)((WindowedValue)kv.getValue()).getValue()).getKey(), ((WindowedValue)kv.getValue()).withValue(((KV)((WindowedValue)kv.getValue()).getValue()).getValue()));
                    previousWindowStructuralValue = Optional.of((Object)currentWindowStructuralValue);
                    previousWindow = Optional.of((Object)((BoundedWindow)kv.getKey()));
                }
                c.output(IsmFormat.IsmRecord.of(ImmutableList.of((Object)((BoundedWindow)previousWindow.get())), BatchViewOverrides.valueInEmptyWindows(new TransformedMap(WindowedValueToValue.of(), map))));
            }
        }
    }
}

