/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.clouddebugger.v2.CloudDebugger;
import com.google.api.services.clouddebugger.v2.model.Debuggee;
import com.google.api.services.clouddebugger.v2.model.RegisterDebuggeeRequest;
import com.google.api.services.clouddebugger.v2.model.RegisterDebuggeeResponse;
import com.google.api.services.dataflow.model.DataflowPackage;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.ListJobsResponse;
import com.google.api.services.dataflow.model.WorkerPool;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.CoderTranslation;
import org.apache.beam.runners.core.construction.DeduplicatedFlattenFactory;
import org.apache.beam.runners.core.construction.EmptyFlattenAsCreateFactory;
import org.apache.beam.runners.core.construction.JavaReadViaImpulse;
import org.apache.beam.runners.core.construction.PTransformMatchers;
import org.apache.beam.runners.core.construction.PTransformReplacements;
import org.apache.beam.runners.core.construction.PipelineResources;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.runners.core.construction.SingleInputOutputOverrideFactory;
import org.apache.beam.runners.core.construction.SplittableParDoNaiveBounded;
import org.apache.beam.runners.core.construction.UnboundedReadFromBoundedSource;
import org.apache.beam.runners.core.construction.UnconsumedReads;
import org.apache.beam.runners.core.construction.WriteFilesTranslation;
import org.apache.beam.runners.dataflow.BatchStatefulParDoOverrides;
import org.apache.beam.runners.dataflow.BatchViewOverrides;
import org.apache.beam.runners.dataflow.DataflowClient;
import org.apache.beam.runners.dataflow.DataflowJobAlreadyExistsException;
import org.apache.beam.runners.dataflow.DataflowJobAlreadyUpdatedException;
import org.apache.beam.runners.dataflow.DataflowPTransformMatchers;
import org.apache.beam.runners.dataflow.DataflowPipelineJob;
import org.apache.beam.runners.dataflow.DataflowPipelineTranslator;
import org.apache.beam.runners.dataflow.DataflowRunnerHooks;
import org.apache.beam.runners.dataflow.DataflowRunnerInfo;
import org.apache.beam.runners.dataflow.PrimitiveParDoSingleFactory;
import org.apache.beam.runners.dataflow.ReadTranslator;
import org.apache.beam.runners.dataflow.ReshuffleOverrideFactory;
import org.apache.beam.runners.dataflow.SplittableParDoOverrides;
import org.apache.beam.runners.dataflow.StreamingViewOverrides;
import org.apache.beam.runners.dataflow.TransformTranslator;
import org.apache.beam.runners.dataflow.options.DataflowPipelineDebugOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineWorkerPoolOptions;
import org.apache.beam.runners.dataflow.util.DataflowTemplateJob;
import org.apache.beam.runners.dataflow.util.DataflowTransport;
import org.apache.beam.runners.dataflow.util.MonitoringUtil;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.extensions.gcp.storage.PathValidator;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageWithAttributesAndMessageIdCoder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageWithAttributesCoder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubUnboundedSink;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubUnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.runners.PTransformOverride;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.state.MapState;
import org.apache.beam.sdk.state.SetState;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.StringUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.ValueWithRecordId;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Utf8;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.UnmodifiableIterator;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataflowRunner
extends PipelineRunner<DataflowPipelineJob> {
    private static final Logger LOG = LoggerFactory.getLogger(DataflowRunner.class);
    private final DataflowPipelineOptions options;
    private final DataflowClient dataflowClient;
    private final DataflowPipelineTranslator translator;
    private DataflowRunnerHooks hooks;
    private static final int CREATE_JOB_REQUEST_LIMIT_BYTES = 0xA00000;
    @VisibleForTesting
    static final int GCS_UPLOAD_BUFFER_SIZE_BYTES_DEFAULT = 0x100000;
    @VisibleForTesting
    static final String PIPELINE_FILE_NAME = "pipeline.pb";
    @VisibleForTesting
    static final String DATAFLOW_GRAPH_FILE_NAME = "dataflow_graph.json";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectMapper MAPPER_WITH_MODULES = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    private final Set<PCollection<?>> pcollectionsRequiringIndexedFormat;
    public static final String PROJECT_ID_REGEXP = "[a-z][-a-z0-9:.]+[a-z0-9]";
    private Set<PTransform<?, ?>> ptransformViewsWithNonDeterministicKeyCoders;

    public static DataflowRunner fromOptions(PipelineOptions options) {
        String stagingLocation;
        String gcpTempLocation;
        DataflowPipelineOptions dataflowOptions = (DataflowPipelineOptions)PipelineOptionsValidator.validate(DataflowPipelineOptions.class, (PipelineOptions)options);
        ArrayList<String> missing = new ArrayList<String>();
        if (dataflowOptions.getAppName() == null) {
            missing.add("appName");
        }
        if (missing.size() > 0) {
            throw new IllegalArgumentException("Missing required values: " + Joiner.on((char)',').join(missing));
        }
        if (dataflowOptions.getRegion() == null) {
            dataflowOptions.setRegion("us-central1");
            LOG.warn("--region not set; will default to us-central1. Future releases of Beam will require the user to set the region explicitly. https://cloud.google.com/compute/docs/regions-zones/regions-zones");
        }
        PathValidator validator = dataflowOptions.getPathValidator();
        try {
            gcpTempLocation = dataflowOptions.getGcpTempLocation();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("DataflowRunner requires gcpTempLocation, but failed to retrieve a value from PipelineOptions", e);
        }
        validator.validateOutputFilePrefixSupported(gcpTempLocation);
        try {
            stagingLocation = dataflowOptions.getStagingLocation();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("DataflowRunner requires stagingLocation, but failed to retrieve a value from PipelineOptions", e);
        }
        validator.validateOutputFilePrefixSupported(stagingLocation);
        if (!Strings.isNullOrEmpty((String)dataflowOptions.getSaveProfilesToGcs())) {
            validator.validateOutputFilePrefixSupported(dataflowOptions.getSaveProfilesToGcs());
        }
        if (dataflowOptions.getFilesToStage() == null) {
            dataflowOptions.setFilesToStage(PipelineResources.detectClassPathResourcesToStage((ClassLoader)DataflowRunner.class.getClassLoader()));
            if (dataflowOptions.getFilesToStage().isEmpty()) {
                throw new IllegalArgumentException("No files to stage has been found.");
            }
            LOG.info("PipelineOptions.filesToStage was not specified. Defaulting to files from the classpath: will stage {} files. Enable logging at DEBUG level to see which files will be staged.", (Object)dataflowOptions.getFilesToStage().size());
            LOG.debug("Classpath elements: {}", (Object)dataflowOptions.getFilesToStage());
        }
        String jobName = dataflowOptions.getJobName().toLowerCase();
        Preconditions.checkArgument((boolean)jobName.matches("[a-z]([-a-z0-9]*[a-z0-9])?"), (Object)"JobName invalid; the name must consist of only the characters [-a-z0-9], starting with a letter and ending with a letter or number");
        if (!jobName.equals(dataflowOptions.getJobName())) {
            LOG.info("PipelineOptions.jobName did not match the service requirements. Using {} instead of {}.", (Object)jobName, (Object)dataflowOptions.getJobName());
        }
        dataflowOptions.setJobName(jobName);
        String project = dataflowOptions.getProject();
        if (project.matches("[0-9]*")) {
            throw new IllegalArgumentException("Project ID '" + project + "' invalid. Please make sure you specified the Project ID, not project number.");
        }
        if (!project.matches(PROJECT_ID_REGEXP)) {
            throw new IllegalArgumentException("Project ID '" + project + "' invalid. Please make sure you specified the Project ID, not project description.");
        }
        DataflowPipelineDebugOptions debugOptions = (DataflowPipelineDebugOptions)dataflowOptions.as(DataflowPipelineDebugOptions.class);
        if (debugOptions.getNumberOfWorkerHarnessThreads() < 0) {
            throw new IllegalArgumentException("Number of worker harness threads '" + debugOptions.getNumberOfWorkerHarnessThreads() + "' invalid. Please make sure the value is non-negative.");
        }
        if (dataflowOptions.isStreaming() && dataflowOptions.getGcsUploadBufferSizeBytes() == null) {
            dataflowOptions.setGcsUploadBufferSizeBytes(0x100000);
        }
        DataflowRunnerInfo dataflowRunnerInfo = DataflowRunnerInfo.getDataflowRunnerInfo();
        String userAgent = String.format("%s/%s", dataflowRunnerInfo.getName(), dataflowRunnerInfo.getVersion()).replace(" ", "_");
        dataflowOptions.setUserAgent(userAgent);
        return new DataflowRunner(dataflowOptions);
    }

    @VisibleForTesting
    protected DataflowRunner(DataflowPipelineOptions options) {
        this.options = options;
        this.dataflowClient = DataflowClient.create(options);
        this.translator = DataflowPipelineTranslator.fromOptions(options);
        this.pcollectionsRequiringIndexedFormat = new HashSet();
        this.ptransformViewsWithNonDeterministicKeyCoders = new HashSet();
    }

    private List<PTransformOverride> getOverrides(boolean streaming) {
        boolean fnApiEnabled = DataflowRunner.hasExperiment(this.options, "beam_fn_api");
        ImmutableList.Builder overridesBuilder = ImmutableList.builder();
        overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.flattenWithDuplicateInputs(), (PTransformOverrideFactory)DeduplicatedFlattenFactory.create())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.emptyFlatten(), (PTransformOverrideFactory)EmptyFlattenAsCreateFactory.instance()));
        if (!fnApiEnabled) {
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.splittableParDoSingle(), new ReflectiveOneToOneOverrideFactory(SplittableParDoOverrides.ParDoSingleViaMulti.class, this))).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.splittableParDoMulti(), new SplittableParDoOverrides.SplittableParDoOverrideFactory()));
        }
        if (streaming) {
            if (!DataflowRunner.hasExperiment(this.options, "enable_custom_pubsub_source")) {
                overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(PubsubUnboundedSource.class), (PTransformOverrideFactory)new StreamingPubsubIOReadOverrideFactory()));
            }
            if (!DataflowRunner.hasExperiment(this.options, "enable_custom_pubsub_sink")) {
                overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(PubsubUnboundedSink.class), (PTransformOverrideFactory)new StreamingPubsubIOWriteOverrideFactory(this)));
            }
            if (fnApiEnabled) {
                overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Create.Values.class), new StreamingFnApiCreateOverrideFactory()));
            }
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.writeWithRunnerDeterminedSharding(), new StreamingShardedWriteFactory(this.options))).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Read.Bounded.class), new StreamingBoundedReadOverrideFactory())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Read.Unbounded.class), new StreamingUnboundedReadOverrideFactory()));
            if (!fnApiEnabled) {
                overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(View.CreatePCollectionView.class), new StreamingViewOverrides.StreamingCreatePCollectionViewFactory()));
            }
        } else {
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(GroupIntoBatches.class), new BatchGroupIntoBatchesOverrideFactory()));
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.stateOrTimerParDoMulti(), BatchStatefulParDoOverrides.multiOutputOverrideFactory(this.options))).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.stateOrTimerParDoSingle(), BatchStatefulParDoOverrides.singleOutputOverrideFactory(this.options)));
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.splittableProcessKeyedBounded(), (PTransformOverrideFactory)new SplittableParDoNaiveBounded.OverrideFactory()));
            if (!fnApiEnabled) {
                overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(View.AsMap.class), new ReflectiveViewOverrideFactory(BatchViewOverrides.BatchViewAsMap.class, this))).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(View.AsMultimap.class), new ReflectiveViewOverrideFactory(BatchViewOverrides.BatchViewAsMultimap.class, this))).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Combine.GloballyAsSingletonView.class), new CombineGloballyAsSingletonViewOverrideFactory(this))).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(View.AsList.class), new ReflectiveViewOverrideFactory(BatchViewOverrides.BatchViewAsList.class, this))).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(View.AsIterable.class), new ReflectiveViewOverrideFactory(BatchViewOverrides.BatchViewAsIterable.class, this)));
            }
        }
        if (fnApiEnabled) {
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Read.Bounded.class), new FnApiBoundedReadOverrideFactory()));
        }
        overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Reshuffle.class), new ReshuffleOverrideFactory())).add((Object)PTransformOverride.of((PTransformMatcher)DataflowRunner.combineValuesTranslation(fnApiEnabled), new PrimitiveCombineGroupedValuesOverrideFactory())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(ParDo.SingleOutput.class), new PrimitiveParDoSingleFactory()));
        return overridesBuilder.build();
    }

    private static PTransformMatcher combineValuesTranslation(boolean fnApiEnabled) {
        if (fnApiEnabled) {
            return new DataflowPTransformMatchers.CombineValuesWithParentCheckPTransformMatcher();
        }
        return new DataflowPTransformMatchers.CombineValuesWithoutSideInputsPTransformMatcher();
    }

    private String debuggerMessage(String projectId, String uniquifier) {
        return String.format("To debug your job, visit Google Cloud Debugger at: https://console.developers.google.com/debug?project=%s&dbgee=%s", projectId, uniquifier);
    }

    private void maybeRegisterDebuggee(DataflowPipelineOptions options, String uniquifier) {
        if (!options.getEnableCloudDebugger()) {
            return;
        }
        if (options.getDebuggee() != null) {
            throw new RuntimeException("Should not specify the debuggee");
        }
        CloudDebugger debuggerClient = DataflowTransport.newClouddebuggerClient(options).build();
        Debuggee debuggee = this.registerDebuggee(debuggerClient, uniquifier);
        options.setDebuggee(debuggee);
        System.out.println(this.debuggerMessage(options.getProject(), debuggee.getUniquifier()));
    }

    private Debuggee registerDebuggee(CloudDebugger debuggerClient, String uniquifier) {
        RegisterDebuggeeRequest registerReq = new RegisterDebuggeeRequest();
        registerReq.setDebuggee(new Debuggee().setProject(this.options.getProject()).setUniquifier(uniquifier).setDescription(uniquifier).setAgentVersion("google.com/cloud-dataflow-java/v1"));
        try {
            RegisterDebuggeeResponse registerResponse = (RegisterDebuggeeResponse)debuggerClient.controller().debuggees().register(registerReq).execute();
            Debuggee debuggee = registerResponse.getDebuggee();
            if (debuggee.getStatus() != null && debuggee.getStatus().getIsError().booleanValue()) {
                throw new RuntimeException("Unable to register with the debugger: " + debuggee.getStatus().getDescription().getFormat());
            }
            return debuggee;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to register with the debugger: ", e);
        }
    }

    public DataflowPipelineJob run(Pipeline pipeline) {
        Job jobResult;
        this.logWarningIfPCollectionViewHasNonDeterministicKeyCoder(pipeline);
        if (this.containsUnboundedPCollection(pipeline)) {
            this.options.setStreaming(true);
        }
        this.replaceTransforms(pipeline);
        LOG.info("Executing pipeline on the Dataflow Service, which will have billing implications related to Google Compute Engine usage and other Google Cloud Services.");
        List<DataflowPackage> packages = this.options.getStager().stageDefaultFiles();
        int randomNum = new Random().nextInt(9000) + 1000;
        String requestId = DateTimeFormat.forPattern((String)"YYYYMMddHHmmssmmm").withZone(DateTimeZone.UTC).print(DateTimeUtils.currentTimeMillis()) + "_" + randomNum;
        DataflowPipelineOptions dataflowOptions = (DataflowPipelineOptions)this.options.as(DataflowPipelineOptions.class);
        this.maybeRegisterDebuggee(dataflowOptions, requestId);
        DataflowPipelineTranslator.JobSpecification jobSpecification = this.translator.translate(pipeline, this, packages);
        LOG.info("Staging pipeline description to {}", (Object)this.options.getStagingLocation());
        byte[] serializedProtoPipeline = jobSpecification.getPipelineProto().toByteArray();
        DataflowPackage stagedPipeline = this.options.getStager().stageToFile(serializedProtoPipeline, PIPELINE_FILE_NAME);
        dataflowOptions.setPipelineUrl(stagedPipeline.getLocation());
        if (!Strings.isNullOrEmpty((String)dataflowOptions.getDataflowWorkerJar())) {
            ArrayList<String> experiments = dataflowOptions.getExperiments() == null ? new ArrayList<String>() : new ArrayList(dataflowOptions.getExperiments());
            experiments.add("use_staged_dataflow_worker_jar");
            dataflowOptions.setExperiments(experiments);
        }
        Job newJob = jobSpecification.getJob();
        try {
            newJob.getEnvironment().setSdkPipelineOptions((Map)MAPPER.readValue(MAPPER_WITH_MODULES.writeValueAsBytes((Object)this.options), Map.class));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("PipelineOptions specified failed to serialize to JSON.", e);
        }
        newJob.setClientRequestId(requestId);
        DataflowRunnerInfo dataflowRunnerInfo = DataflowRunnerInfo.getDataflowRunnerInfo();
        String version = dataflowRunnerInfo.getVersion();
        Preconditions.checkState((!"${pom.version}".equals(version) ? 1 : 0) != 0, (Object)"Unable to submit a job to the Dataflow service with unset version ${pom.version}");
        System.out.println("Dataflow SDK version: " + version);
        newJob.getEnvironment().setUserAgent(dataflowRunnerInfo.getProperties());
        if (!Strings.isNullOrEmpty((String)this.options.getGcpTempLocation())) {
            newJob.getEnvironment().setTempStoragePrefix(dataflowOptions.getPathValidator().verifyPath(this.options.getGcpTempLocation()));
        }
        newJob.getEnvironment().setDataset(this.options.getTempDatasetId());
        if (this.options.getFlexRSGoal() == DataflowPipelineOptions.FlexResourceSchedulingGoal.COST_OPTIMIZED) {
            newJob.getEnvironment().setFlexResourceSchedulingGoal("FLEXRS_COST_OPTIMIZED");
        } else if (this.options.getFlexRSGoal() == DataflowPipelineOptions.FlexResourceSchedulingGoal.SPEED_OPTIMIZED) {
            newJob.getEnvironment().setFlexResourceSchedulingGoal("FLEXRS_SPEED_OPTIMIZED");
        }
        List experiments = (List)MoreObjects.firstNonNull((Object)dataflowOptions.getExperiments(), new ArrayList());
        if (!Strings.isNullOrEmpty((String)dataflowOptions.getMinCpuPlatform())) {
            List minCpuFlags = experiments.stream().filter(p -> p.startsWith("min_cpu_platform")).collect(Collectors.toList());
            if (minCpuFlags.isEmpty()) {
                experiments.add("min_cpu_platform=" + dataflowOptions.getMinCpuPlatform());
            } else {
                LOG.warn("Flag min_cpu_platform is defined in both top level PipelineOption, as well as under experiments. Proceed using {}.", minCpuFlags.get(0));
            }
        }
        newJob.getEnvironment().setExperiments(experiments);
        String workerHarnessContainerImage = DataflowRunner.getContainerImageForJob(this.options);
        for (WorkerPool workerPool : newJob.getEnvironment().getWorkerPools()) {
            workerPool.setWorkerHarnessContainerImage(workerHarnessContainerImage);
        }
        newJob.getEnvironment().setVersion(DataflowRunner.getEnvironmentVersion(this.options));
        if (this.hooks != null) {
            this.hooks.modifyEnvironmentBeforeSubmission(newJob.getEnvironment());
        }
        if (DataflowRunner.hasExperiment(this.options, "upload_graph")) {
            DataflowPackage stagedGraph = this.options.getStager().stageToFile(DataflowPipelineTranslator.jobToString(newJob).getBytes(StandardCharsets.UTF_8), DATAFLOW_GRAPH_FILE_NAME);
            newJob.getSteps().clear();
            newJob.setStepsLocation(stagedGraph.getLocation());
        }
        if (!Strings.isNullOrEmpty((String)this.options.getDataflowJobFile()) || !Strings.isNullOrEmpty((String)this.options.getTemplateLocation())) {
            String fileLocation;
            boolean isTemplate;
            boolean bl = isTemplate = !Strings.isNullOrEmpty((String)this.options.getTemplateLocation());
            if (isTemplate) {
                Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)this.options.getDataflowJobFile()), (Object)"--dataflowJobFile and --templateLocation are mutually exclusive.");
            }
            Preconditions.checkArgument(((fileLocation = (String)MoreObjects.firstNonNull((Object)this.options.getTemplateLocation(), (Object)this.options.getDataflowJobFile())).startsWith("/") || fileLocation.startsWith("gs://") ? 1 : 0) != 0, (String)"Location must be local or on Cloud Storage, got %s.", (Object)fileLocation);
            ResourceId fileResource = FileSystems.matchNewResource((String)fileLocation, (boolean)false);
            String workSpecJson = DataflowPipelineTranslator.jobToString(newJob);
            try (PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(Channels.newOutputStream(FileSystems.create((ResourceId)fileResource, (String)"text/plain")), StandardCharsets.UTF_8)));){
                printWriter.print(workSpecJson);
                LOG.info("Printed job specification to {}", (Object)fileLocation);
            }
            catch (IOException ex) {
                String error = String.format("Cannot create output file at %s", fileLocation);
                if (isTemplate) {
                    throw new RuntimeException(error, ex);
                }
                LOG.warn(error, (Throwable)ex);
            }
            if (isTemplate) {
                LOG.info("Template successfully created.");
                return new DataflowTemplateJob();
            }
        }
        String jobIdToUpdate = null;
        if (this.options.isUpdate()) {
            jobIdToUpdate = this.getJobIdFromName(this.options.getJobName());
            newJob.setTransformNameMapping(this.options.getTransformNameMapping());
            newJob.setReplaceJobId(jobIdToUpdate);
        }
        if (this.options.getCreateFromSnapshot() != null && !this.options.getCreateFromSnapshot().isEmpty()) {
            newJob.setCreatedFromSnapshotId(this.options.getCreateFromSnapshot());
        }
        try {
            jobResult = this.dataflowClient.createJob(newJob);
        }
        catch (GoogleJsonResponseException e) {
            String errorMessages = "Unexpected errors";
            if (e.getDetails() != null) {
                errorMessages = Utf8.encodedLength((CharSequence)newJob.toString()) >= 0xA00000 ? "The size of the serialized JSON representation of the pipeline exceeds the allowable limit. For more information, please see the documentation on job submission:\nhttps://cloud.google.com/dataflow/docs/guides/deploying-a-pipeline#jobs" : e.getDetails().getMessage();
            }
            throw new RuntimeException("Failed to create a workflow job: " + errorMessages, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create a workflow job", e);
        }
        DataflowPipelineJob dataflowPipelineJob = new DataflowPipelineJob(DataflowClient.create(this.options), jobResult.getId(), this.options, jobSpecification.getStepNames());
        if (jobResult.getClientRequestId() != null && !jobResult.getClientRequestId().isEmpty() && !jobResult.getClientRequestId().equals(requestId)) {
            if (this.options.isUpdate()) {
                throw new DataflowJobAlreadyUpdatedException(dataflowPipelineJob, String.format("The job named %s with id: %s has already been updated into job id: %s and cannot be updated again.", newJob.getName(), jobIdToUpdate, jobResult.getId()));
            }
            throw new DataflowJobAlreadyExistsException(dataflowPipelineJob, String.format("There is already an active job named %s with id: %s. If you want to submit a second job, try again by setting a different name using --jobName.", newJob.getName(), jobResult.getId()));
        }
        LOG.info("To access the Dataflow monitoring console, please navigate to {}", (Object)MonitoringUtil.getJobMonitoringPageURL(this.options.getProject(), this.options.getRegion(), jobResult.getId()));
        System.out.println("Submitted job: " + jobResult.getId());
        LOG.info("To cancel the job using the 'gcloud' tool, run:\n> {}", (Object)MonitoringUtil.getGcloudCancelCommand(this.options, jobResult.getId()));
        return dataflowPipelineJob;
    }

    public static boolean hasExperiment(DataflowPipelineDebugOptions options, String experiment) {
        List experiments = (List)MoreObjects.firstNonNull((Object)options.getExperiments(), Collections.emptyList());
        return experiments.contains(experiment);
    }

    private static Map<String, Object> getEnvironmentVersion(DataflowPipelineOptions options) {
        String jobType;
        String majorVersion;
        DataflowRunnerInfo runnerInfo = DataflowRunnerInfo.getDataflowRunnerInfo();
        if (DataflowRunner.hasExperiment(options, "beam_fn_api")) {
            majorVersion = runnerInfo.getFnApiEnvironmentMajorVersion();
            jobType = options.isStreaming() ? "FNAPI_STREAMING" : "FNAPI_BATCH";
        } else {
            majorVersion = runnerInfo.getLegacyEnvironmentMajorVersion();
            jobType = options.isStreaming() ? "STREAMING" : "JAVA_BATCH_AUTOSCALING";
        }
        return ImmutableMap.of((Object)"major", (Object)majorVersion, (Object)"job_type", (Object)jobType);
    }

    @VisibleForTesting
    protected void replaceTransforms(Pipeline pipeline) {
        boolean streaming = this.options.isStreaming() || this.containsUnboundedPCollection(pipeline);
        UnconsumedReads.ensureAllReadsConsumed((Pipeline)pipeline);
        pipeline.replaceAll(this.getOverrides(streaming));
    }

    private boolean containsUnboundedPCollection(Pipeline p) {
        class BoundednessVisitor
        extends Pipeline.PipelineVisitor.Defaults {
            PCollection.IsBounded boundedness = PCollection.IsBounded.BOUNDED;

            BoundednessVisitor() {
            }

            public void visitValue(PValue value, TransformHierarchy.Node producer) {
                if (value instanceof PCollection) {
                    this.boundedness = this.boundedness.and(((PCollection)value).isBounded());
                }
            }
        }
        BoundednessVisitor visitor = new BoundednessVisitor();
        p.traverseTopologically((Pipeline.PipelineVisitor)visitor);
        return visitor.boundedness == PCollection.IsBounded.UNBOUNDED;
    }

    public DataflowPipelineTranslator getTranslator() {
        return this.translator;
    }

    @Experimental
    public void setHooks(DataflowRunnerHooks hooks) {
        this.hooks = hooks;
    }

    private void logWarningIfPCollectionViewHasNonDeterministicKeyCoder(Pipeline pipeline) {
        if (!this.ptransformViewsWithNonDeterministicKeyCoders.isEmpty()) {
            final TreeSet ptransformViewNamesWithNonDeterministicKeyCoders = new TreeSet();
            pipeline.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

                public void visitValue(PValue value, TransformHierarchy.Node producer) {
                }

                public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                    if (DataflowRunner.this.ptransformViewsWithNonDeterministicKeyCoders.contains(node.getTransform())) {
                        ptransformViewNamesWithNonDeterministicKeyCoders.add(node.getFullName());
                    }
                }

                public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
                    if (node.getTransform() instanceof View.AsMap || node.getTransform() instanceof View.AsMultimap) {
                        PCollection input = (PCollection)Iterables.getOnlyElement(node.getInputs().values());
                        KvCoder inputCoder = (KvCoder)input.getCoder();
                        try {
                            inputCoder.getKeyCoder().verifyDeterministic();
                        }
                        catch (Coder.NonDeterministicException e) {
                            ptransformViewNamesWithNonDeterministicKeyCoders.add(node.getFullName());
                        }
                    }
                    if (DataflowRunner.this.ptransformViewsWithNonDeterministicKeyCoders.contains(node.getTransform())) {
                        ptransformViewNamesWithNonDeterministicKeyCoders.add(node.getFullName());
                    }
                    return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
                }

                public void leaveCompositeTransform(TransformHierarchy.Node node) {
                }
            });
            LOG.warn("Unable to use indexed implementation for View.AsMap and View.AsMultimap for {} because the key coder is not deterministic. Falling back to singleton implementation which may cause memory and/or performance problems. Future major versions of Dataflow will require deterministic key coders.", ptransformViewNamesWithNonDeterministicKeyCoders);
        }
    }

    boolean doesPCollectionRequireIndexedFormat(PCollection<?> pcol) {
        return this.pcollectionsRequiringIndexedFormat.contains(pcol);
    }

    void addPCollectionRequiringIndexedFormat(PCollection<?> pcol) {
        this.pcollectionsRequiringIndexedFormat.add(pcol);
    }

    void recordViewUsesNonDeterministicKeyCoder(PTransform<?, ?> ptransform) {
        this.ptransformViewsWithNonDeterministicKeyCoders.add(ptransform);
    }

    public String toString() {
        return "DataflowRunner#" + this.options.getJobName();
    }

    private String getJobIdFromName(String jobName) {
        try {
            String token = null;
            do {
                ListJobsResponse listResult = this.dataflowClient.listJobs(token);
                token = listResult.getNextPageToken();
                for (Job job : listResult.getJobs()) {
                    if (!job.getName().equals(jobName) || !MonitoringUtil.toState(job.getCurrentState()).equals((Object)PipelineResult.State.RUNNING)) continue;
                    return job.getId();
                }
            } while (token != null);
        }
        catch (GoogleJsonResponseException e) {
            throw new RuntimeException("Got error while looking up jobs: " + (e.getDetails() != null ? e.getDetails().getMessage() : e), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Got error while looking up jobs: ", e);
        }
        throw new IllegalArgumentException("Could not find running job named " + jobName);
    }

    @VisibleForTesting
    static String getContainerImageForJob(DataflowPipelineOptions options) {
        String javaVersionId;
        String workerHarnessContainerImage = options.getWorkerHarnessContainerImage();
        String string = javaVersionId = Float.parseFloat(System.getProperty("java.specification.version")) >= 9.0f ? "java11" : "java";
        if (!workerHarnessContainerImage.contains("IMAGE")) {
            return workerHarnessContainerImage;
        }
        if (DataflowRunner.hasExperiment(options, "beam_fn_api")) {
            return workerHarnessContainerImage.replace("IMAGE", "java");
        }
        if (options.isStreaming()) {
            return workerHarnessContainerImage.replace("IMAGE", String.format("beam-%s-streaming", javaVersionId));
        }
        return workerHarnessContainerImage.replace("IMAGE", String.format("beam-%s-batch", javaVersionId));
    }

    static void verifyStateSupported(DoFn<?, ?> fn) {
        DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
        for (DoFnSignature.StateDeclaration stateDecl : signature.stateDeclarations().values()) {
            if (stateDecl.stateType().isSubtypeOf(TypeDescriptor.of(MapState.class))) {
                throw new UnsupportedOperationException(String.format("%s does not currently support %s", DataflowRunner.class.getSimpleName(), MapState.class.getSimpleName()));
            }
            if (!stateDecl.stateType().isSubtypeOf(TypeDescriptor.of(SetState.class))) continue;
            throw new UnsupportedOperationException(String.format("%s does not currently support %s", DataflowRunner.class.getSimpleName(), SetState.class.getSimpleName()));
        }
    }

    static void verifyStateSupportForWindowingStrategy(WindowingStrategy strategy) {
        if (!strategy.getWindowFn().isNonMerging()) {
            throw new UnsupportedOperationException(String.format("%s does not currently support state or timers with merging windows", DataflowRunner.class.getSimpleName()));
        }
    }

    static {
        DataflowPipelineTranslator.registerTransformTranslator(Impulse.class, new ImpulseTranslator());
    }

    @VisibleForTesting
    static class StreamingShardedWriteFactory<UserT, DestinationT, OutputT>
    implements PTransformOverrideFactory<PCollection<UserT>, WriteFilesResult<DestinationT>, WriteFiles<UserT, DestinationT, OutputT>> {
        static final int DEFAULT_NUM_SHARDS = 10;
        DataflowPipelineWorkerPoolOptions options;

        StreamingShardedWriteFactory(PipelineOptions options) {
            this.options = (DataflowPipelineWorkerPoolOptions)options.as(DataflowPipelineWorkerPoolOptions.class);
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<UserT>, WriteFilesResult<DestinationT>> getReplacementTransform(AppliedPTransform<PCollection<UserT>, WriteFilesResult<DestinationT>, WriteFiles<UserT, DestinationT, OutputT>> transform) {
            int numShards = this.options.getMaxNumWorkers() > 0 ? this.options.getMaxNumWorkers() * 2 : (this.options.getNumWorkers() > 0 ? this.options.getNumWorkers() * 2 : 10);
            try {
                List sideInputs = WriteFilesTranslation.getDynamicDestinationSideInputs(transform);
                FileBasedSink sink = WriteFilesTranslation.getSink(transform);
                WriteFiles replacement = WriteFiles.to((FileBasedSink)sink).withSideInputs(sideInputs);
                if (WriteFilesTranslation.isWindowedWrites(transform)) {
                    replacement = replacement.withWindowedWrites();
                }
                return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), (PTransform)replacement.withNumShards(numShards));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, WriteFilesResult<DestinationT> newOutput) {
            return ReplacementOutputs.tagged(outputs, newOutput);
        }
    }

    private static class StreamingPubsubIOWriteOverrideFactory
    implements PTransformOverrideFactory<PCollection<PubsubMessage>, PDone, PubsubUnboundedSink> {
        private final DataflowRunner runner;

        private StreamingPubsubIOWriteOverrideFactory(DataflowRunner runner) {
            this.runner = runner;
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<PubsubMessage>, PDone> getReplacementTransform(AppliedPTransform<PCollection<PubsubMessage>, PDone, PubsubUnboundedSink> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), (PTransform)new StreamingPubsubIOWrite(this.runner, (PubsubUnboundedSink)transform.getTransform()));
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PDone newOutput) {
            return Collections.emptyMap();
        }
    }

    private static class PrimitiveCombineGroupedValuesOverrideFactory<K, InputT, OutputT>
    implements PTransformOverrideFactory<PCollection<KV<K, Iterable<InputT>>>, PCollection<KV<K, OutputT>>, Combine.GroupedValues<K, InputT, OutputT>> {
        private PrimitiveCombineGroupedValuesOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<KV<K, Iterable<InputT>>>, PCollection<KV<K, OutputT>>> getReplacementTransform(AppliedPTransform<PCollection<KV<K, Iterable<InputT>>>, PCollection<KV<K, OutputT>>, Combine.GroupedValues<K, InputT, OutputT>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new CombineGroupedValues((Combine.GroupedValues)transform.getTransform(), PTransformReplacements.getSingletonMainOutput(transform).getCoder()));
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<KV<K, OutputT>> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    static class CombineGroupedValues<K, InputT, OutputT>
    extends PTransform<PCollection<KV<K, Iterable<InputT>>>, PCollection<KV<K, OutputT>>> {
        private final Combine.GroupedValues<K, InputT, OutputT> original;
        private final Coder<KV<K, OutputT>> outputCoder;

        CombineGroupedValues(Combine.GroupedValues<K, InputT, OutputT> original, Coder<KV<K, OutputT>> outputCoder) {
            this.original = original;
            this.outputCoder = outputCoder;
        }

        public PCollection<KV<K, OutputT>> expand(PCollection<KV<K, Iterable<InputT>>> input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)input.getWindowingStrategy(), (PCollection.IsBounded)input.isBounded(), this.outputCoder);
        }

        public Combine.GroupedValues<K, InputT, OutputT> getOriginalCombine() {
            return this.original;
        }
    }

    @Internal
    public static class StreamingPCollectionViewWriterFn<T>
    extends DoFn<Iterable<T>, T> {
        private final PCollectionView<?> view;
        private final Coder<T> dataCoder;

        public static <T> StreamingPCollectionViewWriterFn<T> create(PCollectionView<?> view, Coder<T> dataCoder) {
            return new StreamingPCollectionViewWriterFn<T>(view, dataCoder);
        }

        private StreamingPCollectionViewWriterFn(PCollectionView<?> view, Coder<T> dataCoder) {
            this.view = view;
            this.dataCoder = dataCoder;
        }

        public PCollectionView<?> getView() {
            return this.view;
        }

        public Coder<T> getDataCoder() {
            return this.dataCoder;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, BoundedWindow w) throws Exception {
            throw new UnsupportedOperationException(String.format("%s is a marker class only and should never be executed.", ((Object)((Object)this)).getClass().getName()));
        }
    }

    private static class FnApiBoundedReadOverrideFactory<T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, Read.Bounded<T>> {
        private FnApiBoundedReadOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PBegin, PCollection<T>> getReplacementTransform(AppliedPTransform<PBegin, PCollection<T>, Read.Bounded<T>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)transform.getPipeline().begin(), (PTransform)JavaReadViaImpulse.bounded((BoundedSource)((Read.Bounded)transform.getTransform()).getSource()));
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<T> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    private static class StreamingBoundedRead<T>
    extends PTransform<PBegin, PCollection<T>> {
        private final BoundedSource<T> source;

        public StreamingBoundedRead(Read.Bounded<T> transform) {
            this.source = transform.getSource();
        }

        public final PCollection<T> expand(PBegin input) {
            this.source.validate();
            return ((PCollection)Pipeline.applyTransform((PInput)input, (PTransform)new UnboundedReadFromBoundedSource(this.source))).setIsBoundedInternal(PCollection.IsBounded.BOUNDED);
        }
    }

    private static class StreamingBoundedReadOverrideFactory<T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, Read.Bounded<T>> {
        private StreamingBoundedReadOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PBegin, PCollection<T>> getReplacementTransform(AppliedPTransform<PBegin, PCollection<T>, Read.Bounded<T>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)transform.getPipeline().begin(), new StreamingBoundedRead((Read.Bounded)transform.getTransform()));
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<T> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    private static class Deduplicate<T>
    extends PTransform<PCollection<ValueWithRecordId<T>>, PCollection<T>> {
        private static final int NUM_RESHARD_KEYS = 10000;

        private Deduplicate() {
        }

        public PCollection<T> expand(PCollection<ValueWithRecordId<T>> input) {
            return (PCollection)((PCollection)((PCollection)input.apply((PTransform)WithKeys.of((SerializableFunction & Serializable)value -> Arrays.hashCode(value.getId()) % 10000).withKeyType(TypeDescriptors.integers()))).apply((PTransform)Reshuffle.of())).apply("StripIds", (PTransform)ParDo.of((DoFn)new DoFn<KV<Integer, ValueWithRecordId<T>>, T>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    c.output(((ValueWithRecordId)((KV)c.element()).getValue()).getValue());
                }
            }));
        }
    }

    private static class StreamingUnboundedRead<T>
    extends PTransform<PBegin, PCollection<T>> {
        private final UnboundedSource<T, ?> source;

        public StreamingUnboundedRead(Read.Unbounded<T> transform) {
            this.source = transform.getSource();
        }

        public final PCollection<T> expand(PBegin input) {
            this.source.validate();
            if (this.source.requiresDeduping()) {
                return (PCollection)((PCollection)Pipeline.applyTransform((PInput)input, new ReadWithIds(this.source))).apply(new Deduplicate());
            }
            return (PCollection)((PCollection)Pipeline.applyTransform((PInput)input, new ReadWithIds(this.source))).apply("StripIds", (PTransform)ParDo.of((DoFn)new ValueWithRecordId.StripIdsDoFn()));
        }

        public String getKindString() {
            return String.format("Read(%s)", NameUtils.approximateSimpleName(this.source));
        }

        static {
            DataflowPipelineTranslator.registerTransformTranslator(ReadWithIds.class, new ReadWithIdsTranslator());
        }

        private static class ReadWithIdsTranslator
        implements TransformTranslator<ReadWithIds<?>> {
            private ReadWithIdsTranslator() {
            }

            @Override
            public void translate(ReadWithIds<?> transform, TransformTranslator.TranslationContext context) {
                ReadTranslator.translateReadHelper(transform.getSource(), transform, context);
            }
        }

        private static class ReadWithIds<T>
        extends PTransform<PInput, PCollection<ValueWithRecordId<T>>> {
            private final UnboundedSource<T, ?> source;

            private ReadWithIds(UnboundedSource<T, ?> source) {
                this.source = source;
            }

            public final PCollection<ValueWithRecordId<T>> expand(PInput input) {
                return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED, (Coder)ValueWithRecordId.ValueWithRecordIdCoder.of((Coder)this.source.getOutputCoder()));
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.delegate(this.source);
            }

            public UnboundedSource<T, ?> getSource() {
                return this.source;
            }
        }
    }

    private static class StreamingUnboundedReadOverrideFactory<T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, Read.Unbounded<T>> {
        private StreamingUnboundedReadOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PBegin, PCollection<T>> getReplacementTransform(AppliedPTransform<PBegin, PCollection<T>, Read.Unbounded<T>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)transform.getPipeline().begin(), new StreamingUnboundedRead((Read.Unbounded)transform.getTransform()));
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<T> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    static class BatchGroupIntoBatches<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
        private final long batchSize;

        private BatchGroupIntoBatches(long batchSize) {
            this.batchSize = batchSize;
        }

        public PCollection<KV<K, Iterable<V>>> expand(PCollection<KV<K, V>> input) {
            return (PCollection)((PCollection)input.apply("GroupAll", (PTransform)GroupByKey.create())).apply("SplitIntoBatches", (PTransform)ParDo.of((DoFn)new DoFn<KV<K, Iterable<V>>, KV<K, Iterable<V>>>(){

                @DoFn.ProcessElement
                public void process(DoFn.ProcessContext c) {
                    UnmodifiableIterator iterator = Iterators.partition(((Iterable)((KV)c.element()).getValue()).iterator(), (int)((int)batchSize));
                    while (iterator.hasNext()) {
                        c.output((Object)KV.of((Object)((KV)c.element()).getKey(), (Object)((Iterable)iterator.next())));
                    }
                }
            }));
        }
    }

    private static class BatchGroupIntoBatchesOverrideFactory<K, V>
    implements PTransformOverrideFactory<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>, GroupIntoBatches<K, V>> {
        private BatchGroupIntoBatchesOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> getReplacementTransform(AppliedPTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>, GroupIntoBatches<K, V>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new BatchGroupIntoBatches(((GroupIntoBatches)transform.getTransform()).getBatchSize()));
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<KV<K, Iterable<V>>> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    private static class ImpulseTranslator
    implements TransformTranslator<Impulse> {
        private ImpulseTranslator() {
        }

        @Override
        public void translate(Impulse transform, TransformTranslator.TranslationContext context) {
            if (context.getPipelineOptions().isStreaming()) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "ParallelRead");
                stepContext.addInput("format", "pubsub");
                stepContext.addInput("pubsub_subscription", "_starting_signal/");
                stepContext.addOutput("output", (PCollection)context.getOutput(transform));
            } else {
                byte[] encodedImpulse;
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "ParallelRead");
                stepContext.addInput("format", "impulse");
                WindowedValue.FullWindowedValueCoder coder = WindowedValue.getFullCoder((Coder)((PCollection)context.getOutput(transform)).getCoder(), (Coder)GlobalWindow.Coder.INSTANCE);
                try {
                    encodedImpulse = CoderUtils.encodeToByteArray((Coder)coder, (Object)WindowedValue.valueInGlobalWindow((Object)new byte[0]));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                stepContext.addInput("impulse_element", StringUtils.byteArrayToJsonString((byte[])encodedImpulse));
                stepContext.addOutput("output", (PCollection)context.getOutput(transform));
            }
        }
    }

    private static class StreamingFnApiCreate<T>
    extends PTransform<PBegin, PCollection<T>> {
        private final Create.Values<T> transform;
        private final transient PCollection<T> originalOutput;

        private StreamingFnApiCreate(Create.Values<T> transform, PCollection<T> originalOutput) {
            this.transform = transform;
            this.originalOutput = originalOutput;
        }

        public final PCollection<T> expand(PBegin input) {
            try {
                PCollection pc = (PCollection)((PCollection)Pipeline.applyTransform((PInput)input, (PTransform)Impulse.create())).apply((PTransform)ParDo.of(DecodeAndEmitDoFn.fromIterable(this.transform.getElements(), this.originalOutput.getCoder())));
                pc.setCoder(this.originalOutput.getCoder());
                return pc;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to encode elements.", e);
            }
        }

        private static class DecodeAndEmitDoFn<T>
        extends DoFn<byte[], T> {
            private final Collection<byte[]> elements;
            private final RunnerApi.MessageWithComponents coderSpec;
            private transient Coder<T> coder;

            public static <T> DecodeAndEmitDoFn<T> fromIterable(Iterable<T> elements, Coder<T> elemCoder) throws IOException {
                ImmutableList.Builder allElementsBytes = ImmutableList.builder();
                for (T element : elements) {
                    byte[] bytes = CoderUtils.encodeToByteArray(elemCoder, element);
                    allElementsBytes.add((Object)bytes);
                }
                return new DecodeAndEmitDoFn<T>((Collection<byte[]>)allElementsBytes.build(), elemCoder);
            }

            private Coder<T> getCoder() throws IOException {
                if (this.coder == null) {
                    this.coder = CoderTranslation.fromProto((RunnerApi.Coder)this.coderSpec.getCoder(), (RehydratedComponents)RehydratedComponents.forComponents((RunnerApi.Components)this.coderSpec.getComponents()));
                }
                return this.coder;
            }

            private DecodeAndEmitDoFn(Collection<byte[]> elements, Coder<T> coder) throws IOException {
                this.elements = elements;
                this.coderSpec = CoderTranslation.toProto(coder);
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws IOException {
                for (byte[] element : this.elements) {
                    context.output(CoderUtils.decodeFromByteArray(this.getCoder(), (byte[])element));
                }
            }
        }
    }

    private static class StreamingFnApiCreateOverrideFactory<T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, Create.Values<T>> {
        private StreamingFnApiCreateOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PBegin, PCollection<T>> getReplacementTransform(AppliedPTransform<PBegin, PCollection<T>, Create.Values<T>> transform) {
            Create.Values original = (Create.Values)transform.getTransform();
            PCollection output = (PCollection)Iterables.getOnlyElement(transform.getOutputs().values());
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)transform.getPipeline().begin(), new StreamingFnApiCreate(original, output));
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<T> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    private static class StreamingPubsubIOWriteTranslator
    implements TransformTranslator<StreamingPubsubIOWrite> {
        private StreamingPubsubIOWriteTranslator() {
        }

        @Override
        public void translate(StreamingPubsubIOWrite transform, TransformTranslator.TranslationContext context) {
            Preconditions.checkArgument((boolean)context.getPipelineOptions().isStreaming(), (Object)"StreamingPubsubIOWrite is only for streaming pipelines.");
            PubsubUnboundedSink overriddenTransform = transform.getOverriddenTransform();
            TransformTranslator.StepTranslationContext stepContext = context.addStep(transform, "ParallelWrite");
            stepContext.addInput("format", "pubsub");
            if (overriddenTransform.getTopicProvider().isAccessible()) {
                stepContext.addInput("pubsub_topic", overriddenTransform.getTopic().getV1Beta1Path());
            } else {
                stepContext.addInput("pubsub_topic_runtime_override", ((ValueProvider.NestedValueProvider)overriddenTransform.getTopicProvider()).propertyName());
            }
            if (overriddenTransform.getTimestampAttribute() != null) {
                stepContext.addInput("pubsub_timestamp_label", overriddenTransform.getTimestampAttribute());
            }
            if (overriddenTransform.getIdAttribute() != null) {
                stepContext.addInput("pubsub_id_label", overriddenTransform.getIdAttribute());
            }
            stepContext.addInput("pubsub_serialized_attributes_fn", StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)((Object)new IdentityMessageFn()))));
            stepContext.addEncodingInput((Coder<?>)WindowedValue.getValueOnlyCoder((Coder)VoidCoder.of()));
            stepContext.addInput("parallel_input", (PInput)context.getInput(transform));
        }
    }

    private static class StreamingPubsubIOWrite
    extends PTransform<PCollection<PubsubMessage>, PDone> {
        private final PubsubUnboundedSink transform;

        public StreamingPubsubIOWrite(DataflowRunner runner, PubsubUnboundedSink transform) {
            this.transform = transform;
        }

        PubsubUnboundedSink getOverriddenTransform() {
            return this.transform;
        }

        public PDone expand(PCollection<PubsubMessage> input) {
            return PDone.in((Pipeline)input.getPipeline());
        }

        protected String getKindString() {
            return "StreamingPubsubIOWrite";
        }

        static {
            DataflowPipelineTranslator.registerTransformTranslator(StreamingPubsubIOWrite.class, new StreamingPubsubIOWriteTranslator());
        }
    }

    private static class IdentityMessageFn
    extends SimpleFunction<PubsubMessage, PubsubMessage> {
        private IdentityMessageFn() {
        }

        public PubsubMessage apply(PubsubMessage input) {
            return input;
        }
    }

    private static class StreamingPubsubIOReadTranslator
    implements TransformTranslator<StreamingPubsubIORead> {
        private StreamingPubsubIOReadTranslator() {
        }

        @Override
        public void translate(StreamingPubsubIORead transform, TransformTranslator.TranslationContext context) {
            Preconditions.checkArgument((boolean)context.getPipelineOptions().isStreaming(), (Object)"StreamingPubsubIORead is only for streaming pipelines.");
            PubsubUnboundedSource overriddenTransform = transform.getOverriddenTransform();
            TransformTranslator.StepTranslationContext stepContext = context.addStep(transform, "ParallelRead");
            stepContext.addInput("format", "pubsub");
            if (overriddenTransform.getTopicProvider() != null) {
                if (overriddenTransform.getTopicProvider().isAccessible()) {
                    stepContext.addInput("pubsub_topic", overriddenTransform.getTopic().getV1Beta1Path());
                } else {
                    stepContext.addInput("pubsub_topic_runtime_override", ((ValueProvider.NestedValueProvider)overriddenTransform.getTopicProvider()).propertyName());
                }
            }
            if (overriddenTransform.getSubscriptionProvider() != null) {
                if (overriddenTransform.getSubscriptionProvider().isAccessible()) {
                    stepContext.addInput("pubsub_subscription", overriddenTransform.getSubscription().getV1Beta1Path());
                } else {
                    stepContext.addInput("pubsub_subscription_runtime_override", ((ValueProvider.NestedValueProvider)overriddenTransform.getSubscriptionProvider()).propertyName());
                }
            }
            if (overriddenTransform.getTimestampAttribute() != null) {
                stepContext.addInput("pubsub_timestamp_label", overriddenTransform.getTimestampAttribute());
            }
            if (overriddenTransform.getIdAttribute() != null) {
                stepContext.addInput("pubsub_id_label", overriddenTransform.getIdAttribute());
            }
            if (overriddenTransform.getNeedsAttributes()) {
                stepContext.addInput("pubsub_serialized_attributes_fn", StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)((Object)new IdentityMessageFn()))));
            }
            stepContext.addOutput("output", context.getOutput(transform));
        }
    }

    private static class StreamingPubsubIORead
    extends PTransform<PBegin, PCollection<PubsubMessage>> {
        private final PubsubUnboundedSource transform;

        public StreamingPubsubIORead(PubsubUnboundedSource transform) {
            this.transform = transform;
        }

        PubsubUnboundedSource getOverriddenTransform() {
            return this.transform;
        }

        public PCollection<PubsubMessage> expand(PBegin input) {
            PubsubMessageWithAttributesAndMessageIdCoder coder = this.transform.getNeedsMessageId() ? new PubsubMessageWithAttributesAndMessageIdCoder() : new PubsubMessageWithAttributesCoder();
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED, (Coder)coder);
        }

        protected String getKindString() {
            return "StreamingPubsubIORead";
        }

        static {
            DataflowPipelineTranslator.registerTransformTranslator(StreamingPubsubIORead.class, new StreamingPubsubIOReadTranslator());
        }
    }

    private static class StreamingPubsubIOReadOverrideFactory
    implements PTransformOverrideFactory<PBegin, PCollection<PubsubMessage>, PubsubUnboundedSource> {
        private StreamingPubsubIOReadOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PBegin, PCollection<PubsubMessage>> getReplacementTransform(AppliedPTransform<PBegin, PCollection<PubsubMessage>, PubsubUnboundedSource> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)transform.getPipeline().begin(), (PTransform)new StreamingPubsubIORead((PubsubUnboundedSource)transform.getTransform()));
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<PubsubMessage> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    private static class ReflectiveOneToOneOverrideFactory<InputT, OutputT, TransformT extends PTransform<PCollection<InputT>, PCollection<OutputT>>>
    extends SingleInputOutputOverrideFactory<PCollection<InputT>, PCollection<OutputT>, TransformT> {
        private final Class<PTransform<PCollection<InputT>, PCollection<OutputT>>> replacement;
        private final DataflowRunner runner;

        private ReflectiveOneToOneOverrideFactory(Class<PTransform<PCollection<InputT>, PCollection<OutputT>>> replacement, DataflowRunner runner) {
            this.replacement = replacement;
            this.runner = runner;
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<InputT>, PCollection<OutputT>> getReplacementTransform(AppliedPTransform<PCollection<InputT>, PCollection<OutputT>, TransformT> transform) {
            PTransform rep = (PTransform)InstanceBuilder.ofType(this.replacement).withArg(DataflowRunner.class, (Object)this.runner).withArg(transform.getTransform().getClass(), (Object)transform.getTransform()).build();
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), (PTransform)rep);
        }
    }

    private static class ReflectiveViewOverrideFactory<InputT, ViewT>
    implements PTransformOverrideFactory<PCollection<InputT>, PValue, PTransform<PCollection<InputT>, PValue>> {
        final Class<PTransform<PCollection<InputT>, PValue>> replacement;
        final DataflowRunner runner;

        private ReflectiveViewOverrideFactory(Class<PTransform<PCollection<InputT>, PValue>> replacement, DataflowRunner runner) {
            this.replacement = replacement;
            this.runner = runner;
        }

        View.CreatePCollectionView<ViewT, ViewT> findCreatePCollectionView(final AppliedPTransform<PCollection<InputT>, PValue, PTransform<PCollection<InputT>, PValue>> transform) {
            final AtomicReference viewTransformRef = new AtomicReference();
            transform.getPipeline().traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){
                private boolean tracking = false;

                public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
                    if (transform.getTransform() == node.getTransform()) {
                        this.tracking = true;
                    }
                    return super.enterCompositeTransform(node);
                }

                public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                    if (this.tracking && node.getTransform() instanceof View.CreatePCollectionView) {
                        Preconditions.checkState((boolean)viewTransformRef.compareAndSet(null, (View.CreatePCollectionView)node.getTransform()), (String)"Found more than one instance of a CreatePCollectionView when attempting to replace %s, found [%s, %s]", replacement, viewTransformRef.get(), (Object)node.getTransform());
                    }
                }

                public void leaveCompositeTransform(TransformHierarchy.Node node) {
                    if (transform.getTransform() == node.getTransform()) {
                        this.tracking = false;
                    }
                }
            });
            Preconditions.checkState((viewTransformRef.get() != null ? 1 : 0) != 0, (String)"Expected to find CreatePCollectionView contained within %s", (Object)transform.getTransform());
            return (View.CreatePCollectionView)viewTransformRef.get();
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<InputT>, PValue> getReplacementTransform(AppliedPTransform<PCollection<InputT>, PValue, PTransform<PCollection<InputT>, PValue>> transform) {
            PTransform rep = (PTransform)InstanceBuilder.ofType(this.replacement).withArg(DataflowRunner.class, (Object)this.runner).withArg(View.CreatePCollectionView.class, this.findCreatePCollectionView(transform)).build();
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), (PTransform)rep);
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PValue newOutput) {
            return ImmutableMap.of();
        }
    }

    private static class CombineGloballyAsSingletonViewOverrideFactory<InputT, ViewT>
    extends ReflectiveViewOverrideFactory<InputT, ViewT> {
        private CombineGloballyAsSingletonViewOverrideFactory(DataflowRunner runner) {
            super(BatchViewOverrides.BatchViewAsSingleton.class, runner);
        }

        @Override
        public PTransformOverrideFactory.PTransformReplacement<PCollection<InputT>, PValue> getReplacementTransform(AppliedPTransform<PCollection<InputT>, PValue, PTransform<PCollection<InputT>, PValue>> transform) {
            Combine.GloballyAsSingletonView combineTransform = (Combine.GloballyAsSingletonView)transform.getTransform();
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new BatchViewOverrides.BatchViewAsSingleton(this.runner, this.findCreatePCollectionView(transform), (Combine.CombineFn)combineTransform.getCombineFn(), combineTransform.getFanout()));
        }
    }
}

