/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.util.Map;
import org.apache.beam.runners.core.construction.PTransformReplacements;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;

class RequiresStableInputParDoOverrides {
    RequiresStableInputParDoOverrides() {
    }

    static <InputT, OutputT> PTransformOverrideFactory<PCollection<InputT>, PCollection<OutputT>, ParDo.SingleOutput<InputT, OutputT>> singleOutputOverrideFactory() {
        return new SingleOutputOverrideFactory();
    }

    static <InputT, OutputT> PTransformOverrideFactory<PCollection<InputT>, PCollectionTuple, ParDo.MultiOutput<InputT, OutputT>> multiOutputOverrideFactory() {
        return new MultiOutputOverrideFactory();
    }

    private static class MultiOutputOverrideFactory<InputT, OutputT>
    implements PTransformOverrideFactory<PCollection<InputT>, PCollectionTuple, ParDo.MultiOutput<InputT, OutputT>> {
        private MultiOutputOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<InputT>, PCollectionTuple> getReplacementTransform(final AppliedPTransform<PCollection<InputT>, PCollectionTuple, ParDo.MultiOutput<InputT, OutputT>> appliedTransform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(appliedTransform), (PTransform)new PTransform<PCollection<InputT>, PCollectionTuple>(){

                public PCollectionTuple expand(PCollection<InputT> input) {
                    return (PCollectionTuple)((PCollection)input.apply("Materialize input", (PTransform)Reshuffle.viaRandomKey())).apply("ParDo with stable input", appliedTransform.getTransform());
                }
            });
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollectionTuple newOutput) {
            return ReplacementOutputs.tagged(outputs, (POutput)newOutput);
        }
    }

    private static class SingleOutputOverrideFactory<InputT, OutputT>
    implements PTransformOverrideFactory<PCollection<InputT>, PCollection<OutputT>, ParDo.SingleOutput<InputT, OutputT>> {
        private SingleOutputOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<InputT>, PCollection<OutputT>> getReplacementTransform(final AppliedPTransform<PCollection<InputT>, PCollection<OutputT>, ParDo.SingleOutput<InputT, OutputT>> appliedTransform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(appliedTransform), (PTransform)new PTransform<PCollection<InputT>, PCollection<OutputT>>(){

                public PCollection<OutputT> expand(PCollection<InputT> input) {
                    return (PCollection)((PCollection)input.apply("Materialize input", (PTransform)Reshuffle.viaRandomKey())).apply("ParDo with stable input", appliedTransform.getTransform());
                }
            });
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<OutputT> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }
}

