/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.services.dataflow.model.DataflowPackage;
import java.util.List;
import org.apache.beam.runners.dataflow.options.DataflowPipelineDebugOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.PackageUtil;
import org.apache.beam.runners.dataflow.util.Stager;
import org.apache.beam.sdk.extensions.gcp.storage.GcsCreateOptions;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class GcsStager
implements Stager {
    private DataflowPipelineOptions options;

    private GcsStager(DataflowPipelineOptions options) {
        this.options = options;
    }

    public static GcsStager fromOptions(PipelineOptions options) {
        return new GcsStager((DataflowPipelineOptions)options.as(DataflowPipelineOptions.class));
    }

    @Override
    public List<DataflowPackage> stageDefaultFiles() {
        Preconditions.checkNotNull((Object)this.options.getStagingLocation());
        String windmillBinary = ((DataflowPipelineDebugOptions)this.options.as(DataflowPipelineDebugOptions.class)).getOverrideWindmillBinary();
        String dataflowWorkerJar = this.options.getDataflowWorkerJar();
        List filesToStage = this.options.getFilesToStage();
        if (windmillBinary != null) {
            filesToStage.add("windmill_main=" + windmillBinary);
        }
        if (dataflowWorkerJar != null && !dataflowWorkerJar.isEmpty()) {
            filesToStage.add(0, "dataflow-worker.jar=" + dataflowWorkerJar);
        }
        return this.stageFiles(filesToStage);
    }

    @Override
    public List<DataflowPackage> stageFiles(List<String> filesToStage) {
        try (PackageUtil packageUtil = PackageUtil.withDefaultThreadPool();){
            List<DataflowPackage> list = packageUtil.stageClasspathElements(filesToStage, this.options.getStagingLocation(), (CreateOptions)this.buildCreateOptions());
            return list;
        }
    }

    @Override
    public DataflowPackage stageToFile(byte[] bytes, String baseName) {
        try (PackageUtil packageUtil = PackageUtil.withDefaultThreadPool();){
            DataflowPackage dataflowPackage = packageUtil.stageToFile(bytes, baseName, this.options.getStagingLocation(), (CreateOptions)this.buildCreateOptions());
            return dataflowPackage;
        }
    }

    private GcsCreateOptions buildCreateOptions() {
        int uploadSizeBytes = (Integer)MoreObjects.firstNonNull((Object)this.options.getGcsUploadBufferSizeBytes(), (Object)0x100000);
        Preconditions.checkArgument((uploadSizeBytes > 0 ? 1 : 0) != 0, (Object)"gcsUploadBufferSizeBytes must be > 0");
        uploadSizeBytes = Math.min(uploadSizeBytes, 0x100000);
        return ((GcsCreateOptions.Builder)GcsCreateOptions.builder().setGcsUploadBufferSizeBytes(Integer.valueOf(uploadSizeBytes)).setMimeType("application/octet-stream")).build();
    }
}

