/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.SchemaTranslation;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.StringUtils;

public class SchemaCoderCloudObjectTranslator
implements CloudObjectTranslator<SchemaCoder> {
    private static final String SCHEMA = "schema";
    private static final String TO_ROW_FUNCTION = "toRowFunction";
    private static final String FROM_ROW_FUNCTION = "fromRowFunction";

    @Override
    public CloudObject toCloudObject(SchemaCoder target, SdkComponents sdkComponents) {
        CloudObject base = CloudObject.forClass(SchemaCoder.class);
        Structs.addString((Map<String, Object>)((Object)base), TO_ROW_FUNCTION, StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)target.getToRowFunction())));
        Structs.addString((Map<String, Object>)((Object)base), FROM_ROW_FUNCTION, StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)target.getFromRowFunction())));
        Structs.addString((Map<String, Object>)((Object)base), SCHEMA, StringUtils.byteArrayToJsonString((byte[])SchemaTranslation.toProto((Schema)target.getSchema()).toByteArray()));
        return base;
    }

    @Override
    public SchemaCoder fromCloudObject(CloudObject cloudObject) {
        try {
            SerializableFunction toRowFunction = (SerializableFunction)SerializableUtils.deserializeFromByteArray((byte[])StringUtils.jsonStringToByteArray((String)Structs.getString((Map<String, Object>)((Object)cloudObject), TO_ROW_FUNCTION)), (String)TO_ROW_FUNCTION);
            SerializableFunction fromRowFunction = (SerializableFunction)SerializableUtils.deserializeFromByteArray((byte[])StringUtils.jsonStringToByteArray((String)Structs.getString((Map<String, Object>)((Object)cloudObject), FROM_ROW_FUNCTION)), (String)FROM_ROW_FUNCTION);
            RunnerApi.Schema protoSchema = RunnerApi.Schema.parseFrom((byte[])StringUtils.jsonStringToByteArray((String)Structs.getString((Map<String, Object>)((Object)cloudObject), SCHEMA)));
            Schema schema = SchemaTranslation.fromProto((RunnerApi.Schema)protoSchema);
            return SchemaCoder.of((Schema)schema, (SerializableFunction)toRowFunction, (SerializableFunction)fromRowFunction);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<? extends SchemaCoder> getSupportedClass() {
        return SchemaCoder.class;
    }

    @Override
    public String cloudObjectClassName() {
        return CloudObject.forClass(SchemaCoder.class).getClassName();
    }
}

