/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.OutputReference;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;

@Internal
public interface TransformTranslator<TransformT extends PTransform> {
    public void translate(TransformT var1, TranslationContext var2);

    public static interface StepTranslationContext {
        public void addEncodingInput(Coder<?> var1);

        public void addInput(String var1, Boolean var2);

        public void addInput(String var1, String var2);

        public void addInput(String var1, Long var2);

        public void addInput(String var1, PInput var2);

        public void addInput(String var1, Map<String, Object> var2);

        public void addInput(String var1, List<? extends Map<String, Object>> var2);

        public void addOutput(String var1, PCollection<?> var2);

        public void addCollectionToSingletonOutput(PCollection<?> var1, String var2, PCollectionView<?> var3);
    }

    public static interface TranslationContext {
        default public boolean isFnApi() {
            List experiments = this.getPipelineOptions().getExperiments();
            return experiments != null && experiments.contains("beam_fn_api");
        }

        default public boolean isStreamingEngine() {
            List experiments = this.getPipelineOptions().getExperiments();
            return experiments != null && experiments.contains("enable_streaming_engine") && experiments.contains("enable_windmill_service");
        }

        public DataflowPipelineOptions getPipelineOptions();

        public <InputT extends PInput> Map<TupleTag<?>, PValue> getInputs(PTransform<InputT, ?> var1);

        public <InputT extends PValue> InputT getInput(PTransform<InputT, ?> var1);

        public <OutputT extends POutput> Map<TupleTag<?>, PValue> getOutputs(PTransform<?, OutputT> var1);

        public <OutputT extends PValue> OutputT getOutput(PTransform<?, OutputT> var1);

        public String getFullName(PTransform<?, ?> var1);

        public StepTranslationContext addStep(PTransform<?, ?> var1, String var2);

        public OutputReference asOutputReference(PValue var1, AppliedPTransform<?, ?, ?> var2);

        public SdkComponents getSdkComponents();

        public AppliedPTransform<?, ?, ?> getCurrentTransform();

        public AppliedPTransform<?, ?, ?> getProducer(PValue var1);

        public AppliedPTransform<?, ?, ?> getCurrentParent();
    }
}

