
package org.apache.beam.runners.dataflow.util;

import com.google.api.services.dataflow.model.DataflowPackage;
import java.io.File;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_PackageUtil_PackageAttributes extends PackageUtil.PackageAttributes {

  private final File source;
  private final DataflowPackage destination;
  private final long size;
  private final String hash;

  AutoValue_PackageUtil_PackageAttributes(
      File source,
      DataflowPackage destination,
      long size,
      String hash) {
    if (source == null) {
      throw new NullPointerException("Null source");
    }
    this.source = source;
    if (destination == null) {
      throw new NullPointerException("Null destination");
    }
    this.destination = destination;
    this.size = size;
    if (hash == null) {
      throw new NullPointerException("Null hash");
    }
    this.hash = hash;
  }

  @Override
  public File getSource() {
    return source;
  }

  @Override
  public DataflowPackage getDestination() {
    return destination;
  }

  @Override
  public long getSize() {
    return size;
  }

  @Override
  public String getHash() {
    return hash;
  }

  @Override
  public String toString() {
    return "PackageAttributes{"
        + "source=" + source + ", "
        + "destination=" + destination + ", "
        + "size=" + size + ", "
        + "hash=" + hash
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PackageUtil.PackageAttributes) {
      PackageUtil.PackageAttributes that = (PackageUtil.PackageAttributes) o;
      return (this.source.equals(that.getSource()))
           && (this.destination.equals(that.getDestination()))
           && (this.size == that.getSize())
           && (this.hash.equals(that.getHash()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.source.hashCode();
    h *= 1000003;
    h ^= this.destination.hashCode();
    h *= 1000003;
    h ^= (this.size >>> 32) ^ this.size;
    h *= 1000003;
    h ^= this.hash.hashCode();
    return h;
  }

}
