/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.google.api.client.util.ArrayMap;
import com.google.api.services.dataflow.model.JobMetrics;
import com.google.api.services.dataflow.model.MetricUpdate;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.runners.dataflow.AutoValue_DataflowMetrics_DataflowMetricQueryResults;
import org.apache.beam.runners.dataflow.AutoValue_DataflowMetrics_DataflowMetricResult;
import org.apache.beam.runners.dataflow.DataflowClient;
import org.apache.beam.runners.dataflow.DataflowPipelineJob;
import org.apache.beam.runners.dataflow.repackaged.com.google.common.base.MoreObjects;
import org.apache.beam.runners.dataflow.repackaged.com.google.common.base.Objects;
import org.apache.beam.runners.dataflow.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.metrics.MetricFiltering;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.metrics.MetricKey;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataflowMetrics
extends MetricResults {
    private static final Logger LOG = LoggerFactory.getLogger(DataflowMetrics.class);
    private DataflowClient dataflowClient;
    private DataflowPipelineJob dataflowPipelineJob;
    private MetricQueryResults cachedMetricResults = null;

    public DataflowMetrics(DataflowPipelineJob dataflowPipelineJob, DataflowClient dataflowClient) {
        this.dataflowClient = dataflowClient;
        this.dataflowPipelineJob = dataflowPipelineJob;
    }

    private MetricQueryResults populateMetricQueryResults(List<MetricUpdate> metricUpdates, MetricsFilter filter) {
        return DataflowMetricQueryResultsFactory.create(this.dataflowPipelineJob, metricUpdates, filter).build();
    }

    private MetricQueryResults queryServiceForMetrics(MetricsFilter filter) {
        JobMetrics jobMetrics;
        ImmutableList<MetricResult<Long>> counters = ImmutableList.of();
        ImmutableList<MetricResult<DistributionResult>> distributions = ImmutableList.of();
        ImmutableList<MetricResult<GaugeResult>> gauges = ImmutableList.of();
        try {
            jobMetrics = this.dataflowClient.getJobMetrics(this.dataflowPipelineJob.jobId);
        }
        catch (IOException e) {
            LOG.warn("Unable to query job metrics.\n");
            return DataflowMetricQueryResults.create(counters, distributions, gauges);
        }
        List<MetricUpdate> metricUpdates = MoreObjects.firstNonNull(jobMetrics.getMetrics(), Collections.emptyList());
        return this.populateMetricQueryResults(metricUpdates, filter);
    }

    public MetricQueryResults queryMetrics() {
        return this.queryMetrics(null);
    }

    public MetricQueryResults queryMetrics(MetricsFilter filter) {
        if (this.cachedMetricResults != null) {
            return this.cachedMetricResults;
        }
        MetricQueryResults result = this.queryServiceForMetrics(filter);
        if (this.dataflowPipelineJob.getState().isTerminal()) {
            this.cachedMetricResults = result;
        }
        return result;
    }

    static abstract class DataflowMetricResult<T>
    implements MetricResult<T> {
        DataflowMetricResult() {
        }

        public abstract MetricName name();

        public abstract String step();

        @Nullable
        public abstract T committed();

        @Nullable
        public abstract T attempted();

        public static <T> MetricResult<T> create(MetricName name, String scope, T committed, T attempted) {
            return new AutoValue_DataflowMetrics_DataflowMetricResult<T>(name, scope, committed, attempted);
        }
    }

    static abstract class DataflowMetricQueryResults
    implements MetricQueryResults {
        DataflowMetricQueryResults() {
        }

        public static MetricQueryResults create(Iterable<MetricResult<Long>> counters, Iterable<MetricResult<DistributionResult>> distributions, Iterable<MetricResult<GaugeResult>> gauges) {
            return new AutoValue_DataflowMetrics_DataflowMetricQueryResults(counters, distributions, gauges);
        }
    }

    private static class DataflowMetricQueryResultsFactory {
        private final Iterable<MetricUpdate> metricUpdates;
        private final MetricsFilter filter;
        private final HashMap<MetricKey, MetricUpdate> tentativeByName;
        private final HashMap<MetricKey, MetricUpdate> committedByName;
        private final HashSet<MetricKey> metricHashKeys;
        private final DataflowPipelineJob dataflowPipelineJob;

        public static DataflowMetricQueryResultsFactory create(DataflowPipelineJob dataflowPipelineJob, Iterable<MetricUpdate> metricUpdates, MetricsFilter filter) {
            return new DataflowMetricQueryResultsFactory(dataflowPipelineJob, metricUpdates, filter);
        }

        private DataflowMetricQueryResultsFactory(DataflowPipelineJob dataflowPipelineJob, Iterable<MetricUpdate> metricUpdates, MetricsFilter filter) {
            this.dataflowPipelineJob = dataflowPipelineJob;
            this.metricUpdates = metricUpdates;
            this.filter = filter;
            this.tentativeByName = new HashMap();
            this.committedByName = new HashMap();
            this.metricHashKeys = new HashSet();
        }

        private boolean isMetricTentative(MetricUpdate metricUpdate) {
            return metricUpdate.getName().getContext().containsKey("tentative") && Objects.equal(metricUpdate.getName().getContext().get("tentative"), "true");
        }

        private MetricKey getMetricHashKey(MetricUpdate metricUpdate) {
            String fullStepName = (String)metricUpdate.getName().getContext().get("step");
            if (this.dataflowPipelineJob.transformStepNames == null || !this.dataflowPipelineJob.transformStepNames.inverse().containsKey(fullStepName)) {
                return null;
            }
            fullStepName = ((AppliedPTransform)this.dataflowPipelineJob.transformStepNames.inverse().get(fullStepName)).getFullName();
            return MetricKey.create(fullStepName, MetricName.named((String)((String)metricUpdate.getName().getContext().get("namespace")), (String)metricUpdate.getName().getName()));
        }

        private void buildMetricsIndex() {
            for (MetricUpdate update : this.metricUpdates) {
                MetricUpdate previousUpdate;
                MetricKey updateKey;
                if (update.getName().getOrigin() != null && (!update.getName().getOrigin().toLowerCase().equals("user") || !update.getName().getContext().containsKey("namespace")) || (updateKey = this.getMetricHashKey(update)) == null || !MetricFiltering.matches(this.filter, updateKey)) continue;
                this.metricHashKeys.add(updateKey);
                if (this.isMetricTentative(update)) {
                    previousUpdate = this.tentativeByName.put(updateKey, update);
                    if (previousUpdate == null) continue;
                    LOG.warn("Metric {} already had a tentative value of {}", (Object)updateKey, (Object)previousUpdate);
                    continue;
                }
                previousUpdate = this.committedByName.put(updateKey, update);
                if (previousUpdate == null) continue;
                LOG.warn("Metric {} already had a committed value of {}", (Object)updateKey, (Object)previousUpdate);
            }
        }

        public MetricQueryResults build() {
            this.buildMetricsIndex();
            DataflowMetricResultExtractor extractor = new DataflowMetricResultExtractor(this.dataflowPipelineJob.getDataflowOptions().isStreaming());
            for (MetricKey metricKey : this.metricHashKeys) {
                String metricName = metricKey.metricName().name();
                if (metricName.endsWith("[MIN]") || metricName.endsWith("[MAX]") || metricName.endsWith("[MEAN]") || metricName.endsWith("[COUNT]")) continue;
                extractor.addMetricResult(metricKey, this.committedByName.get(metricKey), this.tentativeByName.get(metricKey));
            }
            return DataflowMetricQueryResults.create(extractor.getCounterResults(), extractor.getDistributionResults(), extractor.getGaugeResults());
        }
    }

    private static class DataflowMetricResultExtractor {
        private final ImmutableList.Builder<MetricResult<Long>> counterResults = ImmutableList.builder();
        private final ImmutableList.Builder<MetricResult<DistributionResult>> distributionResults = ImmutableList.builder();
        private final ImmutableList.Builder<MetricResult<GaugeResult>> gaugeResults = ImmutableList.builder();
        private final boolean isStreamingJob;

        DataflowMetricResultExtractor(boolean isStreamingJob) {
            this.isStreamingJob = isStreamingJob;
        }

        public void addMetricResult(MetricKey metricKey, @Nullable MetricUpdate committed, @Nullable MetricUpdate attempted) {
            if (committed == null || attempted == null) {
                LOG.warn("Metric {} did not have both a committed ({}) and tentative value ({}).", new Object[]{metricKey, committed, attempted});
            } else if (committed.getDistribution() != null && attempted.getDistribution() != null) {
                DistributionResult value = this.getDistributionValue(committed);
                this.distributionResults.add((Object)DataflowMetricResult.create(metricKey.metricName(), metricKey.stepName(), this.isStreamingJob ? null : value, this.isStreamingJob ? value : null));
            } else if (committed.getScalar() != null && attempted.getScalar() != null) {
                Long value = this.getCounterValue(committed);
                this.counterResults.add((Object)DataflowMetricResult.create(metricKey.metricName(), metricKey.stepName(), this.isStreamingJob ? null : value, this.isStreamingJob ? value : null));
            } else {
                LOG.warn("Unexpected / mismatched metric types. Please report JOB ID to Dataflow Support. Metric key: {}. Committed / attempted Metric updates: {} / {}", new Object[]{metricKey.toString(), committed.toString(), attempted.toString()});
            }
        }

        private Long getCounterValue(MetricUpdate metricUpdate) {
            if (metricUpdate.getScalar() == null) {
                return 0L;
            }
            return ((Number)metricUpdate.getScalar()).longValue();
        }

        private DistributionResult getDistributionValue(MetricUpdate metricUpdate) {
            if (metricUpdate.getDistribution() == null) {
                return DistributionResult.ZERO;
            }
            ArrayMap distributionMap = (ArrayMap)metricUpdate.getDistribution();
            Long count = ((Number)distributionMap.get((Object)"count")).longValue();
            Long min = ((Number)distributionMap.get((Object)"min")).longValue();
            Long max = ((Number)distributionMap.get((Object)"max")).longValue();
            Long sum = ((Number)distributionMap.get((Object)"sum")).longValue();
            return DistributionResult.create((long)sum, (long)count, (long)min, (long)max);
        }

        public Iterable<MetricResult<DistributionResult>> getDistributionResults() {
            return this.distributionResults.build();
        }

        public Iterable<MetricResult<Long>> getCounterResults() {
            return this.counterResults.build();
        }

        public Iterable<MetricResult<GaugeResult>> getGaugeResults() {
            return this.gaugeResults.build();
        }
    }
}

