/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction;

import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;

public abstract class ForwardingPTransform<InputT extends PInput, OutputT extends POutput>
extends PTransform<InputT, OutputT> {
    protected abstract PTransform<InputT, OutputT> delegate();

    public OutputT expand(InputT input) {
        POutput res = this.delegate().expand(input);
        if (res instanceof PCollection) {
            PCollection pc = (PCollection)res;
            try {
                pc.setCoder(this.delegate().getDefaultOutputCoder(input, pc));
            }
            catch (CannotProvideCoderException cannotProvideCoderException) {
                // empty catch block
            }
        }
        return (OutputT)res;
    }

    public void validate(PipelineOptions options) {
        this.delegate().validate(options);
    }

    public String getName() {
        return this.delegate().getName();
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        builder.delegate(this.delegate());
    }
}

