/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction;

import com.google.auto.service.AutoService;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.AutoValue_ParDoTranslation_DoFnAndMainOutput;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.CombineTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.RunnerPCollectionView;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.base.Optional;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.collect.Sets;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.WindowingStrategy;

public class ParDoTranslation {
    public static final String CUSTOM_JAVA_DO_FN_URN = "urn:beam:dofn:javasdk:0.1";
    public static final String CUSTOM_JAVA_VIEW_FN_URN = "urn:beam:viewfn:javasdk:0.1";
    public static final String CUSTOM_JAVA_WINDOW_MAPPING_FN_URN = "urn:beam:windowmappingfn:javasdk:0.1";

    public static RunnerApi.ParDoPayload toProto(ParDo.MultiOutput<?, ?> parDo, SdkComponents components) throws IOException {
        RunnerApi.StateSpec spec;
        DoFn doFn = parDo.getFn();
        DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
        Map states = signature.stateDeclarations();
        Map timers = signature.timerDeclarations();
        List parameters = signature.processElement().extraParameters();
        RunnerApi.ParDoPayload.Builder builder = RunnerApi.ParDoPayload.newBuilder();
        builder.setDoFn(ParDoTranslation.toProto(parDo.getFn(), parDo.getMainOutputTag()));
        builder.setSplittable(signature.processElement().isSplittable());
        for (PCollectionView pCollectionView : parDo.getSideInputs()) {
            builder.putSideInputs(pCollectionView.getTagInternal().getId(), ParDoTranslation.toProto(pCollectionView));
        }
        for (DoFnSignature.Parameter parameter : parameters) {
            Optional<RunnerApi.Parameter> protoParameter = ParDoTranslation.toProto(parameter);
            if (!protoParameter.isPresent()) continue;
            builder.addParameters(protoParameter.get());
        }
        for (Map.Entry entry : states.entrySet()) {
            spec = ParDoTranslation.toProto(ParDoTranslation.getStateSpecOrCrash((DoFnSignature.StateDeclaration)entry.getValue(), doFn), components);
            builder.putStateSpecs((String)entry.getKey(), spec);
        }
        for (Map.Entry entry : timers.entrySet()) {
            spec = ParDoTranslation.toProto(ParDoTranslation.getTimerSpecOrCrash((DoFnSignature.TimerDeclaration)entry.getValue(), doFn));
            builder.putTimerSpecs((String)entry.getKey(), (RunnerApi.TimerSpec)spec);
        }
        return builder.build();
    }

    private static StateSpec<?> getStateSpecOrCrash(DoFnSignature.StateDeclaration stateDeclaration, DoFn<?, ?> target) {
        try {
            Object fieldValue = stateDeclaration.field().get(target);
            Preconditions.checkState(fieldValue instanceof StateSpec, "Malformed %s class %s: state declaration field %s does not have type %s.", (Object)DoFn.class.getSimpleName(), (Object)target.getClass().getName(), (Object)stateDeclaration.field().getName(), StateSpec.class);
            return (StateSpec)stateDeclaration.field().get(target);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException(String.format("Malformed %s class %s: state declaration field %s is not accessible.", DoFn.class.getSimpleName(), target.getClass().getName(), stateDeclaration.field().getName()));
        }
    }

    private static TimerSpec getTimerSpecOrCrash(DoFnSignature.TimerDeclaration timerDeclaration, DoFn<?, ?> target) {
        try {
            Object fieldValue = timerDeclaration.field().get(target);
            Preconditions.checkState(fieldValue instanceof TimerSpec, "Malformed %s class %s: timer declaration field %s does not have type %s.", (Object)DoFn.class.getSimpleName(), (Object)target.getClass().getName(), (Object)timerDeclaration.field().getName(), TimerSpec.class);
            return (TimerSpec)timerDeclaration.field().get(target);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException(String.format("Malformed %s class %s: timer declaration field %s is not accessible.", DoFn.class.getSimpleName(), target.getClass().getName(), timerDeclaration.field().getName()));
        }
    }

    public static DoFn<?, ?> getDoFn(RunnerApi.ParDoPayload payload) throws InvalidProtocolBufferException {
        return ParDoTranslation.doFnAndMainOutputTagFromProto(payload.getDoFn()).getDoFn();
    }

    public static DoFn<?, ?> getDoFn(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getFn();
        }
        return ParDoTranslation.getDoFn(ParDoTranslation.getParDoPayload(application));
    }

    public static TupleTag<?> getMainOutputTag(RunnerApi.ParDoPayload payload) throws InvalidProtocolBufferException {
        return ParDoTranslation.doFnAndMainOutputTagFromProto(payload.getDoFn()).getMainOutputTag();
    }

    public static TupleTag<?> getMainOutputTag(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getMainOutputTag();
        }
        return ParDoTranslation.getMainOutputTag(ParDoTranslation.getParDoPayload(application));
    }

    public static TupleTagList getAdditionalOutputTags(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getAdditionalOutputTags();
        }
        RunnerApi.PTransform protoTransform = PTransformTranslation.toProto(application, SdkComponents.create());
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)protoTransform.getSpec().getPayload());
        TupleTag<?> mainOutputTag = ParDoTranslation.getMainOutputTag(payload);
        Sets.SetView<String> outputTags = Sets.difference(protoTransform.getOutputsMap().keySet(), Collections.singleton(mainOutputTag.getId()));
        ArrayList<TupleTag> additionalOutputTags = new ArrayList<TupleTag>();
        for (String outputTag : outputTags) {
            additionalOutputTags.add(new TupleTag(outputTag));
        }
        return TupleTagList.of(additionalOutputTags);
    }

    public static List<PCollectionView<?>> getSideInputs(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getSideInputs();
        }
        SdkComponents sdkComponents = SdkComponents.create();
        RunnerApi.PTransform parDoProto = PTransformTranslation.toProto(application, sdkComponents);
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)parDoProto.getSpec().getPayload());
        ArrayList views = new ArrayList();
        RehydratedComponents components = RehydratedComponents.forComponents(sdkComponents.toComponents());
        for (Map.Entry sideInputEntry : payload.getSideInputsMap().entrySet()) {
            String sideInputTag = (String)sideInputEntry.getKey();
            RunnerApi.SideInput sideInput = (RunnerApi.SideInput)sideInputEntry.getValue();
            PCollection originalPCollection = Preconditions.checkNotNull((PCollection)application.getInputs().get(new TupleTag(sideInputTag)), "no input with tag %s", (Object)sideInputTag);
            views.add(ParDoTranslation.viewFromProto(sideInput, sideInputTag, originalPCollection, parDoProto, components));
        }
        return views;
    }

    public static RunnerApi.PCollection getMainInput(RunnerApi.PTransform ptransform, RunnerApi.Components components) throws IOException {
        Preconditions.checkArgument(ptransform.getSpec().getUrn().equals("urn:beam:transform:pardo:v1"), "Unexpected payload type %s", (Object)ptransform.getSpec().getUrn());
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)ptransform.getSpec().getPayload());
        String mainInputId = (String)Iterables.getOnlyElement(Sets.difference(ptransform.getInputsMap().keySet(), payload.getSideInputsMap().keySet()));
        return components.getPcollectionsOrThrow(ptransform.getInputsOrThrow(mainInputId));
    }

    @VisibleForTesting
    static RunnerApi.StateSpec toProto(StateSpec<?> stateSpec, final SdkComponents components) throws IOException {
        final RunnerApi.StateSpec.Builder builder = RunnerApi.StateSpec.newBuilder();
        return (RunnerApi.StateSpec)stateSpec.match((StateSpec.Cases)new StateSpec.Cases<RunnerApi.StateSpec>(){

            public RunnerApi.StateSpec dispatchValue(Coder<?> valueCoder) {
                return builder.setValueSpec(RunnerApi.ValueStateSpec.newBuilder().setCoderId(ParDoTranslation.registerCoderOrThrow(components, valueCoder))).build();
            }

            public RunnerApi.StateSpec dispatchBag(Coder<?> elementCoder) {
                return builder.setBagSpec(RunnerApi.BagStateSpec.newBuilder().setElementCoderId(ParDoTranslation.registerCoderOrThrow(components, elementCoder))).build();
            }

            public RunnerApi.StateSpec dispatchCombining(Combine.CombineFn<?, ?, ?> combineFn, Coder<?> accumCoder) {
                return builder.setCombiningSpec(RunnerApi.CombiningStateSpec.newBuilder().setAccumulatorCoderId(ParDoTranslation.registerCoderOrThrow(components, accumCoder)).setCombineFn(CombineTranslation.toProto(combineFn))).build();
            }

            public RunnerApi.StateSpec dispatchMap(Coder<?> keyCoder, Coder<?> valueCoder) {
                return builder.setMapSpec(RunnerApi.MapStateSpec.newBuilder().setKeyCoderId(ParDoTranslation.registerCoderOrThrow(components, keyCoder)).setValueCoderId(ParDoTranslation.registerCoderOrThrow(components, valueCoder))).build();
            }

            public RunnerApi.StateSpec dispatchSet(Coder<?> elementCoder) {
                return builder.setSetSpec(RunnerApi.SetStateSpec.newBuilder().setElementCoderId(ParDoTranslation.registerCoderOrThrow(components, elementCoder))).build();
            }
        });
    }

    @VisibleForTesting
    static StateSpec<?> fromProto(RunnerApi.StateSpec stateSpec, RehydratedComponents components) throws IOException {
        switch (stateSpec.getSpecCase()) {
            case VALUE_SPEC: {
                return StateSpecs.value(components.getCoder(stateSpec.getValueSpec().getCoderId()));
            }
            case BAG_SPEC: {
                return StateSpecs.bag(components.getCoder(stateSpec.getBagSpec().getElementCoderId()));
            }
            case COMBINING_SPEC: {
                RunnerApi.FunctionSpec combineFnSpec = stateSpec.getCombiningSpec().getCombineFn().getSpec();
                if (!combineFnSpec.getUrn().equals("urn:beam:combinefn:javasdk:v1")) {
                    throw new UnsupportedOperationException(String.format("Cannot create %s from non-Java %s: %s", StateSpec.class.getSimpleName(), Combine.CombineFn.class.getSimpleName(), combineFnSpec.getUrn()));
                }
                Combine.CombineFn combineFn = (Combine.CombineFn)SerializableUtils.deserializeFromByteArray((byte[])combineFnSpec.getPayload().toByteArray(), (String)Combine.CombineFn.class.getSimpleName());
                return StateSpecs.combining(components.getCoder(stateSpec.getCombiningSpec().getAccumulatorCoderId()), (Combine.CombineFn)combineFn);
            }
            case MAP_SPEC: {
                return StateSpecs.map(components.getCoder(stateSpec.getMapSpec().getKeyCoderId()), components.getCoder(stateSpec.getMapSpec().getValueCoderId()));
            }
            case SET_SPEC: {
                return StateSpecs.set(components.getCoder(stateSpec.getSetSpec().getElementCoderId()));
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s: %s", RunnerApi.StateSpec.class.getName(), stateSpec));
    }

    private static String registerCoderOrThrow(SdkComponents components, Coder coder) {
        try {
            return components.registerCoder(coder);
        }
        catch (IOException exc) {
            throw new RuntimeException("Failure to register coder", exc);
        }
    }

    private static RunnerApi.TimerSpec toProto(TimerSpec timer) {
        return RunnerApi.TimerSpec.newBuilder().setTimeDomain(ParDoTranslation.toProto(timer.getTimeDomain())).build();
    }

    private static RunnerApi.TimeDomain.Enum toProto(TimeDomain timeDomain) {
        switch (timeDomain) {
            case EVENT_TIME: {
                return RunnerApi.TimeDomain.Enum.EVENT_TIME;
            }
            case PROCESSING_TIME: {
                return RunnerApi.TimeDomain.Enum.PROCESSING_TIME;
            }
            case SYNCHRONIZED_PROCESSING_TIME: {
                return RunnerApi.TimeDomain.Enum.SYNCHRONIZED_PROCESSING_TIME;
            }
        }
        throw new IllegalArgumentException("Unknown time domain");
    }

    private static RunnerApi.SdkFunctionSpec toProto(DoFn<?, ?> fn, TupleTag<?> tag) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_DO_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray((Serializable)DoFnAndMainOutput.of(fn, tag)))).build()).build();
    }

    private static DoFnAndMainOutput doFnAndMainOutputTagFromProto(RunnerApi.SdkFunctionSpec fnSpec) throws InvalidProtocolBufferException {
        Preconditions.checkArgument(fnSpec.getSpec().getUrn().equals(CUSTOM_JAVA_DO_FN_URN), "Expected %s to be %s with URN %s, but URN was %s", (Object)DoFn.class.getSimpleName(), (Object)RunnerApi.FunctionSpec.class.getSimpleName(), (Object)CUSTOM_JAVA_DO_FN_URN, (Object)fnSpec.getSpec().getUrn());
        byte[] serializedFn = fnSpec.getSpec().getPayload().toByteArray();
        return (DoFnAndMainOutput)SerializableUtils.deserializeFromByteArray((byte[])serializedFn, (String)"Custom DoFn And Main Output tag");
    }

    private static Optional<RunnerApi.Parameter> toProto(DoFnSignature.Parameter parameter) {
        return (Optional)parameter.match((DoFnSignature.Parameter.Cases)new DoFnSignature.Parameter.Cases.WithDefault<Optional<RunnerApi.Parameter>>(){

            public Optional<RunnerApi.Parameter> dispatch(DoFnSignature.Parameter.WindowParameter p) {
                return Optional.of(RunnerApi.Parameter.newBuilder().setType(RunnerApi.Parameter.Type.Enum.WINDOW).build());
            }

            public Optional<RunnerApi.Parameter> dispatch(DoFnSignature.Parameter.RestrictionTrackerParameter p) {
                return Optional.of(RunnerApi.Parameter.newBuilder().setType(RunnerApi.Parameter.Type.Enum.RESTRICTION_TRACKER).build());
            }

            protected Optional<RunnerApi.Parameter> dispatchDefault(DoFnSignature.Parameter p) {
                return Optional.absent();
            }
        });
    }

    public static RunnerApi.SideInput toProto(PCollectionView<?> view) {
        RunnerApi.SideInput.Builder builder = RunnerApi.SideInput.newBuilder();
        builder.setAccessPattern(RunnerApi.FunctionSpec.newBuilder().setUrn(view.getViewFn().getMaterialization().getUrn()).build());
        builder.setViewFn(ParDoTranslation.toProto(view.getViewFn()));
        builder.setWindowMappingFn(ParDoTranslation.toProto(view.getWindowMappingFn()));
        return builder.build();
    }

    public static PCollectionView<?> viewFromProto(RunnerApi.SideInput sideInput, String localName, PCollection<?> pCollection, RunnerApi.PTransform parDoTransform, RehydratedComponents components) throws IOException {
        Preconditions.checkArgument(localName != null, "%s.viewFromProto: localName must not be null", (Object)ParDoTranslation.class.getSimpleName());
        TupleTag tag = new TupleTag(localName);
        WindowMappingFn<?> windowMappingFn = ParDoTranslation.windowMappingFnFromProto(sideInput.getWindowMappingFn());
        ViewFn<?, ?> viewFn = ParDoTranslation.viewFnFromProto(sideInput.getViewFn());
        WindowingStrategy windowingStrategy = pCollection.getWindowingStrategy().fixDefaults();
        IterableCoder coder = IterableCoder.of((Coder)WindowedValue.FullWindowedValueCoder.of((Coder)pCollection.getCoder(), (Coder)pCollection.getWindowingStrategy().getWindowFn().windowCoder()));
        Preconditions.checkArgument(sideInput.getAccessPattern().getUrn().equals("urn:beam:sideinput:materialization:iterable:0.1"), "Unknown View Materialization URN %s", (Object)sideInput.getAccessPattern().getUrn());
        RunnerPCollectionView view = new RunnerPCollectionView(pCollection, (TupleTag<Iterable<WindowedValue<?>>>)tag, (ViewFn<Iterable<WindowedValue<?>>, ?>)viewFn, windowMappingFn, (WindowingStrategy<?, ?>)windowingStrategy, (Coder<Iterable<WindowedValue<?>>>)coder);
        return view;
    }

    private static RunnerApi.SdkFunctionSpec toProto(ViewFn<?, ?> viewFn) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_VIEW_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(viewFn))).build()).build();
    }

    private static <T> RunnerApi.ParDoPayload getParDoPayload(AppliedPTransform<?, ?, ?> transform) throws IOException {
        RunnerApi.PTransform parDoPTransform = PTransformTranslation.toProto(transform, Collections.emptyList(), SdkComponents.create());
        return RunnerApi.ParDoPayload.parseFrom((ByteString)parDoPTransform.getSpec().getPayload());
    }

    public static boolean usesStateOrTimers(AppliedPTransform<?, ?, ?> transform) throws IOException {
        RunnerApi.ParDoPayload payload = ParDoTranslation.getParDoPayload(transform);
        return payload.getStateSpecsCount() > 0 || payload.getTimerSpecsCount() > 0;
    }

    public static boolean isSplittable(AppliedPTransform<?, ?, ?> transform) throws IOException {
        RunnerApi.ParDoPayload payload = ParDoTranslation.getParDoPayload(transform);
        return payload.getSplittable();
    }

    private static ViewFn<?, ?> viewFnFromProto(RunnerApi.SdkFunctionSpec viewFn) throws InvalidProtocolBufferException {
        RunnerApi.FunctionSpec spec = viewFn.getSpec();
        Preconditions.checkArgument(spec.getUrn().equals(CUSTOM_JAVA_VIEW_FN_URN), "Can't deserialize unknown %s type %s", (Object)ViewFn.class.getSimpleName(), (Object)spec.getUrn());
        return (ViewFn)SerializableUtils.deserializeFromByteArray((byte[])spec.getPayload().toByteArray(), (String)"Custom ViewFn");
    }

    private static RunnerApi.SdkFunctionSpec toProto(WindowMappingFn<?> windowMappingFn) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_WINDOW_MAPPING_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(windowMappingFn))).build()).build();
    }

    private static WindowMappingFn<?> windowMappingFnFromProto(RunnerApi.SdkFunctionSpec windowMappingFn) throws InvalidProtocolBufferException {
        RunnerApi.FunctionSpec spec = windowMappingFn.getSpec();
        Preconditions.checkArgument(spec.getUrn().equals(CUSTOM_JAVA_WINDOW_MAPPING_FN_URN), "Can't deserialize unknown %s type %s", (Object)WindowMappingFn.class.getSimpleName(), (Object)spec.getUrn());
        return (WindowMappingFn)SerializableUtils.deserializeFromByteArray((byte[])spec.getPayload().toByteArray(), (String)"Custom WinodwMappingFn");
    }

    static abstract class DoFnAndMainOutput
    implements Serializable {
        DoFnAndMainOutput() {
        }

        public static DoFnAndMainOutput of(DoFn<?, ?> fn, TupleTag<?> tag) {
            return new AutoValue_ParDoTranslation_DoFnAndMainOutput(fn, tag);
        }

        abstract DoFn<?, ?> getDoFn();

        abstract TupleTag<?> getMainOutputTag();
    }

    public static class ParDoPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<ParDo.MultiOutput<?, ?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new ParDoPayloadTranslator();
        }

        private ParDoPayloadTranslator() {
        }

        @Override
        public String getUrn(ParDo.MultiOutput<?, ?> transform) {
            return "urn:beam:transform:pardo:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, ParDo.MultiOutput<?, ?>> transform, SdkComponents components) throws IOException {
            RunnerApi.ParDoPayload payload = ParDoTranslation.toProto((ParDo.MultiOutput)transform.getTransform(), components);
            return RunnerApi.FunctionSpec.newBuilder().setUrn("urn:beam:transform:pardo:v1").setPayload(payload.toByteString()).build();
        }

        @AutoService(value=TransformPayloadTranslatorRegistrar.class)
        public static class Registrar
        implements TransformPayloadTranslatorRegistrar {
            @Override
            public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
                return Collections.singletonMap(ParDo.MultiOutput.class, new ParDoPayloadTranslator());
            }
        }
    }
}

