/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.AutoValue_PipelineTranslation_RehydratedPTransform;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.base.MoreObjects;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.collect.ListMultimap;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionViews;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;

public class PipelineTranslation {
    public static RunnerApi.Pipeline toProto(final Pipeline pipeline) {
        final SdkComponents components = SdkComponents.create();
        final HashSet rootIds = new HashSet();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){
            private final ListMultimap<TransformHierarchy.Node, AppliedPTransform<?, ?, ?>> children = ArrayListMultimap.create();

            public void leaveCompositeTransform(TransformHierarchy.Node node) {
                if (node.isRootNode()) {
                    for (AppliedPTransform<?, ?, ?> pipelineRoot : this.children.get(node)) {
                        rootIds.add(components.getExistingPTransformId(pipelineRoot));
                    }
                } else {
                    this.children.put(node.getEnclosingNode(), node.toAppliedPTransform(pipeline));
                    try {
                        components.registerPTransform(node.toAppliedPTransform(pipeline), this.children.get(node));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                this.children.put(node.getEnclosingNode(), node.toAppliedPTransform(pipeline));
                try {
                    components.registerPTransform(node.toAppliedPTransform(pipeline), Collections.emptyList());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        return RunnerApi.Pipeline.newBuilder().setComponents(components.toComponents()).addAllRootTransformIds(rootIds).build();
    }

    private static DisplayData evaluateDisplayData(HasDisplayData component) {
        return DisplayData.from((HasDisplayData)component);
    }

    public static Pipeline fromProto(RunnerApi.Pipeline pipelineProto) throws IOException {
        TransformHierarchy transforms = new TransformHierarchy();
        Pipeline pipeline = Pipeline.forTransformHierarchy((TransformHierarchy)transforms, (PipelineOptions)PipelineOptionsFactory.create());
        RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents(pipelineProto.getComponents()).withPipeline(pipeline);
        for (String rootId : pipelineProto.getRootTransformIdsList()) {
            PipelineTranslation.addRehydratedTransform(transforms, pipelineProto.getComponents().getTransformsOrThrow(rootId), pipeline, pipelineProto.getComponents().getTransformsMap(), rehydratedComponents);
        }
        return pipeline;
    }

    /*
     * WARNING - void declaration
     */
    private static void addRehydratedTransform(TransformHierarchy transforms, RunnerApi.PTransform transformProto, Pipeline pipeline, Map<String, RunnerApi.PTransform> transformProtos, RehydratedComponents rehydratedComponents) throws IOException {
        void var8_15;
        RunnerApi.ParDoPayload payload;
        HashMap rehydratedInputs = new HashMap();
        for (Map.Entry entry : transformProto.getInputsMap().entrySet()) {
            rehydratedInputs.put((TupleTag<?>)new TupleTag((String)entry.getKey()), (PValue)rehydratedComponents.getPCollection((String)entry.getValue()));
        }
        HashMap rehydratedOutputs = new HashMap();
        for (Map.Entry entry : transformProto.getOutputsMap().entrySet()) {
            rehydratedOutputs.put(new TupleTag((String)entry.getKey()), rehydratedComponents.getPCollection((String)entry.getValue()));
        }
        RunnerApi.FunctionSpec functionSpec = transformProto.getSpec();
        Map map = Collections.emptyMap();
        if (functionSpec.getUrn().equals("urn:beam:transform:pardo:v1")) {
            payload = RunnerApi.ParDoPayload.parseFrom((ByteString)functionSpec.getPayload());
            Map<TupleTag<?>, PValue> map2 = PipelineTranslation.sideInputMapToAdditionalInputs(transformProto, rehydratedComponents, rehydratedInputs, payload.getSideInputsMap());
        }
        if (functionSpec.getUrn().equals("urn:beam:transform:write_files:0.1")) {
            payload = RunnerApi.WriteFilesPayload.parseFrom((ByteString)functionSpec.getPayload());
            Map<TupleTag<?>, PValue> map3 = PipelineTranslation.sideInputMapToAdditionalInputs(transformProto, rehydratedComponents, rehydratedInputs, payload.getSideInputsMap());
        }
        List<Coder<?>> additionalCoders = Collections.emptyList();
        if (functionSpec.getUrn().equals("urn:beam:transform:combine:v1")) {
            RunnerApi.CombinePayload payload2 = RunnerApi.CombinePayload.parseFrom((ByteString)functionSpec.getPayload());
            additionalCoders = Collections.singletonList(rehydratedComponents.getCoder(payload2.getAccumulatorCoderId()));
        }
        RehydratedPTransform transform = RehydratedPTransform.of(functionSpec.getUrn(), functionSpec.getPayload(), var8_15, additionalCoders);
        if (PipelineTranslation.isPrimitive(transformProto)) {
            transforms.addFinalizedPrimitiveNode(transformProto.getUniqueName(), rehydratedInputs, (PTransform)transform, rehydratedOutputs);
        } else {
            transforms.pushFinalizedNode(transformProto.getUniqueName(), rehydratedInputs, (PTransform)transform, rehydratedOutputs);
            for (String childTransformId : transformProto.getSubtransformsList()) {
                PipelineTranslation.addRehydratedTransform(transforms, transformProtos.get(childTransformId), pipeline, transformProtos, rehydratedComponents);
            }
            transforms.popNode();
        }
    }

    private static Map<TupleTag<?>, PValue> sideInputMapToAdditionalInputs(RunnerApi.PTransform transformProto, RehydratedComponents rehydratedComponents, Map<TupleTag<?>, PValue> rehydratedInputs, Map<String, RunnerApi.SideInput> sideInputsMap) throws IOException {
        ArrayList views = new ArrayList();
        for (Map.Entry<String, RunnerApi.SideInput> sideInputEntry : sideInputsMap.entrySet()) {
            String localName = sideInputEntry.getKey();
            RunnerApi.SideInput sideInput = sideInputEntry.getValue();
            PCollection pCollection = (PCollection)Preconditions.checkNotNull(rehydratedInputs.get(new TupleTag(localName)));
            views.add(ParDoTranslation.viewFromProto(sideInput, localName, pCollection, transformProto, rehydratedComponents));
        }
        return PCollectionViews.toAdditionalInputs(views);
    }

    private static boolean isPrimitive(RunnerApi.PTransform transformProto) {
        return transformProto.getSubtransformsCount() == 0 && !transformProto.getInputsMap().values().containsAll(transformProto.getOutputsMap().values());
    }

    static abstract class RehydratedPTransform
    extends PTransformTranslation.RawPTransform<PInput, POutput> {
        RehydratedPTransform() {
        }

        @Override
        @Nullable
        public abstract String getUrn();

        @Override
        @Nullable
        public abstract ByteString getPayload();

        public abstract Map<TupleTag<?>, PValue> getAdditionalInputs();

        public abstract List<Coder<?>> getCoders();

        public static RehydratedPTransform of(String urn, ByteString payload, Map<TupleTag<?>, PValue> additionalInputs, List<Coder<?>> additionalCoders) {
            return new AutoValue_PipelineTranslation_RehydratedPTransform(urn, payload, additionalInputs, additionalCoders);
        }

        public POutput expand(PInput input) {
            throw new IllegalStateException(String.format("%s should never be asked to expand; it is the result of deserializing an already-constructed Pipeline", ((Object)((Object)this)).getClass().getSimpleName()));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("urn", this.getUrn()).add("payload", this.getPayload()).toString();
        }

        @Override
        public void registerComponents(SdkComponents components) {
            for (Coder<?> coder : this.getCoders()) {
                try {
                    components.registerCoder(coder);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

