/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.CoderTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.PCollectionTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.cache.CacheBuilder;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.cache.CacheLoader;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.cache.LoadingCache;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;

public class RehydratedComponents {
    private final RunnerApi.Components components;
    @Nullable
    private final Pipeline pipeline;
    private final LoadingCache<String, WindowingStrategy<?, ?>> windowingStrategies = CacheBuilder.newBuilder().build(new CacheLoader<String, WindowingStrategy<?, ?>>(){

        @Override
        public WindowingStrategy<?, ?> load(String id) throws Exception {
            return WindowingStrategyTranslation.fromProto(RehydratedComponents.this.components.getWindowingStrategiesOrThrow(id), RehydratedComponents.this);
        }
    });
    private final LoadingCache<String, Coder<?>> coders = CacheBuilder.newBuilder().build(new CacheLoader<String, Coder<?>>(){

        @Override
        public Coder<?> load(String id) throws Exception {
            return CoderTranslation.fromProto(RehydratedComponents.this.components.getCodersOrThrow(id), RehydratedComponents.this);
        }
    });
    private final LoadingCache<String, PCollection<?>> pCollections = CacheBuilder.newBuilder().build(new CacheLoader<String, PCollection<?>>(){

        @Override
        public PCollection<?> load(String id) throws Exception {
            Preconditions.checkState(RehydratedComponents.this.pipeline != null, "%s Cannot rehydrate %s without a %s: provide one via .withPipeline(...)", (Object)RehydratedComponents.class.getSimpleName(), (Object)PCollection.class.getSimpleName(), (Object)Pipeline.class.getSimpleName());
            return PCollectionTranslation.fromProto(RehydratedComponents.this.components.getPcollectionsOrThrow(id), RehydratedComponents.this.pipeline, RehydratedComponents.this).setName(id);
        }
    });

    public static RehydratedComponents forComponents(RunnerApi.Components components) {
        return new RehydratedComponents(components, null);
    }

    public RehydratedComponents withPipeline(Pipeline pipeline) {
        return new RehydratedComponents(this.components, pipeline);
    }

    private RehydratedComponents(RunnerApi.Components components, @Nullable Pipeline pipeline) {
        this.components = components;
        this.pipeline = pipeline;
    }

    public PCollection<?> getPCollection(String pCollectionId) throws IOException {
        try {
            return this.pCollections.get(pCollectionId);
        }
        catch (ExecutionException exc) {
            throw new RuntimeException(exc);
        }
    }

    public WindowingStrategy<?, ?> getWindowingStrategy(String windowingStrategyId) throws IOException {
        try {
            return this.windowingStrategies.get(windowingStrategyId);
        }
        catch (ExecutionException exc) {
            throw new RuntimeException(exc);
        }
    }

    public Coder<?> getCoder(String coderId) throws IOException {
        try {
            return this.coders.get(coderId);
        }
        catch (ExecutionException exc) {
            throw new RuntimeException(exc);
        }
    }
}

