/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.PValueBase;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;

class RunnerPCollectionView<T>
extends PValueBase
implements PCollectionView<T> {
    private final TupleTag<Iterable<WindowedValue<?>>> tag;
    private final ViewFn<Iterable<WindowedValue<?>>, T> viewFn;
    private final WindowMappingFn<?> windowMappingFn;
    private final WindowingStrategy<?, ?> windowingStrategy;
    private final Coder<Iterable<WindowedValue<?>>> coder;
    private final transient PCollection<?> pCollection;

    RunnerPCollectionView(PCollection<?> pCollection, TupleTag<Iterable<WindowedValue<?>>> tag, ViewFn<Iterable<WindowedValue<?>>, T> viewFn, WindowMappingFn<?> windowMappingFn, @Nullable WindowingStrategy<?, ?> windowingStrategy, @Nullable Coder<Iterable<WindowedValue<?>>> coder) {
        this.pCollection = pCollection;
        this.tag = tag;
        this.viewFn = viewFn;
        this.windowMappingFn = windowMappingFn;
        this.windowingStrategy = windowingStrategy;
        this.coder = coder;
    }

    public PCollection<?> getPCollection() {
        return this.pCollection;
    }

    public TupleTag<Iterable<WindowedValue<?>>> getTagInternal() {
        return this.tag;
    }

    public ViewFn<Iterable<WindowedValue<?>>, T> getViewFn() {
        return this.viewFn;
    }

    public WindowMappingFn<?> getWindowMappingFn() {
        return this.windowMappingFn;
    }

    public WindowingStrategy<?, ?> getWindowingStrategyInternal() {
        return this.windowingStrategy;
    }

    public Coder<Iterable<WindowedValue<?>>> getCoderInternal() {
        return this.coder;
    }

    public Map<TupleTag<?>, PValue> expand() {
        throw new UnsupportedOperationException(String.format("A %s cannot be expanded", RunnerPCollectionView.class.getSimpleName()));
    }

    public boolean equals(Object other) {
        if (!(other instanceof PCollectionView)) {
            return false;
        }
        PCollectionView otherView = (PCollectionView)other;
        return this.tag.equals((Object)otherView.getTagInternal());
    }

    public int hashCode() {
        return Objects.hash(this.tag);
    }
}

