/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction;

import com.google.auto.service.AutoService;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.collect.Lists;
import org.apache.beam.runners.dataflow.repackaged.org.apache.beam.runners.core.construction.java.repackaged.com.google.common.collect.Maps;
import org.apache.beam.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;

public class WriteFilesTranslation {
    public static final String CUSTOM_JAVA_FILE_BASED_SINK_URN = "urn:beam:file_based_sink:javasdk:0.1";

    @VisibleForTesting
    static RunnerApi.WriteFilesPayload toProto(WriteFiles<?, ?, ?> transform) {
        HashMap<String, RunnerApi.SideInput> sideInputs = Maps.newHashMap();
        for (PCollectionView view : transform.getSink().getDynamicDestinations().getSideInputs()) {
            sideInputs.put(view.getTagInternal().getId(), ParDoTranslation.toProto(view));
        }
        return RunnerApi.WriteFilesPayload.newBuilder().setSink(WriteFilesTranslation.toProto(transform.getSink())).setWindowedWrites(transform.isWindowedWrites()).setRunnerDeterminedSharding(transform.getNumShards() == null && transform.getSharding() == null).putAllSideInputs(sideInputs).build();
    }

    private static RunnerApi.SdkFunctionSpec toProto(FileBasedSink<?, ?, ?> sink) {
        return WriteFilesTranslation.toProto(CUSTOM_JAVA_FILE_BASED_SINK_URN, sink);
    }

    private static RunnerApi.SdkFunctionSpec toProto(String urn, Serializable serializable) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(urn).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray((Serializable)serializable))).build()).build();
    }

    @VisibleForTesting
    static FileBasedSink<?, ?, ?> sinkFromProto(RunnerApi.SdkFunctionSpec sinkProto) throws IOException {
        Preconditions.checkArgument(sinkProto.getSpec().getUrn().equals(CUSTOM_JAVA_FILE_BASED_SINK_URN), "Cannot extract %s instance from %s with URN %s", (Object)FileBasedSink.class.getSimpleName(), (Object)RunnerApi.FunctionSpec.class.getSimpleName(), (Object)sinkProto.getSpec().getUrn());
        byte[] serializedSink = sinkProto.getSpec().getPayload().toByteArray();
        return (FileBasedSink)SerializableUtils.deserializeFromByteArray((byte[])serializedSink, (String)FileBasedSink.class.getSimpleName());
    }

    public static <UserT, DestinationT, OutputT> FileBasedSink<UserT, DestinationT, OutputT> getSink(AppliedPTransform<PCollection<UserT>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<UserT>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        return WriteFilesTranslation.sinkFromProto(WriteFilesTranslation.getWriteFilesPayload(transform).getSink());
    }

    public static <UserT, DestinationT> List<PCollectionView<?>> getDynamicDestinationSideInputs(AppliedPTransform<PCollection<UserT>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<UserT>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        SdkComponents sdkComponents = SdkComponents.create();
        RunnerApi.PTransform transformProto = PTransformTranslation.toProto(transform, sdkComponents);
        ArrayList<PCollectionView<?>> views = Lists.newArrayList();
        Map sideInputs = WriteFilesTranslation.getWriteFilesPayload(transform).getSideInputsMap();
        for (Map.Entry entry : sideInputs.entrySet()) {
            PCollection originalPCollection = Preconditions.checkNotNull((PCollection)transform.getInputs().get(new TupleTag((String)entry.getKey())), "no input with tag %s", entry.getKey());
            views.add(ParDoTranslation.viewFromProto((RunnerApi.SideInput)entry.getValue(), (String)entry.getKey(), originalPCollection, transformProto, RehydratedComponents.forComponents(sdkComponents.toComponents())));
        }
        return views;
    }

    public static <T, DestinationT> boolean isWindowedWrites(AppliedPTransform<PCollection<T>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<T>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        return WriteFilesTranslation.getWriteFilesPayload(transform).getWindowedWrites();
    }

    public static <T, DestinationT> boolean isRunnerDeterminedSharding(AppliedPTransform<PCollection<T>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<T>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        return WriteFilesTranslation.getWriteFilesPayload(transform).getRunnerDeterminedSharding();
    }

    private static <T, DestinationT> RunnerApi.WriteFilesPayload getWriteFilesPayload(AppliedPTransform<PCollection<T>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<T>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        return RunnerApi.WriteFilesPayload.parseFrom((ByteString)PTransformTranslation.toProto(transform, Collections.emptyList(), SdkComponents.create()).getSpec().getPayload());
    }

    @AutoService(value=TransformPayloadTranslatorRegistrar.class)
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return Collections.singletonMap(WriteFiles.class, new WriteFilesTranslator());
        }
    }

    static class WriteFilesTranslator
    implements PTransformTranslation.TransformPayloadTranslator<WriteFiles<?, ?, ?>> {
        WriteFilesTranslator() {
        }

        @Override
        public String getUrn(WriteFiles<?, ?, ?> transform) {
            return "urn:beam:transform:write_files:0.1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, WriteFiles<?, ?, ?>> transform, SdkComponents components) {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((WriteFiles)transform.getTransform())).setPayload(WriteFilesTranslation.toProto((WriteFiles)transform.getTransform()).toByteString()).build();
        }
    }
}

