/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.NanoClock;
import com.google.api.client.util.Sleeper;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.JobMessage;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.runners.dataflow.DataflowClient;
import org.apache.beam.runners.dataflow.DataflowMetrics;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.MonitoringUtil;
import org.apache.beam.runners.dataflow.util.TimeUtil;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataflowPipelineJob
implements PipelineResult {
    private static final Logger LOG = LoggerFactory.getLogger(DataflowPipelineJob.class);
    protected String jobId;
    private final DataflowPipelineOptions dataflowOptions;
    private final DataflowClient dataflowClient;
    private final DataflowMetrics dataflowMetrics;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable PipelineResult.State terminalState = null;
    private @Nullable DataflowPipelineJob replacedByJob = null;
    protected BiMap<AppliedPTransform<?, ?, ?>, String> transformStepNames;
    private long lastTimestamp = Long.MIN_VALUE;
    static final Duration MESSAGES_POLLING_INTERVAL = Duration.standardSeconds((long)2L);
    static final Duration STATUS_POLLING_INTERVAL = Duration.standardSeconds((long)2L);
    static final Duration DEFAULT_MAX_BACKOFF = Duration.standardMinutes((long)2L);
    static final double DEFAULT_BACKOFF_EXPONENT = 1.5;
    static final int MESSAGES_POLLING_RETRIES = 11;
    static final int STATUS_POLLING_RETRIES = 4;
    private static final FluentBackoff MESSAGES_BACKOFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(MESSAGES_POLLING_INTERVAL).withMaxRetries(11).withExponent(1.5).withMaxBackoff(DEFAULT_MAX_BACKOFF);
    protected static final FluentBackoff STATUS_BACKOFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(STATUS_POLLING_INTERVAL).withMaxRetries(4).withExponent(1.5);
    private @Nullable String latestStateString;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable RunnerApi.Pipeline pipelineProto;
    private AtomicReference<FutureTask<PipelineResult.State>> cancelState = new AtomicReference();

    public DataflowPipelineJob(DataflowClient dataflowClient, String jobId, DataflowPipelineOptions dataflowOptions, Map<AppliedPTransform<?, ?, ?>, String> transformStepNames, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable RunnerApi.Pipeline pipelineProto) {
        this.dataflowClient = dataflowClient;
        this.jobId = jobId;
        this.dataflowOptions = dataflowOptions;
        this.transformStepNames = HashBiMap.create((Map)((Map)MoreObjects.firstNonNull(transformStepNames, (Object)ImmutableMap.of())));
        this.dataflowMetrics = new DataflowMetrics(this, this.dataflowClient);
        this.pipelineProto = pipelineProto;
    }

    public DataflowPipelineJob(DataflowClient dataflowClient, String jobId, DataflowPipelineOptions dataflowOptions, Map<AppliedPTransform<?, ?, ?>, String> transformStepNames) {
        this(dataflowClient, jobId, dataflowOptions, transformStepNames, null);
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getProjectId() {
        return this.dataflowOptions.getProject();
    }

    public DataflowPipelineOptions getDataflowOptions() {
        return this.dataflowOptions;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable RunnerApi.Pipeline getPipelineProto() {
        return this.pipelineProto;
    }

    public String getRegion() {
        return this.dataflowOptions.getRegion();
    }

    public DataflowPipelineJob getReplacedByJob() {
        if (this.terminalState == null) {
            throw new IllegalStateException("getReplacedByJob() called before job terminated");
        }
        if (this.replacedByJob == null) {
            throw new IllegalStateException("getReplacedByJob() called for job that was not replaced");
        }
        return this.replacedByJob;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable PipelineResult.State waitUntilFinish() {
        return this.waitUntilFinish(Duration.millis((long)-1L));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable PipelineResult.State waitUntilFinish(Duration duration) {
        try {
            return this.waitUntilFinish(duration, new MonitoringUtil.LoggingHandler());
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable PipelineResult.State waitUntilFinish(Duration duration, MonitoringUtil.JobMessagesHandler messageHandler) throws IOException, InterruptedException {
        Thread shutdownHook = new Thread(() -> LOG.warn("Job is already running in Google Cloud Platform, Ctrl-C will not cancel it.\nTo cancel the job in the cloud, run:\n> {}", (Object)MonitoringUtil.getGcloudCancelCommand(this.dataflowOptions, this.getJobId())));
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            PipelineResult.State state = this.waitUntilFinish(duration, messageHandler, Sleeper.DEFAULT, NanoClock.SYSTEM, new MonitoringUtil(this.dataflowClient));
            return state;
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
    }

    @VisibleForTesting
    // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable PipelineResult.State waitUntilFinish(Duration duration, @Nullable MonitoringUtil.JobMessagesHandler messageHandler, Sleeper sleeper, NanoClock nanoClock) throws IOException, InterruptedException {
        return this.waitUntilFinish(duration, messageHandler, sleeper, nanoClock, new MonitoringUtil(this.dataflowClient));
    }

    private static BackOff getMessagesBackoff(Duration duration) {
        FluentBackoff factory = MESSAGES_BACKOFF_FACTORY;
        if (!duration.isShorterThan((ReadableDuration)Duration.ZERO)) {
            factory = factory.withMaxCumulativeBackoff(duration);
        }
        return BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)factory.backoff());
    }

    @VisibleForTesting
    // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable PipelineResult.State waitUntilFinish(Duration duration, @Nullable MonitoringUtil.JobMessagesHandler messageHandler, Sleeper sleeper, NanoClock nanoClock, MonitoringUtil monitor) throws IOException, InterruptedException {
        Exception exception;
        BackOff backoff = DataflowPipelineJob.getMessagesBackoff(duration);
        long startNanos = nanoClock.nanoTime();
        PipelineResult.State state = PipelineResult.State.UNKNOWN;
        do {
            exception = null;
            try {
                state = this.getStateWithRetries(BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)STATUS_BACKOFF_FACTORY.withMaxRetries(0).backoff()), sleeper);
            }
            catch (IOException e) {
                exception = e;
                LOG.warn("Failed to get job state: {}", (Object)e.getMessage());
                LOG.debug("Failed to get job state.", (Throwable)e);
                continue;
            }
            exception = this.processJobMessages(messageHandler, monitor);
            if (exception != null) continue;
            if (state.isTerminal()) {
                this.logTerminalState(state);
                return state;
            }
            backoff = DataflowPipelineJob.resetBackoff(duration, nanoClock, startNanos);
        } while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff));
        if (exception == null) {
            LOG.warn("No terminal state was returned within allotted timeout. State value {}", (Object)state);
        } else {
            LOG.error("Failed to fetch job metadata.", (Throwable)exception);
        }
        return null;
    }

    private void logTerminalState(PipelineResult.State state) {
        switch (state) {
            case DONE: 
            case CANCELLED: {
                LOG.info("Job {} finished with status {}.", (Object)this.getJobId(), (Object)state);
                break;
            }
            case UPDATED: {
                LOG.info("Job {} has been updated and is running as the new job with id {}. To access the updated job on the Dataflow monitoring console, please navigate to {}", new Object[]{this.getJobId(), this.getReplacedByJob().getJobId(), MonitoringUtil.getJobMonitoringPageURL(this.getReplacedByJob().getProjectId(), this.getRegion(), this.getReplacedByJob().getJobId())});
                break;
            }
            default: {
                LOG.info("Job {} failed with status {}.", (Object)this.getJobId(), (Object)state);
            }
        }
    }

    private static BackOff resetBackoff(Duration duration, NanoClock nanoClock, long startNanos) {
        long nanosConsumed;
        Duration consumed;
        Duration remaining;
        BackOff backoff = duration.isLongerThan((ReadableDuration)Duration.ZERO) ? ((remaining = duration.minus((ReadableDuration)(consumed = Duration.millis((long)(((nanosConsumed = nanoClock.nanoTime() - startNanos) + 999999L) / 1000000L))))).isLongerThan((ReadableDuration)Duration.ZERO) ? DataflowPipelineJob.getMessagesBackoff(remaining) : BackOff.STOP_BACKOFF) : DataflowPipelineJob.getMessagesBackoff(duration);
        return backoff;
    }

    private Exception processJobMessages(@Nullable MonitoringUtil.JobMessagesHandler messageHandler, MonitoringUtil monitor) throws IOException {
        if (messageHandler != null) {
            try {
                List<JobMessage> allMessages = monitor.getJobMessages(this.getJobId(), this.lastTimestamp);
                if (!allMessages.isEmpty()) {
                    this.lastTimestamp = TimeUtil.fromCloudTime(allMessages.get(allMessages.size() - 1).getTime()).getMillis();
                    messageHandler.process(allMessages);
                }
            }
            catch (GoogleJsonResponseException | SocketTimeoutException e) {
                LOG.warn("Failed to get job messages: {}", (Object)e.getMessage());
                LOG.debug("Failed to get job messages.", e);
                return e;
            }
        }
        return null;
    }

    public PipelineResult.State cancel() throws IOException {
        FutureTask<PipelineResult.State> tentativeCancelTask = new FutureTask<PipelineResult.State>(() -> {
            Job content = new Job();
            content.setProjectId(this.getProjectId());
            String currentJobId = this.getJobId();
            content.setId(currentJobId);
            content.setRequestedState("JOB_STATE_CANCELLED");
            try {
                Job job = this.dataflowClient.updateJob(currentJobId, content);
                return MonitoringUtil.toState(job.getCurrentState());
            }
            catch (IOException e) {
                PipelineResult.State state = this.getState();
                if (state.isTerminal()) {
                    LOG.warn("Cancel failed because job is already terminated. State is {}", (Object)state);
                    return state;
                }
                if (e.getMessage().contains("has terminated")) {
                    LOG.warn("Cancel failed because job is already terminated.", (Throwable)e);
                    return state;
                }
                String errorMsg = String.format("Failed to cancel job in state %s, please go to the Developers Console to cancel it manually: %s", state, MonitoringUtil.getJobMonitoringPageURL(this.getProjectId(), this.getRegion(), this.getJobId()));
                LOG.warn(errorMsg);
                throw new IOException(errorMsg, e);
            }
        });
        if (this.cancelState.compareAndSet(null, tentativeCancelTask)) {
            this.cancelState.get().run();
        }
        try {
            return this.cancelState.get().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    public PipelineResult.State getState() {
        if (this.terminalState != null) {
            return this.terminalState;
        }
        return this.getStateWithRetriesOrUnknownOnException(BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)STATUS_BACKOFF_FACTORY.backoff()), Sleeper.DEFAULT);
    }

    @Nullable String getLatestStateString() {
        return this.latestStateString;
    }

    @VisibleForTesting
    PipelineResult.State getStateWithRetriesOrUnknownOnException(BackOff attempts, Sleeper sleeper) {
        try {
            return this.getStateWithRetries(attempts, sleeper);
        }
        catch (IOException exn) {
            return PipelineResult.State.UNKNOWN;
        }
    }

    PipelineResult.State getStateWithRetries(BackOff attempts, Sleeper sleeper) throws IOException {
        if (this.terminalState != null) {
            return this.terminalState;
        }
        Job job = this.getJobWithRetries(attempts, sleeper);
        this.latestStateString = job.getCurrentState();
        return MonitoringUtil.toState(this.latestStateString);
    }

    private Job getJobWithRetries(BackOff backoff, Sleeper sleeper) throws IOException {
        while (true) {
            try {
                Job job = this.dataflowClient.getJob(this.getJobId());
                PipelineResult.State currentState = MonitoringUtil.toState(job.getCurrentState());
                if (currentState.isTerminal()) {
                    this.terminalState = currentState;
                    this.replacedByJob = new DataflowPipelineJob(this.dataflowClient, job.getReplacedByJobId(), this.dataflowOptions, (Map<AppliedPTransform<?, ?, ?>, String>)this.transformStepNames, this.pipelineProto);
                }
                return job;
            }
            catch (IOException exn) {
                LOG.warn("There were problems getting current job status: {}.", (Object)exn.getMessage());
                LOG.debug("Exception information:", (Throwable)exn);
                if (this.nextBackOff(sleeper, backoff)) continue;
                throw exn;
            }
            break;
        }
    }

    private boolean nextBackOff(Sleeper sleeper, BackOff backoff) {
        try {
            return BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff);
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(e);
        }
    }

    public MetricResults metrics() {
        return this.dataflowMetrics;
    }
}

