/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.repackaged.beam_runners_google_cloud_dataflow_java.com.google.common.base.Preconditions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;

@Description(value="Options that are used to control logging configuration on the Dataflow worker.")
@Deprecated
public interface DataflowWorkerLoggingOptions
extends PipelineOptions {
    @Description(value="Controls the default log level of all loggers without a log level override.")
    @Default.Enum(value="INFO")
    public Level getDefaultWorkerLogLevel();

    public void setDefaultWorkerLogLevel(Level var1);

    @Description(value="Controls the log level given to messages printed to System.out. Note that the message may be filtered depending on the defaultWorkerLogLevel or if a 'System.out' override is specified via workerLogLevelOverrides.")
    @Default.Enum(value="INFO")
    public Level getWorkerSystemOutMessageLevel();

    public void setWorkerSystemOutMessageLevel(Level var1);

    @Description(value="Controls the log level given to messages printed to System.err. Note that the message may be filtered depending on the defaultWorkerLogLevel or if a 'System.err' override is specified via workerLogLevelOverrides.")
    @Default.Enum(value="ERROR")
    public Level getWorkerSystemErrMessageLevel();

    public void setWorkerSystemErrMessageLevel(Level var1);

    @Description(value="This option controls the log levels for specifically named loggers. The expected format is {\"Name\":\"Level\",...}. The Dataflow worker supports a logging hierarchy based off of names that are '.' separated. For example, by specifying the value {\"a.b.c.Foo\":\"DEBUG\"}, the logger for the class 'a.b.c.Foo' will be configured to output logs at the DEBUG level. Similarly, by specifying the value {\"a.b.c\":\"WARN\"}, all loggers underneath the 'a.b.c' package will be configured to output logs at the WARN level. System.out and System.err levels are configured via loggers of the corresponding name. Also, note that when multiple overrides are specified, the exact name followed by the closest parent takes precedence.")
    public WorkerLogLevelOverrides getWorkerLogLevelOverrides();

    public void setWorkerLogLevelOverrides(WorkerLogLevelOverrides var1);

    public static class WorkerLogLevelOverrides
    extends HashMap<String, Level> {
        public WorkerLogLevelOverrides addOverrideForClass(Class<?> klass, Level level) {
            Preconditions.checkNotNull(klass, "Expected class to be not null.");
            this.addOverrideForName(klass.getName(), level);
            return this;
        }

        public WorkerLogLevelOverrides addOverrideForPackage(Package pkg, Level level) {
            Preconditions.checkNotNull(pkg, "Expected package to be not null.");
            this.addOverrideForName(pkg.getName(), level);
            return this;
        }

        public WorkerLogLevelOverrides addOverrideForName(String name, Level level) {
            Preconditions.checkNotNull(name, "Expected name to be not null.");
            Preconditions.checkNotNull(level, "Expected level to be one of %s.", (Object)Arrays.toString((Object[])Level.values()));
            this.put(name, level);
            return this;
        }

        @JsonCreator
        public static WorkerLogLevelOverrides from(Map<String, String> values) {
            Preconditions.checkNotNull(values, "Expected values to be not null.");
            WorkerLogLevelOverrides overrides = new WorkerLogLevelOverrides();
            for (Map.Entry<String, String> entry : values.entrySet()) {
                try {
                    overrides.addOverrideForName(entry.getKey(), Level.valueOf(entry.getValue()));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("Unsupported log level '%s' requested for %s. Must be one of %s.", entry.getValue(), entry.getKey(), Arrays.toString((Object[])Level.values())));
                }
            }
            return overrides;
        }
    }

    public static enum Level {
        OFF,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

