/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.api.services.dataflow.Dataflow;
import java.util.Map;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.DataflowTransport;
import org.apache.beam.runners.dataflow.util.GcsStager;
import org.apache.beam.runners.dataflow.util.Stager;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.MemoryMonitorOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Description(value="[Internal] Options used to control execution of the Dataflow SDK for debugging and testing purposes.")
@Hidden
public interface DataflowPipelineDebugOptions
extends ExperimentalOptions,
MemoryMonitorOptions,
PipelineOptions {
    @Description(value="The root URL for the Dataflow API. dataflowEndpoint can override this value if it contains an absolute URL, otherwise apiRootUrl will be combined with dataflowEndpoint to generate the full URL to communicate with the Dataflow API.")
    @Default.String(value="https://dataflow.googleapis.com/")
    public @UnknownKeyFor @NonNull @Initialized String getApiRootUrl();

    public void setApiRootUrl(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The URL for the Dataflow API. If the string contains \"://\", this will be treated as the entire URL, otherwise will be treated relative to apiRootUrl.")
    @Default.String(value="")
    public @UnknownKeyFor @NonNull @Initialized String getDataflowEndpoint();

    public void setDataflowEndpoint(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The path to write the translated Dataflow job specification out to at job submission time. The Dataflow job specification will be represented in JSON format.")
    public @UnknownKeyFor @NonNull @Initialized String getDataflowJobFile();

    public void setDataflowJobFile(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The class of the stager that should be created and used to stage resources. If stager has not been set explicitly, an instance of the this class will be created and used as the resource stager.")
    @Default.Class(value=GcsStager.class)
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Stager> getStagerClass();

    public void setStagerClass(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Stager> var1);

    @JsonIgnore
    @Description(value="The resource stager instance that should be used to stage resources. If no stager has been set explicitly, the default is to use the instance factory that constructs a resource stager based upon the currently set stagerClass.")
    @Default.InstanceFactory(value=StagerFactory.class)
    public @UnknownKeyFor @NonNull @Initialized Stager getStager();

    public void setStager(@UnknownKeyFor @NonNull @Initialized Stager var1);

    @JsonIgnore
    @Description(value="An instance of the Dataflow client. Defaults to creating a Dataflow client using the current set of options.")
    @Default.InstanceFactory(value=DataflowClientFactory.class)
    public @UnknownKeyFor @NonNull @Initialized Dataflow getDataflowClient();

    public void setDataflowClient(@UnknownKeyFor @NonNull @Initialized Dataflow var1);

    @JsonIgnore
    @Description(value="Mapping of old PTransform names to new ones, specified as JSON {\"oldName\":\"newName\",...}. To mark a transform as deleted, make newName the empty string.")
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getTransformNameMapping();

    public void setTransformNameMapping(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="Custom windmill_main binary to use with the streaming runner")
    public @UnknownKeyFor @NonNull @Initialized String getOverrideWindmillBinary();

    public void setOverrideWindmillBinary(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Custom windmill service endpoint.")
    public @UnknownKeyFor @NonNull @Initialized String getWindmillServiceEndpoint();

    public void setWindmillServiceEndpoint(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Port for communicating with a remote windmill service.")
    @Default.Integer(value=443)
    public @UnknownKeyFor @NonNull @Initialized int getWindmillServicePort();

    public void setWindmillServicePort(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Number of threads to use on the Dataflow worker harness. If left unspecified, the Dataflow service will compute an appropriate number of threads to use.")
    public @UnknownKeyFor @NonNull @Initialized int getNumberOfWorkerHarnessThreads();

    public void setNumberOfWorkerHarnessThreads(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Maximum number of bundles outstanding from windmill before the worker stops requesting.")
    @Default.Integer(value=0)
    public @UnknownKeyFor @NonNull @Initialized int getMaxBundlesFromWindmillOutstanding();

    public void setMaxBundlesFromWindmillOutstanding(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Maximum number of bytes outstanding from windmill before the worker stops requesting. If <= 0, use the default value of 50% of jvm memory.")
    @Default.Long(value=0L)
    public @UnknownKeyFor @NonNull @Initialized long getMaxBytesFromWindmillOutstanding();

    public void setMaxBytesFromWindmillOutstanding(@UnknownKeyFor @NonNull @Initialized long var1);

    @Description(value="If {@literal true}, save a heap dump before killing a thread or process which is GC thrashing or out of memory.")
    public @UnknownKeyFor @NonNull @Initialized boolean getDumpHeapOnOOM();

    public void setDumpHeapOnOOM(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="If true, save a JFR profile before killing a thread or process which is GC thrashing or out of memory.  Only available on java 9 or up")
    public @UnknownKeyFor @NonNull @Initialized boolean getRecordJfrOnGcThrashing();

    public void setRecordJfrOnGcThrashing(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Default.Integer(value=60)
    @Description(value="The duration of the JFR recording taken if --recordJfrOnGcThrashing is set.")
    public @UnknownKeyFor @NonNull @Initialized int getJfrRecordingDurationSec();

    public void setJfrRecordingDurationSec(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="The size of the worker's in-memory cache, in megabytes.")
    @Default.Integer(value=100)
    public @UnknownKeyFor @NonNull @Initialized Integer getWorkerCacheMb();

    public void setWorkerCacheMb(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The size of the streaming worker's side input cache, in megabytes.")
    @Default.Integer(value=100)
    public @UnknownKeyFor @NonNull @Initialized Integer getStreamingSideInputCacheMb();

    public void setStreamingSideInputCacheMb(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The expiry for streaming worker's side input cache entries, in milliseconds.")
    @Default.Integer(value=60000)
    public @UnknownKeyFor @NonNull @Initialized Integer getStreamingSideInputCacheExpirationMillis();

    public void setstreamingSideInputCacheExpirationMillis(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The amount of time before UnboundedReaders are uncached, in seconds.")
    @Default.Integer(value=60)
    public @UnknownKeyFor @NonNull @Initialized Integer getReaderCacheTimeoutSec();

    public void setReaderCacheTimeoutSec(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The max amount of time before an UnboundedReader is consumed before checkpointing, in seconds.")
    @Default.Integer(value=10)
    public @UnknownKeyFor @NonNull @Initialized Integer getUnboundedReaderMaxReadTimeSec();

    public void setUnboundedReaderMaxReadTimeSec(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The max elements read from an UnboundedReader before checkpointing. ")
    @Default.Integer(value=10000)
    public @UnknownKeyFor @NonNull @Initialized Integer getUnboundedReaderMaxElements();

    public void setUnboundedReaderMaxElements(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The max amount of time waiting for elements when reading from UnboundedReader.")
    @Default.Integer(value=1000)
    public @UnknownKeyFor @NonNull @Initialized Integer getUnboundedReaderMaxWaitForElementsMs();

    public void setUnboundedReaderMaxWaitForElementsMs(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The desired number of initial splits for UnboundedSources.")
    @Default.Integer(value=0)
    public @UnknownKeyFor @NonNull @Initialized int getDesiredNumUnboundedSourceSplits();

    public void setDesiredNumUnboundedSourceSplits(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Set to a GCS bucket (directory) to upload heap dumps to the given location.\nEnabling this implies that heap dumps should be generated on OOM (--dumpHeapOnOOM=true)\nUploads will continue until the pipeline is stopped or updated without this option.\n")
    public @UnknownKeyFor @NonNull @Initialized String getSaveHeapDumpsToGcsPath();

    public void setSaveHeapDumpsToGcsPath(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Overrides for SDK harness container images. Each entry consist of two values separated by \na comma where first value gives a regex to identify the container image to override \nand the second value gives the replacement container image.")
    public @UnknownKeyFor @NonNull @Initialized String getSdkHarnessContainerImageOverrides();

    public void setSdkHarnessContainerImageOverrides(@UnknownKeyFor @NonNull @Initialized String var1);

    public static class StagerFactory
    implements DefaultValueFactory<Stager> {
        public @UnknownKeyFor @NonNull @Initialized Stager create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            DataflowPipelineDebugOptions debugOptions = (DataflowPipelineDebugOptions)options.as(DataflowPipelineDebugOptions.class);
            return (Stager)InstanceBuilder.ofType(Stager.class).fromClass(debugOptions.getStagerClass()).fromFactoryMethod("fromOptions").withArg(PipelineOptions.class, (Object)options).build();
        }
    }

    public static class DataflowClientFactory
    implements DefaultValueFactory<Dataflow> {
        public @UnknownKeyFor @NonNull @Initialized Dataflow create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return DataflowTransport.newDataflowClient((DataflowPipelineOptions)options.as(DataflowPipelineOptions.class)).build();
        }
    }
}

