/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import org.apache.beam.runners.dataflow.options.DataflowWorkerHarnessOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

@Description(value="[Internal] Options for configuring StreamingDataflowWorker.")
@Hidden
public interface DataflowStreamingPipelineOptions
extends PipelineOptions {
    @Description(value="Custom windmill_main binary to use with the streaming runner")
    public @UnknownKeyFor @NonNull @Initialized String getOverrideWindmillBinary();

    public void setOverrideWindmillBinary(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Custom windmill service endpoint.")
    public @UnknownKeyFor @NonNull @Initialized String getWindmillServiceEndpoint();

    public void setWindmillServiceEndpoint(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Port for communicating with a remote windmill service.")
    @Default.Integer(value=443)
    public @UnknownKeyFor @NonNull @Initialized int getWindmillServicePort();

    public void setWindmillServicePort(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Hostport of a co-located Windmill server.")
    @Default.InstanceFactory(value=LocalWindmillHostportFactory.class)
    public @UnknownKeyFor @NonNull @Initialized String getLocalWindmillHostport();

    public void setLocalWindmillHostport(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Maximum number of bundles outstanding from windmill before the worker stops requesting.")
    @Default.Integer(value=0)
    public @UnknownKeyFor @NonNull @Initialized int getMaxBundlesFromWindmillOutstanding();

    public void setMaxBundlesFromWindmillOutstanding(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Maximum number of bytes outstanding from windmill before the worker stops requesting. If <= 0, use the default value of 50% of jvm memory.")
    @Default.Long(value=0L)
    public @UnknownKeyFor @NonNull @Initialized long getMaxBytesFromWindmillOutstanding();

    public void setMaxBytesFromWindmillOutstanding(@UnknownKeyFor @NonNull @Initialized long var1);

    @Description(value="The size of the streaming worker's side input cache, in megabytes.")
    @Default.Integer(value=100)
    public @UnknownKeyFor @NonNull @Initialized Integer getStreamingSideInputCacheMb();

    public void setStreamingSideInputCacheMb(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The expiry for streaming worker's side input cache entries, in milliseconds.")
    @Default.Integer(value=60000)
    public @UnknownKeyFor @NonNull @Initialized Integer getStreamingSideInputCacheExpirationMillis();

    public void setStreamingSideInputCacheExpirationMillis(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="Number of commit threads used to commit items to streaming engine.")
    @Default.Integer(value=1)
    public @UnknownKeyFor @NonNull @Initialized Integer getWindmillServiceCommitThreads();

    public void setWindmillServiceCommitThreads(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="Frequency at which active work should be reported back to Windmill, in millis. The first refresh will occur after at least this much time has passed since starting the work item")
    @Default.Integer(value=10000)
    public @UnknownKeyFor @NonNull @Initialized int getActiveWorkRefreshPeriodMillis();

    public void setActiveWorkRefreshPeriodMillis(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="If positive, frequency at which windmill service streaming rpcs will have application level health checks.")
    @Default.Integer(value=10000)
    public @UnknownKeyFor @NonNull @Initialized int getWindmillServiceStreamingRpcHealthCheckPeriodMs();

    public void setWindmillServiceStreamingRpcHealthCheckPeriodMs(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="If positive, the number of messages to send on streaming rpc before checking isReady.Higher values reduce cost of output overhead at the cost of more memory used in grpc buffers.")
    @Default.Integer(value=10)
    public @UnknownKeyFor @NonNull @Initialized int getWindmillMessagesBetweenIsReadyChecks();

    public void setWindmillMessagesBetweenIsReadyChecks(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="If true, a most a single active rpc will be used per channel.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized boolean getUseWindmillIsolatedChannels();

    public void setUseWindmillIsolatedChannels(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="If true, separate streaming rpcs will be used for heartbeats instead of sharing streams with state reads.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized boolean getUseSeparateWindmillHeartbeatStreams();

    public void setUseSeparateWindmillHeartbeatStreams(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="The number of streams to use for GetData requests.")
    @Default.Integer(value=1)
    public @UnknownKeyFor @NonNull @Initialized int getWindmillGetDataStreamCount();

    public void setWindmillGetDataStreamCount(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="If true, will only show windmill service channels on /channelz")
    @Default.Boolean(value=true)
    public @UnknownKeyFor @NonNull @Initialized boolean getChannelzShowOnlyWindmillServiceChannels();

    public void setChannelzShowOnlyWindmillServiceChannels(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="Period for reporting worker updates. The duration is specified as seconds in 'PTx.yS' format, e.g. 'PT5.125S'. Default is PT10S (10 seconds).Explicitly set only in tests.")
    @Default.InstanceFactory(value=HarnessUpdateReportingPeriodFactory.class)
    public @UnknownKeyFor @NonNull @Initialized Duration getWindmillHarnessUpdateReportingPeriod();

    public void setWindmillHarnessUpdateReportingPeriod(@UnknownKeyFor @NonNull @Initialized Duration var1);

    @Description(value="Limit on depth of user exception stack trace reported to cloud monitoring.")
    @Default.InstanceFactory(value=MaxStackTraceDepthToReportFactory.class)
    public @UnknownKeyFor @NonNull @Initialized int getMaxStackTraceDepthToReport();

    public void setMaxStackTraceDepthToReport(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Necessary duration for a commit to be considered stuck and invalidated.")
    @Default.Integer(value=600000)
    public @UnknownKeyFor @NonNull @Initialized int getStuckCommitDurationMillis();

    public void setStuckCommitDurationMillis(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Period for sending 'global get config' requests to the service. The duration is specified as seconds in 'PTx.yS' format, e.g. 'PT5.125S'. Default is PT120S (2 minutes).")
    @Default.InstanceFactory(value=GlobalConfigRefreshPeriodFactory.class)
    public @UnknownKeyFor @NonNull @Initialized Duration getGlobalConfigRefreshPeriod();

    public void setGlobalConfigRefreshPeriod(@UnknownKeyFor @NonNull @Initialized Duration var1);

    @Description(value="If non-null, StreamingDataflowWorkerHarness will periodically snapshot it's status pagesand thread stacks to a file in this directory. Generally only set for tests.")
    @Default.InstanceFactory(value=PeriodicStatusPageDirectoryFactory.class)
    public @UnknownKeyFor @NonNull @Initialized String getPeriodicStatusPageOutputDirectory();

    public void setPeriodicStatusPageOutputDirectory(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Streaming requests will be batched into messages up to this limit.")
    @Default.InstanceFactory(value=WindmillServiceStreamingRpcBatchLimitFactory.class)
    public @UnknownKeyFor @NonNull @Initialized int getWindmillServiceStreamingRpcBatchLimit();

    public void setWindmillServiceStreamingRpcBatchLimit(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Log streaming rpc errors once out of every N.")
    @Default.Integer(value=20)
    public @UnknownKeyFor @NonNull @Initialized int getWindmillServiceStreamingLogEveryNStreamFailures();

    public void setWindmillServiceStreamingLogEveryNStreamFailures(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="The health check period and timeout for grpc channel healthchecks")
    @Default.Integer(value=40)
    public @UnknownKeyFor @NonNull @Initialized int getWindmillServiceRpcChannelAliveTimeoutSec();

    public void setWindmillServiceRpcChannelAliveTimeoutSec(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Max backoff with which the windmill service stream failures are retried")
    @Default.Integer(value=30000)
    public @UnknownKeyFor @NonNull @Initialized int getWindmillServiceStreamMaxBackoffMillis();

    public void setWindmillServiceStreamMaxBackoffMillis(@UnknownKeyFor @NonNull @Initialized int var1);

    public static class WindmillServiceStreamingRpcBatchLimitFactory
    implements DefaultValueFactory<Integer> {
        public @UnknownKeyFor @NonNull @Initialized Integer create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            DataflowWorkerHarnessOptions streamingOptions = (DataflowWorkerHarnessOptions)options.as(DataflowWorkerHarnessOptions.class);
            return streamingOptions.isEnableStreamingEngine() ? Integer.MAX_VALUE : 1;
        }
    }

    public static class PeriodicStatusPageDirectoryFactory
    implements DefaultValueFactory<String> {
        public @UnknownKeyFor @NonNull @Initialized String create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return System.getProperty("windmill.periodic_status_page_directory");
        }
    }

    public static class MaxStackTraceDepthToReportFactory
    implements DefaultValueFactory<Integer> {
        public @UnknownKeyFor @NonNull @Initialized Integer create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return Integer.parseInt(System.getProperty("windmill.max_stack_trace_depth_to_report", Integer.toString(Integer.MAX_VALUE)));
        }
    }

    public static class GlobalConfigRefreshPeriodFactory
    implements DefaultValueFactory<Duration> {
        public @UnknownKeyFor @NonNull @Initialized Duration create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            Duration period = Duration.parse((String)System.getProperty("windmill.global_get_config_refresh_period", "PT120S"));
            return period.isLongerThan((ReadableDuration)Duration.ZERO) ? period : Duration.standardMinutes((long)2L);
        }
    }

    public static class HarnessUpdateReportingPeriodFactory
    implements DefaultValueFactory<Duration> {
        public @UnknownKeyFor @NonNull @Initialized Duration create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            Duration period = Duration.parse((String)System.getProperty("windmill.harness_update_reporting_period", "PT10S"));
            return period.isLongerThan((ReadableDuration)Duration.ZERO) ? period : Duration.standardSeconds((long)10L);
        }
    }

    public static class LocalWindmillHostportFactory
    implements DefaultValueFactory<String> {
        private static final @UnknownKeyFor @NonNull @Initialized String WINDMILL_HOSTPORT_PROPERTY = "windmill.hostport";

        public @UnknownKeyFor @NonNull @Initialized String create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return System.getProperty(WINDMILL_HOSTPORT_PROPERTY);
        }
    }
}

