/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.google.api.services.dataflow.Dataflow;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.JobMetrics;
import com.google.api.services.dataflow.model.LeaseWorkItemRequest;
import com.google.api.services.dataflow.model.LeaseWorkItemResponse;
import com.google.api.services.dataflow.model.ListJobMessagesResponse;
import com.google.api.services.dataflow.model.ListJobsResponse;
import com.google.api.services.dataflow.model.ReportWorkItemStatusRequest;
import com.google.api.services.dataflow.model.ReportWorkItemStatusResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_google_cloud_dataflow_java.com.google.common.base.Preconditions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;

public class DataflowClient {
    private final Dataflow dataflow;
    private final DataflowPipelineOptions options;

    public static DataflowClient create(DataflowPipelineOptions options) {
        return new DataflowClient(options.getDataflowClient(), options);
    }

    private DataflowClient(Dataflow dataflow, DataflowPipelineOptions options) {
        this.dataflow = Preconditions.checkNotNull(dataflow, "dataflow");
        this.options = Preconditions.checkNotNull(options, "options");
    }

    public Job createJob(@Nonnull Job job) throws IOException {
        Preconditions.checkNotNull(job, "job");
        Dataflow.Projects.Locations.Jobs.Create jobsCreate = this.dataflow.projects().locations().jobs().create(this.options.getProject(), this.options.getRegion(), job);
        return (Job)jobsCreate.execute();
    }

    public ListJobsResponse listJobs(@Nullable String pageToken) throws IOException {
        Dataflow.Projects.Locations.Jobs.List jobsList = this.dataflow.projects().locations().jobs().list(this.options.getProject(), this.options.getRegion()).setPageToken(pageToken);
        return (ListJobsResponse)jobsList.execute();
    }

    public Job updateJob(@Nonnull String jobId, @Nonnull Job content) throws IOException {
        Preconditions.checkNotNull(jobId, "jobId");
        Preconditions.checkNotNull(content, "content");
        Dataflow.Projects.Locations.Jobs.Update jobsUpdate = this.dataflow.projects().locations().jobs().update(this.options.getProject(), this.options.getRegion(), jobId, content);
        return (Job)jobsUpdate.execute();
    }

    public Job getJob(@Nonnull String jobId) throws IOException {
        Preconditions.checkNotNull(jobId, "jobId");
        Dataflow.Projects.Locations.Jobs.Get jobsGet = this.dataflow.projects().locations().jobs().get(this.options.getProject(), this.options.getRegion(), jobId);
        return (Job)jobsGet.execute();
    }

    public JobMetrics getJobMetrics(@Nonnull String jobId) throws IOException {
        Preconditions.checkNotNull(jobId, "jobId");
        Dataflow.Projects.Locations.Jobs.GetMetrics jobsGetMetrics = this.dataflow.projects().locations().jobs().getMetrics(this.options.getProject(), this.options.getRegion(), jobId);
        return (JobMetrics)jobsGetMetrics.execute();
    }

    public ListJobMessagesResponse listJobMessages(@Nonnull String jobId, @Nullable String pageToken) throws IOException {
        Preconditions.checkNotNull(jobId, "jobId");
        Dataflow.Projects.Locations.Jobs.Messages.List jobMessagesList = this.dataflow.projects().locations().jobs().messages().list(this.options.getProject(), this.options.getRegion(), jobId).setPageToken(pageToken);
        return (ListJobMessagesResponse)jobMessagesList.execute();
    }

    public LeaseWorkItemResponse leaseWorkItem(@Nonnull String jobId, @Nonnull LeaseWorkItemRequest request) throws IOException {
        Preconditions.checkNotNull(jobId, "jobId");
        Preconditions.checkNotNull(request, "request");
        Dataflow.Projects.Locations.Jobs.WorkItems.Lease jobWorkItemsLease = this.dataflow.projects().locations().jobs().workItems().lease(this.options.getProject(), this.options.getRegion(), jobId, request);
        return (LeaseWorkItemResponse)jobWorkItemsLease.execute();
    }

    public ReportWorkItemStatusResponse reportWorkItemStatus(@Nonnull String jobId, @Nonnull ReportWorkItemStatusRequest request) throws IOException {
        Preconditions.checkNotNull(jobId, "jobId");
        Preconditions.checkNotNull(request, "request");
        Dataflow.Projects.Locations.Jobs.WorkItems.ReportStatus jobWorkItemsReportStatus = this.dataflow.projects().locations().jobs().workItems().reportStatus(this.options.getProject(), this.options.getRegion(), jobId, request);
        return (ReportWorkItemStatusResponse)jobWorkItemsReportStatus.execute();
    }
}

