/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_google_cloud_dataflow_java.com.google.common.collect.ImmutableList;

enum CloudKnownType {
    TEXT("http://schema.org/Text", new Class[]{String.class}){

        @Override
        public <T> T parse(Object value, Class<T> clazz) {
            return clazz.cast(value);
        }
    }
    ,
    BOOLEAN("http://schema.org/Boolean", new Class[]{Boolean.class}){

        @Override
        public <T> T parse(Object value, Class<T> clazz) {
            return clazz.cast(value);
        }
    }
    ,
    INTEGER("http://schema.org/Integer", new Class[]{Long.class, Integer.class}){

        @Override
        public <T> T parse(Object value, Class<T> clazz) {
            Object result = null;
            if (value.getClass() == clazz) {
                result = value;
            } else if (clazz == Long.class) {
                if (value instanceof Integer) {
                    result = ((Integer)value).longValue();
                } else if (value instanceof String) {
                    result = Long.valueOf((String)value);
                }
            } else if (clazz == Integer.class) {
                if (value instanceof Long) {
                    result = ((Long)value).intValue();
                } else if (value instanceof String) {
                    result = Integer.valueOf((String)value);
                }
            }
            return clazz.cast(result);
        }
    }
    ,
    FLOAT("http://schema.org/Float", new Class[]{Double.class, Float.class}){

        @Override
        public <T> T parse(Object value, Class<T> clazz) {
            Object result = null;
            if (value.getClass() == clazz) {
                result = value;
            } else if (clazz == Double.class) {
                if (value instanceof Float) {
                    result = ((Float)value).doubleValue();
                } else if (value instanceof String) {
                    result = Double.valueOf((String)value);
                }
            } else if (clazz == Float.class) {
                if (value instanceof Double) {
                    result = Float.valueOf(((Double)value).floatValue());
                } else if (value instanceof String) {
                    result = Float.valueOf((String)value);
                }
            }
            return clazz.cast(result);
        }
    };

    private final String uri;
    private final ImmutableList<Class<?>> classes;
    private static final Map<String, CloudKnownType> typesByUri;
    private static final Map<Class<?>, CloudKnownType> typesByClass;

    private CloudKnownType(String uri, Class<?> ... classes) {
        this.uri = uri;
        this.classes = ImmutableList.copyOf(classes);
    }

    public String getUri() {
        return this.uri;
    }

    public abstract <T> T parse(Object var1, Class<T> var2);

    public Class<?> defaultClass() {
        return (Class)this.classes.get(0);
    }

    private static Map<String, CloudKnownType> buildTypesByUri() {
        HashMap<String, CloudKnownType> result = new HashMap<String, CloudKnownType>();
        for (CloudKnownType ty : CloudKnownType.values()) {
            result.put(ty.getUri(), ty);
        }
        return result;
    }

    @Nullable
    public static CloudKnownType forUri(@Nullable String uri) {
        if (uri == null) {
            return null;
        }
        return typesByUri.get(uri);
    }

    private static Map<Class<?>, CloudKnownType> buildTypesByClass() {
        HashMap result = new HashMap();
        for (CloudKnownType ty : CloudKnownType.values()) {
            for (Class clazz : ty.classes) {
                result.put(clazz, ty);
            }
        }
        return result;
    }

    @Nullable
    public static CloudKnownType forClass(Class<?> clazz) {
        return typesByClass.get(clazz);
    }

    static {
        typesByUri = Collections.unmodifiableMap(CloudKnownType.buildTypesByUri());
        typesByClass = Collections.unmodifiableMap(CloudKnownType.buildTypesByClass());
    }
}

