/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.clouddebugger.v2.CloudDebugger;
import com.google.api.services.dataflow.Dataflow;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.beam.repackaged.beam_runners_google_cloud_dataflow_java.com.google.common.collect.ImmutableList;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.extensions.gcp.auth.NullCredentialInitializer;
import org.apache.beam.sdk.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.util.Transport;

public class DataflowTransport {
    private static ApiComponents apiComponentsFromUrl(String urlString) {
        try {
            URL url = new URL(urlString);
            String rootUrl = url.getProtocol() + "://" + url.getHost() + (url.getPort() > 0 ? ":" + url.getPort() : "");
            return new ApiComponents(rootUrl, url.getPath());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL: " + urlString);
        }
    }

    public static Dataflow.Builder newDataflowClient(DataflowPipelineOptions options) {
        String servicePath = options.getDataflowEndpoint();
        ApiComponents components = servicePath.contains("://") ? DataflowTransport.apiComponentsFromUrl(servicePath) : new ApiComponents(options.getApiRootUrl(), servicePath);
        return new Dataflow.Builder(Transport.getTransport(), Transport.getJsonFactory(), DataflowTransport.chainHttpRequestInitializer(options.getGcpCredential(), (HttpRequestInitializer)new RetryHttpRequestInitializer(ImmutableList.of(Integer.valueOf(404))))).setApplicationName(options.getAppName()).setRootUrl(components.rootUrl).setServicePath(components.servicePath).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
    }

    public static CloudDebugger.Builder newClouddebuggerClient(DataflowPipelineOptions options) {
        return new CloudDebugger.Builder(Transport.getTransport(), Transport.getJsonFactory(), DataflowTransport.chainHttpRequestInitializer(options.getGcpCredential(), (HttpRequestInitializer)new RetryHttpRequestInitializer())).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
    }

    private static HttpRequestInitializer chainHttpRequestInitializer(Credentials credential, HttpRequestInitializer httpRequestInitializer) {
        if (credential == null) {
            NullCredentialInitializer.throwNullCredentialException();
        }
        return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new HttpCredentialsAdapter(credential), httpRequestInitializer});
    }

    private static class ApiComponents {
        public String rootUrl;
        public String servicePath;

        public ApiComponents(String root, String path) {
            this.rootUrl = root;
            this.servicePath = path;
        }
    }
}

