/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.google.auth.Credentials;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.beam.runners.dataflow.BatchStatefulParDoOverrides;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.extensions.gcp.auth.TestCredential;
import org.apache.beam.sdk.extensions.gcp.util.GcsUtil;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class BatchStatefulParDoOverridesTest
implements Serializable {
    @Test
    public void testSingleOutputOverrideNonCrashing() throws Exception {
        DataflowPipelineOptions options = BatchStatefulParDoOverridesTest.buildPipelineOptions(new String[0]);
        options.setRunner(DataflowRunner.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        DummyStatefulDoFn fn = new DummyStatefulDoFn();
        ((PCollection)pipeline.apply((PTransform)Create.of((Object)KV.of((Object)1, (Object)2), (Object[])new KV[0]))).apply((PTransform)ParDo.of((DoFn)fn));
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        runner.replaceV1Transforms(pipeline);
        MatcherAssert.assertThat((Object)((Object)BatchStatefulParDoOverridesTest.findBatchStatefulDoFn(pipeline)), (Matcher)org.hamcrest.Matchers.equalTo((Object)((Object)fn)));
    }

    @Test
    public void testFnApiSingleOutputOverrideNonCrashing() throws Exception {
        DataflowPipelineOptions options = BatchStatefulParDoOverridesTest.buildPipelineOptions(new String[0]);
        options.setRunner(DataflowRunner.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        DummyStatefulDoFn fn = new DummyStatefulDoFn();
        ((PCollection)pipeline.apply((PTransform)Create.of((Object)KV.of((Object)1, (Object)2), (Object[])new KV[0]))).apply((PTransform)ParDo.of((DoFn)fn));
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        runner.replaceV1Transforms(pipeline);
        MatcherAssert.assertThat((Object)((Object)BatchStatefulParDoOverridesTest.findBatchStatefulDoFn(pipeline)), (Matcher)org.hamcrest.Matchers.equalTo((Object)((Object)fn)));
    }

    @Test
    public void testMultiOutputOverrideNonCrashing() throws Exception {
        DataflowPipelineOptions options = BatchStatefulParDoOverridesTest.buildPipelineOptions(new String[0]);
        options.setRunner(DataflowRunner.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        TupleTag<Integer> mainOutputTag = new TupleTag<Integer>(){};
        TupleTag<Integer> sideOutputTag = new TupleTag<Integer>(){};
        DummyStatefulDoFn fn = new DummyStatefulDoFn();
        ((PCollection)pipeline.apply((PTransform)Create.of((Object)KV.of((Object)1, (Object)2), (Object[])new KV[0]))).apply((PTransform)ParDo.of((DoFn)fn).withOutputTags((TupleTag)mainOutputTag, TupleTagList.of((TupleTag)sideOutputTag)));
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        runner.replaceV1Transforms(pipeline);
        MatcherAssert.assertThat((Object)((Object)BatchStatefulParDoOverridesTest.findBatchStatefulDoFn(pipeline)), (Matcher)org.hamcrest.Matchers.equalTo((Object)((Object)fn)));
    }

    @Test
    @Ignore(value="TODO: BEAM-2902 Add support for user state in a ParDo.Multi once PTransformMatcher exposes a way to know when the replacement is not required by checking that the preceding ParDos to a GBK are key preserving.")
    public void testFnApiMultiOutputOverrideNonCrashing() throws Exception {
        DataflowPipelineOptions options = BatchStatefulParDoOverridesTest.buildPipelineOptions(new String[0]);
        options.setRunner(DataflowRunner.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        TupleTag<Integer> mainOutputTag = new TupleTag<Integer>(){};
        TupleTag<Integer> sideOutputTag = new TupleTag<Integer>(){};
        DummyStatefulDoFn fn = new DummyStatefulDoFn();
        ((PCollection)pipeline.apply((PTransform)Create.of((Object)KV.of((Object)1, (Object)2), (Object[])new KV[0]))).apply((PTransform)ParDo.of((DoFn)fn).withOutputTags((TupleTag)mainOutputTag, TupleTagList.of((TupleTag)sideOutputTag)));
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        runner.replaceV1Transforms(pipeline);
        MatcherAssert.assertThat((Object)((Object)BatchStatefulParDoOverridesTest.findBatchStatefulDoFn(pipeline)), (Matcher)org.hamcrest.Matchers.equalTo((Object)((Object)fn)));
    }

    private static DummyStatefulDoFn findBatchStatefulDoFn(Pipeline p) {
        FindBatchStatefulDoFnVisitor findBatchStatefulDoFnVisitor = new FindBatchStatefulDoFnVisitor();
        p.traverseTopologically((Pipeline.PipelineVisitor)findBatchStatefulDoFnVisitor);
        return (DummyStatefulDoFn)findBatchStatefulDoFnVisitor.getStatefulDoFn();
    }

    private static DataflowPipelineOptions buildPipelineOptions(String ... args) throws IOException {
        GcsUtil mockGcsUtil = (GcsUtil)Mockito.mock(GcsUtil.class);
        Mockito.when((Object)mockGcsUtil.expand((GcsPath)Matchers.any(GcsPath.class))).then(invocation -> ImmutableList.of((Object)((GcsPath)invocation.getArguments()[0])));
        ((GcsUtil)Mockito.doNothing().when((Object)mockGcsUtil)).verifyBucketAccessible((GcsPath)Matchers.any(GcsPath.class));
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.fromArgs((String[])args).as(DataflowPipelineOptions.class);
        options.setRunner(DataflowRunner.class);
        options.setGcpCredential((Credentials)new TestCredential());
        options.setJobName("some-job-name");
        options.setProject("some-project");
        options.setRegion("some-region");
        options.setTempLocation(GcsPath.fromComponents((String)"somebucket", (String)"some/path").toString());
        options.setFilesToStage(new ArrayList());
        options.setGcsUtil(mockGcsUtil);
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        return options;
    }

    private static class FindBatchStatefulDoFnVisitor
    extends Pipeline.PipelineVisitor.Defaults {
        private @Nullable DoFn<?, ?> batchStatefulDoFn;

        private FindBatchStatefulDoFnVisitor() {
        }

        public DoFn<?, ?> getStatefulDoFn() {
            MatcherAssert.assertThat(this.batchStatefulDoFn, (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.nullValue()));
            return this.batchStatefulDoFn;
        }

        public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
            if (node.getTransform() instanceof BatchStatefulParDoOverrides.StatefulSingleOutputParDo) {
                this.batchStatefulDoFn = ((BatchStatefulParDoOverrides.StatefulSingleOutputParDo)node.getTransform()).getOriginalParDo().getFn();
                return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
            }
            if (node.getTransform() instanceof BatchStatefulParDoOverrides.StatefulMultiOutputParDo) {
                this.batchStatefulDoFn = ((BatchStatefulParDoOverrides.StatefulMultiOutputParDo)node.getTransform()).getOriginalParDo().getFn();
                return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }
    }

    private static class DummyStatefulDoFn
    extends DoFn<KV<Integer, Integer>, Integer> {
        @DoFn.StateId(value="foo")
        private final StateSpec<ValueState<Integer>> spec = StateSpecs.value((Coder)VarIntCoder.of());

        private DummyStatefulDoFn() {
        }

        @DoFn.ProcessElement
        public void processElem(DoFn.ProcessContext c) {
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof DummyStatefulDoFn;
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    }
}

