/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.util.List;
import java.util.Map;
import org.apache.beam.runners.dataflow.BatchViewOverrides;
import org.apache.beam.runners.dataflow.internal.IsmFormat;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BatchViewOverridesTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testBatchViewAsSingletonToIsmRecord() throws Exception {
        DoFnTester doFnTester = DoFnTester.of((DoFn)new BatchViewOverrides.BatchViewAsSingleton.IsmRecordForSingularValuePerWindowDoFn((Coder)GlobalWindow.Coder.INSTANCE));
        MatcherAssert.assertThat((Object)doFnTester.processBundle((Iterable)ImmutableList.of((Object)KV.of((Object)0, (Object)ImmutableList.of((Object)KV.of((Object)GlobalWindow.INSTANCE, (Object)WindowedValue.valueInGlobalWindow((Object)"a")))))), (Matcher)Matchers.contains((Object[])new IsmFormat.IsmRecord[]{IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)GlobalWindow.INSTANCE), (Object)WindowedValue.valueInGlobalWindow((Object)"a"))}));
    }

    @Test
    public void testBatchViewAsSingletonToIsmRecordWithMultipleValuesThrowsException() throws Exception {
        DoFnTester doFnTester = DoFnTester.of((DoFn)new BatchViewOverrides.BatchViewAsSingleton.IsmRecordForSingularValuePerWindowDoFn((Coder)GlobalWindow.Coder.INSTANCE));
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("found for singleton within window");
        doFnTester.processBundle((Iterable)ImmutableList.of((Object)KV.of((Object)0, (Object)ImmutableList.of((Object)KV.of((Object)GlobalWindow.INSTANCE, (Object)WindowedValue.valueInGlobalWindow((Object)"a")), (Object)KV.of((Object)GlobalWindow.INSTANCE, (Object)WindowedValue.valueInGlobalWindow((Object)"b"))))));
    }

    @Test
    public void testBatchViewAsListToIsmRecordForGlobalWindow() throws Exception {
        DoFnTester doFnTester = DoFnTester.of((DoFn)new BatchViewOverrides.BatchViewAsList.ToIsmRecordForGlobalWindowDoFn());
        MatcherAssert.assertThat((Object)doFnTester.processBundle((Iterable)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")), (Matcher)Matchers.contains((Object[])new IsmFormat.IsmRecord[]{IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)GlobalWindow.INSTANCE, (Object)0L), (Object)WindowedValue.valueInGlobalWindow((Object)"a")), IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)GlobalWindow.INSTANCE, (Object)1L), (Object)WindowedValue.valueInGlobalWindow((Object)"b")), IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)GlobalWindow.INSTANCE, (Object)2L), (Object)WindowedValue.valueInGlobalWindow((Object)"c"))}));
    }

    @Test
    public void testBatchViewAsListToIsmRecordForNonGlobalWindow() throws Exception {
        DoFnTester doFnTester = DoFnTester.of((DoFn)new BatchViewOverrides.BatchViewAsList.ToIsmRecordForNonGlobalWindowDoFn(IntervalWindow.getCoder()));
        IntervalWindow windowA = new IntervalWindow(new Instant(0L), new Instant(10L));
        IntervalWindow windowB = new IntervalWindow(new Instant(10L), new Instant(20L));
        IntervalWindow windowC = new IntervalWindow(new Instant(20L), new Instant(30L));
        ImmutableList inputElements = ImmutableList.of((Object)KV.of((Object)1, (Object)ImmutableList.of((Object)KV.of((Object)windowA, (Object)WindowedValue.of((Object)110L, (Instant)new Instant(1L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)windowA, (Object)WindowedValue.of((Object)111L, (Instant)new Instant(3L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)windowA, (Object)WindowedValue.of((Object)112L, (Instant)new Instant(4L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)windowB, (Object)WindowedValue.of((Object)120L, (Instant)new Instant(12L), (BoundedWindow)windowB, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)windowB, (Object)WindowedValue.of((Object)121L, (Instant)new Instant(14L), (BoundedWindow)windowB, (PaneInfo)PaneInfo.NO_FIRING)))), (Object)KV.of((Object)2, (Object)ImmutableList.of((Object)KV.of((Object)windowC, (Object)WindowedValue.of((Object)210L, (Instant)new Instant(25L), (BoundedWindow)windowC, (PaneInfo)PaneInfo.NO_FIRING)))));
        MatcherAssert.assertThat((Object)doFnTester.processBundle((Iterable)inputElements), (Matcher)Matchers.contains((Object[])new IsmFormat.IsmRecord[]{IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)windowA, (Object)0L), (Object)WindowedValue.of((Object)110L, (Instant)new Instant(1L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)windowA, (Object)1L), (Object)WindowedValue.of((Object)111L, (Instant)new Instant(3L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)windowA, (Object)2L), (Object)WindowedValue.of((Object)112L, (Instant)new Instant(4L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)windowB, (Object)0L), (Object)WindowedValue.of((Object)120L, (Instant)new Instant(12L), (BoundedWindow)windowB, (PaneInfo)PaneInfo.NO_FIRING)), IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)windowB, (Object)1L), (Object)WindowedValue.of((Object)121L, (Instant)new Instant(14L), (BoundedWindow)windowB, (PaneInfo)PaneInfo.NO_FIRING)), IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)windowC, (Object)0L), (Object)WindowedValue.of((Object)210L, (Instant)new Instant(25L), (BoundedWindow)windowC, (PaneInfo)PaneInfo.NO_FIRING))}));
    }

    @Test
    public void testToIsmRecordForMapLikeDoFn() throws Exception {
        TupleTag outputForSizeTag = new TupleTag();
        TupleTag outputForEntrySetTag = new TupleTag();
        VarLongCoder keyCoder = VarLongCoder.of();
        Coder windowCoder = IntervalWindow.getCoder();
        IsmFormat.IsmRecordCoder ismCoder = IsmFormat.IsmRecordCoder.of((int)1, (int)2, (List)ImmutableList.of((Object)IsmFormat.MetadataKeyCoder.of((Coder)keyCoder), (Object)IntervalWindow.getCoder(), (Object)BigEndianLongCoder.of()), (Coder)WindowedValue.FullWindowedValueCoder.of((Coder)VarLongCoder.of(), (Coder)windowCoder));
        DoFnTester doFnTester = DoFnTester.of((DoFn)new BatchViewOverrides.BatchViewAsMultimap.ToIsmRecordForMapLikeDoFn(outputForSizeTag, outputForEntrySetTag, windowCoder, (Coder)keyCoder, ismCoder, false));
        IntervalWindow windowA = new IntervalWindow(new Instant(0L), new Instant(10L));
        IntervalWindow windowB = new IntervalWindow(new Instant(10L), new Instant(20L));
        IntervalWindow windowC = new IntervalWindow(new Instant(20L), new Instant(30L));
        ImmutableList inputElements = ImmutableList.of((Object)KV.of((Object)1, (Object)ImmutableList.of((Object)KV.of((Object)KV.of((Object)1L, (Object)windowA), (Object)WindowedValue.of((Object)110L, (Instant)new Instant(1L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)KV.of((Object)1L, (Object)windowA), (Object)WindowedValue.of((Object)111L, (Instant)new Instant(2L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)KV.of((Object)2L, (Object)windowA), (Object)WindowedValue.of((Object)120L, (Instant)new Instant(3L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)KV.of((Object)2L, (Object)windowB), (Object)WindowedValue.of((Object)210L, (Instant)new Instant(11L), (BoundedWindow)windowB, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)KV.of((Object)3L, (Object)windowB), (Object)WindowedValue.of((Object)220L, (Instant)new Instant(12L), (BoundedWindow)windowB, (PaneInfo)PaneInfo.NO_FIRING)))), (Object)KV.of((Object)2, (Object)ImmutableList.of((Object)KV.of((Object)KV.of((Object)4L, (Object)windowC), (Object)WindowedValue.of((Object)330L, (Instant)new Instant(21L), (BoundedWindow)windowC, (PaneInfo)PaneInfo.NO_FIRING)))));
        MatcherAssert.assertThat((Object)doFnTester.processBundle((Iterable)inputElements), (Matcher)Matchers.contains((Object[])new IsmFormat.IsmRecord[]{IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)1L, (Object)windowA, (Object)0L), (Object)WindowedValue.of((Object)110L, (Instant)new Instant(1L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)1L, (Object)windowA, (Object)1L), (Object)WindowedValue.of((Object)111L, (Instant)new Instant(2L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)2L, (Object)windowA, (Object)0L), (Object)WindowedValue.of((Object)120L, (Instant)new Instant(3L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)2L, (Object)windowB, (Object)0L), (Object)WindowedValue.of((Object)210L, (Instant)new Instant(11L), (BoundedWindow)windowB, (PaneInfo)PaneInfo.NO_FIRING)), IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)3L, (Object)windowB, (Object)0L), (Object)WindowedValue.of((Object)220L, (Instant)new Instant(12L), (BoundedWindow)windowB, (PaneInfo)PaneInfo.NO_FIRING)), IsmFormat.IsmRecord.of((List)ImmutableList.of((Object)4L, (Object)windowC, (Object)0L), (Object)WindowedValue.of((Object)330L, (Instant)new Instant(21L), (BoundedWindow)windowC, (PaneInfo)PaneInfo.NO_FIRING))}));
        MatcherAssert.assertThat((Object)doFnTester.takeOutputElements(outputForSizeTag), (Matcher)Matchers.contains((Object[])new KV[]{KV.of((Object)ismCoder.hash((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowA)), (Object)KV.of((Object)windowA, (Object)2L)), KV.of((Object)ismCoder.hash((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowB)), (Object)KV.of((Object)windowB, (Object)2L)), KV.of((Object)ismCoder.hash((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowC)), (Object)KV.of((Object)windowC, (Object)1L))}));
        MatcherAssert.assertThat((Object)doFnTester.takeOutputElements(outputForEntrySetTag), (Matcher)Matchers.contains((Object[])new KV[]{KV.of((Object)ismCoder.hash((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowA)), (Object)KV.of((Object)windowA, (Object)1L)), KV.of((Object)ismCoder.hash((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowA)), (Object)KV.of((Object)windowA, (Object)2L)), KV.of((Object)ismCoder.hash((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowB)), (Object)KV.of((Object)windowB, (Object)2L)), KV.of((Object)ismCoder.hash((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowB)), (Object)KV.of((Object)windowB, (Object)3L)), KV.of((Object)ismCoder.hash((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowC)), (Object)KV.of((Object)windowC, (Object)4L))}));
    }

    @Test
    public void testToIsmRecordForMapLikeDoFnWithoutUniqueKeysThrowsException() throws Exception {
        TupleTag outputForSizeTag = new TupleTag();
        TupleTag outputForEntrySetTag = new TupleTag();
        VarLongCoder keyCoder = VarLongCoder.of();
        Coder windowCoder = IntervalWindow.getCoder();
        IsmFormat.IsmRecordCoder ismCoder = IsmFormat.IsmRecordCoder.of((int)1, (int)2, (List)ImmutableList.of((Object)IsmFormat.MetadataKeyCoder.of((Coder)keyCoder), (Object)IntervalWindow.getCoder(), (Object)BigEndianLongCoder.of()), (Coder)WindowedValue.FullWindowedValueCoder.of((Coder)VarLongCoder.of(), (Coder)windowCoder));
        DoFnTester doFnTester = DoFnTester.of((DoFn)new BatchViewOverrides.BatchViewAsMultimap.ToIsmRecordForMapLikeDoFn(outputForSizeTag, outputForEntrySetTag, windowCoder, (Coder)keyCoder, ismCoder, true));
        IntervalWindow windowA = new IntervalWindow(new Instant(0L), new Instant(10L));
        ImmutableList inputElements = ImmutableList.of((Object)KV.of((Object)1, (Object)ImmutableList.of((Object)KV.of((Object)KV.of((Object)1L, (Object)windowA), (Object)WindowedValue.of((Object)110L, (Instant)new Instant(1L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)KV.of((Object)1L, (Object)windowA), (Object)WindowedValue.of((Object)111L, (Instant)new Instant(2L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)))));
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Unique keys are expected but found key");
        doFnTester.processBundle((Iterable)inputElements);
    }

    @Test
    public void testToIsmMetadataRecordForSizeDoFn() throws Exception {
        VarLongCoder keyCoder = VarLongCoder.of();
        Coder windowCoder = IntervalWindow.getCoder();
        IsmFormat.IsmRecordCoder ismCoder = IsmFormat.IsmRecordCoder.of((int)1, (int)2, (List)ImmutableList.of((Object)IsmFormat.MetadataKeyCoder.of((Coder)keyCoder), (Object)IntervalWindow.getCoder(), (Object)BigEndianLongCoder.of()), (Coder)WindowedValue.FullWindowedValueCoder.of((Coder)VarLongCoder.of(), (Coder)windowCoder));
        DoFnTester doFnTester = DoFnTester.of((DoFn)new BatchViewOverrides.BatchViewAsMultimap.ToIsmMetadataRecordForSizeDoFn(windowCoder));
        IntervalWindow windowA = new IntervalWindow(new Instant(0L), new Instant(10L));
        IntervalWindow windowB = new IntervalWindow(new Instant(10L), new Instant(20L));
        IntervalWindow windowC = new IntervalWindow(new Instant(20L), new Instant(30L));
        ImmutableList inputElements = ImmutableList.of((Object)KV.of((Object)1, (Object)ImmutableList.of((Object)KV.of((Object)windowA, (Object)2L), (Object)KV.of((Object)windowA, (Object)3L), (Object)KV.of((Object)windowB, (Object)7L))), (Object)KV.of((Object)ismCoder.hash((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowB)), (Object)ImmutableList.of((Object)KV.of((Object)windowC, (Object)9L))));
        MatcherAssert.assertThat((Object)doFnTester.processBundle((Iterable)inputElements), (Matcher)Matchers.contains((Object[])new IsmFormat.IsmRecord[]{IsmFormat.IsmRecord.meta((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowA, (Object)0L), (byte[])CoderUtils.encodeToByteArray((Coder)VarLongCoder.of(), (Object)5L)), IsmFormat.IsmRecord.meta((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowB, (Object)0L), (byte[])CoderUtils.encodeToByteArray((Coder)VarLongCoder.of(), (Object)7L)), IsmFormat.IsmRecord.meta((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowC, (Object)0L), (byte[])CoderUtils.encodeToByteArray((Coder)VarLongCoder.of(), (Object)9L))}));
    }

    @Test
    public void testToIsmMetadataRecordForKeyDoFn() throws Exception {
        VarLongCoder keyCoder = VarLongCoder.of();
        Coder windowCoder = IntervalWindow.getCoder();
        IsmFormat.IsmRecordCoder ismCoder = IsmFormat.IsmRecordCoder.of((int)1, (int)2, (List)ImmutableList.of((Object)IsmFormat.MetadataKeyCoder.of((Coder)keyCoder), (Object)IntervalWindow.getCoder(), (Object)BigEndianLongCoder.of()), (Coder)WindowedValue.FullWindowedValueCoder.of((Coder)VarLongCoder.of(), (Coder)windowCoder));
        DoFnTester doFnTester = DoFnTester.of((DoFn)new BatchViewOverrides.BatchViewAsMultimap.ToIsmMetadataRecordForKeyDoFn((Coder)keyCoder, windowCoder));
        IntervalWindow windowA = new IntervalWindow(new Instant(0L), new Instant(10L));
        IntervalWindow windowB = new IntervalWindow(new Instant(10L), new Instant(20L));
        IntervalWindow windowC = new IntervalWindow(new Instant(20L), new Instant(30L));
        ImmutableList inputElements = ImmutableList.of((Object)KV.of((Object)1, (Object)ImmutableList.of((Object)KV.of((Object)windowA, (Object)2L), (Object)KV.of((Object)windowA, (Object)3L), (Object)KV.of((Object)windowB, (Object)3L))), (Object)KV.of((Object)ismCoder.hash((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowB)), (Object)ImmutableList.of((Object)KV.of((Object)windowC, (Object)3L))));
        MatcherAssert.assertThat((Object)doFnTester.processBundle((Iterable)inputElements), (Matcher)Matchers.contains((Object[])new IsmFormat.IsmRecord[]{IsmFormat.IsmRecord.meta((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowA, (Object)1L), (byte[])CoderUtils.encodeToByteArray((Coder)VarLongCoder.of(), (Object)2L)), IsmFormat.IsmRecord.meta((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowA, (Object)2L), (byte[])CoderUtils.encodeToByteArray((Coder)VarLongCoder.of(), (Object)3L)), IsmFormat.IsmRecord.meta((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowB, (Object)1L), (byte[])CoderUtils.encodeToByteArray((Coder)VarLongCoder.of(), (Object)3L)), IsmFormat.IsmRecord.meta((List)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)windowC, (Object)1L), (byte[])CoderUtils.encodeToByteArray((Coder)VarLongCoder.of(), (Object)3L))}));
    }

    @Test
    public void testToMapDoFn() throws Exception {
        Coder windowCoder = IntervalWindow.getCoder();
        DoFnTester doFnTester = DoFnTester.of((DoFn)new BatchViewOverrides.BatchViewAsMap.ToMapDoFn(windowCoder));
        IntervalWindow windowA = new IntervalWindow(new Instant(0L), new Instant(10L));
        IntervalWindow windowB = new IntervalWindow(new Instant(10L), new Instant(20L));
        IntervalWindow windowC = new IntervalWindow(new Instant(20L), new Instant(30L));
        ImmutableList inputElements = ImmutableList.of((Object)KV.of((Object)1, (Object)ImmutableList.of((Object)KV.of((Object)windowA, (Object)WindowedValue.of((Object)KV.of((Object)1L, (Object)11L), (Instant)new Instant(3L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)windowA, (Object)WindowedValue.of((Object)KV.of((Object)2L, (Object)21L), (Instant)new Instant(7L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)windowB, (Object)WindowedValue.of((Object)KV.of((Object)2L, (Object)21L), (Instant)new Instant(13L), (BoundedWindow)windowB, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)windowB, (Object)WindowedValue.of((Object)KV.of((Object)3L, (Object)31L), (Instant)new Instant(15L), (BoundedWindow)windowB, (PaneInfo)PaneInfo.NO_FIRING)))), (Object)KV.of((Object)2, (Object)ImmutableList.of((Object)KV.of((Object)windowC, (Object)WindowedValue.of((Object)KV.of((Object)4L, (Object)41L), (Instant)new Instant(25L), (BoundedWindow)windowC, (PaneInfo)PaneInfo.NO_FIRING)))));
        List output = doFnTester.processBundle((Iterable)inputElements);
        Assert.assertEquals((long)3L, (long)output.size());
        Map outputMap = (Map)((WindowedValue)((IsmFormat.IsmRecord)output.get(0)).getValue()).getValue();
        Assert.assertEquals((long)2L, (long)outputMap.size());
        Assert.assertEquals((Object)ImmutableMap.of((Object)1L, (Object)11L, (Object)2L, (Object)21L), (Object)outputMap);
        outputMap = (Map)((WindowedValue)((IsmFormat.IsmRecord)output.get(1)).getValue()).getValue();
        Assert.assertEquals((long)2L, (long)outputMap.size());
        Assert.assertEquals((Object)ImmutableMap.of((Object)2L, (Object)21L, (Object)3L, (Object)31L), (Object)outputMap);
        outputMap = (Map)((WindowedValue)((IsmFormat.IsmRecord)output.get(2)).getValue()).getValue();
        Assert.assertEquals((long)1L, (long)outputMap.size());
        Assert.assertEquals((Object)ImmutableMap.of((Object)4L, (Object)41L), (Object)outputMap);
    }

    @Test
    public void testToMultimapDoFn() throws Exception {
        Coder windowCoder = IntervalWindow.getCoder();
        DoFnTester doFnTester = DoFnTester.of((DoFn)new BatchViewOverrides.BatchViewAsMultimap.ToMultimapDoFn(windowCoder));
        IntervalWindow windowA = new IntervalWindow(new Instant(0L), new Instant(10L));
        IntervalWindow windowB = new IntervalWindow(new Instant(10L), new Instant(20L));
        IntervalWindow windowC = new IntervalWindow(new Instant(20L), new Instant(30L));
        ImmutableList inputElements = ImmutableList.of((Object)KV.of((Object)1, (Object)ImmutableList.of((Object)KV.of((Object)windowA, (Object)WindowedValue.of((Object)KV.of((Object)1L, (Object)11L), (Instant)new Instant(3L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)windowA, (Object)WindowedValue.of((Object)KV.of((Object)1L, (Object)11L), (Instant)new Instant(3L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)windowA, (Object)WindowedValue.of((Object)KV.of((Object)1L, (Object)12L), (Instant)new Instant(5L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)windowA, (Object)WindowedValue.of((Object)KV.of((Object)2L, (Object)21L), (Instant)new Instant(7L), (BoundedWindow)windowA, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)windowB, (Object)WindowedValue.of((Object)KV.of((Object)2L, (Object)21L), (Instant)new Instant(13L), (BoundedWindow)windowB, (PaneInfo)PaneInfo.NO_FIRING)), (Object)KV.of((Object)windowB, (Object)WindowedValue.of((Object)KV.of((Object)3L, (Object)31L), (Instant)new Instant(15L), (BoundedWindow)windowB, (PaneInfo)PaneInfo.NO_FIRING)))), (Object)KV.of((Object)2, (Object)ImmutableList.of((Object)KV.of((Object)windowC, (Object)WindowedValue.of((Object)KV.of((Object)4L, (Object)41L), (Instant)new Instant(25L), (BoundedWindow)windowC, (PaneInfo)PaneInfo.NO_FIRING)))));
        List output = doFnTester.processBundle((Iterable)inputElements);
        Assert.assertEquals((long)3L, (long)output.size());
        Map outputMap = (Map)((WindowedValue)((IsmFormat.IsmRecord)output.get(0)).getValue()).getValue();
        Assert.assertEquals((long)2L, (long)outputMap.size());
        MatcherAssert.assertThat((Object)((Iterable)outputMap.get(1L)), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{11L, 11L, 12L}));
        MatcherAssert.assertThat((Object)((Iterable)outputMap.get(2L)), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{21L}));
        outputMap = (Map)((WindowedValue)((IsmFormat.IsmRecord)output.get(1)).getValue()).getValue();
        Assert.assertEquals((long)2L, (long)outputMap.size());
        MatcherAssert.assertThat((Object)((Iterable)outputMap.get(2L)), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{21L}));
        MatcherAssert.assertThat((Object)((Iterable)outputMap.get(3L)), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{31L}));
        outputMap = (Map)((WindowedValue)((IsmFormat.IsmRecord)output.get(2)).getValue()).getValue();
        Assert.assertEquals((long)1L, (long)outputMap.size());
        MatcherAssert.assertThat((Object)((Iterable)outputMap.get(4L)), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{41L}));
    }
}

