/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.google.api.client.util.ArrayMap;
import com.google.api.services.dataflow.Dataflow;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.JobMetrics;
import com.google.api.services.dataflow.model.MetricStructuredName;
import com.google.api.services.dataflow.model.MetricUpdate;
import com.google.auth.Credentials;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.runners.core.metrics.BoundedTrieData;
import org.apache.beam.runners.dataflow.DataflowClient;
import org.apache.beam.runners.dataflow.DataflowMetrics;
import org.apache.beam.runners.dataflow.DataflowPipelineJob;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.dataflow.TestDataflowPipelineOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.DataflowTemplateJob;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.gcp.auth.TestCredential;
import org.apache.beam.sdk.extensions.gcp.storage.NoopPathValidator;
import org.apache.beam.sdk.metrics.BoundedTrieResult;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResultsMatchers;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.metrics.StringSetResult;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashBiMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class DataflowMetricsTest {
    private static final String PROJECT_ID = "some-project";
    private static final String JOB_ID = "1234";
    @Mock
    private Dataflow mockWorkflowClient;
    @Mock
    private Dataflow.Projects mockProjects;
    @Mock
    private Dataflow.Projects.Locations mockLocations;
    @Mock
    private Dataflow.Projects.Locations.Jobs mockJobs;
    private TestDataflowPipelineOptions options;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockWorkflowClient.projects()).thenReturn((Object)this.mockProjects);
        Mockito.when((Object)this.mockProjects.locations()).thenReturn((Object)this.mockLocations);
        Mockito.when((Object)this.mockLocations.jobs()).thenReturn((Object)this.mockJobs);
        this.options = (TestDataflowPipelineOptions)PipelineOptionsFactory.as(TestDataflowPipelineOptions.class);
        this.options.setDataflowClient(this.mockWorkflowClient);
        this.options.setProject(PROJECT_ID);
        this.options.setRunner(DataflowRunner.class);
        this.options.setTempLocation("gs://fakebucket/temp");
        this.options.setPathValidatorClass(NoopPathValidator.class);
        this.options.setGcpCredential((Credentials)new TestCredential());
    }

    @Test
    public void testEmptyMetricUpdates() throws IOException {
        Job modelJob = new Job();
        modelJob.setCurrentState(PipelineResult.State.RUNNING.toString());
        DataflowPipelineJob job = (DataflowPipelineJob)Mockito.mock(DataflowPipelineJob.class);
        DataflowPipelineOptions options = (DataflowPipelineOptions)Mockito.mock(DataflowPipelineOptions.class);
        Mockito.when((Object)options.isStreaming()).thenReturn((Object)false);
        Mockito.when((Object)job.getDataflowOptions()).thenReturn((Object)options);
        Mockito.when((Object)job.getState()).thenReturn((Object)PipelineResult.State.RUNNING);
        Mockito.when((Object)job.getJobId()).thenReturn((Object)JOB_ID);
        JobMetrics jobMetrics = new JobMetrics();
        jobMetrics.setMetrics(null);
        DataflowClient dataflowClient = (DataflowClient)Mockito.mock(DataflowClient.class);
        Mockito.when((Object)dataflowClient.getJobMetrics(JOB_ID)).thenReturn((Object)jobMetrics);
        DataflowMetrics dataflowMetrics = new DataflowMetrics(job, dataflowClient);
        MetricQueryResults result = dataflowMetrics.allMetrics();
        MatcherAssert.assertThat((Object)ImmutableList.copyOf((Iterable)result.getCounters()), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)ImmutableList.copyOf((Iterable)result.getDistributions()), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)ImmutableList.copyOf((Iterable)result.getStringSets()), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)ImmutableList.copyOf((Iterable)result.getBoundedTries()), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testCachingMetricUpdates() throws IOException {
        Job modelJob = new Job();
        modelJob.setCurrentState(PipelineResult.State.RUNNING.toString());
        DataflowPipelineJob job = (DataflowPipelineJob)Mockito.mock(DataflowPipelineJob.class);
        DataflowPipelineOptions options = (DataflowPipelineOptions)Mockito.mock(DataflowPipelineOptions.class);
        Mockito.when((Object)options.isStreaming()).thenReturn((Object)false);
        Mockito.when((Object)job.getDataflowOptions()).thenReturn((Object)options);
        Mockito.when((Object)job.getState()).thenReturn((Object)PipelineResult.State.DONE);
        Mockito.when((Object)job.getJobId()).thenReturn((Object)JOB_ID);
        JobMetrics jobMetrics = new JobMetrics();
        jobMetrics.setMetrics((List)ImmutableList.of());
        DataflowClient dataflowClient = (DataflowClient)Mockito.mock(DataflowClient.class);
        Mockito.when((Object)dataflowClient.getJobMetrics(JOB_ID)).thenReturn((Object)jobMetrics);
        DataflowMetrics dataflowMetrics = new DataflowMetrics(job, dataflowClient);
        ((DataflowClient)Mockito.verify((Object)dataflowClient, (VerificationMode)Mockito.times((int)0))).getJobMetrics(JOB_ID);
        dataflowMetrics.allMetrics();
        ((DataflowClient)Mockito.verify((Object)dataflowClient, (VerificationMode)Mockito.times((int)1))).getJobMetrics(JOB_ID);
        dataflowMetrics.allMetrics();
        ((DataflowClient)Mockito.verify((Object)dataflowClient, (VerificationMode)Mockito.times((int)1))).getJobMetrics(JOB_ID);
    }

    private MetricUpdate setStructuredName(MetricUpdate update, String name, String namespace, String step, boolean tentative) {
        MetricStructuredName structuredName = new MetricStructuredName();
        structuredName.setName(name);
        structuredName.setOrigin("user");
        ImmutableMap.Builder contextBuilder = new ImmutableMap.Builder();
        contextBuilder.put((Object)"step", (Object)step).put((Object)"namespace", (Object)namespace);
        if (tentative) {
            contextBuilder.put((Object)"tentative", (Object)"true");
        }
        structuredName.setContext((Map)contextBuilder.build());
        update.setName(structuredName);
        return update;
    }

    private MetricUpdate makeDistributionMetricUpdate(String name, String namespace, String step, Long sum, Long count, Long min, Long max, boolean tentative) {
        MetricUpdate update = new MetricUpdate();
        ArrayMap distribution = ArrayMap.create();
        distribution.add((Object)"count", (Object)new BigDecimal(count));
        distribution.add((Object)"mean", (Object)new BigDecimal(sum / count));
        distribution.add((Object)"sum", (Object)new BigDecimal(sum));
        distribution.add((Object)"min", (Object)new BigDecimal(min));
        distribution.add((Object)"max", (Object)new BigDecimal(max));
        update.setDistribution((Object)distribution);
        return this.setStructuredName(update, name, namespace, step, tentative);
    }

    private MetricUpdate makeCounterMetricUpdate(String name, String namespace, String step, long scalar, boolean tentative) {
        MetricUpdate update = new MetricUpdate();
        update.setScalar((Object)new BigDecimal(scalar));
        return this.setStructuredName(update, name, namespace, step, tentative);
    }

    private MetricUpdate makeStringSetMetricUpdate(String name, String namespace, String step, Set<String> setValues, boolean tentative) {
        MetricUpdate update = new MetricUpdate();
        update.setSet(setValues);
        return this.setStructuredName(update, name, namespace, step, tentative);
    }

    private MetricUpdate makeBoundedTrieMetricUpdate(String name, String namespace, String step, MetricsApi.BoundedTrie data, boolean tentative) {
        MetricUpdate update = new MetricUpdate();
        update.setTrie((Object)data);
        return this.setStructuredName(update, name, namespace, step, tentative);
    }

    @Test
    public void testSingleCounterUpdates() throws IOException {
        AppliedPTransform myStep = (AppliedPTransform)Mockito.mock(AppliedPTransform.class);
        Mockito.when((Object)myStep.getFullName()).thenReturn((Object)"myStepName");
        HashBiMap transformStepNames = HashBiMap.create();
        transformStepNames.put((Object)myStep, (Object)"s2");
        JobMetrics jobMetrics = new JobMetrics();
        DataflowPipelineJob job = (DataflowPipelineJob)Mockito.mock(DataflowPipelineJob.class);
        DataflowPipelineOptions options = (DataflowPipelineOptions)Mockito.mock(DataflowPipelineOptions.class);
        Mockito.when((Object)options.isStreaming()).thenReturn((Object)false);
        Mockito.when((Object)job.getDataflowOptions()).thenReturn((Object)options);
        Mockito.when((Object)job.getState()).thenReturn((Object)PipelineResult.State.RUNNING);
        Mockito.when((Object)job.getJobId()).thenReturn((Object)JOB_ID);
        Mockito.when((Object)job.getTransformStepNames()).thenReturn((Object)transformStepNames);
        MetricUpdate update = new MetricUpdate();
        long stepValue = 1234L;
        update.setScalar((Object)new BigDecimal(stepValue));
        MetricUpdate mu1 = this.makeCounterMetricUpdate("counterName", "counterNamespace", "s2", 1234L, false);
        MetricUpdate mu1Tentative = this.makeCounterMetricUpdate("counterName", "counterNamespace", "s2", 1233L, true);
        jobMetrics.setMetrics((List)ImmutableList.of((Object)mu1, (Object)mu1Tentative));
        DataflowClient dataflowClient = (DataflowClient)Mockito.mock(DataflowClient.class);
        Mockito.when((Object)dataflowClient.getJobMetrics(JOB_ID)).thenReturn((Object)jobMetrics);
        DataflowMetrics dataflowMetrics = new DataflowMetrics(job, dataflowClient);
        MetricQueryResults result = dataflowMetrics.allMetrics();
        MatcherAssert.assertThat((Object)result.getCounters(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{MetricResultsMatchers.attemptedMetricsResult((String)"counterNamespace", (String)"counterName", (String)"myStepName", (Object)1234L)}));
        MatcherAssert.assertThat((Object)result.getCounters(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{MetricResultsMatchers.committedMetricsResult((String)"counterNamespace", (String)"counterName", (String)"myStepName", (Object)1234L)}));
    }

    @Test
    public void testSingleStringSetUpdates() throws IOException {
        AppliedPTransform myStep = (AppliedPTransform)Mockito.mock(AppliedPTransform.class);
        Mockito.when((Object)myStep.getFullName()).thenReturn((Object)"myStepName");
        HashBiMap transformStepNames = HashBiMap.create();
        transformStepNames.put((Object)myStep, (Object)"s2");
        JobMetrics jobMetrics = new JobMetrics();
        DataflowPipelineJob job = (DataflowPipelineJob)Mockito.mock(DataflowPipelineJob.class);
        DataflowPipelineOptions options = (DataflowPipelineOptions)Mockito.mock(DataflowPipelineOptions.class);
        Mockito.when((Object)options.isStreaming()).thenReturn((Object)false);
        Mockito.when((Object)job.getDataflowOptions()).thenReturn((Object)options);
        Mockito.when((Object)job.getState()).thenReturn((Object)PipelineResult.State.RUNNING);
        Mockito.when((Object)job.getJobId()).thenReturn((Object)JOB_ID);
        Mockito.when((Object)job.getTransformStepNames()).thenReturn((Object)transformStepNames);
        MetricUpdate mu1 = this.makeStringSetMetricUpdate("counterName", "counterNamespace", "s2", (Set<String>)ImmutableSet.of((Object)"ab", (Object)"cd"), false);
        MetricUpdate mu1Tentative = this.makeStringSetMetricUpdate("counterName", "counterNamespace", "s2", (Set<String>)ImmutableSet.of((Object)"ab", (Object)"cd"), true);
        jobMetrics.setMetrics((List)ImmutableList.of((Object)mu1, (Object)mu1Tentative));
        DataflowClient dataflowClient = (DataflowClient)Mockito.mock(DataflowClient.class);
        Mockito.when((Object)dataflowClient.getJobMetrics(JOB_ID)).thenReturn((Object)jobMetrics);
        DataflowMetrics dataflowMetrics = new DataflowMetrics(job, dataflowClient);
        MetricQueryResults result = dataflowMetrics.allMetrics();
        MatcherAssert.assertThat((Object)result.getStringSets(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{MetricResultsMatchers.attemptedMetricsResult((String)"counterNamespace", (String)"counterName", (String)"myStepName", (Object)StringSetResult.create((Set)ImmutableSet.of((Object)"ab", (Object)"cd")))}));
        MatcherAssert.assertThat((Object)result.getStringSets(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{MetricResultsMatchers.committedMetricsResult((String)"counterNamespace", (String)"counterName", (String)"myStepName", (Object)StringSetResult.create((Set)ImmutableSet.of((Object)"ab", (Object)"cd")))}));
    }

    @Test
    public void testSingleBoundedTrieUpdates() throws IOException {
        AppliedPTransform myStep = (AppliedPTransform)Mockito.mock(AppliedPTransform.class);
        Mockito.when((Object)myStep.getFullName()).thenReturn((Object)"myStepName");
        HashBiMap transformStepNames = HashBiMap.create();
        transformStepNames.put((Object)myStep, (Object)"s2");
        JobMetrics jobMetrics = new JobMetrics();
        DataflowPipelineJob job = (DataflowPipelineJob)Mockito.mock(DataflowPipelineJob.class);
        DataflowPipelineOptions options = (DataflowPipelineOptions)Mockito.mock(DataflowPipelineOptions.class);
        Mockito.when((Object)options.isStreaming()).thenReturn((Object)false);
        Mockito.when((Object)job.getDataflowOptions()).thenReturn((Object)options);
        Mockito.when((Object)job.getState()).thenReturn((Object)PipelineResult.State.RUNNING);
        Mockito.when((Object)job.getJobId()).thenReturn((Object)JOB_ID);
        Mockito.when((Object)job.getTransformStepNames()).thenReturn((Object)transformStepNames);
        MetricUpdate mu1 = this.makeBoundedTrieMetricUpdate("counterName", "counterNamespace", "s2", new BoundedTrieData((List)ImmutableList.of((Object)"ab", (Object)"cd")).toProto(), false);
        MetricUpdate mu1Tentative = this.makeBoundedTrieMetricUpdate("counterName", "counterNamespace", "s2", new BoundedTrieData((List)ImmutableList.of((Object)"ab", (Object)"cd")).toProto(), true);
        jobMetrics.setMetrics((List)ImmutableList.of((Object)mu1, (Object)mu1Tentative));
        DataflowClient dataflowClient = (DataflowClient)Mockito.mock(DataflowClient.class);
        Mockito.when((Object)dataflowClient.getJobMetrics(JOB_ID)).thenReturn((Object)jobMetrics);
        DataflowMetrics dataflowMetrics = new DataflowMetrics(job, dataflowClient);
        MetricQueryResults result = dataflowMetrics.allMetrics();
        MatcherAssert.assertThat((Object)result.getBoundedTries(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{MetricResultsMatchers.attemptedMetricsResult((String)"counterNamespace", (String)"counterName", (String)"myStepName", (Object)BoundedTrieResult.create((Set)ImmutableSet.of((Object)ImmutableList.of((Object)"ab", (Object)"cd", (Object)String.valueOf(false)))))}));
        MatcherAssert.assertThat((Object)result.getBoundedTries(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{MetricResultsMatchers.committedMetricsResult((String)"counterNamespace", (String)"counterName", (String)"myStepName", (Object)BoundedTrieResult.create((Set)ImmutableSet.of((Object)ImmutableList.of((Object)"ab", (Object)"cd", (Object)String.valueOf(false)))))}));
    }

    @Test
    public void testIgnoreDistributionButGetCounterUpdates() throws IOException {
        AppliedPTransform myStep = (AppliedPTransform)Mockito.mock(AppliedPTransform.class);
        Mockito.when((Object)myStep.getFullName()).thenReturn((Object)"myStepName");
        HashBiMap transformStepNames = HashBiMap.create();
        transformStepNames.put((Object)myStep, (Object)"s2");
        JobMetrics jobMetrics = new JobMetrics();
        DataflowClient dataflowClient = (DataflowClient)Mockito.mock(DataflowClient.class);
        Mockito.when((Object)dataflowClient.getJobMetrics(JOB_ID)).thenReturn((Object)jobMetrics);
        DataflowPipelineJob job = (DataflowPipelineJob)Mockito.mock(DataflowPipelineJob.class);
        DataflowPipelineOptions options = (DataflowPipelineOptions)Mockito.mock(DataflowPipelineOptions.class);
        Mockito.when((Object)options.isStreaming()).thenReturn((Object)false);
        Mockito.when((Object)job.getDataflowOptions()).thenReturn((Object)options);
        Mockito.when((Object)job.getState()).thenReturn((Object)PipelineResult.State.RUNNING);
        Mockito.when((Object)job.getJobId()).thenReturn((Object)JOB_ID);
        Mockito.when((Object)job.getTransformStepNames()).thenReturn((Object)transformStepNames);
        jobMetrics.setMetrics((List)ImmutableList.of((Object)this.makeCounterMetricUpdate("counterName", "counterNamespace", "s2", 1233L, false), (Object)this.makeCounterMetricUpdate("counterName", "counterNamespace", "s2", 1233L, true), (Object)this.makeCounterMetricUpdate("otherCounter[MIN]", "otherNamespace", "s2", 0L, false), (Object)this.makeCounterMetricUpdate("otherCounter[MIN]", "otherNamespace", "s2", 0L, true)));
        DataflowMetrics dataflowMetrics = new DataflowMetrics(job, dataflowClient);
        MetricQueryResults result = dataflowMetrics.allMetrics();
        MatcherAssert.assertThat((Object)result.getCounters(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{MetricResultsMatchers.attemptedMetricsResult((String)"counterNamespace", (String)"counterName", (String)"myStepName", (Object)1233L)}));
        MatcherAssert.assertThat((Object)result.getCounters(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{MetricResultsMatchers.committedMetricsResult((String)"counterNamespace", (String)"counterName", (String)"myStepName", (Object)1233L)}));
    }

    @Test
    public void testDistributionUpdates() throws IOException {
        AppliedPTransform myStep2 = (AppliedPTransform)Mockito.mock(AppliedPTransform.class);
        Mockito.when((Object)myStep2.getFullName()).thenReturn((Object)"myStepName");
        HashBiMap transformStepNames = HashBiMap.create();
        transformStepNames.put((Object)myStep2, (Object)"s2");
        JobMetrics jobMetrics = new JobMetrics();
        DataflowClient dataflowClient = (DataflowClient)Mockito.mock(DataflowClient.class);
        Mockito.when((Object)dataflowClient.getJobMetrics(JOB_ID)).thenReturn((Object)jobMetrics);
        DataflowPipelineJob job = (DataflowPipelineJob)Mockito.mock(DataflowPipelineJob.class);
        DataflowPipelineOptions options = (DataflowPipelineOptions)Mockito.mock(DataflowPipelineOptions.class);
        Mockito.when((Object)options.isStreaming()).thenReturn((Object)false);
        Mockito.when((Object)job.getDataflowOptions()).thenReturn((Object)options);
        Mockito.when((Object)job.getState()).thenReturn((Object)PipelineResult.State.RUNNING);
        Mockito.when((Object)job.getJobId()).thenReturn((Object)JOB_ID);
        Mockito.when((Object)job.getTransformStepNames()).thenReturn((Object)transformStepNames);
        jobMetrics.setMetrics((List)ImmutableList.of((Object)this.makeDistributionMetricUpdate("distributionName", "distributionNamespace", "s2", 18L, 2L, 2L, 16L, false), (Object)this.makeDistributionMetricUpdate("distributionName", "distributionNamespace", "s2", 18L, 2L, 2L, 16L, true)));
        DataflowMetrics dataflowMetrics = new DataflowMetrics(job, dataflowClient);
        MetricQueryResults result = dataflowMetrics.allMetrics();
        MatcherAssert.assertThat((Object)result.getDistributions(), (Matcher)Matchers.contains((Matcher)MetricResultsMatchers.attemptedMetricsResult((String)"distributionNamespace", (String)"distributionName", (String)"myStepName", (Object)DistributionResult.create((long)18L, (long)2L, (long)2L, (long)16L))));
        MatcherAssert.assertThat((Object)result.getDistributions(), (Matcher)Matchers.contains((Matcher)MetricResultsMatchers.committedMetricsResult((String)"distributionNamespace", (String)"distributionName", (String)"myStepName", (Object)DistributionResult.create((long)18L, (long)2L, (long)2L, (long)16L))));
    }

    @Test
    public void testDistributionUpdatesStreaming() throws IOException {
        AppliedPTransform myStep2 = (AppliedPTransform)Mockito.mock(AppliedPTransform.class);
        Mockito.when((Object)myStep2.getFullName()).thenReturn((Object)"myStepName");
        HashBiMap transformStepNames = HashBiMap.create();
        transformStepNames.put((Object)myStep2, (Object)"s2");
        JobMetrics jobMetrics = new JobMetrics();
        DataflowClient dataflowClient = (DataflowClient)Mockito.mock(DataflowClient.class);
        Mockito.when((Object)dataflowClient.getJobMetrics(JOB_ID)).thenReturn((Object)jobMetrics);
        DataflowPipelineJob job = (DataflowPipelineJob)Mockito.mock(DataflowPipelineJob.class);
        DataflowPipelineOptions options = (DataflowPipelineOptions)Mockito.mock(DataflowPipelineOptions.class);
        Mockito.when((Object)options.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)job.getDataflowOptions()).thenReturn((Object)options);
        Mockito.when((Object)job.getState()).thenReturn((Object)PipelineResult.State.RUNNING);
        Mockito.when((Object)job.getJobId()).thenReturn((Object)JOB_ID);
        Mockito.when((Object)job.getTransformStepNames()).thenReturn((Object)transformStepNames);
        jobMetrics.setMetrics((List)ImmutableList.of((Object)this.makeDistributionMetricUpdate("distributionName", "distributionNamespace", "s2", 18L, 2L, 2L, 16L, false), (Object)this.makeDistributionMetricUpdate("distributionName", "distributionNamespace", "s2", 18L, 2L, 2L, 16L, true)));
        DataflowMetrics dataflowMetrics = new DataflowMetrics(job, dataflowClient);
        MetricQueryResults result = dataflowMetrics.allMetrics();
        try {
            ((MetricResult)result.getDistributions().iterator().next()).getCommitted();
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException expected) {
            MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)Matchers.containsString((String)"This runner does not currently support committed metrics results. Please use 'attempted' instead."));
        }
        MatcherAssert.assertThat((Object)result.getDistributions(), (Matcher)Matchers.contains((Matcher)MetricResultsMatchers.attemptedMetricsResult((String)"distributionNamespace", (String)"distributionName", (String)"myStepName", (Object)DistributionResult.create((long)18L, (long)2L, (long)2L, (long)16L))));
    }

    @Test
    public void testMultipleCounterUpdates() throws IOException {
        AppliedPTransform myStep2 = (AppliedPTransform)Mockito.mock(AppliedPTransform.class);
        Mockito.when((Object)myStep2.getFullName()).thenReturn((Object)"myStepName");
        HashBiMap transformStepNames = HashBiMap.create();
        transformStepNames.put((Object)myStep2, (Object)"s2");
        AppliedPTransform myStep3 = (AppliedPTransform)Mockito.mock(AppliedPTransform.class);
        Mockito.when((Object)myStep3.getFullName()).thenReturn((Object)"myStepName3");
        transformStepNames.put((Object)myStep3, (Object)"s3");
        AppliedPTransform myStep4 = (AppliedPTransform)Mockito.mock(AppliedPTransform.class);
        Mockito.when((Object)myStep4.getFullName()).thenReturn((Object)"myStepName4");
        transformStepNames.put((Object)myStep4, (Object)"s4");
        JobMetrics jobMetrics = new JobMetrics();
        DataflowClient dataflowClient = (DataflowClient)Mockito.mock(DataflowClient.class);
        Mockito.when((Object)dataflowClient.getJobMetrics(JOB_ID)).thenReturn((Object)jobMetrics);
        DataflowPipelineJob job = (DataflowPipelineJob)Mockito.mock(DataflowPipelineJob.class);
        DataflowPipelineOptions options = (DataflowPipelineOptions)Mockito.mock(DataflowPipelineOptions.class);
        Mockito.when((Object)options.isStreaming()).thenReturn((Object)false);
        Mockito.when((Object)job.getDataflowOptions()).thenReturn((Object)options);
        Mockito.when((Object)job.getState()).thenReturn((Object)PipelineResult.State.RUNNING);
        Mockito.when((Object)job.getJobId()).thenReturn((Object)JOB_ID);
        Mockito.when((Object)job.getTransformStepNames()).thenReturn((Object)transformStepNames);
        jobMetrics.setMetrics((List)ImmutableList.of((Object)this.makeCounterMetricUpdate("counterName", "counterNamespace", "s2", 1233L, false), (Object)this.makeCounterMetricUpdate("counterName", "counterNamespace", "s2", 1234L, true), (Object)this.makeCounterMetricUpdate("otherCounter", "otherNamespace", "s3", 12L, false), (Object)this.makeCounterMetricUpdate("otherCounter", "otherNamespace", "s3", 12L, true), (Object)this.makeCounterMetricUpdate("counterName", "otherNamespace", "s4", 1200L, false), (Object)this.makeCounterMetricUpdate("counterName", "otherNamespace", "s4", 1233L, true), (Object)this.makeCounterMetricUpdate("lostName", "otherNamespace", "s5", 1200L, false), (Object)this.makeCounterMetricUpdate("lostName", "otherNamespace", "s5", 1200L, true)));
        DataflowMetrics dataflowMetrics = new DataflowMetrics(job, dataflowClient);
        MetricQueryResults result = dataflowMetrics.allMetrics();
        MatcherAssert.assertThat((Object)result.getCounters(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{MetricResultsMatchers.attemptedMetricsResult((String)"counterNamespace", (String)"counterName", (String)"myStepName", (Object)1233L), MetricResultsMatchers.attemptedMetricsResult((String)"otherNamespace", (String)"otherCounter", (String)"myStepName3", (Object)12L), MetricResultsMatchers.attemptedMetricsResult((String)"otherNamespace", (String)"counterName", (String)"myStepName4", (Object)1200L)}));
        MatcherAssert.assertThat((Object)result.getCounters(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{MetricResultsMatchers.committedMetricsResult((String)"counterNamespace", (String)"counterName", (String)"myStepName", (Object)1233L), MetricResultsMatchers.committedMetricsResult((String)"otherNamespace", (String)"otherCounter", (String)"myStepName3", (Object)12L), MetricResultsMatchers.committedMetricsResult((String)"otherNamespace", (String)"counterName", (String)"myStepName4", (Object)1200L)}));
    }

    @Test
    public void testMultipleCounterUpdatesStreaming() throws IOException {
        AppliedPTransform myStep2 = (AppliedPTransform)Mockito.mock(AppliedPTransform.class);
        Mockito.when((Object)myStep2.getFullName()).thenReturn((Object)"myStepName");
        HashBiMap transformStepNames = HashBiMap.create();
        transformStepNames.put((Object)myStep2, (Object)"s2");
        AppliedPTransform myStep3 = (AppliedPTransform)Mockito.mock(AppliedPTransform.class);
        Mockito.when((Object)myStep3.getFullName()).thenReturn((Object)"myStepName3");
        transformStepNames.put((Object)myStep3, (Object)"s3");
        AppliedPTransform myStep4 = (AppliedPTransform)Mockito.mock(AppliedPTransform.class);
        Mockito.when((Object)myStep4.getFullName()).thenReturn((Object)"myStepName4");
        transformStepNames.put((Object)myStep4, (Object)"s4");
        JobMetrics jobMetrics = new JobMetrics();
        DataflowClient dataflowClient = (DataflowClient)Mockito.mock(DataflowClient.class);
        Mockito.when((Object)dataflowClient.getJobMetrics(JOB_ID)).thenReturn((Object)jobMetrics);
        DataflowPipelineJob job = (DataflowPipelineJob)Mockito.mock(DataflowPipelineJob.class);
        DataflowPipelineOptions options = (DataflowPipelineOptions)Mockito.mock(DataflowPipelineOptions.class);
        Mockito.when((Object)options.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)job.getDataflowOptions()).thenReturn((Object)options);
        Mockito.when((Object)job.getState()).thenReturn((Object)PipelineResult.State.RUNNING);
        Mockito.when((Object)job.getJobId()).thenReturn((Object)JOB_ID);
        Mockito.when((Object)job.getTransformStepNames()).thenReturn((Object)transformStepNames);
        jobMetrics.setMetrics((List)ImmutableList.of((Object)this.makeCounterMetricUpdate("counterName", "counterNamespace", "s2", 1233L, false), (Object)this.makeCounterMetricUpdate("counterName", "counterNamespace", "s2", 1234L, true), (Object)this.makeCounterMetricUpdate("otherCounter", "otherNamespace", "s3", 12L, false), (Object)this.makeCounterMetricUpdate("otherCounter", "otherNamespace", "s3", 12L, true), (Object)this.makeCounterMetricUpdate("counterName", "otherNamespace", "s4", 1200L, false), (Object)this.makeCounterMetricUpdate("counterName", "otherNamespace", "s4", 1233L, true)));
        DataflowMetrics dataflowMetrics = new DataflowMetrics(job, dataflowClient);
        MetricQueryResults result = dataflowMetrics.allMetrics();
        try {
            ((MetricResult)result.getCounters().iterator().next()).getCommitted();
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException expected) {
            MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)Matchers.containsString((String)"This runner does not currently support committed metrics results. Please use 'attempted' instead."));
        }
        MatcherAssert.assertThat((Object)result.getCounters(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{MetricResultsMatchers.attemptedMetricsResult((String)"counterNamespace", (String)"counterName", (String)"myStepName", (Object)1233L), MetricResultsMatchers.attemptedMetricsResult((String)"otherNamespace", (String)"otherCounter", (String)"myStepName3", (Object)12L), MetricResultsMatchers.attemptedMetricsResult((String)"otherNamespace", (String)"counterName", (String)"myStepName4", (Object)1200L)}));
    }

    @Test
    public void testTemplateJobMetricsThrowsUsefulError() throws Exception {
        DataflowClient dataflowClient = (DataflowClient)Mockito.mock(DataflowClient.class);
        DataflowMetrics metrics = new DataflowMetrics((DataflowPipelineJob)new DataflowTemplateJob(), dataflowClient);
        Assert.assertThrows((String)"The result of template creation should not be used.", UnsupportedOperationException.class, () -> metrics.allMetrics());
        Assert.assertThrows((String)"The result of template creation should not be used.", UnsupportedOperationException.class, () -> metrics.queryMetrics(MetricsFilter.builder().build()));
    }
}

