/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.dataflow.Dataflow;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.Step;
import com.google.api.services.dataflow.model.WorkerPool;
import com.google.auth.Credentials;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.dataflow.DataflowPipelineTranslator;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.dataflow.RecordingPipelineVisitor;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineWorkerPoolOptions;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjects;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.extensions.gcp.auth.TestCredential;
import org.apache.beam.sdk.extensions.gcp.util.GcsUtil;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHints;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHintsOptions;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.DoFnInfo;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.StringUtils;
import org.apache.beam.sdk.util.construction.Environments;
import org.apache.beam.sdk.util.construction.PipelineTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class DataflowPipelineTranslatorTest
implements Serializable {
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    private SdkComponents createSdkComponents(PipelineOptions options) {
        SdkComponents sdkComponents = SdkComponents.create();
        String containerImageURL = DataflowRunner.getContainerImageForJob((DataflowPipelineOptions)((DataflowPipelineOptions)options.as(DataflowPipelineOptions.class)));
        RunnerApi.Environment defaultEnvironmentForDataflow = Environments.createDockerEnvironment((String)containerImageURL);
        sdkComponents.registerEnvironment(defaultEnvironmentForDataflow);
        return sdkComponents;
    }

    private Pipeline buildPipeline(DataflowPipelineOptions options) {
        options.setRunner(DataflowRunner.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)p.apply("ReadMyFile", (PTransform)TextIO.read().from("gs://bucket/object"))).apply("WriteMyFile", (PTransform)TextIO.write().to("gs://bucket/object"));
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        runner.replaceV1Transforms(p);
        return p;
    }

    private static Dataflow buildMockDataflow(ArgumentMatcher<Job> jobMatcher) throws IOException {
        Dataflow mockDataflowClient = (Dataflow)Mockito.mock(Dataflow.class);
        Dataflow.Projects mockProjects = (Dataflow.Projects)Mockito.mock(Dataflow.Projects.class);
        Dataflow.Projects.Jobs mockJobs = (Dataflow.Projects.Jobs)Mockito.mock(Dataflow.Projects.Jobs.class);
        Dataflow.Projects.Jobs.Create mockRequest = (Dataflow.Projects.Jobs.Create)Mockito.mock(Dataflow.Projects.Jobs.Create.class);
        Mockito.when((Object)mockDataflowClient.projects()).thenReturn((Object)mockProjects);
        Mockito.when((Object)mockProjects.jobs()).thenReturn((Object)mockJobs);
        Mockito.when((Object)mockJobs.create((String)Matchers.eq((Object)"someProject"), (Job)Matchers.argThat(jobMatcher))).thenReturn((Object)mockRequest);
        Job resultJob = new Job();
        resultJob.setId("newid");
        Mockito.when((Object)((Job)mockRequest.execute())).thenReturn((Object)resultJob);
        return mockDataflowClient;
    }

    private static DataflowPipelineOptions buildPipelineOptions() throws IOException {
        GcsUtil mockGcsUtil = (GcsUtil)Mockito.mock(GcsUtil.class);
        Mockito.when((Object)mockGcsUtil.expand((GcsPath)Matchers.any(GcsPath.class))).then(invocation -> ImmutableList.of((Object)((GcsPath)invocation.getArguments()[0])));
        ((GcsUtil)Mockito.doNothing().when((Object)mockGcsUtil)).verifyBucketAccessible((GcsPath)Matchers.any(GcsPath.class));
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setRunner(DataflowRunner.class);
        options.setGcpCredential((Credentials)new TestCredential());
        options.setJobName("some-job-name");
        options.setProject("some-project");
        options.setRegion("some-region");
        options.setTempLocation(GcsPath.fromComponents((String)"somebucket", (String)"some/path").toString());
        options.setFilesToStage(new ArrayList());
        options.setDataflowClient(DataflowPipelineTranslatorTest.buildMockDataflow(new IsValidCreateRequest()));
        options.setGcsUtil(mockGcsUtil);
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        return options;
    }

    @Test
    public void testStorageWriteApiTransformNames() throws IOException, Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setRunner(DataflowRunner.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        BigQueryIO.Write writeTransform = BigQueryIO.write().withFormatFunction((SerializableFunction & Serializable)input1 -> new TableRow().set("description", input1)).withMethod(BigQueryIO.Write.Method.STORAGE_WRITE_API).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withTriggeringFrequency(Duration.standardSeconds((long)5L)).to(new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table")).withSchema(new TableSchema().setFields(new ArrayList(ImmutableList.of((Object)new TableFieldSchema().setName("description").setType("STRING")))));
        ((PCollection)p.apply((PTransform)Create.of((Object)"1", (Object[])new String[]{"2", "3", "4"}).withCoder((Coder)StringUtf8Coder.of()))).setIsBoundedInternal(PCollection.IsBounded.UNBOUNDED).apply("StorageWriteApi", (PTransform)writeTransform);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        DataflowPipelineTranslator t = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)((DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class)));
        DataflowPipelineTranslator.JobSpecification jobSpecification = t.translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList());
        boolean foundStep = false;
        for (Step step : jobSpecification.getJob().getSteps()) {
            if (!Structs.getString((Map)step.getProperties(), (String)"user_name").contains("StorageWriteApi/StorageApiLoads")) continue;
            foundStep = true;
        }
        Assert.assertTrue((boolean)foundStep);
    }

    @Test
    public void testGCSWriteTransformNames() throws IOException, Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setRunner(DataflowRunner.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        ((PCollection)((PCollection)p.apply((PTransform)Create.of((Object)"1", (Object[])new String[]{"2", "3", "4"}).withCoder((Coder)StringUtf8Coder.of()))).setIsBoundedInternal(PCollection.IsBounded.UNBOUNDED).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)1L))))).apply("WriteMyFile", (PTransform)TextIO.write().to("gs://bucket/object").withWindowedWrites().withNumShards(0));
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        DataflowPipelineTranslator t = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)((DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class)));
        DataflowPipelineTranslator.JobSpecification jobSpecification = t.translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList());
        boolean foundStep = false;
        for (Step step : jobSpecification.getJob().getSteps()) {
            if (!Structs.getString((Map)step.getProperties(), (String)"user_name").contains("WriteFiles/WriteAutoShardedBundlesToTempFiles")) continue;
            foundStep = true;
        }
        Assert.assertTrue((boolean)foundStep);
    }

    @Test
    public void testNetworkConfig() throws IOException {
        String testNetwork = "test-network";
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setNetwork("test-network");
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertEquals((Object)"test-network", (Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getNetwork());
    }

    @Test
    public void testNetworkConfigMissing() throws IOException {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertNull((Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getNetwork());
    }

    @Test
    public void testSubnetworkConfig() throws IOException {
        String testSubnetwork = "regions/REGION/subnetworks/SUBNETWORK";
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setSubnetwork("regions/REGION/subnetworks/SUBNETWORK");
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertEquals((Object)"regions/REGION/subnetworks/SUBNETWORK", (Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getSubnetwork());
    }

    @Test
    public void testSubnetworkConfigMissing() throws IOException {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertNull((Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getSubnetwork());
    }

    @Test
    public void testScalingAlgorithmMissing() throws IOException {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertNull((Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getAutoscalingSettings().getAlgorithm());
        Assert.assertEquals((long)0L, (long)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getAutoscalingSettings().getMaxNumWorkers().intValue());
    }

    @Test
    public void testScalingAlgorithmNone() throws IOException {
        DataflowPipelineWorkerPoolOptions.AutoscalingAlgorithmType noScaling = DataflowPipelineWorkerPoolOptions.AutoscalingAlgorithmType.NONE;
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setAutoscalingAlgorithm(noScaling);
        options.setNumWorkers(42);
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertEquals((Object)"AUTOSCALING_ALGORITHM_NONE", (Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getAutoscalingSettings().getAlgorithm());
        Assert.assertEquals((long)42L, (long)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getNumWorkers().intValue());
        Assert.assertEquals((long)0L, (long)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getAutoscalingSettings().getMaxNumWorkers().intValue());
    }

    @Test
    public void testMaxNumWorkersIsPassedWhenNoAlgorithmIsSet() throws IOException {
        DataflowPipelineWorkerPoolOptions.AutoscalingAlgorithmType noScaling = null;
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setMaxNumWorkers(42);
        options.setAutoscalingAlgorithm(noScaling);
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertNull((Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getAutoscalingSettings().getAlgorithm());
        Assert.assertEquals((long)42L, (long)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getAutoscalingSettings().getMaxNumWorkers().intValue());
    }

    @Test
    public void testNumWorkersCannotExceedMaxNumWorkers() throws IOException {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setNumWorkers(43);
        options.setMaxNumWorkers(42);
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("numWorkers (43) cannot exceed maxNumWorkers (42).");
        DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList()).getJob();
    }

    @Test
    public void testWorkerMachineTypeConfig() throws IOException {
        String testMachineType = "test-machine-type";
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setWorkerMachineType("test-machine-type");
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        WorkerPool workerPool = (WorkerPool)job.getEnvironment().getWorkerPools().get(0);
        Assert.assertEquals((Object)"test-machine-type", (Object)workerPool.getMachineType());
    }

    @Test
    public void testDiskSizeGbConfig() throws IOException {
        Integer diskSizeGb = 1234;
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setDiskSizeGb(diskSizeGb.intValue());
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertEquals((Object)diskSizeGb, (Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getDiskSizeGb());
    }

    @Test
    public void testMultiGraphPipelineSerialization() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        Pipeline p = Pipeline.create((PipelineOptions)options);
        PCollection input = (PCollection)p.begin().apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
        input.apply((PTransform)new UnrelatedOutputCreator());
        input.apply((PTransform)new UnboundOutputCreator());
        DataflowPipelineTranslator t = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)((DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class)));
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        DataflowPipelineTranslator.JobSpecification jobSpecification = t.translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList());
        DataflowPipelineTranslatorTest.assertAllStepOutputsHaveUniqueIds(jobSpecification.getJob());
    }

    @Test
    public void testPartiallyBoundFailure() throws IOException {
        Pipeline p = Pipeline.create((PipelineOptions)DataflowPipelineTranslatorTest.buildPipelineOptions());
        PCollection input = (PCollection)p.begin().apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
        this.thrown.expect(IllegalArgumentException.class);
        input.apply((PTransform)new PartiallyBoundOutputCreator());
        Assert.fail((String)"Failure expected from use of partially bound output");
    }

    @Test
    public void testGoodWildcards() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        DataflowPipelineTranslator t = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        this.applyRead(pipeline, "gs://bucket/foo");
        this.applyRead(pipeline, "gs://bucket/foo/");
        this.applyRead(pipeline, "gs://bucket/foo/*");
        this.applyRead(pipeline, "gs://bucket/foo/?");
        this.applyRead(pipeline, "gs://bucket/foo/[0-9]");
        this.applyRead(pipeline, "gs://bucket/foo/*baz*");
        this.applyRead(pipeline, "gs://bucket/foo/*baz?");
        this.applyRead(pipeline, "gs://bucket/foo/[0-9]baz?");
        this.applyRead(pipeline, "gs://bucket/foo/baz/*");
        this.applyRead(pipeline, "gs://bucket/foo/baz/*wonka*");
        this.applyRead(pipeline, "gs://bucket/foo/*baz/wonka*");
        this.applyRead(pipeline, "gs://bucket/foo*/baz");
        this.applyRead(pipeline, "gs://bucket/foo?/baz");
        this.applyRead(pipeline, "gs://bucket/foo[0-9]/baz");
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        DataflowPipelineTranslator.JobSpecification jobSpecification = t.translate(pipeline, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList());
        DataflowPipelineTranslatorTest.assertAllStepOutputsHaveUniqueIds(jobSpecification.getJob());
    }

    private void applyRead(Pipeline pipeline, String path) {
        pipeline.apply("Read(" + path + ")", (PTransform)TextIO.read().from(path));
    }

    @Test
    public void testInaccessibleProvider() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        DataflowPipelineTranslator t = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        pipeline.apply((PTransform)TextIO.read().from((ValueProvider)new TestValueProvider()));
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        t.translate(pipeline, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList());
    }

    @Test
    public void testNamesOverridden() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        options.setStreaming(false);
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply("Jazzy", (PTransform)Create.of((Object)3, (Object[])new Integer[0]))).setName("foobizzle");
        runner.replaceV1Transforms(pipeline);
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        Job job = translator.translate(pipeline, pipelineProto, sdkComponents, runner, Collections.emptyList()).getJob();
        Step step = (Step)job.getSteps().get(0);
        String userSpecifiedName = Structs.getString((Map)((Map)Structs.getListOfMaps((Map)step.getProperties(), (String)"output_info", null).get(0)), (String)"user_name");
        String calculatedName = Structs.getString((Map)step.getProperties(), (String)"user_name") + ".out0";
        MatcherAssert.assertThat((Object)userSpecifiedName, (Matcher)org.hamcrest.Matchers.equalTo((Object)calculatedName));
    }

    @Test
    public void testTaggedNamesOverridden() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        options.setStreaming(false);
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        TupleTag<Integer> tag1 = new TupleTag<Integer>("frazzle"){};
        TupleTag<Integer> tag2 = new TupleTag<Integer>("bazzle"){};
        TupleTag<Integer> tag3 = new TupleTag<Integer>(){};
        PCollectionTuple outputs = (PCollectionTuple)((PCollection)pipeline.apply((PTransform)Create.of((Object)3, (Object[])new Integer[]{4}))).apply((PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void drop() {
            }
        }).withOutputTags((TupleTag)tag1, TupleTagList.of((TupleTag)tag2).and((TupleTag)tag3)));
        outputs.get((TupleTag)tag1).setName("bizbazzle");
        outputs.get((TupleTag)tag2).setName("gonzaggle");
        outputs.get((TupleTag)tag3).setName("froonazzle");
        runner.replaceV1Transforms(pipeline);
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        Job job = translator.translate(pipeline, pipelineProto, sdkComponents, runner, Collections.emptyList()).getJob();
        Step step = (Step)job.getSteps().get(1);
        String stepName = Structs.getString((Map)step.getProperties(), (String)"user_name");
        List outputInfos = Structs.getListOfMaps((Map)step.getProperties(), (String)"output_info", null);
        MatcherAssert.assertThat((Object)outputInfos.size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)3));
        for (int i = 0; i < outputInfos.size(); ++i) {
            MatcherAssert.assertThat((Object)Structs.getString((Map)((Map)outputInfos.get(i)), (String)"user_name"), (Matcher)org.hamcrest.Matchers.equalTo((Object)String.format("%s.out%s", stepName, i)));
        }
    }

    @Test
    public void testBatchStatefulParDoTranslation() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        options.setStreaming(false);
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        TupleTag<Integer> mainOutputTag = new TupleTag<Integer>(){};
        ((PCollection)pipeline.apply((PTransform)Create.of((Object)KV.of((Object)1, (Object)1), (Object[])new KV[]{KV.of((Object)2, (Object)3)}))).apply((PTransform)ParDo.of((DoFn)new DoFn<KV<Integer, Integer>, Integer>(){
            @DoFn.StateId(value="unused")
            final StateSpec<ValueState<Integer>> stateSpec = StateSpecs.value((Coder)VarIntCoder.of());

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext c) {
            }
        }).withOutputTags((TupleTag)mainOutputTag, TupleTagList.empty()));
        runner.replaceV1Transforms(pipeline);
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        Job job = translator.translate(pipeline, pipelineProto, sdkComponents, runner, Collections.emptyList()).getJob();
        List steps = job.getSteps();
        Assert.assertEquals((long)4L, (long)steps.size());
        Step createStep = (Step)steps.get(0);
        Assert.assertEquals((Object)"ParallelRead", (Object)createStep.getKind());
        Step reifyWindowedValueStep = (Step)steps.get(1);
        Assert.assertEquals((Object)"ParallelDo", (Object)reifyWindowedValueStep.getKind());
        Step gbkStep = (Step)steps.get(2);
        Assert.assertEquals((Object)"GroupByKey", (Object)gbkStep.getKind());
        Step statefulParDoStep = (Step)steps.get(3);
        Assert.assertEquals((Object)"ParallelDo", (Object)statefulParDoStep.getKind());
        MatcherAssert.assertThat((Object)((String)statefulParDoStep.getProperties().get("uses_keyed_state")), (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.equalTo((Object)"true")));
    }

    @Test
    public void testToList() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        final PCollectionView view = (PCollectionView)((PCollection)pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)11, (Object[])new Integer[]{13, 17, 23}))).apply((PTransform)View.asList().withRandomAccess());
        ((PCollection)pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)29, (Object[])new Integer[]{31}))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Preconditions.checkArgument((((List)c.sideInput(view)).size() == 4 ? 1 : 0) != 0);
                Preconditions.checkArgument((boolean)((Integer)((List)c.sideInput(view)).get(0)).equals(((List)c.sideInput(view)).get(0)));
                for (Integer i : (List)c.sideInput(view)) {
                    c.output((Object)i);
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        runner.replaceV1Transforms(pipeline);
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        Job job = translator.translate(pipeline, pipelineProto, sdkComponents, runner, Collections.emptyList()).getJob();
        List steps = job.getSteps();
        Assert.assertEquals((long)5L, (long)steps.size());
    }

    @Test
    public void testToMap() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        final PCollectionView view = (PCollectionView)((PCollection)pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)KV.of((Object)"a", (Object)1), (Object[])new KV[]{KV.of((Object)"b", (Object)3)}))).apply((PTransform)View.asMap());
        PCollection output = (PCollection)((PCollection)pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)"apple", (Object[])new String[]{"banana", "blackberry"}))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)KV.of((Object)((String)c.element()), (Object)((Integer)((Map)c.sideInput(view)).get(((String)c.element()).substring(0, 1)))));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"apple", (Object)1), KV.of((Object)"banana", (Object)3), KV.of((Object)"blackberry", (Object)3)});
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        runner.replaceV1Transforms(pipeline);
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        Job job = translator.translate(pipeline, pipelineProto, sdkComponents, runner, Collections.emptyList()).getJob();
        List steps = job.getSteps();
        Assert.assertEquals((long)25L, (long)steps.size());
    }

    @Test
    public void testStreamingSplittableParDoTranslation() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        options.setStreaming(true);
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        PCollection windowedInput = (PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Object)"a", (Object[])new String[0]))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)1L))));
        windowedInput.apply((PTransform)ParDo.of((DoFn)new TestSplittableFn()));
        runner.replaceV1Transforms(pipeline);
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        Job job = translator.translate(pipeline, pipelineProto, sdkComponents, runner, Collections.emptyList()).getJob();
        List steps = job.getSteps();
        Step processKeyedStep = null;
        for (Step step : steps) {
            if (!"SplittableProcessKeyed".equals(step.getKind())) continue;
            Assert.assertNull(processKeyedStep);
            processKeyedStep = step;
        }
        Assert.assertNotNull(processKeyedStep);
        DoFnInfo fnInfo = (DoFnInfo)SerializableUtils.deserializeFromByteArray((byte[])StringUtils.jsonStringToByteArray((String)Structs.getString((Map)processKeyedStep.getProperties(), (String)"serialized_fn")), (String)"DoFnInfo");
        MatcherAssert.assertThat((Object)fnInfo.getDoFn(), (Matcher)org.hamcrest.Matchers.instanceOf(TestSplittableFn.class));
        MatcherAssert.assertThat((Object)fnInfo.getWindowingStrategy().getWindowFn(), (Matcher)org.hamcrest.Matchers.equalTo((Object)FixedWindows.of((Duration)Duration.standardMinutes((long)1L))));
        MatcherAssert.assertThat((Object)fnInfo.getInputCoder(), (Matcher)org.hamcrest.Matchers.instanceOf(StringUtf8Coder.class));
        Coder restrictionCoder = CloudObjects.coderFromCloudObject((CloudObject)((CloudObject)Structs.getObject((Map)processKeyedStep.getProperties(), (String)"restriction_coder")));
        Assert.assertEquals((Object)KvCoder.of((Coder)SerializableCoder.of(OffsetRange.class), (Coder)VoidCoder.of()), (Object)restrictionCoder);
    }

    @Test
    public void testPortablePipelineContainsExpectedDependenciesAndCapabilities() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setExperiments(Arrays.asList("beam_fn_api"));
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)pipeline.apply((PTransform)Impulse.create())).apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<byte[], String>(){

            public String apply(byte[] input) {
                return "";
            }
        }))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)1L))));
        runner.replaceV1Transforms(pipeline);
        File file1 = File.createTempFile("file1-", ".txt");
        file1.deleteOnExit();
        File file2 = File.createTempFile("file2-", ".txt");
        file2.deleteOnExit();
        SdkComponents sdkComponents = SdkComponents.create();
        sdkComponents.registerEnvironment(Environments.createDockerEnvironment((String)DataflowRunner.getContainerImageForJob((DataflowPipelineOptions)options)).toBuilder().addAllDependencies((Iterable)Environments.getArtifacts((List)ImmutableList.of((Object)("file1.txt=" + file1), (Object)("file2.txt=" + file2)))).addAllCapabilities((Iterable)Environments.getJavaCapabilities()).build());
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        DataflowPipelineTranslator.JobSpecification result = translator.translate(pipeline, pipelineProto, sdkComponents, runner, Collections.emptyList());
        RunnerApi.Components componentsProto = result.getPipelineProto().getComponents();
        MatcherAssert.assertThat((Object)((RunnerApi.Environment)Iterables.getOnlyElement(componentsProto.getEnvironmentsMap().values())).getCapabilitiesList(), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])Environments.getJavaCapabilities().toArray(new String[0])));
        MatcherAssert.assertThat((Object)((RunnerApi.Environment)Iterables.getOnlyElement(componentsProto.getEnvironmentsMap().values())).getDependenciesList(), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])Environments.getArtifacts((List)ImmutableList.of((Object)("file1.txt=" + file1), (Object)("file2.txt=" + file2))).toArray(new RunnerApi.ArtifactInformation[0])));
    }

    @Test
    public void testToSingletonTranslationWithIsmSideInput() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply((PTransform)View.asSingleton());
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        runner.replaceV1Transforms(pipeline);
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        Job job = translator.translate(pipeline, pipelineProto, sdkComponents, runner, Collections.emptyList()).getJob();
        DataflowPipelineTranslatorTest.assertAllStepOutputsHaveUniqueIds(job);
        List steps = job.getSteps();
        Assert.assertEquals((long)10L, (long)steps.size());
        List toIsmRecordOutputs = (List)((Step)steps.get(steps.size() - 2)).getProperties().get("output_info");
        Assert.assertTrue((boolean)Structs.getBoolean((Map)((Map)Iterables.getOnlyElement((Iterable)toIsmRecordOutputs)), (String)"use_indexed_format"));
        Step collectionToSingletonStep = (Step)steps.get(steps.size() - 1);
        Assert.assertEquals((Object)"CollectionToSingleton", (Object)collectionToSingletonStep.getKind());
    }

    @Test
    public void testToIterableTranslationWithIsmSideInput() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)View.asIterable());
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        runner.replaceV1Transforms(pipeline);
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        Job job = translator.translate(pipeline, pipelineProto, sdkComponents, runner, Collections.emptyList()).getJob();
        DataflowPipelineTranslatorTest.assertAllStepOutputsHaveUniqueIds(job);
        List steps = job.getSteps();
        Assert.assertEquals((long)3L, (long)steps.size());
        List toIsmRecordOutputs = (List)((Step)steps.get(steps.size() - 2)).getProperties().get("output_info");
        Assert.assertTrue((boolean)Structs.getBoolean((Map)((Map)Iterables.getOnlyElement((Iterable)toIsmRecordOutputs)), (String)"use_indexed_format"));
        Step collectionToSingletonStep = (Step)steps.get(steps.size() - 1);
        Assert.assertEquals((Object)"CollectionToSingleton", (Object)collectionToSingletonStep.getKind());
    }

    private DataflowPipelineTranslator.JobSpecification runBatchGroupIntoBatchesAndGetJobSpec(Boolean withShardedKey, List<String> experiments) throws IOException {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setExperiments(experiments);
        options.setStreaming(false);
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        PCollection input = (PCollection)pipeline.apply((PTransform)Create.of(Arrays.asList(KV.of((Object)1, (Object)"1"), KV.of((Object)2, (Object)"2"), KV.of((Object)3, (Object)"3"))));
        if (withShardedKey.booleanValue()) {
            input.apply((PTransform)GroupIntoBatches.ofSize((long)3L).withShardedKey());
        } else {
            input.apply((PTransform)GroupIntoBatches.ofSize((long)3L));
        }
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        runner.replaceV1Transforms(pipeline);
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        return translator.translate(pipeline, pipelineProto, sdkComponents, runner, Collections.emptyList());
    }

    private DataflowPipelineTranslator.JobSpecification runStreamingGroupIntoBatchesAndGetJobSpec(Boolean withShardedKey, List<String> experiments) throws IOException {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setExperiments(experiments);
        options.setStreaming(true);
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        PCollection input = (PCollection)pipeline.apply((PTransform)Create.of(Arrays.asList(KV.of((Object)1, (Object)"1"), KV.of((Object)2, (Object)"2"), KV.of((Object)3, (Object)"3"))));
        if (withShardedKey.booleanValue()) {
            input.apply((PTransform)GroupIntoBatches.ofSize((long)3L).withShardedKey());
        } else {
            input.apply((PTransform)GroupIntoBatches.ofSize((long)3L));
        }
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        runner.replaceV1Transforms(pipeline);
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        return translator.translate(pipeline, pipelineProto, sdkComponents, runner, Collections.emptyList());
    }

    @Test
    public void testBatchGroupIntoBatchesTranslation() throws Exception {
        DataflowPipelineTranslator.JobSpecification jobSpec = this.runBatchGroupIntoBatchesAndGetJobSpec(false, Collections.emptyList());
        List steps = jobSpec.getJob().getSteps();
        Step shardedStateStep = (Step)steps.get(steps.size() - 1);
        Map properties = shardedStateStep.getProperties();
        Assert.assertTrue((boolean)properties.containsKey("preserves_keys"));
        Assert.assertEquals((Object)"true", (Object)Structs.getString((Map)properties, (String)"preserves_keys"));
    }

    @Test
    public void testBatchGroupIntoBatchesWithShardedKeyTranslation() throws Exception {
        List<String> experiments = Collections.emptyList();
        DataflowPipelineTranslator.JobSpecification jobSpec = this.runBatchGroupIntoBatchesAndGetJobSpec(true, experiments);
        List steps = jobSpec.getJob().getSteps();
        Step shardedStateStep = (Step)steps.get(steps.size() - 1);
        Map properties = shardedStateStep.getProperties();
        Assert.assertTrue((boolean)properties.containsKey("preserves_keys"));
        Assert.assertEquals((Object)"true", (Object)Structs.getString((Map)properties, (String)"preserves_keys"));
    }

    @Test
    public void testStreamingGroupIntoBatchesTranslation() throws Exception {
        ArrayList<String> experiments = new ArrayList<String>((Collection<String>)ImmutableList.of((Object)"enable_streaming_engine", (Object)"enable_windmill_service"));
        DataflowPipelineTranslator.JobSpecification jobSpec = this.runStreamingGroupIntoBatchesAndGetJobSpec(false, experiments);
        List steps = jobSpec.getJob().getSteps();
        Step shardedStateStep = (Step)steps.get(steps.size() - 1);
        Map properties = shardedStateStep.getProperties();
        Assert.assertTrue((boolean)properties.containsKey("uses_keyed_state"));
        Assert.assertEquals((Object)"true", (Object)Structs.getString((Map)properties, (String)"uses_keyed_state"));
        Assert.assertFalse((boolean)properties.containsKey("allows_shardable_state"));
        Assert.assertTrue((boolean)properties.containsKey("preserves_keys"));
    }

    @Test
    public void testStreamingGroupIntoBatchesWithShardedKeyTranslation() throws Exception {
        ArrayList<String> experiments = new ArrayList<String>((Collection<String>)ImmutableList.of((Object)"enable_streaming_engine", (Object)"enable_windmill_service"));
        DataflowPipelineTranslator.JobSpecification jobSpec = this.runStreamingGroupIntoBatchesAndGetJobSpec(true, experiments);
        List steps = jobSpec.getJob().getSteps();
        Step shardedStateStep = (Step)steps.get(steps.size() - 1);
        Map properties = shardedStateStep.getProperties();
        Assert.assertTrue((boolean)properties.containsKey("uses_keyed_state"));
        Assert.assertEquals((Object)"true", (Object)Structs.getString((Map)properties, (String)"uses_keyed_state"));
        Assert.assertTrue((boolean)properties.containsKey("allows_shardable_state"));
        Assert.assertEquals((Object)"true", (Object)Structs.getString((Map)properties, (String)"allows_shardable_state"));
        Assert.assertTrue((boolean)properties.containsKey("preserves_keys"));
        Assert.assertEquals((Object)"true", (Object)Structs.getString((Map)properties, (String)"preserves_keys"));
    }

    @Test
    public void testGroupIntoBatchesWithShardedKeyNotSupported() throws IOException {
        ArrayList<String> experiments = new ArrayList<String>((Collection<String>)ImmutableList.of((Object)"use_runner_v2"));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Runner determined sharding not available in Dataflow for GroupIntoBatches for non-Streaming-Engine jobs");
        this.runStreamingGroupIntoBatchesAndGetJobSpec(true, experiments);
    }

    @Test
    public void testStepDisplayData() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        DoFn<Integer, Integer> fn1 = new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output((Object)((Integer)c.element()));
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar")).add(DisplayData.item((String)"foo2", DataflowPipelineTranslatorTest.class).withLabel("Test Class").withLinkUrl("http://www.google.com"));
            }
        };
        DoFn<Integer, Integer> fn2 = new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output((Object)((Integer)c.element()));
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo3", (Integer)1234));
            }
        };
        ParDo.SingleOutput parDo1 = ParDo.of((DoFn)fn1);
        ParDo.SingleOutput parDo2 = ParDo.of((DoFn)fn2);
        ((PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)parDo1)).apply((PTransform)parDo2);
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        runner.replaceV1Transforms(pipeline);
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        Job job = translator.translate(pipeline, pipelineProto, sdkComponents, runner, Collections.emptyList()).getJob();
        DataflowPipelineTranslatorTest.assertAllStepOutputsHaveUniqueIds(job);
        List steps = job.getSteps();
        Assert.assertEquals((long)3L, (long)steps.size());
        Map parDo1Properties = ((Step)steps.get(1)).getProperties();
        Map parDo2Properties = ((Step)steps.get(2)).getProperties();
        MatcherAssert.assertThat((Object)parDo1Properties, (Matcher)org.hamcrest.Matchers.hasKey((Object)"display_data"));
        Collection fn1displayData = (Collection)parDo1Properties.get("display_data");
        Collection fn2displayData = (Collection)parDo2Properties.get("display_data");
        ImmutableSet expectedFn1DisplayData = ImmutableSet.of((Object)ImmutableMap.builder().put((Object)"key", (Object)"foo").put((Object)"type", (Object)"STRING").put((Object)"value", (Object)"bar").put((Object)"namespace", (Object)fn1.getClass().getName()).build(), (Object)ImmutableMap.builder().put((Object)"key", (Object)"fn").put((Object)"label", (Object)"Transform Function").put((Object)"type", (Object)"JAVA_CLASS").put((Object)"value", (Object)fn1.getClass().getName()).put((Object)"shortValue", (Object)fn1.getClass().getSimpleName()).put((Object)"namespace", (Object)parDo1.getClass().getName()).build(), (Object)ImmutableMap.builder().put((Object)"key", (Object)"foo2").put((Object)"type", (Object)"JAVA_CLASS").put((Object)"value", (Object)DataflowPipelineTranslatorTest.class.getName()).put((Object)"shortValue", (Object)DataflowPipelineTranslatorTest.class.getSimpleName()).put((Object)"namespace", (Object)fn1.getClass().getName()).put((Object)"label", (Object)"Test Class").put((Object)"linkUrl", (Object)"http://www.google.com").build());
        ImmutableSet expectedFn2DisplayData = ImmutableSet.of((Object)ImmutableMap.builder().put((Object)"key", (Object)"fn").put((Object)"label", (Object)"Transform Function").put((Object)"type", (Object)"JAVA_CLASS").put((Object)"value", (Object)fn2.getClass().getName()).put((Object)"shortValue", (Object)fn2.getClass().getSimpleName()).put((Object)"namespace", (Object)parDo2.getClass().getName()).build(), (Object)ImmutableMap.builder().put((Object)"key", (Object)"foo3").put((Object)"type", (Object)"INTEGER").put((Object)"value", (Object)1234L).put((Object)"namespace", (Object)fn2.getClass().getName()).build());
        Assert.assertEquals((Object)expectedFn1DisplayData, (Object)ImmutableSet.copyOf((Collection)fn1displayData));
        Assert.assertEquals((Object)expectedFn2DisplayData, (Object)ImmutableSet.copyOf((Collection)fn2displayData));
    }

    @Test
    public void testStepResourceHints() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply("Has hints", MapElements.into((TypeDescriptor)TypeDescriptors.integers()).via((SerializableFunction & Serializable)x -> x + 1).setResourceHints(ResourceHints.create().withMinRam("10.0GiB").withAccelerator("type:nvidia-tesla-k80;count:1;install-nvidia-driver")));
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        runner.replaceV1Transforms(pipeline);
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents, (boolean)true);
        Job job = translator.translate(pipeline, pipelineProto, sdkComponents, runner, Collections.emptyList()).getJob();
        Step stepWithHints = (Step)job.getSteps().get(1);
        ImmutableMap expectedHints = ImmutableMap.builder().put((Object)"beam:resources:min_ram_bytes:v1", (Object)"10737418240").put((Object)"beam:resources:accelerator:v1", (Object)"type:nvidia-tesla-k80;count:1;install-nvidia-driver").build();
        Assert.assertEquals((Object)expectedHints, stepWithHints.getProperties().get("resource_hints"));
    }

    private RunnerApi.PTransform getLeafTransform(RunnerApi.Pipeline pipelineProto, String label) {
        for (RunnerApi.PTransform transform : pipelineProto.getComponents().getTransformsMap().values()) {
            if (!transform.getUniqueName().contains(label) || transform.getSubtransformsCount() != 0) continue;
            return transform;
        }
        throw new IllegalArgumentException(label);
    }

    @Test
    public void testResourceHintsTranslationsResolvesHintsOnOptionsAndComposites() {
        ResourceHintsOptions options = (ResourceHintsOptions)PipelineOptionsFactory.as(ResourceHintsOptions.class);
        options.setResourceHints(Arrays.asList("accelerator=set_via_options", "minRam=1B"));
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        PCollection root = (PCollection)pipeline.apply((PTransform)Impulse.create());
        root.apply(new Outer().setResourceHints(ResourceHints.create().withAccelerator("set_on_outer_transform").withMinRam(20L)));
        root.apply("Leaf", (PTransform)ParDo.of(new IdentityDoFn()));
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (boolean)false);
        MatcherAssert.assertThat((Object)((RunnerApi.Environment)pipelineProto.getComponents().getEnvironmentsMap().get(this.getLeafTransform(pipelineProto, "Leaf").getEnvironmentId())).getResourceHintsMap(), (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.hasEntry((Object)"beam:resources:min_ram_bytes:v1", (Object)ByteString.copyFromUtf8((String)"1")), (Matcher)org.hamcrest.Matchers.hasEntry((Object)"beam:resources:accelerator:v1", (Object)ByteString.copyFromUtf8((String)"set_via_options"))));
        MatcherAssert.assertThat((Object)((RunnerApi.Environment)pipelineProto.getComponents().getEnvironmentsMap().get(this.getLeafTransform(pipelineProto, "Innermost").getEnvironmentId())).getResourceHintsMap(), (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.hasEntry((Object)"beam:resources:min_ram_bytes:v1", (Object)ByteString.copyFromUtf8((String)"20")), (Matcher)org.hamcrest.Matchers.hasEntry((Object)"beam:resources:accelerator:v1", (Object)ByteString.copyFromUtf8((String)"set_in_inner_transform"))));
    }

    @Test
    public void testSetWorkerHarnessContainerImageInPipelineProto() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        String containerImage = "gcr.io/image:foo";
        ((DataflowPipelineOptions)options.as(DataflowPipelineOptions.class)).setWorkerHarnessContainerImage(containerImage);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline proto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        DataflowPipelineTranslator.JobSpecification specification = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, proto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList());
        RunnerApi.Pipeline pipelineProto = specification.getPipelineProto();
        Assert.assertEquals((long)1L, (long)pipelineProto.getComponents().getEnvironmentsCount());
        RunnerApi.Environment defaultEnvironment = (RunnerApi.Environment)Iterables.getOnlyElement(pipelineProto.getComponents().getEnvironmentsMap().values());
        RunnerApi.DockerPayload payload = RunnerApi.DockerPayload.parseFrom((ByteString)defaultEnvironment.getPayload());
        Assert.assertEquals((Object)DataflowRunner.getContainerImageForJob((DataflowPipelineOptions)options), (Object)payload.getContainerImage());
    }

    @Test
    public void testSetSdkContainerImageInPipelineProto() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        String containerImage = "gcr.io/image:foo";
        ((DataflowPipelineOptions)options.as(DataflowPipelineOptions.class)).setSdkContainerImage(containerImage);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline proto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        DataflowPipelineTranslator.JobSpecification specification = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, proto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList());
        RunnerApi.Pipeline pipelineProto = specification.getPipelineProto();
        Assert.assertEquals((long)1L, (long)pipelineProto.getComponents().getEnvironmentsCount());
        RunnerApi.Environment defaultEnvironment = (RunnerApi.Environment)Iterables.getOnlyElement(pipelineProto.getComponents().getEnvironmentsMap().values());
        RunnerApi.DockerPayload payload = RunnerApi.DockerPayload.parseFrom((ByteString)defaultEnvironment.getPayload());
        Assert.assertEquals((Object)DataflowRunner.getContainerImageForJob((DataflowPipelineOptions)options), (Object)payload.getContainerImage());
    }

    @Test
    public void testDataflowServiceOptionsSet() throws IOException {
        List dataflowServiceOptions = Stream.of("whizz=bang", "foo=bar").collect(Collectors.toList());
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setDataflowServiceOptions(dataflowServiceOptions);
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList()).getJob();
        Assert.assertEquals(dataflowServiceOptions, (Object)job.getEnvironment().getServiceOptions());
    }

    @Test
    public void testHotKeyLoggingEnabledOption() throws IOException {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setHotKeyLoggingEnabled(true);
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        SdkComponents sdkComponents = this.createSdkComponents((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList()).getJob();
        Assert.assertTrue((boolean)job.getEnvironment().getDebugOptions().getEnableHotKeyLogging());
    }

    private static void assertAllStepOutputsHaveUniqueIds(Job job) throws Exception {
        ArrayList<String> outputIds = new ArrayList<String>();
        for (Step step : job.getSteps()) {
            List outputInfoList = (List)step.getProperties().get("output_info");
            if (outputInfoList == null) continue;
            for (Map outputInfo : outputInfoList) {
                outputIds.add(Structs.getString((Map)outputInfo, (String)"output_name"));
            }
        }
        HashSet uniqueOutputNames = new HashSet(outputIds);
        outputIds.removeAll(uniqueOutputNames);
        Assert.assertTrue((String)String.format("Found duplicate output ids %s", outputIds), (boolean)outputIds.isEmpty());
    }

    private static class TestSplittableFn
    extends DoFn<String, Integer> {
        private TestSplittableFn() {
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c, RestrictionTracker<OffsetRange, Long> tracker) {
        }

        @DoFn.GetInitialRestriction
        public OffsetRange getInitialRange(@DoFn.Element String element) {
            return null;
        }
    }

    private static class Outer
    extends PTransform<PCollection<byte[]>, PCollection<byte[]>> {
        private Outer() {
        }

        public PCollection<byte[]> expand(PCollection<byte[]> input) {
            return (PCollection)input.apply((PTransform)new Inner());
        }
    }

    private static class Inner
    extends PTransform<PCollection<byte[]>, PCollection<byte[]>> {
        private Inner() {
        }

        public PCollection<byte[]> expand(PCollection<byte[]> input) {
            return (PCollection)input.apply("Innermost", ParDo.of(new IdentityDoFn()).setResourceHints(ResourceHints.create().withAccelerator("set_in_inner_transform")));
        }
    }

    private static class IdentityDoFn<T>
    extends DoFn<T, T> {
        private IdentityDoFn() {
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element T input, DoFn.OutputReceiver<T> out) {
            out.output(input);
        }
    }

    private static class TestValueProvider
    implements ValueProvider<String>,
    Serializable {
        private TestValueProvider() {
        }

        public boolean isAccessible() {
            return false;
        }

        public String get() {
            throw new RuntimeException("Should not be called.");
        }
    }

    private static class PartiallyBoundOutputCreator
    extends PTransform<PCollection<Integer>, PCollectionTuple> {
        public final TupleTag<Integer> sumTag = new TupleTag("sum");
        public final TupleTag<Void> doneTag = new TupleTag("done");

        private PartiallyBoundOutputCreator() {
        }

        public PCollectionTuple expand(PCollection<Integer> input) {
            PCollection sum = (PCollection)input.apply((PTransform)Sum.integersGlobally());
            return PCollectionTuple.of(this.sumTag, (PCollection)sum).and(this.doneTag, PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)input.isBounded(), (Coder)VoidCoder.of()));
        }
    }

    private static class UnboundOutputCreator
    extends PTransform<PCollection<Integer>, PDone> {
        private UnboundOutputCreator() {
        }

        public PDone expand(PCollection<Integer> input) {
            input.apply(Count.perElement());
            return PDone.in((Pipeline)input.getPipeline());
        }
    }

    private static class UnrelatedOutputCreator
    extends PTransform<PCollection<Integer>, PCollection<Integer>> {
        private UnrelatedOutputCreator() {
        }

        public PCollection<Integer> expand(PCollection<Integer> input) {
            input.apply(Count.perElement());
            return (PCollection)input.getPipeline().apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4}));
        }
    }

    private static class IsValidCreateRequest
    implements ArgumentMatcher<Job> {
        private IsValidCreateRequest() {
        }

        public boolean matches(Job o) {
            Job job = o;
            return job.getId() == null && job.getProjectId() == null && job.getName() != null && job.getType() != null && job.getEnvironment() != null && job.getSteps() != null && job.getCurrentState() == null && job.getCurrentStateTime() == null && job.getExecutionInfo() == null && job.getCreateTime() == null;
        }
    }
}

