/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import org.apache.beam.runners.dataflow.DataflowRunnerInfo;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DataflowRunnerInfoTest {
    @Test
    public void getDataflowRunnerInfo() throws Exception {
        DataflowRunnerInfo info = DataflowRunnerInfo.getDataflowRunnerInfo();
        String version = info.getLegacyEnvironmentMajorVersion();
        Assert.assertTrue((String)String.format("Legacy environment major version number %s is not a number", version), (boolean)version.matches("\\d+"));
        version = info.getFnApiEnvironmentMajorVersion();
        Assert.assertTrue((String)String.format("FnAPI environment major version number %s is not a number", version), (boolean)version.matches("\\d+"));
        MatcherAssert.assertThat((String)"legacy container version invalid", (Object)info.getFnApiDevContainerVersion(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"dataflow.legacy_container_version")));
        MatcherAssert.assertThat((String)"FnAPI container version invalid", (Object)info.getLegacyDevContainerVersion(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"dataflow.fnapi_container_version")));
        MatcherAssert.assertThat((String)"container repository invalid", (Object)info.getContainerImageBaseRepository(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"dataflow.container_base_repository")));
        for (String property : new String[]{"java.vendor", "java.version", "os.arch", "os.name", "os.version"}) {
            Assert.assertEquals((Object)System.getProperty(property), info.getProperties().get(property));
        }
    }
}

