/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.dataflow.Dataflow;
import com.google.api.services.dataflow.model.DataflowPackage;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.ListJobsResponse;
import com.google.api.services.dataflow.model.SdkHarnessContainerImage;
import com.google.api.services.dataflow.model.WorkerPool;
import com.google.api.services.storage.model.StorageObject;
import com.google.auth.Credentials;
import com.google.auto.service.AutoService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.beam.model.expansion.v1.ExpansionApi;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.dataflow.DataflowJobAlreadyExistsException;
import org.apache.beam.runners.dataflow.DataflowJobAlreadyUpdatedException;
import org.apache.beam.runners.dataflow.DataflowPipelineJob;
import org.apache.beam.runners.dataflow.DataflowPipelineTranslator;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.dataflow.DataflowRunnerInfo;
import org.apache.beam.runners.dataflow.GroupIntoBatchesOverride;
import org.apache.beam.runners.dataflow.TransformTranslator;
import org.apache.beam.runners.dataflow.options.DataflowPipelineDebugOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineWorkerPoolOptions;
import org.apache.beam.runners.dataflow.options.DefaultGcpRegionFactory;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.extensions.gcp.auth.NoopCredentialFactory;
import org.apache.beam.sdk.extensions.gcp.auth.TestCredential;
import org.apache.beam.sdk.extensions.gcp.storage.NoopPathValidator;
import org.apache.beam.sdk.extensions.gcp.util.GcsUtil;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.DynamicFileDestinations;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.UsesStatefulParDo;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHints;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.util.construction.Environments;
import org.apache.beam.sdk.util.construction.ExpansionServiceClient;
import org.apache.beam.sdk.util.construction.ExpansionServiceClientFactory;
import org.apache.beam.sdk.util.construction.External;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.PipelineTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValues;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Files;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class DataflowRunnerTest
implements Serializable {
    private static final String VALID_BUCKET = "valid-bucket";
    private static final String VALID_STAGING_BUCKET = "gs://valid-bucket/staging";
    private static final String VALID_TEMP_BUCKET = "gs://valid-bucket/temp";
    private static final String VALID_PROFILE_BUCKET = "gs://valid-bucket/profiles";
    private static final String NON_EXISTENT_BUCKET = "gs://non-existent-bucket/location";
    private static final String PROJECT_ID = "some-project";
    private static final String REGION_ID = "some-region-1";
    @Rule
    public transient TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();
    @Rule
    public transient ExpectedLogs expectedLogs = ExpectedLogs.none(DataflowRunner.class);
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    private transient Dataflow.Projects.Locations.Jobs mockJobs;
    private transient GcsUtil mockGcsUtil;

    private static void assertValidJob(Job job) {
        Assert.assertNull((Object)job.getId());
        Assert.assertNull((Object)job.getCurrentState());
        Assert.assertTrue((boolean)Pattern.matches("[a-z]([-a-z0-9]*[a-z0-9])?", job.getName()));
        MatcherAssert.assertThat((Object)((Map)job.getEnvironment().getSdkPipelineOptions().get("options")), (Matcher)Matchers.hasKey((Object)"pipelineUrl"));
    }

    @Before
    public void setUp() throws IOException {
        this.mockGcsUtil = DataflowRunnerTest.buildMockGcsUtil();
        this.mockJobs = (Dataflow.Projects.Locations.Jobs)Mockito.mock(Dataflow.Projects.Locations.Jobs.class);
    }

    private static Pipeline buildDataflowPipeline(DataflowPipelineOptions options) {
        options.setStableUniqueNames(PipelineOptions.CheckEnabled.ERROR);
        options.setRunner(DataflowRunner.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)p.apply("ReadMyFile", (PTransform)TextIO.read().from("gs://bucket/object"))).apply("WriteMyFile", (PTransform)TextIO.write().to("gs://bucket/object"));
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        return p;
    }

    private static Pipeline buildDataflowPipelineWithLargeGraph(DataflowPipelineOptions options) {
        options.setStableUniqueNames(PipelineOptions.CheckEnabled.ERROR);
        options.setRunner(DataflowRunner.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        for (int i = 0; i < 100; ++i) {
            ((PCollection)p.apply("ReadMyFile_" + i, (PTransform)TextIO.read().from("gs://bucket/object"))).apply("WriteMyFile_" + i, (PTransform)TextIO.write().to("gs://bucket/object"));
        }
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        return p;
    }

    private static Dataflow buildMockDataflow(Dataflow.Projects.Locations.Jobs mockJobs) throws IOException {
        Dataflow mockDataflowClient = (Dataflow)Mockito.mock(Dataflow.class);
        Dataflow.Projects mockProjects = (Dataflow.Projects)Mockito.mock(Dataflow.Projects.class);
        Dataflow.Projects.Locations mockLocations = (Dataflow.Projects.Locations)Mockito.mock(Dataflow.Projects.Locations.class);
        Dataflow.Projects.Locations.Jobs.Create mockRequest = (Dataflow.Projects.Locations.Jobs.Create)Mockito.mock(Dataflow.Projects.Locations.Jobs.Create.class);
        Dataflow.Projects.Locations.Jobs.List mockList = (Dataflow.Projects.Locations.Jobs.List)Mockito.mock(Dataflow.Projects.Locations.Jobs.List.class);
        Mockito.when((Object)mockDataflowClient.projects()).thenReturn((Object)mockProjects);
        Mockito.when((Object)mockDataflowClient.getBaseUrl()).thenReturn((Object)"dataflow.googleapis.com");
        Mockito.when((Object)mockProjects.locations()).thenReturn((Object)mockLocations);
        Mockito.when((Object)mockLocations.jobs()).thenReturn((Object)mockJobs);
        Mockito.when((Object)mockJobs.create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)ArgumentMatchers.isA(Job.class))).thenReturn((Object)mockRequest);
        Mockito.when((Object)mockJobs.list((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID))).thenReturn((Object)mockList);
        Mockito.when((Object)mockList.setPageToken((String)ArgumentMatchers.any())).thenReturn((Object)mockList);
        Mockito.when((Object)((ListJobsResponse)mockList.execute())).thenReturn((Object)new ListJobsResponse().setJobs(Arrays.asList(new Job().setName("oldjobname").setId("oldJobId").setCurrentState("JOB_STATE_RUNNING"))));
        Job resultJob = new Job();
        resultJob.setId("newid");
        Mockito.when((Object)((Job)mockRequest.execute())).thenReturn((Object)resultJob);
        return mockDataflowClient;
    }

    private static GcsUtil buildMockGcsUtil() throws IOException {
        GcsUtil mockGcsUtil = (GcsUtil)Mockito.mock(GcsUtil.class);
        Mockito.when((Object)mockGcsUtil.create((GcsPath)ArgumentMatchers.any(GcsPath.class), (GcsUtil.CreateOptions)ArgumentMatchers.any(GcsUtil.CreateOptions.class))).then(invocation -> FileChannel.open(java.nio.file.Files.createTempFile("channel-", ".tmp", new FileAttribute[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE));
        Mockito.when((Object)mockGcsUtil.create((GcsPath)ArgumentMatchers.any(GcsPath.class), (GcsUtil.CreateOptions)ArgumentMatchers.any(GcsUtil.CreateOptions.class))).then(invocation -> FileChannel.open(java.nio.file.Files.createTempFile("channel-", ".tmp", new FileAttribute[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE));
        Mockito.when((Object)mockGcsUtil.expand((GcsPath)ArgumentMatchers.any(GcsPath.class))).then(invocation -> ImmutableList.of((Object)((GcsPath)invocation.getArguments()[0])));
        ((GcsUtil)Mockito.doNothing().when((Object)mockGcsUtil)).verifyBucketAccessible(GcsPath.fromUri((String)VALID_STAGING_BUCKET));
        ((GcsUtil)Mockito.doNothing().when((Object)mockGcsUtil)).verifyBucketAccessible(GcsPath.fromUri((String)VALID_TEMP_BUCKET));
        ((GcsUtil)Mockito.doNothing().when((Object)mockGcsUtil)).verifyBucketAccessible(GcsPath.fromUri((String)"gs://valid-bucket/temp/staging"));
        ((GcsUtil)Mockito.doNothing().when((Object)mockGcsUtil)).verifyBucketAccessible(GcsPath.fromUri((String)VALID_PROFILE_BUCKET));
        ((GcsUtil)Mockito.doThrow((Throwable[])new Throwable[]{new FileNotFoundException()}).when((Object)mockGcsUtil)).verifyBucketAccessible(GcsPath.fromUri((String)NON_EXISTENT_BUCKET));
        Mockito.when((Object)mockGcsUtil.getObjects(ArgumentMatchers.anyList())).thenAnswer(invocationOnMock -> {
            List gcsPaths = (List)invocationOnMock.getArguments()[0];
            ArrayList<GcsUtil.StorageObjectOrIOException> results = new ArrayList<GcsUtil.StorageObjectOrIOException>();
            for (GcsPath gcsPath : gcsPaths) {
                if (!gcsPath.getBucket().equals(VALID_BUCKET)) continue;
                StorageObject resultObject = new StorageObject();
                resultObject.setBucket(gcsPath.getBucket());
                resultObject.setName(gcsPath.getObject());
                results.add(GcsUtil.StorageObjectOrIOException.create((StorageObject)resultObject));
            }
            return results;
        });
        ((GcsUtil)Mockito.doNothing().when((Object)mockGcsUtil)).verifyBucketAccessible(GcsPath.fromUri((String)"gs://bucket/object"));
        return mockGcsUtil;
    }

    private DataflowPipelineOptions buildPipelineOptions() throws IOException {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setRunner(DataflowRunner.class);
        options.setProject(PROJECT_ID);
        options.setTempLocation(VALID_TEMP_BUCKET);
        options.setRegion(REGION_ID);
        options.setFilesToStage(new ArrayList());
        options.setDataflowClient(DataflowRunnerTest.buildMockDataflow(this.mockJobs));
        options.setGcsUtil(this.mockGcsUtil);
        options.setGcpCredential((Credentials)new TestCredential());
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        return options;
    }

    @Test
    public void testPathValidation() {
        String[] args = new String[]{"--runner=DataflowRunner", "--region=some-region-1", "--tempLocation=/tmp/not/a/gs/path", "--project=test-project", "--credentialFactoryClass=" + NoopCredentialFactory.class.getName()};
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("DataflowRunner requires gcpTempLocation");
        Pipeline.create((PipelineOptions)PipelineOptionsFactory.fromArgs((String[])args).create()).run();
    }

    @Test
    public void testPathExistsValidation() {
        String[] args = new String[]{"--runner=DataflowRunner", "--region=some-region-1", "--tempLocation=gs://does/not/exist", "--project=test-project", "--credentialFactoryClass=" + NoopCredentialFactory.class.getName()};
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("gcpTempLocation");
        this.thrown.expectCause(Matchers.hasProperty((String)"message", (Matcher)Matchers.containsString((String)"gs://does/not/exist")));
        Pipeline.create((PipelineOptions)PipelineOptionsFactory.fromArgs((String[])args).create()).run();
    }

    @Test
    public void testPathValidatorOverride() {
        String[] args = new String[]{"--runner=DataflowRunner", "--region=some-region-1", "--tempLocation=/tmp/testing", "--project=test-project", "--credentialFactoryClass=" + NoopCredentialFactory.class.getName(), "--pathValidatorClass=" + NoopPathValidator.class.getName()};
        TestPipeline.fromOptions((PipelineOptions)PipelineOptionsFactory.fromArgs((String[])args).create());
    }

    @Test
    public void testFromOptionsWithUppercaseConvertsToLowercase() throws Exception {
        String mixedCase = "ThisJobNameHasMixedCase";
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setJobName(mixedCase);
        DataflowRunner.fromOptions((PipelineOptions)options);
        MatcherAssert.assertThat((Object)options.getJobName(), (Matcher)Matchers.equalTo((Object)mixedCase.toLowerCase()));
    }

    @Test
    public void testFromOptionsUserAgentFromPipelineInfo() throws Exception {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        DataflowRunner.fromOptions((PipelineOptions)options);
        String expectedName = DataflowRunnerInfo.getDataflowRunnerInfo().getName().replace(" ", "_");
        MatcherAssert.assertThat((Object)options.getUserAgent(), (Matcher)Matchers.containsString((String)expectedName));
        String expectedVersion = DataflowRunnerInfo.getDataflowRunnerInfo().getVersion();
        MatcherAssert.assertThat((Object)options.getUserAgent(), (Matcher)Matchers.containsString((String)expectedVersion));
    }

    @Test
    public void testSettingOfSdkPipelineOptions() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setAppName(DataflowRunnerTest.class.getSimpleName());
        options.setJobName("some-job-name");
        Pipeline p = Pipeline.create((PipelineOptions)options);
        p.run();
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)this.mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
        Map sdkPipelineOptions = ((Job)jobCaptor.getValue()).getEnvironment().getSdkPipelineOptions();
        MatcherAssert.assertThat((Object)sdkPipelineOptions, (Matcher)Matchers.hasKey((Object)"options"));
        Map optionsMap = (Map)sdkPipelineOptions.get("options");
        MatcherAssert.assertThat((Object)optionsMap, (Matcher)Matchers.hasEntry((Object)"appName", (Object)options.getAppName()));
        MatcherAssert.assertThat((Object)optionsMap, (Matcher)Matchers.hasEntry((Object)"project", (Object)options.getProject()));
        MatcherAssert.assertThat((Object)optionsMap, (Matcher)Matchers.hasEntry((Object)"pathValidatorClass", (Object)options.getPathValidatorClass().getName()));
        MatcherAssert.assertThat((Object)optionsMap, (Matcher)Matchers.hasEntry((Object)"runner", (Object)options.getRunner().getName()));
        MatcherAssert.assertThat((Object)optionsMap, (Matcher)Matchers.hasEntry((Object)"jobName", (Object)options.getJobName()));
        MatcherAssert.assertThat((Object)optionsMap, (Matcher)Matchers.hasEntry((Object)"tempLocation", (Object)options.getTempLocation()));
        MatcherAssert.assertThat((Object)optionsMap, (Matcher)Matchers.hasEntry((Object)"stagingLocation", (Object)options.getStagingLocation()));
        MatcherAssert.assertThat((Object)optionsMap, (Matcher)Matchers.hasEntry((Object)"stableUniqueNames", (Object)options.getStableUniqueNames().toString()));
        MatcherAssert.assertThat((Object)optionsMap, (Matcher)Matchers.hasEntry((Object)"streaming", (Object)options.isStreaming()));
        MatcherAssert.assertThat((Object)optionsMap, (Matcher)Matchers.hasEntry((Object)"numberOfWorkerHarnessThreads", (Object)options.getNumberOfWorkerHarnessThreads()));
        MatcherAssert.assertThat((Object)optionsMap, (Matcher)Matchers.hasEntry((Object)"region", (Object)options.getRegion()));
    }

    @Test
    public void testDefaultRegionSet() throws Exception {
        try (MockedStatic mocked = Mockito.mockStatic(DefaultGcpRegionFactory.class);){
            mocked.when(DefaultGcpRegionFactory::getRegionFromEnvironment).thenReturn((Object)REGION_ID);
            Dataflow.Projects.Locations.Jobs mockJobs = (Dataflow.Projects.Locations.Jobs)Mockito.mock(Dataflow.Projects.Locations.Jobs.class);
            DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
            options.setRunner(DataflowRunner.class);
            options.setProject(PROJECT_ID);
            options.setTempLocation(VALID_TEMP_BUCKET);
            options.setFilesToStage(new ArrayList());
            options.setDataflowClient(DataflowRunnerTest.buildMockDataflow(mockJobs));
            options.setGcsUtil(DataflowRunnerTest.buildMockGcsUtil());
            options.setGcpCredential((Credentials)new TestCredential());
            Pipeline p = Pipeline.create((PipelineOptions)options);
            p.run();
            ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
            ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
            Map sdkPipelineOptions = ((Job)jobCaptor.getValue()).getEnvironment().getSdkPipelineOptions();
            MatcherAssert.assertThat((Object)sdkPipelineOptions, (Matcher)Matchers.hasKey((Object)"options"));
            Map optionsMap = (Map)sdkPipelineOptions.get("options");
            MatcherAssert.assertThat((Object)optionsMap, (Matcher)Matchers.hasEntry((Object)"region", (Object)options.getRegion()));
        }
    }

    @Test
    public void testSettingFlexRS() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setFlexRSGoal(DataflowPipelineOptions.FlexResourceSchedulingGoal.COST_OPTIMIZED);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        p.run();
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)this.mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
        Assert.assertEquals((Object)"FLEXRS_COST_OPTIMIZED", (Object)((Job)jobCaptor.getValue()).getEnvironment().getFlexResourceSchedulingGoal());
    }

    @Test
    public void testSettingOfPipelineOptionsWithCustomUserType() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        ((JacksonIncompatibleOptions)options.as(JacksonIncompatibleOptions.class)).setJacksonIncompatible(new JacksonIncompatible("userCustomTypeTest"));
        Pipeline p = Pipeline.create((PipelineOptions)options);
        p.run();
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)this.mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
        Map sdkPipelineOptions = ((Job)jobCaptor.getValue()).getEnvironment().getSdkPipelineOptions();
        MatcherAssert.assertThat((Object)sdkPipelineOptions, (Matcher)Matchers.hasKey((Object)"options"));
        Map optionsMap = (Map)sdkPipelineOptions.get("options");
        MatcherAssert.assertThat((Object)optionsMap, (Matcher)Matchers.hasEntry((Object)"jacksonIncompatible", (Object)"userCustomTypeTest"));
    }

    @Test
    public void testZoneAndWorkerRegionMutuallyExclusive() {
        DataflowPipelineWorkerPoolOptions options = (DataflowPipelineWorkerPoolOptions)PipelineOptionsFactory.as(DataflowPipelineWorkerPoolOptions.class);
        options.setZone("us-east1-b");
        options.setWorkerRegion("us-east1");
        Assert.assertThrows(IllegalArgumentException.class, () -> DataflowRunner.validateWorkerSettings((DataflowPipelineWorkerPoolOptions)options));
    }

    @Test
    public void testZoneAndWorkerZoneMutuallyExclusive() {
        DataflowPipelineWorkerPoolOptions options = (DataflowPipelineWorkerPoolOptions)PipelineOptionsFactory.as(DataflowPipelineWorkerPoolOptions.class);
        options.setZone("us-east1-b");
        options.setWorkerZone("us-east1-c");
        Assert.assertThrows(IllegalArgumentException.class, () -> DataflowRunner.validateWorkerSettings((DataflowPipelineWorkerPoolOptions)options));
    }

    @Test
    public void testExperimentRegionAndWorkerRegionMutuallyExclusive() {
        DataflowPipelineWorkerPoolOptions options = (DataflowPipelineWorkerPoolOptions)PipelineOptionsFactory.as(DataflowPipelineWorkerPoolOptions.class);
        DataflowPipelineOptions dataflowOptions = (DataflowPipelineOptions)options.as(DataflowPipelineOptions.class);
        ExperimentalOptions.addExperiment((ExperimentalOptions)dataflowOptions, (String)"worker_region=us-west1");
        options.setWorkerRegion("us-east1");
        Assert.assertThrows(IllegalArgumentException.class, () -> DataflowRunner.validateWorkerSettings((DataflowPipelineWorkerPoolOptions)options));
    }

    @Test
    public void testExperimentRegionAndWorkerZoneMutuallyExclusive() {
        DataflowPipelineWorkerPoolOptions options = (DataflowPipelineWorkerPoolOptions)PipelineOptionsFactory.as(DataflowPipelineWorkerPoolOptions.class);
        DataflowPipelineOptions dataflowOptions = (DataflowPipelineOptions)options.as(DataflowPipelineOptions.class);
        ExperimentalOptions.addExperiment((ExperimentalOptions)dataflowOptions, (String)"worker_region=us-west1");
        options.setWorkerZone("us-east1-b");
        Assert.assertThrows(IllegalArgumentException.class, () -> DataflowRunner.validateWorkerSettings((DataflowPipelineWorkerPoolOptions)options));
    }

    @Test
    public void testWorkerRegionAndWorkerZoneMutuallyExclusive() {
        DataflowPipelineWorkerPoolOptions options = (DataflowPipelineWorkerPoolOptions)PipelineOptionsFactory.as(DataflowPipelineWorkerPoolOptions.class);
        options.setWorkerRegion("us-east1");
        options.setWorkerZone("us-east1-b");
        Assert.assertThrows(IllegalArgumentException.class, () -> DataflowRunner.validateWorkerSettings((DataflowPipelineWorkerPoolOptions)options));
    }

    @Test
    public void testZoneAliasWorkerZone() {
        DataflowPipelineWorkerPoolOptions options = (DataflowPipelineWorkerPoolOptions)PipelineOptionsFactory.as(DataflowPipelineWorkerPoolOptions.class);
        options.setZone("us-east1-b");
        DataflowRunner.validateWorkerSettings((DataflowPipelineWorkerPoolOptions)options);
        Assert.assertNull((Object)options.getZone());
        Assert.assertEquals((Object)"us-east1-b", (Object)options.getWorkerZone());
    }

    @Test
    public void testAliasForLegacyWorkerHarnessContainerImage() {
        DataflowPipelineWorkerPoolOptions options = (DataflowPipelineWorkerPoolOptions)PipelineOptionsFactory.as(DataflowPipelineWorkerPoolOptions.class);
        String testImage = "image.url:worker";
        options.setWorkerHarnessContainerImage(testImage);
        DataflowRunner.validateWorkerSettings((DataflowPipelineWorkerPoolOptions)options);
        Assert.assertEquals((Object)testImage, (Object)options.getWorkerHarnessContainerImage());
        Assert.assertEquals((Object)testImage, (Object)options.getSdkContainerImage());
    }

    @Test
    public void testAliasForSdkContainerImage() {
        DataflowPipelineWorkerPoolOptions options = (DataflowPipelineWorkerPoolOptions)PipelineOptionsFactory.as(DataflowPipelineWorkerPoolOptions.class);
        String testImage = "image.url:sdk";
        options.setSdkContainerImage("image.url:sdk");
        DataflowRunner.validateWorkerSettings((DataflowPipelineWorkerPoolOptions)options);
        Assert.assertEquals((Object)testImage, (Object)options.getWorkerHarnessContainerImage());
        Assert.assertEquals((Object)testImage, (Object)options.getSdkContainerImage());
    }

    @Test
    public void testRegionRequiredForServiceRunner() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setRegion(null);
        options.setDataflowEndpoint("https://dataflow.googleapis.com");
        Assert.assertThrows(IllegalArgumentException.class, () -> DataflowRunner.fromOptions((PipelineOptions)options));
    }

    @Test
    public void testRegionOptionalForNonServiceRunner() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setRegion(null);
        options.setDataflowEndpoint("http://localhost:20281");
        DataflowRunner.fromOptions((PipelineOptions)options);
    }

    @Test
    public void testRun() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        Pipeline p = DataflowRunnerTest.buildDataflowPipeline(options);
        DataflowPipelineJob job = (DataflowPipelineJob)p.run();
        Assert.assertEquals((Object)"newid", (Object)job.getJobId());
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)this.mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
        DataflowRunnerTest.assertValidJob((Job)jobCaptor.getValue());
    }

    @Test
    public void testTextIOWithRuntimeParameters() throws IOException {
        DataflowPipelineOptions dataflowOptions = this.buildPipelineOptions();
        RuntimeTestOptions options = (RuntimeTestOptions)dataflowOptions.as(RuntimeTestOptions.class);
        Pipeline p = DataflowRunnerTest.buildDataflowPipeline(dataflowOptions);
        ((PCollection)p.apply((PTransform)TextIO.read().from(options.getInput()))).apply((PTransform)TextIO.write().to(options.getOutput()));
    }

    @Test
    public void testUnconsumedReads() throws IOException {
        DataflowPipelineOptions dataflowOptions = this.buildPipelineOptions();
        RuntimeTestOptions options = (RuntimeTestOptions)dataflowOptions.as(RuntimeTestOptions.class);
        Pipeline p = DataflowRunnerTest.buildDataflowPipeline(dataflowOptions);
        p.apply((PTransform)TextIO.read().from(options.getInput()));
        DataflowRunner.fromOptions((PipelineOptions)dataflowOptions).replaceV1Transforms(p);
        final AtomicBoolean unconsumedSeenAsInput = new AtomicBoolean();
        p.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                unconsumedSeenAsInput.set(true);
            }
        });
        MatcherAssert.assertThat((Object)unconsumedSeenAsInput.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testRunReturnDifferentRequestId() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        Dataflow mockDataflowClient = options.getDataflowClient();
        Dataflow.Projects.Locations.Jobs.Create mockRequest = (Dataflow.Projects.Locations.Jobs.Create)Mockito.mock(Dataflow.Projects.Locations.Jobs.Create.class);
        Mockito.when((Object)mockDataflowClient.projects().locations().jobs().create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)ArgumentMatchers.any(Job.class))).thenReturn((Object)mockRequest);
        Job resultJob = new Job();
        resultJob.setId("newid");
        resultJob.setClientRequestId("different_request_id");
        Mockito.when((Object)((Job)mockRequest.execute())).thenReturn((Object)resultJob);
        Pipeline p = DataflowRunnerTest.buildDataflowPipeline(options);
        try {
            p.run();
            Assert.fail((String)"Expected DataflowJobAlreadyExistsException");
        }
        catch (DataflowJobAlreadyExistsException expected) {
            MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)Matchers.containsString((String)"If you want to submit a second job, try again by setting a different name using --jobName."));
            Assert.assertEquals((Object)expected.getJob().getJobId(), (Object)resultJob.getId());
        }
    }

    @Test
    public void testUpdate() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setUpdate(true);
        options.setJobName("oldJobName");
        Pipeline p = DataflowRunnerTest.buildDataflowPipeline(options);
        DataflowPipelineJob job = (DataflowPipelineJob)p.run();
        Assert.assertEquals((Object)"newid", (Object)job.getJobId());
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)this.mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
        DataflowRunnerTest.assertValidJob((Job)jobCaptor.getValue());
    }

    @Test
    public void testUploadGraph() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setExperiments(Arrays.asList("upload_graph"));
        Pipeline p = DataflowRunnerTest.buildDataflowPipeline(options);
        p.run();
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)this.mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
        DataflowRunnerTest.assertValidJob((Job)jobCaptor.getValue());
        Assert.assertTrue((boolean)((Job)jobCaptor.getValue()).getSteps().isEmpty());
        Assert.assertTrue((boolean)((Job)jobCaptor.getValue()).getStepsLocation().startsWith("gs://valid-bucket/temp/staging/dataflow_graph"));
    }

    @Test
    public void testUploadGraphV2IsNoOp() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setExperiments(Arrays.asList("upload_graph", "use_runner_v2"));
        Pipeline p = DataflowRunnerTest.buildDataflowPipeline(options);
        p.run();
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)this.mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
        DataflowRunnerTest.assertValidJob((Job)jobCaptor.getValue());
        Assert.assertNull((Object)((Job)jobCaptor.getValue()).getStepsLocation());
    }

    @Test
    public void testUploadGraphWithAutoUpload() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        Pipeline p = DataflowRunnerTest.buildDataflowPipelineWithLargeGraph(options);
        p.run();
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)this.mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
        DataflowRunnerTest.assertValidJob((Job)jobCaptor.getValue());
        Assert.assertTrue((boolean)((Job)jobCaptor.getValue()).getSteps().isEmpty());
        Assert.assertTrue((boolean)((Job)jobCaptor.getValue()).getStepsLocation().startsWith("gs://valid-bucket/temp/staging/dataflow_graph"));
    }

    @Test
    public void testUpdateNonExistentPipeline() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Could not find running job named badjobname");
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setUpdate(true);
        options.setJobName("badJobName");
        Pipeline p = DataflowRunnerTest.buildDataflowPipeline(options);
        p.run();
    }

    @Test
    public void testUpdateAlreadyUpdatedPipeline() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setUpdate(true);
        options.setJobName("oldJobName");
        Dataflow mockDataflowClient = options.getDataflowClient();
        Dataflow.Projects.Locations.Jobs.Create mockRequest = (Dataflow.Projects.Locations.Jobs.Create)Mockito.mock(Dataflow.Projects.Locations.Jobs.Create.class);
        Mockito.when((Object)mockDataflowClient.projects().locations().jobs().create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)ArgumentMatchers.any(Job.class))).thenReturn((Object)mockRequest);
        final Job resultJob = new Job();
        resultJob.setId("newid");
        resultJob.setClientRequestId("different_request_id");
        Mockito.when((Object)((Job)mockRequest.execute())).thenReturn((Object)resultJob);
        Pipeline p = DataflowRunnerTest.buildDataflowPipeline(options);
        this.thrown.expect(DataflowJobAlreadyUpdatedException.class);
        this.thrown.expect((Matcher)new TypeSafeMatcher<DataflowJobAlreadyUpdatedException>(){

            public void describeTo(Description description) {
                description.appendText("Expected job ID: " + resultJob.getId());
            }

            protected boolean matchesSafely(DataflowJobAlreadyUpdatedException item) {
                return resultJob.getId().equals(item.getJob().getJobId());
            }
        });
        this.thrown.expectMessage("The job named oldjobname with id: oldJobId has already been updated into job id: newid and cannot be updated again.");
        p.run();
    }

    @Test
    public void testRunWithFiles() throws IOException {
        String cloudDataflowDataset = "somedataset";
        File temp1 = File.createTempFile("DataflowRunnerTest-", ".txt");
        temp1.deleteOnExit();
        File temp2 = File.createTempFile("DataflowRunnerTest2-", ".txt");
        temp2.deleteOnExit();
        String overridePackageName = "alias.txt";
        Mockito.when((Object)this.mockGcsUtil.getObjects(ArgumentMatchers.anyList())).thenReturn((Object)ImmutableList.of((Object)GcsUtil.StorageObjectOrIOException.create((IOException)new FileNotFoundException("some/path"))));
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setFilesToStage((List)ImmutableList.of((Object)temp1.getAbsolutePath(), (Object)(overridePackageName + "=" + temp2.getAbsolutePath())));
        options.setStagingLocation(VALID_STAGING_BUCKET);
        options.setTempLocation(VALID_TEMP_BUCKET);
        options.setTempDatasetId("somedataset");
        options.setProject(PROJECT_ID);
        options.setRegion(REGION_ID);
        options.setJobName("job");
        options.setDataflowClient(DataflowRunnerTest.buildMockDataflow(this.mockJobs));
        options.setGcsUtil(this.mockGcsUtil);
        options.setGcpCredential((Credentials)new TestCredential());
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)ArgumentMatchers.any(GcsPath.class), (GcsUtil.CreateOptions)ArgumentMatchers.any(GcsUtil.CreateOptions.class))).then(invocation -> FileChannel.open(java.nio.file.Files.createTempFile("channel-", ".tmp", new FileAttribute[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE));
        Pipeline p = DataflowRunnerTest.buildDataflowPipeline(options);
        DataflowPipelineJob job = (DataflowPipelineJob)p.run();
        Assert.assertEquals((Object)"newid", (Object)job.getJobId());
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)this.mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
        Job workflowJob = (Job)jobCaptor.getValue();
        DataflowRunnerTest.assertValidJob(workflowJob);
        Assert.assertEquals((long)2L, (long)((WorkerPool)workflowJob.getEnvironment().getWorkerPools().get(0)).getPackages().size());
        DataflowPackage workflowPackage1 = (DataflowPackage)((WorkerPool)workflowJob.getEnvironment().getWorkerPools().get(0)).getPackages().get(0);
        MatcherAssert.assertThat((Object)workflowPackage1.getName(), (Matcher)Matchers.endsWith((String)Files.getFileExtension((String)temp1.getAbsolutePath())));
        DataflowPackage workflowPackage2 = (DataflowPackage)((WorkerPool)workflowJob.getEnvironment().getWorkerPools().get(0)).getPackages().get(1);
        Assert.assertEquals((Object)overridePackageName, (Object)workflowPackage2.getName());
        Assert.assertEquals((Object)GcsPath.fromUri((String)VALID_TEMP_BUCKET).toResourceName(), (Object)workflowJob.getEnvironment().getTempStoragePrefix());
        Assert.assertEquals((Object)"somedataset", (Object)workflowJob.getEnvironment().getDataset());
        Assert.assertEquals((Object)DataflowRunnerInfo.getDataflowRunnerInfo().getName(), workflowJob.getEnvironment().getUserAgent().get("name"));
        Assert.assertEquals((Object)DataflowRunnerInfo.getDataflowRunnerInfo().getVersion(), workflowJob.getEnvironment().getUserAgent().get("version"));
    }

    @Test(expected=RuntimeException.class)
    public void testRunWithMissingFiles() throws IOException {
        String cloudDataflowDataset = "somedataset";
        File temp = new File("/this/is/not/a/path/that/will/exist");
        String overridePackageName = "alias.txt";
        Mockito.when((Object)this.mockGcsUtil.getObjects(ArgumentMatchers.anyList())).thenReturn((Object)ImmutableList.of((Object)GcsUtil.StorageObjectOrIOException.create((IOException)new FileNotFoundException("some/path"))));
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setFilesToStage((List)ImmutableList.of((Object)(overridePackageName + "=" + temp.getAbsolutePath())));
        options.setStagingLocation(VALID_STAGING_BUCKET);
        options.setTempLocation(VALID_TEMP_BUCKET);
        options.setTempDatasetId("somedataset");
        options.setProject(PROJECT_ID);
        options.setRegion(REGION_ID);
        options.setJobName("job");
        options.setDataflowClient(DataflowRunnerTest.buildMockDataflow(this.mockJobs));
        options.setGcsUtil(this.mockGcsUtil);
        options.setGcpCredential((Credentials)new TestCredential());
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)ArgumentMatchers.any(GcsPath.class), (GcsUtil.CreateOptions)ArgumentMatchers.any(GcsUtil.CreateOptions.class))).then(invocation -> FileChannel.open(java.nio.file.Files.createTempFile("channel-", ".tmp", new FileAttribute[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE));
        Pipeline p = DataflowRunnerTest.buildDataflowPipeline(options);
        p.run();
    }

    @Test
    public void runWithDefaultFilesToStage() throws Exception {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setFilesToStage(null);
        DataflowRunner.fromOptions((PipelineOptions)options);
        Assert.assertFalse((boolean)options.getFilesToStage().isEmpty());
    }

    @Test
    public void testGcsStagingLocationInitialization() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setTempLocation(VALID_TEMP_BUCKET);
        options.setProject(PROJECT_ID);
        options.setRegion(REGION_ID);
        options.setGcpCredential((Credentials)new TestCredential());
        options.setGcsUtil(this.mockGcsUtil);
        options.setRunner(DataflowRunner.class);
        DataflowRunner.fromOptions((PipelineOptions)options);
        Assert.assertNotNull((Object)options.getStagingLocation());
    }

    @Test
    public void testInvalidGcpTempLocation() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setGcpTempLocation("file://temp/location");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"Expected a valid 'gs://' path but was given"));
        DataflowRunner.fromOptions((PipelineOptions)options);
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)this.mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
        DataflowRunnerTest.assertValidJob((Job)jobCaptor.getValue());
    }

    @Test
    public void testNonGcsTempLocation() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setTempLocation("file://temp/location");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("DataflowRunner requires gcpTempLocation, but failed to retrieve a value from PipelineOptions");
        DataflowRunner.fromOptions((PipelineOptions)options);
    }

    @Test
    public void testInvalidStagingLocation() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setStagingLocation("file://my/staging/location");
        try {
            DataflowRunner.fromOptions((PipelineOptions)options);
            Assert.fail((String)"fromOptions should have failed");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Expected a valid 'gs://' path but was given"));
        }
        options.setStagingLocation("my/staging/location");
        try {
            DataflowRunner.fromOptions((PipelineOptions)options);
            Assert.fail((String)"fromOptions should have failed");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Expected a valid 'gs://' path but was given"));
        }
    }

    @Test
    public void testInvalidProfileLocation() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setSaveProfilesToGcs("file://my/staging/location");
        try {
            DataflowRunner.fromOptions((PipelineOptions)options);
            Assert.fail((String)"fromOptions should have failed");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Expected a valid 'gs://' path but was given"));
        }
        options.setSaveProfilesToGcs("my/staging/location");
        try {
            DataflowRunner.fromOptions((PipelineOptions)options);
            Assert.fail((String)"fromOptions should have failed");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Expected a valid 'gs://' path but was given"));
        }
    }

    @Test
    public void testNonExistentTempLocation() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setGcpTempLocation(NON_EXISTENT_BUCKET);
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectCause(Matchers.instanceOf(FileNotFoundException.class));
        this.thrown.expectMessage(Matchers.containsString((String)"Output path does not exist or is not writeable: gs://non-existent-bucket/location"));
        DataflowRunner.fromOptions((PipelineOptions)options);
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)this.mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
        DataflowRunnerTest.assertValidJob((Job)jobCaptor.getValue());
    }

    @Test
    public void testNonExistentStagingLocation() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setStagingLocation(NON_EXISTENT_BUCKET);
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectCause(Matchers.instanceOf(FileNotFoundException.class));
        this.thrown.expectMessage(Matchers.containsString((String)"Output path does not exist or is not writeable: gs://non-existent-bucket/location"));
        DataflowRunner.fromOptions((PipelineOptions)options);
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)this.mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
        DataflowRunnerTest.assertValidJob((Job)jobCaptor.getValue());
    }

    @Test
    public void testReplaceGcsFilesWithLocalFilesEmptyList() {
        List filesToStage = Collections.emptyList();
        List processedFiles = DataflowRunner.replaceGcsFilesWithLocalFiles(filesToStage);
        Assert.assertTrue((boolean)processedFiles.isEmpty());
    }

    @Test(expected=RuntimeException.class)
    public void testReplaceGcsFilesWithLocalFilesIOError() {
        List<String> filesToStage = Collections.singletonList("gs://non-existent-bucket/file.jar");
        DataflowRunner.replaceGcsFilesWithLocalFiles(filesToStage);
    }

    @Test
    public void testNonExistentProfileLocation() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setSaveProfilesToGcs(NON_EXISTENT_BUCKET);
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectCause(Matchers.instanceOf(FileNotFoundException.class));
        this.thrown.expectMessage(Matchers.containsString((String)"Output path does not exist or is not writeable: gs://non-existent-bucket/location"));
        DataflowRunner.fromOptions((PipelineOptions)options);
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)this.mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
        DataflowRunnerTest.assertValidJob((Job)jobCaptor.getValue());
    }

    @Test
    public void testNoProjectFails() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setProject(null);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Project id");
        this.thrown.expectMessage("when running a Dataflow in the cloud");
        DataflowRunner.fromOptions((PipelineOptions)options);
    }

    @Test
    public void testProjectId() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setProject("foo-12345");
        DataflowRunner.fromOptions((PipelineOptions)options);
    }

    @Test
    public void testProjectPrefix() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setProject("google.com:some-project-12345");
        DataflowRunner.fromOptions((PipelineOptions)options);
    }

    @Test
    public void testProjectNumber() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setProject("12345");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Project ID");
        this.thrown.expectMessage("project number");
        DataflowRunner.fromOptions((PipelineOptions)options);
    }

    @Test
    public void testProjectDescription() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setProject("some project");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Project ID");
        this.thrown.expectMessage("project description");
        DataflowRunner.fromOptions((PipelineOptions)options);
    }

    @Test
    public void testInvalidNumberOfWorkerHarnessThreads() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        ((DataflowPipelineDebugOptions)options.as(DataflowPipelineDebugOptions.class)).setNumberOfWorkerHarnessThreads(-1);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Number of worker harness threads");
        this.thrown.expectMessage("Please make sure the value is non-negative.");
        DataflowRunner.fromOptions((PipelineOptions)options);
    }

    @Test
    public void testNoStagingLocationAndNoTempLocationFails() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setRunner(DataflowRunner.class);
        options.setProject("foo-project");
        options.setRegion(REGION_ID);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("DataflowRunner requires gcpTempLocation, but failed to retrieve a value from PipelineOption");
        DataflowRunner.fromOptions((PipelineOptions)options);
    }

    @Test
    public void testApplySdkEnvironmentOverrides() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        String dockerHubPythonContainerUrl = "apache/beam_python3.9_sdk:latest";
        String gcrPythonContainerUrl = "gcr.io/apache-beam-testing/beam-sdk/beam_python3.9_sdk:latest";
        options.setSdkHarnessContainerImageOverrides(".*python.*," + gcrPythonContainerUrl);
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        RunnerApi.Pipeline pipeline = RunnerApi.Pipeline.newBuilder().setComponents(RunnerApi.Components.newBuilder().putEnvironments("env", RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER)).setPayload(RunnerApi.DockerPayload.newBuilder().setContainerImage(dockerHubPythonContainerUrl).build().toByteString()).build())).build();
        RunnerApi.Pipeline expectedPipeline = RunnerApi.Pipeline.newBuilder().setComponents(RunnerApi.Components.newBuilder().putEnvironments("env", RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER)).setPayload(RunnerApi.DockerPayload.newBuilder().setContainerImage(gcrPythonContainerUrl).build().toByteString()).build())).build();
        MatcherAssert.assertThat((Object)runner.applySdkEnvironmentOverrides(pipeline, options), (Matcher)Matchers.equalTo((Object)expectedPipeline));
    }

    @Test
    public void testApplySdkEnvironmentOverridesByDefault() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        String dockerHubPythonContainerUrl = "apache/beam_python3.9_sdk:latest";
        String gcrPythonContainerUrl = "gcr.io/cloud-dataflow/v1beta3/beam_python3.9_sdk:latest";
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        RunnerApi.Pipeline pipeline = RunnerApi.Pipeline.newBuilder().setComponents(RunnerApi.Components.newBuilder().putEnvironments("env", RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER)).setPayload(RunnerApi.DockerPayload.newBuilder().setContainerImage(dockerHubPythonContainerUrl).build().toByteString()).build())).build();
        RunnerApi.Pipeline expectedPipeline = RunnerApi.Pipeline.newBuilder().setComponents(RunnerApi.Components.newBuilder().putEnvironments("env", RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER)).setPayload(RunnerApi.DockerPayload.newBuilder().setContainerImage(gcrPythonContainerUrl).build().toByteString()).build())).build();
        MatcherAssert.assertThat((Object)runner.applySdkEnvironmentOverrides(pipeline, options), (Matcher)Matchers.equalTo((Object)expectedPipeline));
    }

    @Test
    public void testStageArtifactWithoutStagedName() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        File temp1 = File.createTempFile("artifact1-", ".txt");
        temp1.deleteOnExit();
        File temp2 = File.createTempFile("artifact2-", ".txt");
        temp2.deleteOnExit();
        RunnerApi.ArtifactInformation fooLocalArtifact = RunnerApi.ArtifactInformation.newBuilder().setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.FILE)).setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(temp1.getAbsolutePath()).build().toByteString()).build();
        RunnerApi.ArtifactInformation barLocalArtifact = RunnerApi.ArtifactInformation.newBuilder().setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.FILE)).setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(temp2.getAbsolutePath()).build().toByteString()).build();
        RunnerApi.Pipeline pipeline = RunnerApi.Pipeline.newBuilder().setComponents(RunnerApi.Components.newBuilder().putEnvironments("env", RunnerApi.Environment.newBuilder().addAllDependencies((Iterable)ImmutableList.of((Object)fooLocalArtifact, (Object)barLocalArtifact)).build())).build();
        List packages = runner.stageArtifacts(pipeline);
        for (DataflowPackage pkg : packages) {
            MatcherAssert.assertThat((Object)pkg.getName(), (Matcher)Matchers.matchesRegex((String)"artifact[1,2]-.+\\.txt"));
        }
    }

    @Test
    public void testStageDuplicatedArtifacts() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        File foo = File.createTempFile("foo-", ".txt");
        foo.deleteOnExit();
        File bar = File.createTempFile("bar-", ".txt");
        bar.deleteOnExit();
        RunnerApi.ArtifactInformation foo1LocalArtifact = RunnerApi.ArtifactInformation.newBuilder().setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.FILE)).setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(foo.getAbsolutePath()).build().toByteString()).setRoleUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Roles.STAGING_TO)).setRolePayload(RunnerApi.ArtifactStagingToRolePayload.newBuilder().setStagedName("foo_staged1.jar").build().toByteString()).build();
        RunnerApi.ArtifactInformation foo2LocalArtifact = RunnerApi.ArtifactInformation.newBuilder().setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.FILE)).setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(foo.getAbsolutePath()).build().toByteString()).setRoleUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Roles.STAGING_TO)).setRolePayload(RunnerApi.ArtifactStagingToRolePayload.newBuilder().setStagedName("foo_staged2.jar").build().toByteString()).build();
        RunnerApi.ArtifactInformation barLocalArtifact = RunnerApi.ArtifactInformation.newBuilder().setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.FILE)).setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(bar.getAbsolutePath()).build().toByteString()).setRoleUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Roles.STAGING_TO)).setRolePayload(RunnerApi.ArtifactStagingToRolePayload.newBuilder().setStagedName("bar_staged.jar").build().toByteString()).build();
        RunnerApi.Environment env1 = RunnerApi.Environment.newBuilder().addAllDependencies((Iterable)ImmutableList.of((Object)foo1LocalArtifact, (Object)barLocalArtifact)).build();
        RunnerApi.Environment env2 = RunnerApi.Environment.newBuilder().addAllDependencies((Iterable)ImmutableList.of((Object)foo2LocalArtifact, (Object)barLocalArtifact)).build();
        RunnerApi.Pipeline pipeline = RunnerApi.Pipeline.newBuilder().setComponents(RunnerApi.Components.newBuilder().putEnvironments("env1", env1).putEnvironments("env2", env2)).build();
        List packages = runner.stageArtifacts(pipeline);
        List packageNames = packages.stream().map(DataflowPackage::getName).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)packageNames.size(), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat(packageNames, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo_staged1.jar", "foo_staged2.jar", "bar_staged.jar"}));
    }

    @Test
    public void testResolveArtifacts() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
        String stagingLocation = options.getStagingLocation().replaceFirst("/$", "");
        RunnerApi.ArtifactInformation fooLocalArtifact = RunnerApi.ArtifactInformation.newBuilder().setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.FILE)).setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath("/tmp/foo.jar").build().toByteString()).setRoleUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Roles.STAGING_TO)).setRolePayload(RunnerApi.ArtifactStagingToRolePayload.newBuilder().setStagedName("foo_staged.jar").build().toByteString()).build();
        RunnerApi.ArtifactInformation barLocalArtifact = RunnerApi.ArtifactInformation.newBuilder().setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.FILE)).setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath("/tmp/bar.jar").build().toByteString()).setRoleUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Roles.STAGING_TO)).setRolePayload(RunnerApi.ArtifactStagingToRolePayload.newBuilder().setStagedName("bar_staged.jar").build().toByteString()).build();
        RunnerApi.Pipeline pipeline = RunnerApi.Pipeline.newBuilder().setComponents(RunnerApi.Components.newBuilder().putEnvironments("env", RunnerApi.Environment.newBuilder().addAllDependencies((Iterable)ImmutableList.of((Object)fooLocalArtifact, (Object)barLocalArtifact)).build())).build();
        RunnerApi.ArtifactInformation fooStagedArtifact = RunnerApi.ArtifactInformation.newBuilder().setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.URL)).setTypePayload(RunnerApi.ArtifactUrlPayload.newBuilder().setUrl(stagingLocation + "/foo_staged.jar").build().toByteString()).setRoleUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Roles.STAGING_TO)).setRolePayload(RunnerApi.ArtifactStagingToRolePayload.newBuilder().setStagedName("foo_staged.jar").build().toByteString()).build();
        RunnerApi.ArtifactInformation barStagedArtifact = RunnerApi.ArtifactInformation.newBuilder().setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.URL)).setTypePayload(RunnerApi.ArtifactUrlPayload.newBuilder().setUrl(stagingLocation + "/bar_staged.jar").build().toByteString()).setRoleUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Roles.STAGING_TO)).setRolePayload(RunnerApi.ArtifactStagingToRolePayload.newBuilder().setStagedName("bar_staged.jar").build().toByteString()).build();
        RunnerApi.Pipeline expectedPipeline = RunnerApi.Pipeline.newBuilder().setComponents(RunnerApi.Components.newBuilder().putEnvironments("env", RunnerApi.Environment.newBuilder().addAllDependencies((Iterable)ImmutableList.of((Object)fooStagedArtifact, (Object)barStagedArtifact)).build())).build();
        MatcherAssert.assertThat((Object)runner.resolveArtifacts(pipeline), (Matcher)Matchers.equalTo((Object)expectedPipeline));
    }

    @Test
    public void testGcpTempAndNoTempLocationSucceeds() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setRunner(DataflowRunner.class);
        options.setGcpCredential((Credentials)new TestCredential());
        options.setProject("foo-project");
        options.setRegion(REGION_ID);
        options.setGcpTempLocation(VALID_TEMP_BUCKET);
        options.setGcsUtil(this.mockGcsUtil);
        DataflowRunner.fromOptions((PipelineOptions)options);
    }

    @Test
    public void testTempLocationAndNoGcpTempLocationSucceeds() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setRunner(DataflowRunner.class);
        options.setGcpCredential((Credentials)new TestCredential());
        options.setProject("foo-project");
        options.setRegion(REGION_ID);
        options.setTempLocation(VALID_TEMP_BUCKET);
        options.setGcsUtil(this.mockGcsUtil);
        DataflowRunner.fromOptions((PipelineOptions)options);
    }

    @Test
    public void testValidProfileLocation() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setSaveProfilesToGcs(VALID_PROFILE_BUCKET);
        DataflowRunner.fromOptions((PipelineOptions)options);
    }

    @Test
    public void testInvalidJobName() throws IOException {
        List<String> invalidNames = Arrays.asList("invalid_name", "0invalid", "invalid-");
        List<String> expectedReason = Arrays.asList("JobName invalid", "JobName invalid", "JobName invalid");
        for (int i = 0; i < invalidNames.size(); ++i) {
            DataflowPipelineOptions options = this.buildPipelineOptions();
            options.setJobName(invalidNames.get(i));
            try {
                DataflowRunner.fromOptions((PipelineOptions)options);
                Assert.fail((String)("Expected IllegalArgumentException for jobName " + options.getJobName()));
                continue;
            }
            catch (IllegalArgumentException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)expectedReason.get(i)));
            }
        }
    }

    @Test
    public void testValidJobName() throws IOException {
        List<String> names = Arrays.asList("ok", "Ok", "A-Ok", "ok-123", "this-one-is-fairly-long-01234567890123456789");
        for (String name : names) {
            DataflowPipelineOptions options = this.buildPipelineOptions();
            options.setJobName(name);
            DataflowRunner runner = DataflowRunner.fromOptions((PipelineOptions)options);
            Assert.assertNotNull((Object)runner);
        }
    }

    @Test
    public void testGcsUploadBufferSizeIsUnsetForBatchWhenDefault() throws IOException {
        DataflowPipelineOptions batchOptions = this.buildPipelineOptions();
        batchOptions.setRunner(DataflowRunner.class);
        Pipeline.create((PipelineOptions)batchOptions);
        Assert.assertNull((Object)batchOptions.getGcsUploadBufferSizeBytes());
    }

    @Test
    public void testGcsUploadBufferSizeIsSetForStreamingWhenDefault() throws IOException {
        DataflowPipelineOptions streamingOptions = this.buildPipelineOptions();
        streamingOptions.setStreaming(true);
        streamingOptions.setRunner(DataflowRunner.class);
        Pipeline p = Pipeline.create((PipelineOptions)streamingOptions);
        p.run();
        Assert.assertEquals((long)0x100000L, (long)streamingOptions.getGcsUploadBufferSizeBytes().intValue());
    }

    @Test
    public void testGcsUploadBufferSizeUnchangedWhenNotDefault() throws IOException {
        int gcsUploadBufferSizeBytes = 12345678;
        DataflowPipelineOptions batchOptions = this.buildPipelineOptions();
        batchOptions.setGcsUploadBufferSizeBytes(Integer.valueOf(gcsUploadBufferSizeBytes));
        batchOptions.setRunner(DataflowRunner.class);
        Pipeline.create((PipelineOptions)batchOptions);
        Assert.assertEquals((long)gcsUploadBufferSizeBytes, (long)batchOptions.getGcsUploadBufferSizeBytes().intValue());
        DataflowPipelineOptions streamingOptions = this.buildPipelineOptions();
        streamingOptions.setStreaming(true);
        streamingOptions.setGcsUploadBufferSizeBytes(Integer.valueOf(gcsUploadBufferSizeBytes));
        streamingOptions.setRunner(DataflowRunner.class);
        Pipeline.create((PipelineOptions)streamingOptions);
        Assert.assertEquals((long)gcsUploadBufferSizeBytes, (long)streamingOptions.getGcsUploadBufferSizeBytes().intValue());
    }

    @Test
    public void testTransformTranslatorMissing() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)p.apply((PTransform)Create.of(Arrays.asList(1, 2, 3)))).apply((PTransform)new TestTransform());
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"no translator registered"));
        SdkComponents sdkComponents = SdkComponents.create((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList());
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Dataflow.Projects.Locations.Jobs)Mockito.verify((Object)this.mockJobs)).create((String)ArgumentMatchers.eq((Object)PROJECT_ID), (String)ArgumentMatchers.eq((Object)REGION_ID), (Job)jobCaptor.capture());
        DataflowRunnerTest.assertValidJob((Job)jobCaptor.getValue());
    }

    @Test
    public void testTransformTranslator() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        Pipeline p = Pipeline.create((PipelineOptions)options);
        TestTransform transform = new TestTransform();
        ((PCollection)p.apply((PTransform)Create.of(Arrays.asList(1, 2, 3)).withCoder((Coder)BigEndianIntegerCoder.of()))).apply((PTransform)transform);
        DataflowPipelineTranslator translator = DataflowRunner.fromOptions((PipelineOptions)options).getTranslator();
        DataflowPipelineTranslator.registerTransformTranslator(TestTransform.class, (transform1, context) -> {
            transform1.translated = true;
            TransformTranslator.StepTranslationContext stepContext = context.addStep(transform1, "TestTranslate");
            stepContext.addOutput("output", (PCollection)context.getOutput(transform1));
        });
        SdkComponents sdkComponents = SdkComponents.create((PipelineOptions)options);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        translator.translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList());
        Assert.assertTrue((boolean)transform.translated);
    }

    private void verifySdkHarnessConfiguration(DataflowPipelineOptions options) {
        Pipeline p = Pipeline.create((PipelineOptions)options);
        p.apply((PTransform)Create.of(Arrays.asList(1, 2, 3)));
        String defaultSdkContainerImage = DataflowRunner.getContainerImageForJob((DataflowPipelineOptions)options);
        SdkComponents sdkComponents = SdkComponents.create();
        RunnerApi.Environment defaultEnvironmentForDataflow = Environments.createDockerEnvironment((String)defaultSdkContainerImage);
        RunnerApi.Environment.Builder envBuilder = defaultEnvironmentForDataflow.toBuilder().addCapabilities("my_dummy_capability");
        sdkComponents.registerEnvironment(envBuilder.build());
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents, (boolean)true);
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, pipelineProto, sdkComponents, DataflowRunner.fromOptions((PipelineOptions)options), Collections.emptyList()).getJob();
        DataflowRunner.configureSdkHarnessContainerImages((DataflowPipelineOptions)options, (RunnerApi.Pipeline)pipelineProto, (Job)job);
        List sdks = ((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getSdkHarnessContainerImages();
        Map<String, String> expectedEnvIdsAndContainerImages = pipelineProto.getComponents().getEnvironmentsMap().entrySet().stream().filter(x -> BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER).equals(((RunnerApi.Environment)x.getValue()).getUrn())).collect(Collectors.toMap(x -> (String)x.getKey(), x -> {
            RunnerApi.DockerPayload payload;
            try {
                payload = RunnerApi.DockerPayload.parseFrom((ByteString)((RunnerApi.Environment)x.getValue()).getPayload());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
            return payload.getContainerImage();
        }));
        Assert.assertEquals((long)1L, (long)expectedEnvIdsAndContainerImages.size());
        Assert.assertEquals((long)1L, (long)sdks.size());
        Assert.assertEquals(expectedEnvIdsAndContainerImages, sdks.stream().collect(Collectors.toMap(SdkHarnessContainerImage::getEnvironmentId, SdkHarnessContainerImage::getContainerImage)));
        Assert.assertTrue((boolean)((SdkHarnessContainerImage)sdks.get(0)).getCapabilities().contains("my_dummy_capability"));
    }

    @Test
    public void testSdkHarnessConfigurationRunnerV2() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        ExperimentalOptions.addExperiment((ExperimentalOptions)options, (String)"use_runner_v2");
        this.verifySdkHarnessConfiguration(options);
    }

    @Test
    public void testSdkHarnessConfigurationPrime() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setDataflowServiceOptions((List)ImmutableList.of((Object)"enable_prime"));
        this.verifySdkHarnessConfiguration(options);
    }

    @Test
    public void testSettingAnyFnApiExperimentEnablesUnifiedWorker() throws Exception {
        Pipeline p;
        DataflowPipelineOptions options;
        for (String experiment : ImmutableList.of((Object)"beam_fn_api", (Object)"use_runner_v2", (Object)"use_unified_worker", (Object)"use_portable_job_submission")) {
            options = this.buildPipelineOptions();
            ExperimentalOptions.addExperiment((ExperimentalOptions)options, (String)experiment);
            p = Pipeline.create((PipelineOptions)options);
            p.apply((PTransform)Create.of((Object)"A", (Object[])new String[0]));
            p.run();
            Assert.assertFalse((boolean)options.isEnableStreamingEngine());
            MatcherAssert.assertThat((Object)options.getExperiments(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"beam_fn_api", "use_runner_v2", "use_unified_worker", "use_portable_job_submission"}));
        }
        for (String experiment : ImmutableList.of((Object)"beam_fn_api", (Object)"use_runner_v2", (Object)"use_unified_worker", (Object)"use_portable_job_submission")) {
            options = this.buildPipelineOptions();
            options.setStreaming(true);
            ExperimentalOptions.addExperiment((ExperimentalOptions)options, (String)experiment);
            p = Pipeline.create((PipelineOptions)options);
            p.apply((PTransform)Create.of((Object)"A", (Object[])new String[0]));
            p.run();
            Assert.assertTrue((boolean)options.isEnableStreamingEngine());
            MatcherAssert.assertThat((Object)options.getExperiments(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"beam_fn_api", "use_runner_v2", "use_unified_worker", "use_portable_job_submission", "enable_windmill_service", "enable_streaming_engine"}));
        }
    }

    @Test
    public void testSettingConflictingEnableAndDisableExperimentsThrowsException() throws Exception {
        for (String experiment : ImmutableList.of((Object)"beam_fn_api", (Object)"use_runner_v2", (Object)"use_unified_worker", (Object)"use_portable_job_submission")) {
            for (String disabledExperiment : ImmutableList.of((Object)"disable_runner_v2", (Object)"disable_runner_v2_until_2023", (Object)"disable_prime_runner_v2")) {
                DataflowPipelineOptions options = this.buildPipelineOptions();
                ExperimentalOptions.addExperiment((ExperimentalOptions)options, (String)experiment);
                ExperimentalOptions.addExperiment((ExperimentalOptions)options, (String)disabledExperiment);
                Pipeline p = Pipeline.create((PipelineOptions)options);
                p.apply((PTransform)Create.of((Object)"A", (Object[])new String[0]));
                Assert.assertThrows((String)"Runner V2 both disabled and enabled", IllegalArgumentException.class, () -> ((Pipeline)p).run());
            }
        }
    }

    @Test
    public void testApplyIsScopedToExactClass() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        Pipeline p = Pipeline.create((PipelineOptions)options);
        Create.TimestampedValues transform = Create.timestamped(Arrays.asList(TimestampedValue.of((Object)"TestString", (Instant)Instant.now())));
        p.apply((PTransform)transform);
        CompositeTransformRecorder recorder = new CompositeTransformRecorder();
        p.traverseTopologically((Pipeline.PipelineVisitor)recorder);
        MatcherAssert.assertThat((String)"Expected to have seen CreateTimestamped composite transform.", recorder.getCompositeTransforms(), (Matcher)Matchers.hasItem((Object)transform));
        MatcherAssert.assertThat((String)"Expected to have two composites, CreateTimestamped and Create.Values", recorder.getCompositeTransforms(), (Matcher)Matchers.hasItem((Matcher)Matchers.isA(Create.Values.class)));
    }

    @Test
    public void testToString() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setJobName("TestJobName");
        options.setProject("test-project");
        options.setRegion(REGION_ID);
        options.setTempLocation("gs://test/temp/location");
        options.setGcpCredential((Credentials)new TestCredential());
        options.setPathValidatorClass(NoopPathValidator.class);
        options.setRunner(DataflowRunner.class);
        Assert.assertEquals((Object)"DataflowRunner#testjobname", (Object)DataflowRunner.fromOptions((PipelineOptions)options).toString());
    }

    @Test
    public void testTemplateRunnerFullCompletion() throws Exception {
        File existingFile = this.tmpFolder.newFile();
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setJobName("TestJobName");
        options.setGcpCredential((Credentials)new TestCredential());
        options.setPathValidatorClass(NoopPathValidator.class);
        options.setProject("test-project");
        options.setRegion(REGION_ID);
        options.setRunner(DataflowRunner.class);
        options.setTemplateLocation(existingFile.getPath());
        options.setTempLocation(this.tmpFolder.getRoot().getPath());
        Pipeline p = Pipeline.create((PipelineOptions)options);
        p.run();
        this.expectedLogs.verifyInfo("Template successfully created");
    }

    @Test
    public void testTemplateRunnerWithUploadGraph() throws Exception {
        File existingFile = this.tmpFolder.newFile();
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setExperiments(Arrays.asList("upload_graph"));
        options.setJobName("TestJobName");
        options.setGcpCredential((Credentials)new TestCredential());
        options.setPathValidatorClass(NoopPathValidator.class);
        options.setProject("test-project");
        options.setRegion(REGION_ID);
        options.setRunner(DataflowRunner.class);
        options.setTemplateLocation(existingFile.getPath());
        options.setTempLocation(this.tmpFolder.getRoot().getPath());
        Pipeline p = Pipeline.create((PipelineOptions)options);
        p.apply((PTransform)Create.of((Iterable)ImmutableList.of((Object)1)));
        p.run();
        this.expectedLogs.verifyInfo("Template successfully created");
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode node = objectMapper.readTree(existingFile);
        Assert.assertEquals((long)0L, (long)node.get("steps").size());
        Assert.assertNotNull((Object)node.get("stepsLocation"));
    }

    @Test
    public void testTemplateRunnerLoggedErrorForFileNotCreatable() throws Exception {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        options.setTemplateLocation("//bad/path");
        Pipeline p = Pipeline.create((PipelineOptions)options);
        this.thrown.expectMessage("Cannot create output file at");
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectCause(Matchers.hasProperty((String)"message", (Matcher)Matchers.containsString((String)"Unable to create parent directories for")));
        p.run();
    }

    private static WritableByteChannel createWritableByteChannelThrowsIOExceptionAtClose(final String errorMessage) {
        return new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) {
                int remaining = src.remaining();
                src.get(new byte[remaining]);
                return remaining;
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() throws IOException {
                throw new IOException(errorMessage);
            }
        };
    }

    @Test
    public void testTemplateRunnerLoggedErrorForFileCloseError() throws Exception {
        File templateLocation = this.tmpFolder.newFile();
        String closeErrorMessage = "Unable to close";
        try (MockedStatic mocked = Mockito.mockStatic(FileSystems.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            mocked.when(() -> FileSystems.create((ResourceId)FileSystems.matchNewResource((String)templateLocation.getPath(), (boolean)false), (String)"text/plain")).thenReturn((Object)DataflowRunnerTest.createWritableByteChannelThrowsIOExceptionAtClose(closeErrorMessage));
            DataflowPipelineOptions options = this.buildPipelineOptions();
            options.setTemplateLocation(templateLocation.getPath());
            Pipeline p = Pipeline.create((PipelineOptions)options);
            this.thrown.expectMessage("Cannot create output file at");
            this.thrown.expect(RuntimeException.class);
            this.thrown.expectCause(Matchers.isA(IOException.class));
            this.thrown.expectCause(Matchers.hasProperty((String)"message", (Matcher)Matchers.is((Object)closeErrorMessage)));
            p.run();
        }
    }

    private static WritableByteChannel createWritableByteChannelThrowsIOExceptionAtWrite(final String errorMessage) {
        return new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) throws IOException {
                throw new IOException(errorMessage);
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() {
            }
        };
    }

    @Test
    public void testTemplateRunnerLoggedErrorForFileWriteError() throws Exception {
        File templateLocation = this.tmpFolder.newFile();
        String closeErrorMessage = "Unable to write";
        try (MockedStatic mocked = Mockito.mockStatic(FileSystems.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            mocked.when(() -> FileSystems.create((ResourceId)FileSystems.matchNewResource((String)templateLocation.getPath(), (boolean)false), (String)"text/plain")).thenReturn((Object)DataflowRunnerTest.createWritableByteChannelThrowsIOExceptionAtWrite(closeErrorMessage));
            this.thrown.expectMessage("Cannot create output file at");
            this.thrown.expect(RuntimeException.class);
            this.thrown.expectCause(Matchers.isA(IOException.class));
            this.thrown.expectCause(Matchers.hasProperty((String)"message", (Matcher)Matchers.is((Object)closeErrorMessage)));
            DataflowPipelineOptions options = this.buildPipelineOptions();
            options.setTemplateLocation(templateLocation.getPath());
            Pipeline p = Pipeline.create((PipelineOptions)options);
            p.run();
        }
    }

    @Test
    public void testGetContainerImageForJobFromOption() {
        String[] testCases;
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        for (String testCase : testCases = new String[]{"some-container", ""}) {
            options.setSdkContainerImage(testCase);
            MatcherAssert.assertThat((Object)DataflowRunner.getContainerImageForJob((DataflowPipelineOptions)options), (Matcher)Matchers.equalTo((Object)testCase));
        }
    }

    @Test
    public void testGetContainerImageForJobFromOptionWithPlaceholder() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setSdkContainerImage("gcr.io/IMAGE/foo");
        for (Environments.JavaVersion javaVersion : Environments.JavaVersion.values()) {
            System.setProperty("java.specification.version", javaVersion.specification());
            options.setExperiments(null);
            options.setStreaming(false);
            MatcherAssert.assertThat((Object)DataflowRunner.getContainerImageForJob((DataflowPipelineOptions)options), (Matcher)Matchers.equalTo((Object)String.format("gcr.io/beam-%s-batch/foo", javaVersion.legacyName())));
            options.setExperiments(null);
            options.setStreaming(true);
            MatcherAssert.assertThat((Object)DataflowRunner.getContainerImageForJob((DataflowPipelineOptions)options), (Matcher)Matchers.equalTo((Object)String.format("gcr.io/beam-%s-streaming/foo", javaVersion.legacyName())));
            options.setExperiments((List)ImmutableList.of((Object)"beam_fn_api"));
            options.setStreaming(false);
            MatcherAssert.assertThat((Object)DataflowRunner.getContainerImageForJob((DataflowPipelineOptions)options), (Matcher)Matchers.equalTo((Object)String.format("gcr.io/beam_%s_sdk/foo", javaVersion.name())));
            options.setExperiments((List)ImmutableList.of((Object)"beam_fn_api"));
            options.setStreaming(true);
            MatcherAssert.assertThat((Object)DataflowRunner.getContainerImageForJob((DataflowPipelineOptions)options), (Matcher)Matchers.equalTo((Object)String.format("gcr.io/beam_%s_sdk/foo", javaVersion.name())));
        }
    }

    @Test
    public void testStreamingWriteWithNoShardingReturnsNewTransform() {
        PipelineOptions options = TestPipeline.testingPipelineOptions();
        ((DataflowPipelineWorkerPoolOptions)options.as(DataflowPipelineWorkerPoolOptions.class)).setMaxNumWorkers(10);
        this.testStreamingWriteOverride(options, 20);
    }

    @Test
    public void testStreamingWriteWithNoShardingReturnsNewTransformMaxWorkersUnset() {
        PipelineOptions options = TestPipeline.testingPipelineOptions();
        this.testStreamingWriteOverride(options, 10);
    }

    @Test
    public void testStreamingWriteWithShardingReturnsSameTransform() {
        PipelineOptions options = TestPipeline.testingPipelineOptions();
        TestPipeline p = TestPipeline.fromOptions((PipelineOptions)options);
        DataflowRunner.StreamingShardedWriteFactory factory = new DataflowRunner.StreamingShardedWriteFactory(p.getOptions());
        WriteFiles original = WriteFiles.to((FileBasedSink)new TestSink(this.tmpFolder.toString())).withAutoSharding();
        PCollection objs = (PCollection)p.apply((PTransform)Create.empty((Coder)VoidCoder.of()));
        AppliedPTransform originalApplication = AppliedPTransform.of((String)"writefiles", (Map)PValues.expandInput((PInput)objs), Collections.emptyMap(), (PTransform)original, (ResourceHints)ResourceHints.create(), (Pipeline)p);
        WriteFiles replacement = (WriteFiles)factory.getReplacementTransform(originalApplication).getTransform();
        WriteFilesResult originalResult = (WriteFilesResult)objs.apply((PTransform)original);
        WriteFilesResult replacementResult = (WriteFilesResult)objs.apply((PTransform)replacement);
        Assert.assertNull((Object)replacement.getNumShardsProvider());
        Assert.assertNull((Object)replacement.getComputeNumShards());
        Assert.assertTrue((boolean)replacement.getWithAutoSharding());
    }

    private void verifyMergingStatefulParDoRejected(PipelineOptions options) throws Exception {
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)p.apply((PTransform)Create.of((Object)KV.of((Object)13, (Object)42), (Object[])new KV[0]))).apply((PTransform)Window.into((WindowFn)Sessions.withGapDuration((Duration)Duration.millis((long)1L))))).apply((PTransform)ParDo.of((DoFn)new DoFn<KV<Integer, Integer>, Void>(){
            @DoFn.StateId(value="fizzle")
            private final StateSpec<ValueState<Void>> voidState = StateSpecs.value();

            @DoFn.ProcessElement
            public void process() {
            }
        }));
        this.thrown.expectMessage("merging");
        this.thrown.expect(UnsupportedOperationException.class);
        p.run();
    }

    @Test
    public void testMergingStatefulRejectedInStreaming() throws Exception {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        ((StreamingOptions)options.as(StreamingOptions.class)).setStreaming(true);
        this.verifyMergingStatefulParDoRejected((PipelineOptions)options);
    }

    @Test
    public void testMergingStatefulRejectedInBatch() throws Exception {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        ((StreamingOptions)options.as(StreamingOptions.class)).setStreaming(false);
        this.verifyMergingStatefulParDoRejected((PipelineOptions)options);
    }

    private void verifyGroupIntoBatchesOverrideCount(final Pipeline p, Boolean withShardedKey, Boolean expectOverridden) {
        int batchSize = 2;
        List<KV> testValues = Arrays.asList(KV.of((Object)"A", (Object)1), KV.of((Object)"B", (Object)0), KV.of((Object)"A", (Object)2), KV.of((Object)"A", (Object)4), KV.of((Object)"A", (Object)8));
        PCollection input = (PCollection)p.apply("CreateValuesCount", (PTransform)Create.of(testValues));
        PCollection output = withShardedKey != false ? (PCollection)((PCollection)input.apply("GroupIntoBatchesCount", (PTransform)GroupIntoBatches.ofSize((long)2L).withShardedKey())).apply("StripShardIdCount", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<KV<ShardedKey<String>, Iterable<Integer>>, KV<String, Iterable<Integer>>>(){

            public KV<String, Iterable<Integer>> apply(KV<ShardedKey<String>, Iterable<Integer>> input) {
                return KV.of((Object)((String)((ShardedKey)input.getKey()).getKey()), (Object)((Iterable)input.getValue()));
            }
        })) : (PCollection)input.apply("GroupIntoBatchesCount", (PTransform)GroupIntoBatches.ofSize((long)2L));
        PAssert.thatMultimap((PCollection)output).satisfies((SerializableFunction & Serializable)i -> {
            Assert.assertEquals((long)2L, (long)i.size());
            MatcherAssert.assertThat(i.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"A", "B"}));
            HashMap<String, Integer> sums = new HashMap<String, Integer>();
            for (Map.Entry entry : i.entrySet()) {
                for (Iterable batch : (Iterable)entry.getValue()) {
                    MatcherAssert.assertThat((Object)Iterables.size((Iterable)batch), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(2)));
                    for (Integer value : batch) {
                        sums.put((String)entry.getKey(), value + sums.getOrDefault(entry.getKey(), 0));
                    }
                }
            }
            Assert.assertEquals((long)15L, (long)((Integer)sums.get("A")).intValue());
            Assert.assertEquals((long)0L, (long)((Integer)sums.get("B")).intValue());
            return null;
        });
        p.run();
        final AtomicBoolean sawGroupIntoBatchesOverride = new AtomicBoolean(false);
        p.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
                if (((StreamingOptions)p.getOptions().as(StreamingOptions.class)).isStreaming() && node.getTransform() instanceof GroupIntoBatchesOverride.StreamingGroupIntoBatchesWithShardedKey) {
                    sawGroupIntoBatchesOverride.set(true);
                }
                if (!((StreamingOptions)p.getOptions().as(StreamingOptions.class)).isStreaming() && node.getTransform() instanceof GroupIntoBatchesOverride.BatchGroupIntoBatches) {
                    sawGroupIntoBatchesOverride.set(true);
                }
                if (!((StreamingOptions)p.getOptions().as(StreamingOptions.class)).isStreaming() && node.getTransform() instanceof GroupIntoBatchesOverride.BatchGroupIntoBatchesWithShardedKey) {
                    sawGroupIntoBatchesOverride.set(true);
                }
                return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
            }
        });
        if (expectOverridden.booleanValue()) {
            Assert.assertTrue((boolean)sawGroupIntoBatchesOverride.get());
        } else {
            Assert.assertFalse((boolean)sawGroupIntoBatchesOverride.get());
        }
    }

    private void verifyGroupIntoBatchesOverrideBytes(final Pipeline p, Boolean withShardedKey, Boolean expectOverridden) {
        long batchSizeBytes = 2L;
        List<KV> testValues = Arrays.asList(KV.of((Object)"A", (Object)"a"), KV.of((Object)"A", (Object)"ab"), KV.of((Object)"A", (Object)"abc"), KV.of((Object)"A", (Object)"abcd"), KV.of((Object)"A", (Object)"abcde"));
        PCollection input = (PCollection)p.apply("CreateValuesBytes", (PTransform)Create.of(testValues));
        PCollection output = withShardedKey != false ? (PCollection)((PCollection)input.apply("GroupIntoBatchesBytes", (PTransform)GroupIntoBatches.ofByteSize((long)2L).withShardedKey())).apply("StripShardIdBytes", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<KV<ShardedKey<String>, Iterable<String>>, KV<String, Iterable<String>>>(){

            public KV<String, Iterable<String>> apply(KV<ShardedKey<String>, Iterable<String>> input) {
                return KV.of((Object)((String)((ShardedKey)input.getKey()).getKey()), (Object)((Iterable)input.getValue()));
            }
        })) : (PCollection)input.apply("GroupIntoBatchesBytes", (PTransform)GroupIntoBatches.ofByteSize((long)2L));
        PAssert.thatMultimap((PCollection)output).satisfies((SerializableFunction & Serializable)i -> {
            Assert.assertEquals((long)1L, (long)i.size());
            MatcherAssert.assertThat(i.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"A"}));
            Iterable batches = (Iterable)i.get("A");
            Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)batches));
            return null;
        });
        p.run();
        final AtomicBoolean sawGroupIntoBatchesOverride = new AtomicBoolean(false);
        p.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
                if (((StreamingOptions)p.getOptions().as(StreamingOptions.class)).isStreaming() && node.getTransform() instanceof GroupIntoBatchesOverride.StreamingGroupIntoBatchesWithShardedKey) {
                    sawGroupIntoBatchesOverride.set(true);
                }
                if (!((StreamingOptions)p.getOptions().as(StreamingOptions.class)).isStreaming() && node.getTransform() instanceof GroupIntoBatchesOverride.BatchGroupIntoBatches) {
                    sawGroupIntoBatchesOverride.set(true);
                }
                if (!((StreamingOptions)p.getOptions().as(StreamingOptions.class)).isStreaming() && node.getTransform() instanceof GroupIntoBatchesOverride.BatchGroupIntoBatchesWithShardedKey) {
                    sawGroupIntoBatchesOverride.set(true);
                }
                return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
            }
        });
        if (expectOverridden.booleanValue()) {
            Assert.assertTrue((boolean)sawGroupIntoBatchesOverride.get());
        } else {
            Assert.assertFalse((boolean)sawGroupIntoBatchesOverride.get());
        }
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesStatefulParDo.class})
    public void testBatchGroupIntoBatchesOverrideCount() {
        Assume.assumeFalse((boolean)((StreamingOptions)this.pipeline.getOptions().as(StreamingOptions.class)).isStreaming());
        this.verifyGroupIntoBatchesOverrideCount((Pipeline)this.pipeline, false, true);
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesStatefulParDo.class})
    public void testBatchGroupIntoBatchesOverrideBytes() {
        Assume.assumeFalse((boolean)((StreamingOptions)this.pipeline.getOptions().as(StreamingOptions.class)).isStreaming());
        this.verifyGroupIntoBatchesOverrideBytes((Pipeline)this.pipeline, false, true);
    }

    @Test
    public void testBatchGroupIntoBatchesWithShardedKeyOverrideCount() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        Pipeline p = Pipeline.create((PipelineOptions)options);
        this.verifyGroupIntoBatchesOverrideCount(p, true, true);
    }

    @Test
    public void testBatchGroupIntoBatchesWithShardedKeyOverrideBytes() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        Pipeline p = Pipeline.create((PipelineOptions)options);
        this.verifyGroupIntoBatchesOverrideBytes(p, true, true);
    }

    @Test
    public void testStreamingGroupIntoBatchesOverrideCount() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        ((StreamingOptions)options.as(StreamingOptions.class)).setStreaming(true);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        this.verifyGroupIntoBatchesOverrideCount(p, false, false);
    }

    @Test
    public void testStreamingGroupIntoBatchesOverrideBytes() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        ((StreamingOptions)options.as(StreamingOptions.class)).setStreaming(true);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        this.verifyGroupIntoBatchesOverrideBytes(p, false, false);
    }

    @Test
    public void testStreamingGroupIntoBatchesWithShardedKeyOverrideCount() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        ArrayList experiments = new ArrayList(ImmutableList.of((Object)"enable_streaming_engine", (Object)"enable_windmill_service"));
        DataflowPipelineOptions dataflowOptions = (DataflowPipelineOptions)options.as(DataflowPipelineOptions.class);
        dataflowOptions.setExperiments(experiments);
        dataflowOptions.setStreaming(true);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        this.verifyGroupIntoBatchesOverrideCount(p, true, true);
    }

    @Test
    public void testStreamingGroupIntoBatchesWithShardedKeyOverrideBytes() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        ArrayList experiments = new ArrayList(ImmutableList.of((Object)"enable_streaming_engine", (Object)"enable_windmill_service"));
        DataflowPipelineOptions dataflowOptions = (DataflowPipelineOptions)options.as(DataflowPipelineOptions.class);
        dataflowOptions.setExperiments(experiments);
        dataflowOptions.setStreaming(true);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        this.verifyGroupIntoBatchesOverrideBytes(p, true, true);
    }

    @Test
    public void testPubsubSinkOverride() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        ArrayList experiments = new ArrayList(ImmutableList.of((Object)"enable_streaming_engine", (Object)"enable_windmill_service"));
        DataflowPipelineOptions dataflowOptions = (DataflowPipelineOptions)options.as(DataflowPipelineOptions.class);
        dataflowOptions.setExperiments(experiments);
        dataflowOptions.setStreaming(true);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        List<PubsubMessage> testValues = Arrays.asList(new PubsubMessage("foo".getBytes(StandardCharsets.UTF_8), Collections.emptyMap()));
        PCollection input = ((PCollection)p.apply("CreateValuesBytes", (PTransform)Create.of(testValues))).setIsBoundedInternal(PCollection.IsBounded.UNBOUNDED);
        input.apply((PTransform)PubsubIO.writeMessages().to("projects/project/topics/topic"));
        p.run();
        final AtomicBoolean sawPubsubOverride = new AtomicBoolean(false);
        p.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized TransformHierarchy.Node node) {
                if (node.getTransform() instanceof DataflowRunner.StreamingPubsubIOWrite) {
                    sawPubsubOverride.set(true);
                }
            }
        });
        Assert.assertTrue((boolean)sawPubsubOverride.get());
    }

    @Test
    public void testBigQueryDLQWarningStreamingInsertsConsumed() throws Exception {
        this.testBigQueryDLQWarning(BigQueryIO.Write.Method.STREAMING_INSERTS, true);
    }

    @Test
    public void testBigQueryDLQWarningStreamingInsertsNotConsumed() throws Exception {
        this.testBigQueryDLQWarning(BigQueryIO.Write.Method.STREAMING_INSERTS, false);
    }

    @Test
    public void testBigQueryDLQWarningStorageApiConsumed() throws Exception {
        this.testBigQueryDLQWarning(BigQueryIO.Write.Method.STORAGE_WRITE_API, true);
    }

    @Test
    public void testBigQueryDLQWarningStorageApiNotConsumed() throws Exception {
        this.testBigQueryDLQWarning(BigQueryIO.Write.Method.STORAGE_WRITE_API, false);
    }

    @Test
    public void testBigQueryDLQWarningStorageApiALOConsumed() throws Exception {
        this.testBigQueryDLQWarning(BigQueryIO.Write.Method.STORAGE_API_AT_LEAST_ONCE, true);
    }

    @Test
    public void testBigQueryDLQWarningStorageApiALONotConsumed() throws Exception {
        this.testBigQueryDLQWarning(BigQueryIO.Write.Method.STORAGE_API_AT_LEAST_ONCE, false);
    }

    public void testBigQueryDLQWarning(BigQueryIO.Write.Method method, boolean processFailures) throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        ArrayList experiments = new ArrayList(ImmutableList.of((Object)"enable_streaming_engine"));
        DataflowPipelineOptions dataflowOptions = (DataflowPipelineOptions)options.as(DataflowPipelineOptions.class);
        dataflowOptions.setExperiments(experiments);
        dataflowOptions.setStreaming(true);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        List<TableRow> testValues = Arrays.asList(new TableRow(), new TableRow());
        PCollection input = ((PCollection)p.apply("CreateValuesBytes", (PTransform)Create.of(testValues))).setIsBoundedInternal(PCollection.IsBounded.UNBOUNDED);
        BigQueryIO.Write write = BigQueryIO.writeTableRows().to("project:dataset.table").withSchema(new TableSchema()).withMethod(method).withoutValidation();
        if (method == BigQueryIO.Write.Method.STORAGE_WRITE_API) {
            write = write.withAutoSharding().withTriggeringFrequency(Duration.standardSeconds((long)1L));
        }
        WriteResult result = (WriteResult)input.apply("BQWrite", (PTransform)write);
        if (processFailures) {
            if (method == BigQueryIO.Write.Method.STREAMING_INSERTS) {
                result.getFailedInserts().apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.voids()).via(SerializableFunctions.constant(null)));
            } else {
                result.getFailedStorageApiInserts().apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.voids()).via(SerializableFunctions.constant(null)));
            }
        }
        p.run();
        String expectedWarning = "No transform processes the failed-inserts output from BigQuery sink: BQWrite! Not processing failed inserts means that those rows will be lost.";
        if (processFailures) {
            this.expectedLogs.verifyNotLogged("No transform processes the failed-inserts output from BigQuery sink: BQWrite! Not processing failed inserts means that those rows will be lost.");
        } else {
            this.expectedLogs.verifyWarn("No transform processes the failed-inserts output from BigQuery sink: BQWrite! Not processing failed inserts means that those rows will be lost.");
        }
    }

    @Test
    public void testPubsubSinkDynamicOverride() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        DataflowPipelineOptions dataflowOptions = (DataflowPipelineOptions)options.as(DataflowPipelineOptions.class);
        dataflowOptions.setStreaming(true);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        List<PubsubMessage> testValues = Arrays.asList(new PubsubMessage("foo".getBytes(StandardCharsets.UTF_8), Collections.emptyMap()).withTopic(""));
        PCollection input = ((PCollection)p.apply("CreateValuesBytes", (PTransform)Create.of(testValues))).setIsBoundedInternal(PCollection.IsBounded.UNBOUNDED);
        input.apply((PTransform)PubsubIO.writeMessagesDynamic());
        p.run();
        final AtomicBoolean sawPubsubOverride = new AtomicBoolean(false);
        p.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized TransformHierarchy.Node node) {
                if (node.getTransform() instanceof DataflowRunner.StreamingPubsubIOWrite) {
                    sawPubsubOverride.set(true);
                }
            }
        });
        Assert.assertTrue((boolean)sawPubsubOverride.get());
    }

    @Test
    public void testIsMultiLanguage() throws IOException {
        DataflowPipelineOptions options = this.buildPipelineOptions();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        PCollection col = (PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Object)"1", (Object[])new String[]{"2", "3"}))).apply((PTransform)External.of((String)"dummy_urn", (byte[])new byte[0], (String)"", (ExpansionServiceClientFactory)new TestExpansionServiceClientFactory()));
        Assert.assertTrue((boolean)DataflowRunner.isMultiLanguagePipeline((Pipeline)pipeline));
    }

    private void testStreamingWriteOverride(PipelineOptions options, int expectedNumShards) {
        TestPipeline p = TestPipeline.fromOptions((PipelineOptions)options);
        DataflowRunner.StreamingShardedWriteFactory factory = new DataflowRunner.StreamingShardedWriteFactory(p.getOptions());
        WriteFiles original = WriteFiles.to((FileBasedSink)new TestSink(this.tmpFolder.toString()));
        PCollection objs = (PCollection)p.apply((PTransform)Create.empty((Coder)VoidCoder.of()));
        AppliedPTransform originalApplication = AppliedPTransform.of((String)"writefiles", (Map)PValues.expandInput((PInput)objs), Collections.emptyMap(), (PTransform)original, (ResourceHints)ResourceHints.create(), (Pipeline)p);
        WriteFiles replacement = (WriteFiles)factory.getReplacementTransform(originalApplication).getTransform();
        MatcherAssert.assertThat((Object)replacement, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)original)));
        MatcherAssert.assertThat((Object)((Integer)replacement.getNumShardsProvider().get()), (Matcher)Matchers.equalTo((Object)expectedNumShards));
        WriteFilesResult originalResult = (WriteFilesResult)objs.apply((PTransform)original);
        WriteFilesResult replacementResult = (WriteFilesResult)objs.apply((PTransform)replacement);
        Map res = factory.mapOutputs(PValues.expandOutput((POutput)originalResult), replacementResult);
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertEquals((Object)originalResult.getPerDestinationOutputFilenames(), (Object)((PTransformOverrideFactory.ReplacementOutput)res.get(replacementResult.getPerDestinationOutputFilenames())).getOriginal().getValue());
    }

    private static class TestSink
    extends FileBasedSink<Object, Void, Object> {
        public void validate(PipelineOptions options) {
        }

        TestSink(String tmpFolder) {
            super((ValueProvider)ValueProvider.StaticValueProvider.of((Object)FileSystems.matchNewResource((String)tmpFolder, (boolean)true)), DynamicFileDestinations.constant((FileBasedSink.FilenamePolicy)new FileBasedSink.FilenamePolicy(){

                public ResourceId windowedFilename(int shardNumber, int numShards, BoundedWindow window, PaneInfo paneInfo, FileBasedSink.OutputFileHints outputFileHints) {
                    throw new UnsupportedOperationException("should not be called");
                }

                public @Nullable ResourceId unwindowedFilename(int shardNumber, int numShards, FileBasedSink.OutputFileHints outputFileHints) {
                    throw new UnsupportedOperationException("should not be called");
                }
            }, (SerializableFunction)SerializableFunctions.identity()));
        }

        public FileBasedSink.WriteOperation<Void, Object> createWriteOperation() {
            return new FileBasedSink.WriteOperation<Void, Object>((FileBasedSink)this){

                public FileBasedSink.Writer<Void, Object> createWriter() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static class TestExpansionServiceClientFactory
    implements ExpansionServiceClientFactory {
        ExpansionApi.ExpansionResponse response;

        TestExpansionServiceClientFactory() {
        }

        public ExpansionServiceClient getExpansionServiceClient(Endpoints.ApiServiceDescriptor endpoint) {
            return new ExpansionServiceClient(){

                public ExpansionApi.ExpansionResponse expand(ExpansionApi.ExpansionRequest request) {
                    TestPipeline p = TestPipeline.create();
                    p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
                    SdkComponents sdkComponents = SdkComponents.create((PipelineOptions)p.getOptions()).withNewIdPrefix(request.getNamespace());
                    RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p, (SdkComponents)sdkComponents);
                    String transformId = (String)Iterables.getOnlyElement((Iterable)pipelineProto.getRootTransformIdsList());
                    RunnerApi.Components components = pipelineProto.getComponents();
                    ImmutableList.Builder requirementsBuilder = ImmutableList.builder();
                    requirementsBuilder.addAll((Iterable)pipelineProto.getRequirementsList());
                    requirementsBuilder.add((Object)"ExternalTranslationTest_Requirement_URN");
                    response = ExpansionApi.ExpansionResponse.newBuilder().setComponents(components).setTransform(components.getTransformsOrThrow(transformId).toBuilder().setUniqueName(transformId)).addAllRequirements((Iterable)requirementsBuilder.build()).build();
                    return response;
                }

                public ExpansionApi.DiscoverSchemaTransformResponse discover(ExpansionApi.DiscoverSchemaTransformRequest request) {
                    return null;
                }

                public void close() {
                }
            };
        }

        public void close() {
        }
    }

    private static class CompositeTransformRecorder
    extends Pipeline.PipelineVisitor.Defaults {
        private final List<PTransform<?, ?>> transforms = new ArrayList();

        private CompositeTransformRecorder() {
        }

        public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
            if (node.getTransform() != null) {
                this.transforms.add(node.getTransform());
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        public List<PTransform<?, ?>> getCompositeTransforms() {
            return this.transforms;
        }
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class DataflowTransformTranslator
    implements TransformPayloadTranslatorRegistrar {
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.of(TestTransform.class, (Object)new TestTransformTranslator());
        }
    }

    private static class TestTransformTranslator
    implements PTransformTranslation.TransformPayloadTranslator<TestTransform> {
        private TestTransformTranslator() {
        }

        public String getUrn() {
            return "test_transform";
        }

        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, TestTransform> application, SdkComponents components) {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((TestTransform)application.getTransform())).build();
        }
    }

    public static class TestTransform
    extends PTransform<PCollection<Integer>, PCollection<Integer>> {
        public boolean translated = false;

        public PCollection<Integer> expand(PCollection<Integer> input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)input.isBounded(), (Coder)input.getCoder());
        }
    }

    public static interface RuntimeTestOptions
    extends PipelineOptions {
        public ValueProvider<String> getInput();

        public void setInput(ValueProvider<String> var1);

        public ValueProvider<String> getOutput();

        public void setOutput(ValueProvider<String> var1);
    }

    public static class JacksonIncompatibleSerializer
    extends JsonSerializer<JacksonIncompatible> {
        public void serialize(JacksonIncompatible jacksonIncompatible, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(jacksonIncompatible.value);
        }
    }

    public static class JacksonIncompatibleDeserializer
    extends JsonDeserializer<JacksonIncompatible> {
        public JacksonIncompatible deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new JacksonIncompatible((String)jsonParser.readValueAs(String.class));
        }
    }

    @JsonDeserialize(using=JacksonIncompatibleDeserializer.class)
    @JsonSerialize(using=JacksonIncompatibleSerializer.class)
    public static final class JacksonIncompatibleMixin {
    }

    public static class JacksonIncompatible {
        private final String value;

        public JacksonIncompatible(String value) {
            this.value = value;
        }
    }

    @AutoService(value={Module.class})
    public static class RegisteredTestModule
    extends SimpleModule {
        public RegisteredTestModule() {
            super("RegisteredTestModule");
            this.setMixInAnnotation(JacksonIncompatible.class, JacksonIncompatibleMixin.class);
        }
    }

    public static interface JacksonIncompatibleOptions
    extends PipelineOptions {
        public JacksonIncompatible getJacksonIncompatible();

        public void setJacksonIncompatible(JacksonIncompatible var1);
    }
}

