/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.io.Serializable;
import java.util.Map;
import org.apache.beam.runners.dataflow.PrimitiveParDoSingleFactory;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHints;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValues;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PrimitiveParDoSingleFactoryTest
implements Serializable {
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create().enableAbandonedNodeEnforcement(false);
    private transient PrimitiveParDoSingleFactory<Integer, Long> factory = new PrimitiveParDoSingleFactory();

    @Test
    public void getReplacementTransformPopulateDisplayData() {
        ParDo.SingleOutput originalTransform = ParDo.of((DoFn)new ToLongFn());
        DisplayData originalDisplayData = DisplayData.from((HasDisplayData)originalTransform);
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
        AppliedPTransform application = AppliedPTransform.of((String)"original", (Map)PValues.expandInput((PInput)input), (Map)PValues.expandOutput((POutput)input.apply((PTransform)originalTransform)), (PTransform)originalTransform, (ResourceHints)ResourceHints.create(), (Pipeline)this.pipeline);
        PTransformOverrideFactory.PTransformReplacement replacement = this.factory.getReplacementTransform(application);
        DisplayData replacementDisplayData = DisplayData.from((HasDisplayData)replacement.getTransform());
        MatcherAssert.assertThat((Object)replacementDisplayData, (Matcher)Matchers.equalTo((Object)originalDisplayData));
        DisplayData primitiveDisplayData = (DisplayData)Iterables.getOnlyElement((Iterable)DisplayDataEvaluator.create().displayDataForPrimitiveTransforms(replacement.getTransform(), (Coder)VarIntCoder.of()));
        MatcherAssert.assertThat((Object)primitiveDisplayData, (Matcher)Matchers.equalTo((Object)replacementDisplayData));
    }

    @Test
    public void getReplacementTransformGetSideInputs() {
        PCollectionView sideLong = (PCollectionView)((PCollection)this.pipeline.apply("LongSideInputVals", (PTransform)Create.of((Object)-1L, (Object[])new Long[]{-2L, -4L}))).apply("SideLongView", (PTransform)Sum.longsGlobally().asSingletonView());
        PCollectionView sideStrings = (PCollectionView)((PCollection)this.pipeline.apply("StringSideInputVals", (PTransform)Create.of((Object)"foo", (Object[])new String[]{"bar", "baz"}))).apply("SideStringsView", (PTransform)View.asList());
        ParDo.SingleOutput originalTransform = ParDo.of((DoFn)new ToLongFn()).withSideInputs(new PCollectionView[]{sideLong, sideStrings});
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
        AppliedPTransform application = AppliedPTransform.of((String)"original", (Map)PValues.expandInput((PInput)input), (Map)PValues.expandOutput((POutput)input.apply((PTransform)originalTransform)), (PTransform)originalTransform, (ResourceHints)ResourceHints.create(), (Pipeline)this.pipeline);
        PTransformOverrideFactory.PTransformReplacement replacementTransform = this.factory.getReplacementTransform(application);
        PrimitiveParDoSingleFactory.ParDoSingle parDoSingle = (PrimitiveParDoSingleFactory.ParDoSingle)replacementTransform.getTransform();
        MatcherAssert.assertThat(parDoSingle.getSideInputs().values(), (Matcher)Matchers.containsInAnyOrder((Object[])new PCollectionView[]{sideStrings, sideLong}));
    }

    @Test
    public void getReplacementTransformGetFn() {
        ToLongFn originalFn = new ToLongFn();
        ParDo.SingleOutput originalTransform = ParDo.of((DoFn)originalFn);
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
        AppliedPTransform application = AppliedPTransform.of((String)"original", (Map)PValues.expandInput((PInput)input), (Map)PValues.expandOutput((POutput)input.apply((PTransform)originalTransform)), (PTransform)originalTransform, (ResourceHints)ResourceHints.create(), (Pipeline)this.pipeline);
        PTransformOverrideFactory.PTransformReplacement replacementTransform = this.factory.getReplacementTransform(application);
        PrimitiveParDoSingleFactory.ParDoSingle parDoSingle = (PrimitiveParDoSingleFactory.ParDoSingle)replacementTransform.getTransform();
        MatcherAssert.assertThat((Object)parDoSingle.getFn(), (Matcher)Matchers.equalTo((Object)originalTransform.getFn()));
        MatcherAssert.assertThat((Object)parDoSingle.getFn(), (Matcher)Matchers.equalTo((Object)((Object)originalFn)));
    }

    private static class ToLongFn
    extends DoFn<Integer, Long> {
        private ToLongFn() {
        }

        @DoFn.ProcessElement
        public void toLong(DoFn.ProcessContext ctxt) {
            ctxt.output((Object)((Integer)ctxt.element()).longValue());
        }

        public boolean equals(@Nullable Object other) {
            return other != null && other.getClass().equals(((Object)((Object)this)).getClass());
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    }
}

